FE.VIS.getRelationHighlighter = function () {
    var selectedObj = null;

    function highlightObject(obj, defaultAttributes) {
        if (selectedObj) {
            if (obj === selectedObj) {
                obj.attr(defaultAttributes.BranchSelected);
            } else if (obj.isRelatedTo(selectedObj)) {
                obj.attr(defaultAttributes.BranchEmphasized);
            } else {
                obj.attr(defaultAttributes.Dimmed);
            }
        } else {
            obj.attr(defaultAttributes.BranchNormal);
        }
    }

    return {
        name: "Lineage",
        highlightChangeset: highlightObject,
        highlightEdge: highlightObject,
        onFocusChanged: function (focusedObject) {
            selectedObj = focusedObject;
        }
    }
};
/*[{!relation_highlighter_js_ih8552z!}]*/