FE.VIS.HIGHLIGHTS = FE.VIS.HIGHLIGHTS || {};
FE.VIS.HIGHLIGHTS.ITERATORS = (function ($) {
    function getDepthFirstIterator(startingObject, startingCs, getNextEdges, getNextChangeset) {
        var pathSoFar = [];
        var indicesSoFar = [];
        var curr = startingCs;
        var allTraversedObjects = [startingCs];
        var addToTraversedObjects = function (newObj) {
            if ($.inArray(newObj, allTraversedObjects) === -1) {
                allTraversedObjects.push(newObj);
                return true;
            }
            return false;
        };
        var firstTime = true;

        if (startingObject !== startingCs) {
            allTraversedObjects.shift(startingObject);
        }

        var iterator = function (endCurrentPath) {
            var edges;
            var nextI;
            var nextEdge;

            if (firstTime) {
                firstTime = false;
                nextI = 0;
                return curr;
            }

            if (!endCurrentPath) {
                edges = getNextEdges(curr);
                nextI = 0;
                if (edges.length) {
                    nextEdge = edges[nextI];

                    var nextCs = getNextChangeset(nextEdge);
                    if (nextCs && addToTraversedObjects(nextEdge) && addToTraversedObjects(nextCs)) {
                        pathSoFar.push(curr);
                        indicesSoFar.push(nextI);
                        return curr = nextCs;
                    } else {
                        // this path has already been traversed from another route.
                        // try the next sibling if it exists (otherwise, we'll begin stepping back below.
                        nextI++;
                    }

                }
            }

            //else  must step back, while we have path left to backtrack on.
            var validNextEdge = edges && edges.length > nextI;
            var canStepBack = pathSoFar.length;

            while (canStepBack || validNextEdge) {
                // while we've exausted all edges on the current node and we still have some path left to backtrack
                while (!validNextEdge && canStepBack) {
                    curr = pathSoFar.pop(); // step back
                    edges = getNextEdges(curr); // re-get edges
                    nextI = indicesSoFar.pop() + 1; // get the next edge-index to try

                    validNextEdge = edges && edges.length > nextI;
                    canStepBack = pathSoFar.length;
                }

                // found something, try each edge in turn.
                while (validNextEdge) {
                    nextEdge = edges[nextI];

                    var nextCs = getNextChangeset(nextEdge);
                    if (nextCs && addToTraversedObjects(nextEdge) && addToTraversedObjects(nextCs)) {
                        pathSoFar.push(curr);
                        indicesSoFar.push(nextI);
                        return curr = nextCs;
                    }

                    ++nextI;
                    validNextEdge = edges && edges.length > nextI;
                }
            }
            return null; // nothing left
        };
        iterator.getCurrentPathObjects = function () {
            var objects = startingCs === startingObject ? [] : [startingObject];
            //push pairs of changeset + following edge
            Array.each(pathSoFar, function (cs, i) {
                objects.push(cs);
                var edgeIndex = indicesSoFar[i];
                var edges = getNextEdges(cs);
                var edge = edges[edgeIndex];

                objects.push(edge);
            });
            //finally push the current object
            objects.push(curr);
            return objects;
        };
        iterator.getCurrentPathChangesets = function () {
            var objects = pathSoFar.slice(0);
            objects.push(curr);
            return objects;
        };
        iterator.getAllTraversedObjects = function () {
            return allTraversedObjects;
        };
        iterator.getAllTraversedChangesets = function () {
            return $.grep(allTraversedObjects, function (obj) {
                return obj.isChangeset();
            });
        };
        return iterator;
    }

    function getAncestorIterator(startingObject, startingCs, untilCs) {
        if (!untilCs || startingCs.order > untilCs.order) {
            return getDepthFirstIterator(startingObject, startingCs,
                function (cs) {
                    return cs.parentEdges();
                },
                untilCs ?
                    function (edge) {
                        var parent = edge.parent();
                        return parent.order >= untilCs.order ? parent : null;
                    } :
                    function (edge) {
                        return edge.parent();
                    }
            );
        } else {
            return getDepthFirstIterator(startingObject, startingCs, function () {
                return [];
            }, function () {
            });
        }
    }

    function getDescendantIterator(startingObject, startingCs, untilCs) {
        if (!untilCs || startingCs.order < untilCs.order) {
            return getDepthFirstIterator(startingObject, startingCs,
                function (cs) {
                    return cs.childEdges();
                },
                untilCs ?
                    function (edge) {
                        var child = edge.child();
                        return child.order <= untilCs.order ? child : null;
                    } :
                    function (edge) {
                        return edge.child();
                    }
            );
        } else {
            return getDepthFirstIterator(startingObject, startingCs, function () {
                return [];
            }, function () {
            });
        }
    }

    var Iterators;
    return Iterators = {
        DESCENDANTS: "descendants",
        ANCESTORS: "ancestors",
        getDepthFirstChangesetIterator: function (startObject, stopChangesetOrDirection) {
            if (!startObject) {
                throw new Error("Starting changeset or edge must be specified.");
            }
            if (!stopChangesetOrDirection) {
                throw new Error("Stopping changeset or direction must be specified.");
            }

            var startChangeset;
            var stopChangeset;
            var getter;

            switch (stopChangesetOrDirection) {
                case Iterators.DESCENDANTS:
                    getter = getDescendantIterator;
                    break;
                case Iterators.ANCESTORS:
                    getter = getAncestorIterator;
                    break;
                default:
                    stopChangeset = stopChangesetOrDirection;
                    if (startObject.isEdge()) {
                        if (stopChangeset.order >= startObject.child().order) {
                            startChangeset = startObject.child();
                            getter = getDescendantIterator;
                        } else {
                            startChangeset = startObject.parent();
                            getter = getAncestorIterator;
                        }

                    } else {
                        startChangeset = startObject;
                        getter = stopChangeset.order > startChangeset.order ?
                            getDescendantIterator :
                            getAncestorIterator;
                    }
                    break;
            }

            //if they passed a direction, we haven't filled in the start changeset yet
            if (!startChangeset) {
                startChangeset = startObject.isEdge() ?
                    (getter === getDescendantIterator ? startObject.child() : startObject.parent()) :
                    startObject;
            }

            return getter(startObject, startChangeset, stopChangeset);
        }
    };

})(AJS.$);
/*[{!lineage_iterator_js_29i152y!}]*/