FE.VIS.getJiraHighlighter = (function ($) {

    /* Imports */
    var Map = FECRU.DATA_STRUCTURES.Map;


    function findIssuesForChangeset(cs, cache) {
        // we cant looking for issues without changeset comment
        if (typeof cs._model.comment === 'undefined') {
            return;
        }
        var $jiraIssues = $('<div>' + cs._model.comment + '</div>').find('.jira-hover-trigger > a');
        var issues = [];
        Array.each($jiraIssues, function (span) {
            var $span = $(span);
            issues.push($span.text());
        });
        cache.set(cs.csid, issues);
    }

    function findRelatedIssuesForChangeset(cs, focusedCsid, issuesById, cache) {
        var csid = cs.csid;
        var focusedIssues = issuesById.get(focusedCsid);
        var issues = issuesById.get(csid);
        var related = [];
        if (typeof issues !== 'undefined') {
            Array.each(issues, function (issueKey) {
                if ($.inArray(issueKey, focusedIssues) !== -1) {
                    related.push(issueKey);
                }
            });
        }
        cache.set(csid, related);
    }

    return function () {
        var issuesById = new Map();
        var relatedIssuesById = null;
        var focusedCsid = null;

        return {
            name: "JIRA issues",
            highlightChangeset: function (cs, defaults) {
                var csid = cs.csid;
                // Ensure caches
                if (!issuesById.has(csid)) {
                    findIssuesForChangeset(cs, issuesById);
                }
                if (focusedCsid !== null && !relatedIssuesById.has(csid)) {
                    findRelatedIssuesForChangeset(cs, focusedCsid, issuesById, relatedIssuesById);
                }

                // Highlighting
                if (focusedCsid === csid) {
                    cs.attr(defaults.Selected);
                } else if (focusedCsid !== null && relatedIssuesById.get(csid).length > 0) {
                    cs.attr(defaults.Emphasized);
                } else if (issuesById.has(csid) && issuesById.get(csid).length > 0) {
                    cs.attr(defaults.Normal)
                        .attr("metadataCssClass", "has-jira-issue");
                } else {
                    cs.attr(defaults.Dimmed);
                }
            },
            onFocusChanged: function (highlightable) {
                if (highlightable && highlightable.isChangeset()) {
                    focusedCsid = highlightable.csid;
                    relatedIssuesById = new Map();
                    if (!issuesById.has(focusedCsid)) {
                        findIssuesForChangeset(highlightable, issuesById);
                    }
                } else {
                    focusedCsid = null;
                    relatedIssuesById = null;
                }
            },
            getChangesetAnnotation: function (cs, createAnnotationList) {
                var csid = cs.csid;
                // Ensure caches
                if (!issuesById.has(csid)) {
                    findIssuesForChangeset(cs, issuesById);
                }
                return createAnnotationList(issuesById.get(csid), {
                    sort: true,
                    getTruncationMessage: function (hiddenCount) {
                        return hiddenCount + " other issues";
                    }
                });
            }
        };
    };
})(AJS.$);
/*[{!jira_highlighter_js_miy652x!}]*/