FE.VIS.HIGHLIGHT_POPUP = (function ($) {

    var ANNOTATION_CLASS = "highlight-annotation";

    function getSortedBranches(branches, primaryBranchNames) {
        branches = branches.slice(0);
        branches.sort(function (a, b) {
            var aIndex = $.inArray(a, primaryBranchNames);
            var bIndex = $.inArray(b, primaryBranchNames);

            if (aIndex !== -1) {
                if (bIndex !== -1) {
                    return a > b ? 1 : -1;
                } else {
                    return -1;
                }
            } else {
                if (bIndex !== -1) {
                    return 1;
                } else {
                    return a > b ? 1 : -1;
                }
            }
        });
        return branches;
    }

    var HighlightPopup = function (selector, id, opts) {
        var defaults = {
            onHover: true,
            fadeTime: 0,
            hideDelay: 80,
            showDelay: 30,
            cacheContent: false,
            useLiveEvents: true,
            addActiveClass: false,
            displayShadow: false,
            getHighlightableChangeset: function () {
                throw "You must supply a getHighlightableChangeset method to HighlightPopup";
            },
            getHighlightContext: function () {
                throw "You must supply a getHighlightContext method to HighlightPopup";
            },
            calculatePositions: function (popup, targetPosition, mousePosition, opts) {
                // CONSTANTS
                var LEFT_PADDING = 8;

                var popupTop = 0;
                var popupLeft = 0;
                var useMousePosition = $.browser.msie && $.browser.version < 9;

                // Only calculate svg element locations if we aren't using mouse position
                if (!useMousePosition) {
                    try {
                        var svgElement = targetPosition.target[0];
                        var boundingBox = svgElement.getBoundingClientRect();

                        var boxLeft = boundingBox.left;
                        var boxTop = boundingBox.top;
                        var boxWidth = boundingBox.width;
                        var boxHeight = boundingBox.height;
                        var elementRadius = svgElement.nodeName === "circle" ? svgElement.r.baseVal.value : 0;

                        if (!boxLeft && !boxTop) {
                            useMousePosition = true;
                        } else {
                            popupLeft = boxLeft + (boxWidth + elementRadius) / 2;
                            popupTop = boxTop + boxHeight / 2 - elementRadius - 3;
                        }
                    } catch (e) {
                        useMousePosition = true;
                    }
                }

                if (useMousePosition) {
                    // fall back to mouse position
                    popupLeft = mousePosition.x;
                    popupTop = mousePosition.y;
                }

                popupLeft += LEFT_PADDING;

                return {
                    displayAbove: false,
                    popupCss: {
                        left: popupLeft,
                        right: "auto",
                        top: popupTop
                    },
                    arrowCss: {
                        display: "none"
                    }
                }
            }
        };

        var hoverOpts = $.extend({}, defaults, opts);

        this.initialise(selector, id, hoverOpts);
    };

    HighlightPopup.create = function (selector, id, opts) {
        return new HighlightPopup(selector, id, opts);
    };

    HighlightPopup.prototype.initialise = function (selector, id, opts) {
        if (this.popup) {
            return; // don't multi-init
        }
        var self = this;
        var lastTrigger = undefined;

        this.popup = AJS.InlineDialog(selector, id, function (contents, trigger, showPopup) {
            var $contents = $(contents).empty();
            var cs = opts.getHighlightableChangeset(trigger);

            if (cs) {
                var highlightContext = opts.getHighlightContext();
                var highlightableChangeset = highlightContext.getChangeset(cs);

                var annotation = highlightContext.getChangesetAnnotation(highlightableChangeset);

                var $container = $("<div></div>");
                var primaryBranches = Array.map(cs.primaryBranches, function (branch) {
                    return branch.name;
                });

                var branches = getSortedBranches(cs.branches, primaryBranches);

                var $csidElem = $("<div></div>").text(opts.getDisplayCsId(cs.id));

                var $branchUl = HighlightPopup.createAnnotationList(branches, {
                    sort: false,
                    getTruncationMessage: function (hiddenCount) {
                        return hiddenCount + " other branches";
                    }
                }).addClass(ANNOTATION_CLASS);

                $container
                    .append($csidElem)
                    .append($branchUl);

                if (annotation) {
                    if (annotation instanceof jQuery) {
                        $container.append(annotation.addClass(ANNOTATION_CLASS));
                    } else {
                        $container.append(
                            $("<div>")
                                .addClass(ANNOTATION_CLASS)
                                .html(annotation)
                        );
                    }
                }
                $contents.append($container);

                if (lastTrigger && lastTrigger !== trigger) {
                    if (self.popup) {
                        // Set the display property rather than calling "hide()" because InlineDialog overrides this method
                        // and it does not do what we expect
                        self.popup.css("display", "none");
                    }
                }
                lastTrigger = trigger;

                showPopup();
            }
        }, opts);
    };

    HighlightPopup.prototype.erase = function () {
        if (this.popup) {
            this.popup.remove();
            this.popup = null;
        }
    };

    HighlightPopup.createAnnotationList = function (items, listOpts) {
        if (!items || !items.length) {
            return null;
        }

        var defaults = {
            maxItems: 10,
            sort: false,
            getTruncationMessage: function (hiddenCount) {
                return hiddenCount + " not shown";
            },
            getItemHtml: undefined,
            listClass: undefined,
            truncatedMessageClass: "hidden-truncated"
        };

        var opts = $.extend({}, defaults, listOpts);

        var $ul = $("<ul></ul>");

        if (opts.listClass) {
            $ul.addClass(opts.listClass);
        }

        if (opts.sort) {
            items = $.isFunction(opts.sort) ?
                items.sort(opts.sort) :
                items.sort();
        }

        Array.each(items, function (item, i) {
            if (opts.maxItems && i >= opts.maxItems) {
                var truncatedMessage = opts.getTruncationMessage(items.length - i);
                $ul.append(
                    $("<li>")
                        .addClass(opts.truncatedMessageClass)
                        .text(truncatedMessage)
                );
                return false;
            }
            var $li = $("<li>");
            if (opts.getItemHtml) {
                $li.html(opts.getItemHtml(item));
            } else {
                $li.text(item);
            }
            $ul.append($li);
        });

        return $ul;
    };

    HighlightPopup.getSortedBranches = getSortedBranches;

    return HighlightPopup;
})(AJS.$);
/*[{!highlight_popup_js_swf152v!}]*/