FE.VIS.HIGHLIGHT_LOZENGE = (function ($) {
    var HighlightLozenge = function (items, options) {

        if (!items || !items.length) {
            throw "Can't create a lozenge out of nothing, sire!";
        }

        var defaults = {
            lozengeClass: null,
            getItemText: null,
            getItemTitle: null,
            collapseCount: 2,
            maxItems: 20,
            sort: false,
            collapsedLozengeText: function (itemCount) {
                return itemCount + " items";
            },
            getTruncationMessage: function (hiddenCount) {
                return hiddenCount + " not shown";
            },
            truncatedMessageClass: "hidden-truncated"
        };

        this.opts = $.extend({}, defaults, options);
        this.lozenges = [];
        this.dropdowns = [];

        var self = this;
        var opts = self.opts;

        if (opts.sort) {
            items = $.isFunction(opts.sort) ?
                items.sort(opts.sort) :
                items.sort();
        }

        if (items.length <= opts.collapseCount) {
            Array.each(items, function (item) {
                self.createLozengeItem(item, opts.getItemText, opts.getItemTitle);
            });
        } else {
            self.createCollapsedLozengeItem(items);
        }
    };

    HighlightLozenge.create = function (items, opts) {
        return new HighlightLozenge(items, opts);
    };

    HighlightLozenge.prototype.erase = function () {
        this.dropdowns = [];
        this.lozenges = [];
        this.opts = null;
    };

    HighlightLozenge.prototype.getLozenges = function () {
        return this.lozenges;
    };

    var _setupLozengeItem = function (item, $lozenge, itemTextCreator, itemTitleCreator) {
        if (itemTextCreator) {
            var itemText = itemTextCreator(item);
            if (itemText.jquery) {
                $lozenge.append($(itemText));
            } else {
                $lozenge.text(itemText);
            }
        } else {
            $lozenge.text(item);
        }

        if (itemTitleCreator) {
            var title = itemTitleCreator(item);
            if (title) {
                $lozenge.attr("title", title);
            }
        }
    };

    HighlightLozenge.prototype.createLozengeItem = function (item, itemTextCreator, itemTitleCreator) {
        var opts = this.opts;
        var $item = $("<span></span>").addClass("highlight-lozenge");

        if (opts.lozengeClass) {
            $item.addClass(opts.lozengeClass);
        }

        _setupLozengeItem(item, $item, itemTextCreator, itemTitleCreator);
        this.lozenges.push($item);
        return $item;
    };

    HighlightLozenge.prototype.createCollapsedLozengeItem = function (items) {
        var self = this;
        var opts = self.opts;
        var $item = self.createLozengeItem(opts.collapsedLozengeText(items.length), function (item) {
            return $("<span class='aui-dd-trigger'></span>").text(item);
        }).addClass("aui-dd-parent");

        var itemTextCreator = opts.getItemText;
        var itemTitleCreator = opts.getItemTitle;

        var $ul = $("<ul></ul>").addClass("collapsed-items aui-dropdown");
        Array.each(items, function (item, i) {
            var $li = $("<li></li>");
            if (opts.maxItems && i >= opts.maxItems) {
                var truncatedMessage = opts.getTruncationMessage(items.length - i);
                $ul.append(
                    $li
                        .addClass(opts.truncatedMessageClass)
                        .text(truncatedMessage)
                );
                return false;
            }

            _setupLozengeItem(item, $li, itemTextCreator, itemTitleCreator);

            $ul.append($li);
        });

        $item
            .addClass("lozenge-collapsed")
            .append($ul);

        // setup AUI dropdown foo
        $item.addClass("aui-dd-trigger");
        var dropDown = $item.dropDown("Standard", {
            alignment: "right"
        });
        this.dropdowns.push(dropDown);
    };

    return HighlightLozenge;
})(AJS.$);
/*[{!highlight_lozenge_js_7miq52u!}]*/