FE.VIS.ChangesetDialog = (function ($, templateFactory) {

    /**imports**/
    var ajax = FECRU.AJAX;
    var setupPathAbbreviation = FE.setupPathAbbreviation;
    var NAV = FECRU.NAVBUILDER;
    var maxTagsDisplayed = 5;

    /**private**/
    //comparator by weight
    function byWeight(a, b) {
        return a.moreInfo.weight - b.moreInfo.weight;
    }

    function computeWidth($pathElement) {
        //abreviate up to the width of tha path, minus the width of the path action items (source, diff ,history etc)
        return $pathElement.closest('li').width() - $pathElement.siblings("ul.file-views").width();
    }

    /**
     * Return a string of the html that make up the tags
     * @param tags an array of string of tags. Should be ready sorted in the order desired by the UI
     */
    function makeTagLiHtml(tags, repositoryName) {
        return Array.map(tags, function (tag) {
            var url = NAV.browseAtTag(repositoryName, tag);
            var tagEncoded = AJS.escapeHtml(tag);

            return "<li class='highlighter-annotation-item'>" +
                "<a href='" + url + "' title='Browse repository at " + tagEncoded + "'>" + tagEncoded + "</a>" +
                "</li>";
        }).join('');
    }

    function addTags(changesetInfo) {
        if (changesetInfo && changesetInfo.tags && changesetInfo.tags.length > 0) {
            var tags = changesetInfo.tags.slice(0).sort();
            var showMore = tags.length > maxTagsDisplayed;
            var visibleTagsHtml = makeTagLiHtml(tags.slice(0, maxTagsDisplayed), changesetInfo.repositoryName);
            var amount = tags.length - maxTagsDisplayed;
            var showMoreHtml = showMore ? "<li id='tags-annotation-show-more' style='cursor:pointer'>Show " + (amount) + " more...</li>" : "";

            if (showMore) {
                //delegate because we don't yet have the dom element inserted
                $(document).delegate("#tags-annotation-show-more", "click", function (e) {
                    var $this = $(this);
                    var remainingTagsHtml = makeTagLiHtml(tags.slice(maxTagsDisplayed), changesetInfo.repositoryName);

                    $this.remove();
                    $("#tags-annotation-list").append(remainingTagsHtml);
                    //undelegate because we dont want this executing again for the next changeset
                    $(document).undelegate("#tags-annotation-show-more", "click");
                });
            }

            return {
                weight: 30,
                title: "Tags",
                element: $("<ul id='tags-annotation-list'>" + visibleTagsHtml + showMoreHtml + "</ul>")
            };
        } else {
            return null;
        }
    }

    /* Public*/

    /**
     * Constructs the chanceset more info dialog. This will delegate a click to each of the more info icon link
     * in the metadata section, which will cause the dialog to appear.
     * @param visualiser the visualiser. Used to obtain a list of highlighter plugins. The set of plugins should be loaded before being passed
     * into this constructor
     */
    var ChangesetDialog = function (visualiser) {
        //properties in this class
        this.visualiser = visualiser;
        this.$dialog = null;
        this.$panel = null;
        this.$infoLink = null;
    };

    /**
     * sets up the dialog
     * @param setting an optional setting containing the width and height. defaults to FE.VIS.Configuration.ChangesetDialogConfig;
     */
    ChangesetDialog.prototype.setup = function (setting) {
        var self = this;
        $(document).delegate('.metadata-changeset .info-link', 'click', function (e) {
            e.preventDefault();
            e.stopImmediatePropagation();

            var $infoLink = self.$infoLink = $(this);
            var url = $infoLink.attr('href');
            var width = setting.width;
            var height = setting.height;
            var dialogId = "changeset-details-dialog";
            var panelId = "changeset-details-dialog-panel";
            var $dialog = self.$dialog = self.$dialog || FECRU.DIALOG.ajaxDialog(width, height, {}, dialogId)
                    .addHeader("Changeset Details")
                    .addPanel("Changeset Details", "<div id='" + panelId + "'>Loading...</div>")
                    .addButton("Close", function (d) {
                        d.hide();
                    }, "cancelButton");
            $dialog.show();
            self.$panel = self.$panel || $('#' + panelId);
            self.$panel.empty(); //clear the panel first before putting in a spinner
            ajax.startSpin(panelId, "changeset-details-spinner");
            ajax.ajaxUpdate(url, {}, panelId, function (data) {
                ajax.stopSpin(self.$panel);
                if (data && data.worked) {
                    var $stream = $("#stream");
                    var $article = $stream.find(".article").first();
                    var model = self.$infoLink.closest(".metadata-changeset").data("model");
                    var highlighterMoreInfos = [];
                    var changesetInfo = {
                        changesetId: model.csid,
                        tags: model.tags,
                        date: model.date,
                        comment: model.comment,
                        author: model.author,
                        repositoryName: setting.repositoryName,
                        branches: model.branches.slice(0)
                    };

                    setupPathAbbreviation($stream, computeWidth);

                    //add the tags list
                    var tagMoreInfo = addTags(changesetInfo);
                    if (tagMoreInfo) {
                        highlighterMoreInfos.push({id: "built-in-tags", moreInfo: addTags(changesetInfo)});
                    }

                    Array.each(self.visualiser.getHighlighters(), function (highlighterData) {
                        var highlighterContext = self.visualiser.getHighlighterContext(highlighterData.id);
                        var moreInfo = highlighterContext.getMoreInfo(changesetInfo, $stream);

                        if (moreInfo) {
                            highlighterMoreInfos.push({id: highlighterData.id, moreInfo: moreInfo});
                        }
                    });

                    highlighterMoreInfos.sort(byWeight);

                    Array.each(highlighterMoreInfos, function (h) {
                        var $dialogContents = $(templateFactory.load("highlighter-more-info-template")
                            .fill({highlighterId: h.id, title: h.moreInfo.title})
                            .toString());

                        $dialogContents.append(h.moreInfo.element);
                        $article.append($dialogContents);
                    });
                }
            });
        }).delegate("#changeset-details-dialog-panel .article-section > h4", "click", function (e) { //TODO: should we even be hide/showing this section?
            var $this = $(this);
            var section = $this.siblings();
            var toggle = function () {
                $this.toggleClass("highlighter-more-info-heading-hidden");
            };

            if ($this.hasClass("highlighter-more-info-heading-hidden")) {
                section.show("fast", toggle);
            } else {
                section.hide("fast", toggle);
            }
        });
        return self;
    };

    /**
     * Factory method for creating a changeset dialog.
     * @param visualiser reference to the visualiser.
     * @param repositoryName the repository name - used to generate links
     */
    ChangesetDialog.create = function (visualiser, repositoryName) {
        return new ChangesetDialog(visualiser).setup({
            width: 900,
            height: 500,
            repositoryName: repositoryName
        });
    };
    return ChangesetDialog;
})(AJS.$, AJS.template);
/*[{!changeset_dialog_js_w87j52i!}]*/