window.CRU = window.CRU || {};
if (!CRU.UNSAVED) {
    CRU.UNSAVED = {};
}

(function ($) {
    var unsaved = CRU.UNSAVED;

    var watchedInputs = [];

    unsaved.clearWatchForUnsavedChanges = function () {
        watchedInputs = [];
    };

    unsaved.watchForUnsavedChanges = function ($input, fieldName) {
        var input = $input ? $input[0] : undefined;
        if (!input) {
            return;
        }

        if ($input.siblings(".backup").length === 0) {
            return;
        }

        $input.data("fieldName", fieldName);

        if ($.inArray(input, watchedInputs) === -1) {
            watchedInputs.push(input);
        }
    };

    /**
     * Shows a confirm dialog if there are unsubmitted input elements on the page.
     * @return true if the user wants to continue
     */
    unsaved.confirmUnsubmittedInputs = function () {
        var warning = getUnsubmittedInputsWarning();
        if (warning) {
            var txt = "Are you sure you want to navigate away from this page?\n\n" +
                warning + "\n\n" +
                "Press OK to continue, or Cancel to stay on the current page.";
            return confirm(txt);
        }
        return true;
    };

    var getUnsubmittedInputsWarning = function () {
        var unsubmitted = getUnsubmittedInputs();
        var warning = null;
        var length = unsubmitted.length;
        if (length > 0) {
            var fields = "";
            for (var i = 0; i < length; i++) {
                if (fields.length > 0) {
                    if (i === length - 1) {
                        fields += " and "
                    } else {
                        fields += ", ";
                    }
                }
                fields += unsubmitted[i].data("fieldName");
            }

            warning = "The " + fields + (length === 1 ? " field has " : " fields have ") + "not been saved.";
        }
        return warning;
    };

    var getUnsubmittedInputs = function () {
        var unsubmitted = [];
        try {
            for (var i = 0, len = watchedInputs.length; i < len; i++) {
                var w = watchedInputs[i];
                // May have been removed from the DOM, so be defensive.
                if (!w) {
                    continue;
                }
                var $input = $(w);
                var $backup = $input.siblings(".backup");
                if ($input.val() !== $backup.val()) {
                    unsubmitted.push($input);
                }
            }
        } catch (e) {
            AJS.log("There was an error getting unsubmitted values: " + e);
        }
        return unsubmitted;
    };

    // Check that we don't have any unsubmitted input fields before unloading the page.
    $(window).bind('beforeunload', function (e) {
        e = e || window.event;

        var txt = getUnsubmittedInputsWarning();
        if (txt) {
            if (e) {
                // Firefox/IE
                e.returnValue = txt;
            }
            // Safari
            return txt;
        }
    });
})(AJS.$);
/*[{!unsaved_changes_js_y2o550w!}]*/