if (!CRU.REVIEW.WIKI.HELP) {
    CRU.REVIEW.WIKI.HELP = {};
}
(function () {
    var wikiPopupShowing = false;
    var wikiPopup;


    var showPopup = function () {
        if (!wikiPopup) {
            wikiPopup = FECRU.DIALOG.create(800, 550, 'wikimarkupHelp')
                .addHeader('Wiki Markup Tips')
                .addPanel('All', AJS.$("#wiki-notation-quick").clone())
                .addButton('Full Wiki Markup', function () {
                    window.open(AJS.$("#wiki-notation-link a").attr("href"), "Full_Wiki_Markup");
                    hidePopup();

                }).addButton('Close', function () {
                    CRU.REVIEW.WIKI.HELP.hidePopup();
                });
        }
        if (!wikiPopupShowing) {
            wikiPopup.show();
            wikiPopupShowing = true;
            return false;
        }
    };

    var hidePopup = function () {
        if (wikiPopupShowing) {
            wikiPopup.hide();
            wikiPopupShowing = false;
            return false;
        }
    };
    CRU.REVIEW.WIKI.HELP = {
        popupShowing: function () {
            return wikiPopupShowing;
        },
        showPopup: showPopup,
        hidePopup: hidePopup
    };

    AJS.$(document).delegate('.wiki-help-button', 'click', function () {
        showPopup();
    });

})();
/*[{!wikihelp_js_b5zm51h!}]*/