(function () {
    window.CRU = window.CRU || {};
    CRU.REVIEW = CRU.REVIEW || {};
    var getWikiPreviewStruct = function ($container, filter) {
        var $previewButton = $container.find(".wiki-preview-button");
        var $textarea = $container.find("textarea" + (filter || ""));
        var $editOnly = $container.find(".edit-only");
        var $previewPane = $container.find(".wiki-preview-pane" + (filter || ""));
        var $previewSpinner = $container.find(".wiki-preview-button-spinner");
        var wikiText = $textarea.val();

        return {
            container: $container,
            previewButton: $previewButton,
            textarea: $textarea,
            editOnly: $editOnly,
            previewPane: $previewPane,
            previewSpinner: $previewSpinner,
            wikiText: wikiText
        };
    };

    CRU.REVIEW.WIKI = CRU.REVIEW.WIKI || {
            resetPreview: function (parentId) {
                var struct = getWikiPreviewStruct(AJS.$((parentId ? ("#" + parentId + " ") : "") + "div a.wiki-preview-button")
                    .closest(".comment, .wiki-preview-wrapper"));
                var $previewButton = struct.previewButton;
                var $textarea = struct.textarea;
                var $editOnly = struct.editOnly;
                var $previewPane = struct.previewPane;
                var $previewSpinner = struct.previewSpinner;

                $previewPane.hide()
                    .text("")
                    .data("isInPreview", false);
                $previewButton.show();
                $previewSpinner.removeClass("wiki-preview-pane-spin");
                $textarea.show();
                $editOnly.removeClass('hidden');
            }
        };

    AJS.$(document).ready(function () {
        AJS.$(document).delegate("div a.wiki-preview-button", "click", function () {
            var struct = getWikiPreviewStruct(AJS.$(this).closest(".comment, .wiki-preview-wrapper"), ":first");
            var $previewButton = struct.previewButton;
            var $textarea = struct.textarea;
            var $editOnly = struct.editOnly;
            var $previewPane = struct.previewPane;
            var $previewSpinner = struct.previewSpinner;
            var wikiText = struct.wikiText;

            var previewController = {
                toggleOn: function (html) {
                    $textarea.hide();
                    $editOnly.addClass('hidden');
                    $previewPane.html(html)
                        .show()
                        .data("isInPreview", true);
                    $previewPane.trigger('wiki-preview-on')
                },
                toggleOff: function () {
                    $previewPane.hide()
                        .text("")
                        .data("isInPreview", false);
                    $textarea.show();
                    $editOnly.removeClass('hidden');
                    $previewPane.trigger('wiki-preview-off');
                }
            };

            if ($previewPane.data("isInPreview") === true) {
                previewController.toggleOff();
            } else {
                if (wikiText) {
                    var url = CRU.UTIL.jsonUrlBase(permaId) + "/wikiPreviewJson";
                    var onComplete = function (resp) {
                        $previewSpinner.removeClass("wiki-preview-pane-spin");
                        $previewButton.show();
                        previewController.toggleOn(resp.html);
                    };
                    previewController.toggleOff();
                    $previewButton.hide();
                    $previewSpinner.addClass("wiki-preview-pane-spin");
                    FECRU.AJAX.ajaxDo(url, {wikiText: wikiText}, onComplete, true);
                }
            }
        });

        // live event for the comment post/cancel buttons
        AJS.$(document).delegate("form fieldset.comment-toolbar-holder button", "click.previewReset", function () {
            CRU.REVIEW.WIKI.resetPreview();
        });
    });
})();
/*[{!wiki_preview_js_hwzj523!}]*/