if (!CRU.REVIEW) {
    CRU.REVIEW = {};
}
if (!CRU.REVIEW.UTIL) {
    CRU.REVIEW.UTIL = {};
}
if (!CRU.REVIEW.TIMER) {
    CRU.REVIEW.TIMER = {};
}

CRU.REVIEW.MAX_FRXS_LOADED = 30;

(function ($, eventBusProvider) {
    var cruReviewUtil = CRU.REVIEW.UTIL;
    var cruReviewTimer = CRU.REVIEW.TIMER;
    var cruUtil;
    var cruFrx;
    var fecruAjax;

    // none of these are ready yet, so initialise them on ready
    AJS.$(document).ready(function () {
        cruUtil = CRU.UTIL;
        cruFrx = CRU.FRX;
        fecruAjax = FECRU.AJAX;
    });

    var displayCredentialsRequiredMessage = function (div, crm, success) {
        var template = AJS.template('<span>{msg} <a>Click here</a> to authenticate.</span>');
        AJS.$(div).empty().append(
            AJS.$('' + template.fill({"msg:html": crm.msgHtml})));

        AJS.$(div).find("a").click(function () {
            var eventProducer = FECRU.OAUTH.authorize(crm.authUrl);
            if (success) {
                eventProducer.authorized(success);
            }
        });
    };

    var displayOauthIgnoredMessage = function (div, oauthIgnored, success) {
        var template = AJS.template(
            "Accessing this issue requires authentication with <a target='_blank' href='{url}'>{name}</a> " +
            "however you have chosen to ignore these authentication requests. " +
            "<a class='jirahover-clear-ignored-applinks-link' href='#'>Click here</a> to stop ignoring.");
        var data = {url: oauthIgnored.jiraServerUrl, name: oauthIgnored.jiraServerName};

        AJS.$(div).empty().append(template.fill(data));
        AJS.$(div).find(".jirahover-clear-ignored-applinks-link").click(function () {
            FECRU.HOVER.invalidateCache(FECRU.HOVER.CACHE_FOREVER);
            fecruAjax.startSpin("jiraDisplaySpinner");
            FECRU.UAL.clearIgnoredAppLinks(function () {
                setTimeout(function () {
                    AJS.$(".linked-issue-error").empty();
                    fecruAjax.stopSpin("jiraDisplaySpinner");
                    success();
                }, 500);
            });
            return false;
        });
    };

    cruReviewUtil.findJiraIssue = function () {
        var jiraIssueKey = AJS.$.trim(AJS.$("#jiraIssueKeyField").val());
        if (!jiraIssueKey) {
            return;
        }
        var url = cruUtil.jsonUrlBase(permaId) + "/findJiraIssueAjax";
        var params = {jiraIssueKey: jiraIssueKey, autoLink: true};
        var $button = AJS.$("#jiraFindButton").prop("disabled", true);

        fecruAjax.startSpin("jiraFindButton");

        var done = function (resp) {
            var credentialsRequired = resp.credentialsRequired && resp.credentialsRequired.length > 0;
            if (credentialsRequired) {
                var crm = resp.credentialsRequired[0];
                displayCredentialsRequiredMessage(".linked-issue-error", crm, function () {
                    // retry after approval:
                    cruReviewUtil.findJiraIssue();
                });
                AJS.$("#frx-filter-subtasks,#frx-filter-unresolvedsubtasks").addClass("disabled");
            } else if (resp.oauthIgnored) {
                displayOauthIgnoredMessage(".linked-issue-error", resp.oauthIgnored, function () {
                    // retry after approval:
                    cruReviewUtil.findAndLinkJiraIssue(jiraIssueKey);
                });
            } else if (resp.worked) {
                if (resp.canLogWork) {
                    AJS.$("#time-spent").addClass("submit-jira-time");
                }
                AJS.$("#linked-issue-container").html(resp.jiraEditHtml);
                AJS.$("#jiraDisplayDiv").replaceWith(resp.jiraDisplayHtml);
                AJS.$("#frx-filter-subtasks,#frx-filter-unresolvedsubtasks").removeClass("disabled");
            } else {
                AJS.$(".linked-issue-error").html(resp.errorMsg);
                $button.removeProp("disabled");
                AJS.$("#frx-filter-subtasks,#frx-filter-unresolvedsubtasks").addClass("disabled");
            }

            $button.removeProp("disabled");
            fecruAjax.stopSpin($button);
        };

        fecruAjax.ajaxDo(url, params, done, true);
    };

    cruReviewUtil.unlinkJiraIssue = function () {
        var url = cruUtil.jsonUrlBase(permaId) + '/findJiraIssueAjax';
        var params = {unlinkJira: true};

        var $button = AJS.$("#jiraClearButton").prop('disabled', true);

        var done = function (resp) {
            if (resp.worked) {
                AJS.$("#time-spent").removeClass("submit-jira-time");
                AJS.$("#linked-issue-container").html(resp.jiraEditHtml);
                AJS.$("#jiraDisplayDiv").replaceWith(resp.jiraDisplayHtml);
                AJS.$("#frx-filter-subtasks,#frx-filter-unresolvedsubtasks").removeClass("disabled");
            } else {
                $button.removeProp("disabled");
            }
        };

        fecruAjax.ajaxDo(url, params, done, true);
    };

    /**
     * This function is used from review details dialog to quickly link the review
     * to a jira issue that was suggested by Crucible.
     *
     * @param jiraIssueKey
     */
    cruReviewUtil.findAndLinkJiraIssue = function (jiraIssueKey) {
        var url = cruUtil.jsonUrlBase(permaId) + "/findJiraIssueAjax";
        var params = {jiraIssueKey: jiraIssueKey, autoLink: true};

        AJS.$("#jiraFindButton").prop("disabled", true);

        var ajax = fecruAjax;

        ajax.startSpin("jiraDisplaySpinner");

        ajax.ajaxDo(url, params, function (resp) {
            ajax.stopSpin(AJS.$("#jiraDisplaySpinner"));
            var credentialsRequired = resp.credentialsRequired && resp.credentialsRequired.length > 0;
            if (credentialsRequired) {
                var crm = resp.credentialsRequired[0];
                displayCredentialsRequiredMessage(".linked-issue-error", crm, function () {
                    // retry after approval:
                    AJS.$(".linked-issue-error").empty();
                    cruReviewUtil.findAndLinkJiraIssue(jiraIssueKey);
                });
                AJS.$("#frx-filter-subtasks,#frx-filter-unresolvedsubtasks").addClass("disabled");
            } else if (resp.oauthIgnored) {
                displayOauthIgnoredMessage(".linked-issue-error", resp.oauthIgnored, function () {
                    // retry after approval:
                    cruReviewUtil.findAndLinkJiraIssue(jiraIssueKey);
                });
            } else if (resp.worked) {
                if (resp.canLogWork) {
                    AJS.$("#time-spent").addClass("submit-jira-time");
                }
                AJS.$("#linked-issue-container").html(resp.jiraEditHtml);
                AJS.$("#jiraDisplayDiv").html(resp.jiraDisplayHtml);
                AJS.$("#jiraIssueQuickLink").hide();
                AJS.$("#frx-filter-subtasks,#frx-filter-unresolvedsubtasks").removeClass("disabled");
            } else {

                var $linkedIssueError = AJS.$(".linked-issue-error");
                $linkedIssueError.empty();
                var $error = AJS.$(AJS.messages.warning($linkedIssueError, {
                    title: 'Linking issue to review failed.',
                    body: 'There ' + (resp.jiraExceptions.length === 1 ? 'was an error' : ('were ' + resp.jiraExceptions.length + ' errors')) + ' communicating with JIRA. <a class="details">Details</a>'
                }));

                $linkedIssueError.find('.details').click(function () {
                    for (var i = 0; i < resp.jiraExceptions.length; i++) {
                        var exception = resp.jiraExceptions[i];
                        var exceptionTemplate = AJS.template('<span>{msg} <a href="{url}">Go to \'{name}\'</a> or see your administrator.</span>');
                        var data = {url: exception.serverUrl, name: exception.name, "msg:html": exception.msgHtml};
                        FECRU.AJAX.appendErrorMessage(AJS.$('' + exceptionTemplate.fill(data)), true);
                    }
                    FECRU.AJAX.showNotificationBox('Errors communicating with JIRA', 'message');
                });

                AJS.$("#frx-filter-subtasks,#frx-filter-unresolvedsubtasks").addClass("disabled");
            }
        }, true);

        AJS.$("#jiraFindButton").removeProp("disabled");
    };

    cruReviewUtil.postEditDetailsForm = function (onCompleteFunc) {
        var url = cruUtil.jsonUrlBase(permaId) + '/postDetails';
        var $form = AJS.$('#editDetailsForm');

        var $title = AJS.$("#reviewTitle");
        if ($title.isPlaceholded()) {
            $title.val("");
        }

        if ($form.length === 0) {
            onCompleteFunc && onCompleteFunc();
            return false;
        }

        var params = $form.serialize() + '&command=norender';
        fecruAjax.ajaxDo(url, params, onCompleteFunc);
        return false;
    };

    cruReviewUtil.closeReviewAjax = function () {
        var params = {
            summary: AJS.$("#reviewSummaryInput").val()
        };

        cruUtil.stateTransition('action:closeReview', permaId, params);
        return false;
    };

    cruReviewUtil.postLinkedReview = function () {
        var newParentId = AJS.$("#parentReviewId").val();
        if (!newParentId) {
            return;
        }
        var url = cruUtil.jsonUrlBase(permaId) + '/linkReview';
        var params = '&parentReviewId=' + newParentId;
        var $button = AJS.$("#linkReviewSaveButton").prop('disabled', true);

        var ajax = fecruAjax;

        ajax.startSpin("linkedReviewSpinner");

        var done = function (resp) {
            if (resp.worked) {
                AJS.$("#unlinkReview").html(resp.unlinkHtml).show();
                AJS.$("#linkReviewForm").hide();
            }
            ajax.stopSpin(AJS.$('#linkedReviewSpinner'));
            $button.removeProp('disabled');
        };

        ajax.ajaxDo(url, params, done);
    };

    cruReviewUtil.postUnlinkReview = function () {
        var url = cruUtil.jsonUrlBase(permaId) + '/linkReview';
        var params = {unlinkParent: true};

        var ajax = fecruAjax;

        ajax.startSpin("linkedReviewSpinner");
        var $button = AJS.$("#linkReviewUnlinkButton").prop('disabled', true);

        var done = function (resp) {
            if (resp.worked) {
                AJS.$("#unlinkReview").hide().html("");
                AJS.$("#linkReviewForm").show();
            }
            ajax.stopSpin(AJS.$('#linkedReviewSpinner'));
            $button.removeProp('disabled');
        };

        ajax.ajaxDo(url, params, done);
    };

    cruReviewUtil.filterAndExpandFrxs = function (filters) {
        var $filterOptions = AJS.$('#frxFilterOptions');
        AJS.$.each(filters, function (i, filter) {
            $filterOptions.find('li[id=frx-filter-' + filter + ']').addClass('selected');
        });
        cruFrx.changedFrxFilter();
    };

    /**
     * @param opts.done called when the request was successful
     * @param opts.error see noDialog param of fecruAjax.ajaxUpdate
     */
    cruReviewUtil.warnAboutReviewUpdates = function (opts) {
        opts = opts || {};
        var notShownYet = !AJS.$('body').hasClass('review-updated');
        cruReviewUtil.reviewUpdatedAjax({
            done: function () {
                if (AJS.$('body').hasClass('review-updated')) {
                    if (notShownYet || opts.reshowWarning) {
                        AJS.$('#review-updated-warning').slideDown('fast');
                    }
                }
                opts.done && opts.done();
            },
            error: opts.error
        });
    };

    cruReviewUtil.reorderParticipants = function () {
        var parent = AJS.$("#participant-list-runner");
        var children = parent.children();

        var sortedReviewers = review.getReviewersSortedByCompletedness();

        for (var i = 0, len = children.length; i < len; i++) {
            var idExpected = sortedReviewers[i].getId();
            var child = children[i];
            if (child.id !== ('review-participant-' + idExpected)) {
                AJS.$(child).before(AJS.$('#review-participant-' + idExpected, parent));
                children = parent.children();
            }
        }

        var reviewerCompleted = {};
        for (i = sortedReviewers.length; i-- > 0;) {
            reviewerCompleted[sortedReviewers[i].getId()] = sortedReviewers[i];
        }

        $('#reviewers .review-avatar, #inline-dialog-more-reviewers .review-avatar').each(function () {
            var $avatar = $(this);
            var id = $avatar.data('user-id');

            $avatar.toggleClass('completed', !!(reviewerCompleted[id] && reviewerCompleted[id].m_hasCompleted));
        })
    };

    cruReviewUtil.redrawStatePercentComplete = function (complete) {
        var $statusBar = AJS.$('.status-open');
        $statusBar.closest('ul').attr('title', complete + '% complete');
        //12 is the minimum, 180 is the width including the first 12, so we need to * by 180 - 12 = 168
        var completeChunk = (12 + (complete / 100 * 168));
        $statusBar.css({
            "background-position": completeChunk + "px 0px"
        });
    };

    /**
     * If on the review page, checks if the review has been updated since last refresh.
     *
     * If the review has been updated, the body has the class `review-updated` added.
     * Silently fails if the Ajax request fails.
     *
     * @param opts.done no arg callback called regardless of whether the request is made.
     * @param opts.checkOwnActions tell the UpdateAction to not disregard actions made by the currently logged in user
     * @param opts.force ensure the review is updated even if the review isn't loaded
     * @param opts.error see noDialog param of fecruAjax.ajaxUpdate
     */
    cruReviewUtil.reviewUpdatedAjax = function (opts) {
        opts = opts || {};

        var util = cruUtil;
        if (!util.isReviewPage() || (!opts.force && !review.isLoaded())) {
            opts.done && opts.done();
            return;
        }

        var url = util.jsonUrlBase(review.id()) + '/reviewUpdatedAjax';

        var timeSpent = cruReviewTimer.getAndReset();
        var params = {
            reviewRenderTime: review.getRenderTime().getTime(),
            reviewStateName: review.getStateName(),
            backingOff: backingOff,
            timeSpent: timeSpent,
            checkOwnActions: opts.checkOwnActions ? true : false
        };

        /*eslint-disable complexity, max-depth*/
        fecruAjax.ajaxDo(url, params, function (resp) {
            if (resp.worked) {
                var pending = review.getPending();
                var noticedChanged = pending.getUpdatedReviewCommentIds().length !== resp.updatedReviewComments.length ||
                    pending.getUpdatedFileCommentIds().length !== resp.updatedFileComments.length ||
                    pending.getUpdatedInlineCommentIds().length !== resp.updatedInlineComments.length ||
                    pending.isReloadRequired() !== resp.reloadRequired ||
                    pending.getAddedFrxIds().length !== resp.frxsAdded.length ||
                    pending.getUpdatedFrxIds().length !== resp.frxsUpdated.length ||
                    pending.getRemovedFrxIds().length !== resp.frxsRemoved.length ||
                    pending.getPendingStateName() !== resp.stateName ||
                    pending.getReviewersToBeAddedCount() !== resp.addedReviewersCount ||
                    pending.getReviewersToBeRemovedCount() !== resp.removedReviewersCount ||
                    pending.getAuthorChanged() !== resp.authorChanged ||
                    pending.getModeratorChanged() !== resp.moderatorChanged ||
                    pending.getRoleChanged() !== resp.roleChanged ||
                    pending.hasBeenUncompleted() !== resp.hasBeenUncompleted;

                review.setLastCheckedUpdateTime(new Date(resp.renderTime));
                pending.setUpdatedReviewCommentIds(resp.updatedReviewComments)
                    .setUpdatedFileCommentIds(resp.updatedFileComments)
                    .setUpdatedInlineCommentIds(resp.updatedInlineComments)
                    .setReloadRequired(resp.reloadRequired)
                    .setDetailsChanged(resp.detailsChanged)
                    .setUpdatedFrxIds(resp.frxsUpdated)
                    .setAddedFrxIds(resp.frxsAdded)
                    .setRemovedFrxIds(resp.frxsRemoved)
                    .setUnreadFrxIds(resp.unreadFrxs)
                    .setPendingStateName(resp.stateName)
                    .setPendingMetaStateName(resp.metaStateName)
                    .setHasBeenUncompleted(resp.hasBeenUncompleted)
                    .setReviewersToBeAddedCount(resp.addedReviewersCount)
                    .setReviewersToBeRemovedCount(resp.removedReviewersCount)
                    .setAuthorChanged(resp.authorChanged)
                    .setModeratorChanged(resp.moderatorChanged)
                    .setRoleChanged(resp.roleChanged)
                    .setLastLogItemTimestamp(resp.lastLogItemTimestamp);

                $('#frx-pane').trigger('review-pending-update', pending);

                if (resp.alsoViewingHtml) {
                    cruReviewUtil.displayAlso(resp.alsoViewingHtml);
                } else {
                    AJS.$('#also-viewing').hide();
                }

                var $timeSpentInput = AJS.$('#time-spent-input');
                if (resp.timeSpent && !cruReviewTimer.editing) {
                    $timeSpentInput.val(resp.timeSpent).show();
                }

                if (pending.isPendingClosed()) {
                    AJS.$('#time-spent').addClass('disabled')
                        .removeClass('enabled');
                    $timeSpentInput.prop('disabled', true)
                        .addClass('disabled')
                        .removeClass('enabled');
                } else {
                    AJS.$('#time-spent').removeClass('disabled')
                        .addClass('enabled');
                    $timeSpentInput.removeProp('disabled')
                        .removeClass('disabled')
                        .addClass('enabled');
                }

                AJS.$('#review-updated-warning div.more-info').html(resp.updateMessageHtml);

                var details = resp.participantDetails;
                if (details) {
                    var completednessChanged = false;
                    for (var i = 0, len = details.length; i < len; i++) {
                        var values = details[i];
                        var user = values.user;
                        var percentage = values.percentage;
                        var isComplete = values.isComplete;
                        var chunk = 100 - percentage;

                        var changed = review.updateReviewerCompleteness(user, percentage, isComplete);

                        var $detailsParticipantRow = AJS.$("#details-participant-" + user);
                        if (changed) {
                            var $headerParticipant = AJS.$("#review-participant-" + user);
                            $detailsParticipantRow.find('.reviewer').toggleClass("completedReviewer", isComplete);
                            $headerParticipant.toggleClass("completedReviewer", isComplete);
                            var $progress = $headerParticipant.children(".reviewer-progressbar");
                            var $detailsProgress = $detailsParticipantRow.find('.reviewer-progressbar');
                            if ($progress.length > 0) {
                                $progress.css({"background-position": chunk + "% 0%"});
                                $progress.attr('title', percentage + '% reviewed');
                                $detailsProgress.css({"background-position": chunk + "% 0%"});
                                $detailsProgress.attr('title', percentage + '% reviewed');
                                $detailsParticipantRow.find('.role-progress').text(percentage);
                            }
                            completednessChanged = true;
                        }
                        if (values.timeSpent) {
                            $detailsParticipantRow.children('.timeSpent').text(values.timeSpent);
                        }
                    }
                    AJS.$('#details-participants-total').children('.timeSpent').text(resp.totalTimeSpent);
                    if (completednessChanged) {
                        cruReviewUtil.reorderParticipants();
                    }

                    reloadCommentDetails(details);
                }

                if (resp.reviewStatePercentComplete !== review.getStatePercentComplete()) {
                    review.setStatePercentComplete(resp.reviewStatePercentComplete);
                    cruReviewUtil.redrawStatePercentComplete(review.getStatePercentComplete());
                }

                if (resp.issueKey !== review.issueKey()) {
                    review.setIssueKey(resp.issueKey);
                }

                if (resp.showMessage) {
                    if (!opts.recheck) {
                        AJS.$('body').addClass('review-updated');
                    }
                } else {
                    AJS.$('body').removeClass('review-updated');
                }

                if (noticedChanged) {
                    AJS.$('#review-updated-warning')
                        .removeClass('collapsed')
                        .find('a.collapse')
                        .text('Collapse');
                }
            } else {
                //on error, roll time that should have been logged back into the timer for the next update
                cruReviewTimer.elapsedTime += timeSpent;
            }
            opts.done && opts.done();
        }, opts.error);
    };
    /*eslint-enable*/

    var reloadCommentDetails = function (participantCommentDetails) {
        var participantTotalComments = 0;
        var participantTotalDefects = 0;
        for (var i = 0, len = participantCommentDetails.length; i < len; i++) {
            var participant = participantCommentDetails[i];
            var userId = participant.user;
            var detailsParticipant = AJS.$('#details-participant-' + userId);

            detailsParticipant.find('.latest-comment').html(participant.latestComment || '');
            detailsParticipant.find('.authored-comments').text(participant.authoredComments || '');

            participantTotalComments += participant.authoredCommentCount;
            participantTotalDefects += participant.authoredDefectCount;
        }
        //update comment total
        var totalDefectString;
        switch (participantTotalDefects) {
            case 0:
                totalDefectString = '';
                break;
            case 1:
                totalDefectString = ' (' + participantTotalDefects + ' defect)';
                break;
            default:
                totalDefectString = ' (' + participantTotalDefects + ' defects)';
                break;
        }
        AJS.$('#details-participants-total').find('.authored-comments').text(participantTotalComments + totalDefectString);
    };


    var DELAY_MIN = 1000 * 20;
    var DELAY_MAX = 1000 * 60 * 60;
    var DELAY_MULTIPLIER = 1.25;
    var INACTIVITY_BEFORE_BACKOFF = 1000 * 60 * 5;

    var lastActivityMs = new Date().getTime();
    var backingOff = false;
    var pollingDelay = DELAY_MIN;

    /**
     * For the first INACTIVITY_BEFORE_BACKOFF ms (e.g., 5 min) since the last activity, poll
     * every DELAY_MIN ms (e.g., 20 sec). After the INACTIVITY_BEFORE_BACKOFF, start backing
     * off the polling period to a maximum of DELAY_MAX ms (e.g., 1 hr).
     *
     * The backoff is required, e.g., if you leave your browser open overnight.
     */
    function calcTimeout() {

        var t = new Date().getTime() - lastActivityMs;
        if (t < INACTIVITY_BEFORE_BACKOFF) {
            backingOff = false;
            pollingDelay = DELAY_MIN;
        } else {
            backingOff = true;
            pollingDelay *= DELAY_MULTIPLIER;
            //also stop time-tracking if backing off
            cruReviewTimer.stop();
        }

        if (pollingDelay > DELAY_MAX) {
            pollingDelay = DELAY_MAX;
        } else if (pollingDelay < DELAY_MIN) {
            pollingDelay = DELAY_MIN;
        }
        return pollingDelay;
    }

    var pollingTimer;
    var pollRequestActive = false;


    function doPollingLoop() {
        var rutil = cruReviewUtil;
        if (!pollRequestActive) {
            pollRequestActive = true;
            rutil.warnAboutReviewUpdates({
                done: chainPollingLoop,
                // Continue requesting when the server is down in case it comes back up.
                error: chainPollingLoop
            });
        }
    }

    function chainPollingLoop() {
        pollingTimer = setTimeout(doPollingLoop, calcTimeout());
        pollRequestActive = false;
    }

    cruReviewUtil.resetInactivityTimer = function () {
        lastActivityMs = new Date().getTime();
    };

    var pollingIsBlocked = false;

    cruReviewUtil.blockReviewUpdatePolling = function () {
        cruReviewUtil.stopPollingForReviewUpdates();
        pollingIsBlocked = true;
    };

    cruReviewUtil.unblockReviewUpdatePolling = function () {
        pollingIsBlocked = false;
        cruReviewUtil.startPollingForReviewUpdates();
    };

    cruReviewUtil.startPollingForReviewUpdates = function () {
        if (pollingIsBlocked) {
            return;
        }
        cruReviewUtil.stopPollingForReviewUpdates();
        doPollingLoop();
    };

    cruReviewUtil.stopPollingForReviewUpdates = function () {
        if (pollingTimer) {
            clearTimeout(pollingTimer);
            pollingTimer = undefined;
        }
    };

    // also-viewing
    cruReviewUtil.displayAlso = function (viewing) {
        AJS.$("#bottom-status-notifications").css({
            bottom: AJS.$('#footer').outerHeight() + 15
        });
        AJS.$('#also-viewing').html(viewing).show();
    };

    // time-tracking
    cruReviewTimer.startTime = new Date().getTime();
    cruReviewTimer.elapsedTime = 0;
    cruReviewTimer.running = false;
    cruReviewTimer.editing = false;

    /* Start the timer (no-effect if already running) */
    cruReviewTimer.start = function () {
        var timer = cruReviewTimer;
        if (!timer.running) {
            timer.startTime = new Date().getTime();
            timer.running = true;
        }
    };

    /* Stop the timer (no-effect if not running) */
    cruReviewTimer.stop = function () {
        var timer = cruReviewTimer;
        if (timer.running) {
            timer.elapsedTime += new Date().getTime() - timer.startTime;
            timer.running = false;
        }
    };

    /* Get the counted ms and reset the timer */
    cruReviewTimer.getAndReset = function () {
        var timer = cruReviewTimer;
        if (timer.editing) {
            return 0;
        }
        timer.stop();
        var count = timer.elapsedTime;
        timer.elapsedTime = 0;
        timer.start();
        return count;
    };

    /* User is currently editing time spent - time is accrued, but not logged during this time */
    cruReviewTimer.startEditing = function () {
        cruReviewTimer.editing = true;
    };

    /* User has finished editing - ditch the accrued time if update was successful */
    cruReviewTimer.stopEditing = function (updated) {
        var timer = cruReviewTimer;
        timer.editing = false;
        if (updated) {
            timer.getAndReset();
        }
    };

    /* debug - I suspect we'll need this again
     cruReviewTimer.log = function (msg) {
     console.log(msg + " count=" + cruReviewTimer.count + " running=" + cruReviewTimer.running +
     " startTime=" + cruReviewTimer.startTime);
     };
     */

    var rowClassMatchFrom = /.*\bfrom(\d+)\b.*/;
    var rowClassMatchTo = /.*\bto(\d+)\b.*/;

    /**
     * get the line number of a tr.sourceLine
     *
     * @param $line an AJS.$('tr.sourceLine') with either a 'fromN' or 'toN' class
     * @param to true to get the to line number, false to get the from line number
     */
    cruReviewUtil.getLineNumber = function ($line, to) {
        if (!$line || $line.length === 0) {
            return null;
        }
        var classMatcher = to ? rowClassMatchTo : rowClassMatchFrom;
        var matches = $line[0].className.match(classMatcher);
        if (matches && matches.length > 1) {
            return parseInt(matches[1]);
        }
        return null;
    };

    cruReviewUtil.getTopVisibleLineNumber = function (frxId) {
        var $sourceLines = AJS.$('#sourceTable' + frxId).children('tbody').children('tr.sourceLine');
        var high = $sourceLines.length;
        var low = 0;
        var middle = low + Math.floor((high - low) / 2);
        var found = false;

        while (middle > low && middle < high && !found) {
            var $middleLine = AJS.$($sourceLines[middle]);
            if ($middleLine.is(':in-viewport-vert(80, frx-pane)')) {
                found = true;
                break;
            } else if ($middleLine.is(':above-the-top(80, frx-pane)')) {
                low = middle;
            } else {
                high = middle;
            }
            middle = low + Math.floor((high - low) / 2);
        }

        if (!found) {
            return 0;
        } else {
            while (middle > 0 && $middleLine.is(':in-viewport-vert(80, frx-pane)')) {
                middle--;
                $middleLine = AJS.$($sourceLines[middle]);
            }
            if ($middleLine.hasClass('toLine')) {
                return cruReviewUtil.getLineNumber($middleLine, true);
            } else {
                return cruReviewUtil.getLineNumber($middleLine, false);
            }
        }
    };

    //opt can have the following properties:
    // - newValue
    // - wikiInputFieldSelector
    // - htmlOutputElementSelector
    cruReviewUtil.updateReviewField = function (type, urlSuffix, opt, callback) {
        var url = CRU.UTIL.jsonUrlBase(permaId) + urlSuffix;

        opt = opt || {};

        var $fieldDiv = AJS.$('#' + type + '-input');
        var $inputFields = $fieldDiv.children('.input');
        var $outputFields = AJS.$('#' + type + '-markup');
        var newValue = opt.newValue !== undefined ? opt.newValue : $inputFields.val();

        //add the extra input fields
        if (opt.wikiInputFieldSelector) {
            $inputFields = $inputFields.add(opt.wikiInputFieldSelector);
        }
        //sync them up
        $inputFields.val(newValue);

        //add the extra output fields
        if (opt.htmlOutputElementSelector) {
            $outputFields = $outputFields.add(opt.htmlOutputElementSelector);
        }
        var $submitTitle = $inputFields.find('.submit-' + type + '');
        $submitTitle.addClass('spinner');

        FECRU.AJAX.ajaxDo(url, {input: newValue}, function (resp) {
            $submitTitle.removeClass('spinner');
            if (resp.worked) {
                AJS.$('#' + type + '-markup').html(resp.payloadHtml);
                $inputFields.add($fieldDiv.children('.backup')).val(resp.payload);
                $outputFields.html(resp.payloadHtml);
                cruReviewUtil.discardNewField(type);
                callback && callback();
            }
        });
    };

    cruReviewUtil.discardNewField = function (type) {
        var $inputField = AJS.$('#' + type + '-input');
        if ($inputField.find('.submit-' + type + '').hasClass('spinner')) {
            return;
        }
        $inputField.hide();
        CRU.REVIEW.WIKI.resetPreview(type + '-input');
        AJS.$('#' + type + '-markup').show();
        //this needs a timeout because of a conflict with leaving the input box (or something like that)
        $inputField.trigger(type + '-form-hidden');
        setTimeout(function () {
            var objectives = $inputField.children('.backup').val();
            $inputField.find('.input').val(objectives);
        }, 200);
    };


    cruReviewUtil.triggerSourceCodeShown = function (frxId) {
        if (commentator.showSource) {
            eventBusProvider().trigger('source-code:shown', {
                key: frxId,
                page: 'review'
            });
        }
    };

    cruReviewUtil.triggerSourceCodeHidden = function (frxId) {
        eventBusProvider().trigger('source-code:hidden', {key: frxId});
    };

    cruReviewUtil.triggerSourceCodeReset = function (frxId) {
        eventBusProvider().trigger('source-code:reset', {key: frxId});
    };

    AJS.$(document).ready(function () {

        // Poll immediately on focus and start the polling loop.
        AJS.$(window).focus(function () {
            if (review.isLoaded()) {
                // Restart polling for updates.
                cruReviewUtil.resetInactivityTimer();
                cruReviewUtil.startPollingForReviewUpdates();
                cruReviewTimer.start();
            } else {
                // Once all FRXs are loaded, frx.js calls startPollingForReviewUpdates.
            }
        });

        // Resetting on keypress (of shortcuts) is handled by keynav.js since it prevents propagation.
        AJS.$('body').click(function () {
            cruReviewUtil.resetInactivityTimer();
            cruReviewTimer.start();
        });

        // Don't poll at all when the window doesn't have focus.
        AJS.$(window).blur(function () {
            cruReviewUtil.stopPollingForReviewUpdates();
            cruReviewTimer.stop();
        });

        /* because $(window).blur() is inneffective when switching tabs in FF */
        AJS.$(document).blur(function () {
            //todo should we add AJS_review_util.stopPollingForReviewUpdates(); here?
            cruReviewTimer.stop();
        });

        var removeAndReloadFrxs = function () {
            var pending = review.getPending();
            var toBeRemovedFrxIds = pending.getRemovedFrxIds();
            var removeFrxFromPage = CRU.CREATE.removeFrxFromPage;
            for (var i = 0, len = toBeRemovedFrxIds.length; i < len; i++) {
                removeFrxFromPage(toBeRemovedFrxIds[i]);
            }

            var pendingUnreadFrxIds = pending.getUnreadFrxIds();
            for (i = 0, len = pendingUnreadFrxIds.length; i < len; i++) {
                cruFrx.AJAX.changeFileReadStatusClass(pendingUnreadFrxIds[i], false, 'unread');
            }

            AJS.$('#review-meta-links .file-count').text(review.frxs().length);

            pending.setAddedFrxIds([]);
            cruFrx.reloadFrxs({}, pending.getUpdatedFrxIds());
        };

        var processUpdatedComments = function (commentsToRetrieve, updatedComments, commentsToRemove, type, commentContainer) {
            for (var i = 0, len = updatedComments.length; i < len; i++) {
                var commentResp = updatedComments[i];

                if (type === 'revision') {
                    var $beforeElem = $('#fileCommentForm' + (commentResp.frxId || ''));
                }
                commentator.replaceOrInsertComment(type,
                    commentResp.id,
                    commentResp.commentHtml,
                    commentContainer + (commentResp.frxId || ''), {
                        $beforeElem: $beforeElem
                    });
                commentator.createOrUpdateComment(commentResp);
                var comment = review.comment(commentResp.id);
                deleteCommentIdsFromList(commentsToRemove, comment);
                commentsToRetrieve.pop(commentResp.id);

                if (type === 'revision') {
                    var $revisionComments = AJS.$('#revision_comments_frxinner' + commentResp.frxId);
                    $revisionComments.toggleClass('hidden', review.frx(commentResp.frxId).fileComments().length === 0);
                }
            }
        };

        var deleteCommentIdsFromList = function (commentsToRemove, comment) {
            delete commentsToRemove[comment.id()];
            for (var i = 0, len = comment.getReplies().length; i < len; i++) {
                deleteCommentIdsFromList(commentsToRemove, comment.getReplies()[i]);
            }
        };

        AJS.$(document).delegate('#review-updated-warning a.reload', 'click', function () {
            cruReviewUtil.reloadReview();
            return false;
        });

        cruReviewUtil.reloadReview = function (forceAndCheckOwnActions, onReloadComplete) {
            FECRU.eventBus.trigger('review:before:reload');
            var frxId = cruFrx.NAV.getCurrentFrxId();
            var commentForm = commentator.getDisplayingCommentForm();
            if (commentForm) {
                var frxOuterId = commentator.getDisplayingCommentForm().getTextBox().closest('.frxouter').attr('id');
                var scrollToFrxId = frxOuterId !== 'generalComments' ? frxOuterId.replace(/^frxouter/, '') : frxOuterId;
                cruFrx.NAV.gotoFrx({frxId: scrollToFrxId, destination: ''});
                commentForm.getTextBox().focus();
                AJS.$('#review-updated-warning .comment-warning').show();
                onReloadComplete && onReloadComplete();
                return false;
            } else {
                AJS.$('#review-updated-warning .comment-warning').hide();
            }
            if (review.frx(frxId)) {
                window.location.hash = 'CFR-' + frxId;
            }
            if (review.getPending().isReloadRequired()) {
                window.location.reload();
            } else {
                cruReviewUtil.reviewUpdatedAjax({
                    checkOwnActions: forceAndCheckOwnActions,
                    force: forceAndCheckOwnActions,
                    done: function () {
                        // review is now up to date - update render times as though
                        // entire page was loaded at the last check time
                        // If there was no last check, set it to now.
                        var lastChecked = review.getLastCheckedUpdateTime();

                        var pending = review.getPending();

                        if (pending.hasBeenUncompleted()) {
                            var $uncompleteButton = AJS.$('.stateAction.uncomplete');
                            $uncompleteButton.unbind('click')
                                .attr('onclick', '')
                                .click(function () {
                                    cruUtil.stateTransition('action:completeReview', permaId);
                                })
                                .removeClass('uncomplete')
                                .addClass('complete')
                                .text('Complete');
                            pending.setHasBeenUncompleted(false);
                        }

                        var detailsOpts = {};
                        if (pending.getReviewersToBeAddedCount() > 0 ||
                            pending.getReviewersToBeRemovedCount() > 0 ||
                            pending.getAuthorChanged() ||
                            pending.getModeratorChanged()) {
                            detailsOpts.getParticipants = true;
                        }

                        if (pending.getDetailsChanged()) {
                            detailsOpts.getDetails = true;
                        }

                        if (!AJS.$.isEmptyObject(detailsOpts)) {
                            reloadDetails(detailsOpts);
                        }

                        if (pending.getUpdatedReviewCommentIds().length > 0 ||
                            pending.getUpdatedFileCommentIds().length > 0 ||
                            pending.getUpdatedInlineCommentIds().length > 0) {
                            removeAndReloadComments();
                        }

                        if (pending.getAddedFrxIds().length > 0) {
                            CRU.CREATE.retrieveNewFrxs(function () {
                                pending.setAddedFrxIds([]);
                                removeAndReloadFrxs();
                                onReloadComplete && onReloadComplete();
                            });
                        } else {
                            removeAndReloadFrxs();
                            onReloadComplete && onReloadComplete();
                        }
                        if (lastChecked) {
                            review.setRenderTime(lastChecked);
                        }
                        FECRU.eventBus.trigger('review:reload', pending);
                    },
                    recheck: true
                });
            }
            AJS.$('body').removeClass('review-updated');
        };

        /**
         * @param {Object} opts to specify which details to load. Currently supports getParticipants and getDetails
         */
        var reloadDetails = function (opts) {
            var url = cruUtil.jsonUrlBase(permaId) + '/retrieveReviewDetailsAjax';

            fecruAjax.ajaxDo(url, opts, function (resp) {
                var participants = resp.participants;
                if (resp.participants) {
                    AJS.$("#participant-table").replaceWith(participants.participantTable);
                    AJS.$(".review-header--metadata--participants").replaceWith(participants.reviewExtraParticipants);
                    review.clearReviewers();
                    review.getPending()
                        .setReviewersToBeAddedCount(0)
                        .setReviewersToBeRemovedCount(0)
                        .setAuthorChanged(false)
                        .setModeratorChanged(false);

                    var reviewers = participants.reviewers;
                    for (var i = 0, len = reviewers.length; i < len; i++) {
                        var r = reviewers[i];
                        review.setReviewer(r.id, r.userName, r.displayName, r.percentageComplete, r.isComplete, r.avatarUrl);
                    }
                    cruReviewUtil.reorderParticipants();

                    var author = participants.author;
                    review.setAuthor(author.id, author.userName, author.displayName, author.avatarUrl);

                    var moderator = participants.moderator;
                    if (moderator) {
                        review.setModerator(moderator.id, moderator.userName, moderator.displayName, moderator.avatarUrl);
                    }
                }

                if (resp.reviewActions) {
                    AJS.$('#page-actions').html(resp.reviewActions);
                }
                $(document).trigger('ajax-dialog-loaded');
                var details = resp.details;
                if (details) {
                    if (details.reviewDueDateHtml) {
                        var $reviewDueDate = AJS.$('.review-header--metadata--due-date');
                        if ($reviewDueDate.length) {
                            $reviewDueDate.replaceWith(details.reviewDueDateHtml);
                        } else {
                            AJS.$('.review-header--metadata .review-header--metadata--section:first-child')
                                .append(details.reviewDueDateHtml);
                        }
                    }
                    if (details.reviewHead) {
                        CRU.REVIEW.reviewTitle.setTitle(details.reviewHeadRaw, details.reviewHead);
                    }

                    if (details.reviewMetaLinks) {
                        AJS.$("#review-meta-links").html(details.reviewMetaLinks);
                    }

                    if (details.objectives) {
                        var $objectives = AJS.$("#objectives");

                        $objectives.find("#objectives-markup")
                            .toggleClass('editable', details.objectives.editable)
                            .html(details.objectives.markup);

                        $objectives.find("#objectives-input > .input")
                            .val(details.objectives.editable);

                        $objectives.find("#objectives-backup")
                            .val(details.objectives.editable);
                    }
                }
                $('#frx-pane').trigger('review-details-updated');
                review.setLastUpdatedTime(review.getLastCheckedUpdateTime());
            });
        };

        var removeAndReloadComments = function () {
            var commentator = CRU.COMMENT;
            var url = cruUtil.jsonUrlBase(permaId) + '/retrieveCommentsAjax';

            var pending = review.getPending();
            var reviewCommentsToRetrieve = pending.getUpdatedReviewCommentIds();
            var fileCommentsToRetrieve = pending.getUpdatedFileCommentIds();
            var inlineCommentsToRetrieve = pending.getUpdatedInlineCommentIds();

            var params = {};
            if (reviewCommentsToRetrieve && reviewCommentsToRetrieve.length) {
                params.reviewCommentsToRetrieve = reviewCommentsToRetrieve;
            }
            if (fileCommentsToRetrieve && fileCommentsToRetrieve.length) {
                params.fileCommentsToRetrieve = fileCommentsToRetrieve;
            }
            if (inlineCommentsToRetrieve && inlineCommentsToRetrieve.length) {
                params.inlineCommentsToRetrieve = inlineCommentsToRetrieve;
                var frxIds = [];
                var frxFromRevs = [];
                var frxToRevs = [];
                AJS.$.each(review.frxs(), function (i, frx) {
                    frxIds.push(frx.id());
                    frxFromRevs.push(frx.visibleFromRevision() || frx.visibleToRevision());
                    frxToRevs.push(frx.visibleToRevision());
                });
                params.frxIds = frxIds;
                params.frxFromRevs = frxFromRevs;
                params.frxToRevs = frxToRevs;
            }

            /*eslint-disable complexity, max-depth*/
            fecruAjax.ajaxDo(url, params, function (resp) {
                if (resp.worked) {
                    var commentsToRemove = {}; //add all comments to retrieve, then remove each as we retrieve them. remove any comments still in the list
                    var i;
                    var len;

                    for (i = 0, len = reviewCommentsToRetrieve.length; i < len; i++) {
                        commentsToRemove[reviewCommentsToRetrieve[i]] = true;
                    }
                    for (i = 0, len = fileCommentsToRetrieve.length; i < len; i++) {
                        commentsToRemove[fileCommentsToRetrieve[i]] = true;
                    }
                    for (i = 0, len = inlineCommentsToRetrieve.length; i < len; i++) {
                        commentsToRemove[inlineCommentsToRetrieve[i]] = true;
                    }

                    processUpdatedComments(reviewCommentsToRetrieve, resp.updatedReviewComments, commentsToRemove, 'general', 'general-comments-container');
                    pending.clearUpdatedReviewCommentIds();

                    processUpdatedComments(fileCommentsToRetrieve, resp.updatedFileComments, commentsToRemove, 'revision', 'revision_comments_frxinner');
                    pending.clearUpdatedFileCommentIds();

                    var updatedInlineComments = resp.updatedInlineComments;

                    for (i = 0, len = updatedInlineComments.length; i < len; i++) {
                        var commentResp = updatedInlineComments[i];
                        var commentRespId = commentResp.id;

                        //remove the old comment if it exists
                        if (review.comment(commentRespId)) {
                            commentator.removeCommentHtml(review.comment(commentRespId));
                        }

                        var frx = review.frx(commentResp.frxId);

                        //insert 'above' comment
                        AJS.$("#inline_comments_frxinner" + frx.id()).append(commentResp.aboveCommentHtml);

                        var isFromOnSkippedLines = false;
                        var isToOnSkippedLines = false;
                        var isOnSkippedLines = false;
                        if (!commentResp.hidden) {
                            var lastTo = commentResp.lastTo;
                            var lastFrom = commentResp.lastFrom;
                            var $sourceFrxInner = AJS.$("#sourcefrxinner" + frx.id());
                            var $lastToLine = $sourceFrxInner.find("tr.to" + lastTo + '.sourceLine');
                            var $lastFromLine = $sourceFrxInner.find("tr.from" + lastFrom + '.sourceLine');


                            //if lastFromLine or lastToLine is not found, look in skipped sections
                            if ($lastToLine.length === 0 || $lastFromLine.length === 0) {
                                var $startOfDiff = $sourceFrxInner.find("#diffStart" + frx.id());
                                var $firstFromLine = $sourceFrxInner.find(".sourceLine.commentableLine.fromLine:first");
                                var $firstToLine = $sourceFrxInner.find(".sourceLine.commentableLine.toLine:first");
                                if ($firstFromLine.length === 1) {
                                    var firstFromLine = cruReviewUtil.getLineNumber($firstFromLine, false);
                                    if (lastFrom <= firstFromLine) {
                                        $lastFromLine = $startOfDiff;
                                        isFromOnSkippedLines = true;
                                    }
                                }
                                if ($firstToLine.length === 1) {
                                    var firstToLine = cruReviewUtil.getLineNumber($firstToLine, true);
                                    if (lastTo <= firstToLine) {
                                        $lastToLine = $startOfDiff;
                                        isToOnSkippedLines = true;
                                    }
                                }

                                var $skippedSections = $sourceFrxInner.find('tr.diffSkipped');
                                for (var sectionIndex = 0, sectionLength = $skippedSections.length; sectionIndex < sectionLength; sectionIndex++) {
                                    if ($lastToLine.length > 0 && $lastFromLine.length > 0) {
                                        break;
                                    }
                                    var $skippedSection = AJS.$($skippedSections[sectionIndex]);
                                    var skippedSectionIdBits = $skippedSection.attr('id').split('_');
                                    if (lastFrom > 0 && $lastFromLine.length === 0) {
                                        var nextFrom = parseInt(skippedSectionIdBits[1], 10);
                                        if (lastFrom <= nextFrom) {
                                            $lastFromLine = $skippedSection;
                                            isFromOnSkippedLines = true;
                                        }
                                    }
                                    if (lastTo > 0 && $lastToLine.length === 0) {
                                        var nextTo = parseInt(skippedSectionIdBits[2], 10);
                                        if (lastTo <= nextTo) {
                                            $lastToLine = $skippedSection;
                                            isToOnSkippedLines = true;
                                        }
                                    }
                                }

                                if ($lastToLine.length === 0 && lastTo !== 0) { //there is supposed to be a to line but we cant see it
                                    $lastToLine = $sourceFrxInner.find("tr:last");
                                    isToOnSkippedLines = true;
                                }
                                if ($lastFromLine.length === 0 && lastFrom !== 0) { //there is supposed to be a from line but we cant see it
                                    $lastFromLine = $sourceFrxInner.find("tr:last");
                                    isFromOnSkippedLines = true;
                                }
                            }

                            //get the last of lastFromLine and lastToLine
                            var lastSelectedLine;
                            if ($lastToLine.length === 0) {
                                lastSelectedLine = $lastFromLine;
                                isOnSkippedLines = isFromOnSkippedLines;
                            } else if ($lastFromLine.length === 0) {
                                lastSelectedLine = $lastToLine;
                                isOnSkippedLines = isToOnSkippedLines;
                            } else {
                                // Find all the lines *after* the lastToLine. if the lastFromLine is not in this resultset,
                                // then the last physical line must be the lastToLine, otherwise it must be the lastFromLine
                                var $subsequentSiblings = $lastToLine.nextAll();
                                if ($subsequentSiblings.index($lastFromLine) < 0) {
                                    lastSelectedLine = $lastToLine;
                                    isOnSkippedLines = isToOnSkippedLines;
                                } else {
                                    lastSelectedLine = $lastFromLine;
                                    isOnSkippedLines = isFromOnSkippedLines;
                                }
                            }

                            //insert the comment in line
                            if (lastSelectedLine) {
                                var colSpan = frx.colspan();
                                var $cell = AJS.$("<td colspan='" + colSpan + "'><div class='comment-list'></div></td>");
                                $cell.children('div').html(commentResp.inlineCommentHtml);
                                AJS.$("<tr class='comment-row'></tr>")
                                    .append($cell)
                                    .insertAfter(lastSelectedLine);
                                $cell.trigger('comment-added');
                            }
                        }

                        //update review-model and arrays
                        commentator.createOrUpdateComment(commentResp);
                        inlineCommentsToRetrieve.pop(commentRespId);
                        delete commentsToRemove[commentRespId];
                        var replyComments = commentResp.replyComments;
                        if (replyComments) {
                            for (var k = 0, kk = replyComments.length; k < kk; k++) {
                                delete commentsToRemove[replyComments[k].id];
                            }
                        }

                        tetrisCommentController.renderTetrisCommentMarkersForComment(commentRespId);

                        //set 'skipped line' message
                        if (lastSelectedLine && isOnSkippedLines) {
                            var $resp = AJS.$('#' + review.comment(commentRespId).domId());
                            $resp.find('.comment-actions-primary')
                                .append('<span class="moreComments">' +
                                '<a class="comment-skipped" id="comment-skipped' + commentRespId + '" ' +
                                'title="click to show full context">Comment on skipped line ' +
                                (lastTo === 0 ? lastFrom : lastTo) + (lastTo === 0 ? '(revision ' +
                                commentResp.fromRevString + ')' : '') + '</a>' +
                                '</span>');
                        }
                    }
                    pending.clearUpdatedInlineCommentIds();

                    // delete any comments not returned
                    for (var commentId in commentsToRemove) {
                        if (commentsToRemove.hasOwnProperty(commentId)) {
                            var comment = review.comment(commentId);
                            if (comment) {
                                commentator.removeCommentHtml(review.comment(commentId));
                                review.removeComment(comment);

                                if (comment.frx()) {
                                    commentator.checkGeneralCommentsWarning(comment.frx().id());
                                } else {
                                    commentator.checkGeneralCommentsWarning();
                                }
                            }
                        }
                    }
                    commentator.updateCommentCount();

                    // update participant comment details
                    reloadCommentDetails(resp.participantCommentDetails);

                    // update comments width
                    commentator.setCommentWidths(null, true);
                }

            });
        };
        /*eslint-enable*/

        //start time-tracking
        cruReviewTimer.start();
    });

})(
    AJS.$,
    function () {
        return FECRU.eventBus
    }
);
/*[{!util_js_oi5d51e!}]*/