(function () {

    AJS.$(document).ready(function () {

        var isSubmittingTime = false;

        AJS.$(document).delegate("#submit-time-jira", "click", function (e) {
            if (!isSubmittingTime) {
                submitTimeToJira(this);
            }
            e.preventDefault();
        });

        /* Concerning the JIRA time submit from the Summarize process */
        var submitTimeToJira = function (submitButton) {
            var $this = AJS.$(submitButton);
            var $container = AJS.$("#linked-jira-log-work > dd");
            var $submitterTime = AJS.$("#submitterTime");
            var $toolbar = $this.closest(".aui-toolbar");
            var $toolbarGroup = $this.closest(".toolbar-group");
            var url = CRU.UTIL.jsonUrlBase(review.id()) + '/updateJiraTimeAjax-post';
            var succeeded = false;
            var params = {
                comment: "Time submitted by " + review.getLoggedInUser().userName + " for review " + review.id(),
                timeToSubmit: $submitterTime.val(),
                username: review.getLoggedInUser().userName
            };
            var setError = function (errorMsg) {
                $toolbar.hide();
                AJS.messages.error($container, {
                    body: errorMsg || "An unknown error occurred.",
                    closeable: false
                });
            };
            var unsetError = function () {
                $container.children('.error').remove();
            };
            var done = function (data) {
                if (data.worked) {
                    succeeded = true;
                    $toolbar.hide();
                    var $message = $container.children(".already-logged-message");
                    if ($message.length === 0) {
                        $message = AJS.$("<span>")
                            .addClass("already-logged-message")
                            .appendTo($container);
                    }
                    if (data.timeSubmitted) {
                        $message.text("You have logged " + data.timeSubmitted);
                    } else {
                        $message.text("Logged " + params.timeToSubmit);
                    }
                } else {
                    setError(data.errorMsg);

                    if (data.credentialsRequired && data.credentialsRequired.length) {
                        // listen for any authorization and try again.
                        var eventProducers = [];
                        var reenableButtonOnCredentialsAcquired = function () {
                            Array.each(eventProducers, function (eventProducer) {
                                eventProducer.unbind('success', reenableButtonOnCredentialsAcquired);
                            });

                            // reshow the button
                            $this.prop("disabled", false);
                            $toolbarGroup.removeClass("loading");
                            unsetError();
                            $toolbar.removeClass("disabled").show();
                        };

                        Array.each(data.credentialsRequired, function (credentialsRequiredMessage) {
                            if (credentialsRequiredMessage.authUrl) {
                                var eventProducer = FECRU.OAUTH.getEventProducer(credentialsRequiredMessage.authUrl);
                                eventProducer.authorized(reenableButtonOnCredentialsAcquired);
                                eventProducers.push(eventProducer);
                            }
                        });
                    }
                }
                isSubmittingTime = false;
            };

            $this.attr("disabled", true).blur();
            $toolbar.addClass("disabled");
            $toolbarGroup.addClass("loading");

            // todo fix error handling
            isSubmittingTime = true;
            FECRU.AJAX.ajaxDo(url, params, done, true);
        };

        var hidden = true;

        /* Concerning the JIRA time submit inline hover from the review toolbar */
        var dialogHider = {
            boundToTrigger: false,
            refreshContentDiv: function ($contentDiv) {
                // aui fires off a bunch of these events, we need to track it ourselves
                if (hidden) {
                    hidden = false;
                    var url = CRU.UTIL.jsonUrlBase(review.id()) + '/updateJiraTimeAjax';
                    var params = {"username": review.getLoggedInUser().userName};
                    var done = function (resp) {
                        if (resp.worked) {
                            if (resp.timeSubmitted) {
                                $contentDiv.find("#time-sofar").html("(" + resp.timeSubmitted + " already submitted)");
                            }
                            $contentDiv.find(".submit-time-issue-label").text(resp.issueKey).attr("href", resp.issueUrl);
                            $contentDiv.find("#time-amount").val(resp.timeToSubmit);
                            $contentDiv.find("#time-issue").val(resp.issueKey);
                            var timeComment = $contentDiv.find("#time-comment");
                            if (timeComment.val() === "") {
                                //set comment if unset (e.g. on init)
                                timeComment.val("Review by " + review.getLoggedInUser().displayName);
                            }
                        }
                        $contentDiv.find(".submit-time-spinner").hide();
                    };

                    $contentDiv.find(".submit-time-spinner").show();
                    FECRU.AJAX.ajaxDo(url, params, done, false);
                    $contentDiv.data("dialogHider", dialogHider);
                }
            }
        };

        var contentHandler = function ($contentDiv, trigger, showPopup) {
            AJS.$(".submit-time-template").removeClass("submit-time-template").appendTo($contentDiv).show();
            dialogHider.refreshContentDiv($contentDiv);
            showPopup();
        };

        var options = {
            onHover: true,
            showArrow: true,
            fadeTime: 200,
            hideDelay: null,
            showDelay: 200,
            width: 393,
            offsetX: 0,
            offsetY: 7,
            container: "body",
            useLiveEvents: true,
            cacheContent: true, //we cache contents until the user submits the time logged
            upfrontCallback: function () {
                //provide a hook into the hide function
                var that = this;
                dialogHider.hideDialog = function () {
                    that.hide();
                };
                //refresh some contents on reload
                dialogHider.refreshContentDiv(that.popup.find(".contents"));
            },
            hideCallback: function () {
                hidden = true;
            }
        };

        AJS.InlineDialog(".submit-jira-time", "submit-time-inline-dialog", contentHandler, options);
    });

})();
/*[{!submit_time_js_yf4q51d!}]*/