window.CRU = window.CRU || {};
if (!CRU.REVIEW) {
    CRU.REVIEW = {};
}
if (!CRU.REVIEW.HISTORY) {
    CRU.REVIEW.HISTORY = {};
}

(function ($) {
    var historyDialog = null;

    CRU.REVIEW.HISTORY.showPage = function (permaId) {
        if (AJS.dropDown.current) {
            AJS.dropDown.current.hide();
        }

        if (!permaId) {
            AJS.log("I don't know which review to give you history for.");
            return;
        }

        historyDialog && historyDialog.remove();
        historyDialog = FECRU.DIALOG.create(1200, 700, "cru-review-history-dialog");

        var iframeStyle = "style='overflow:hidden;width:100%;height:" + (historyDialog.height - 48 - 44 - 23 - 17) + "px'"; // @2ADG (-17) for adg purposes
        var cs = "<iframe frameborder='0' id='reviewHistoryIframe' name='reviewHistoryIframe' scrolling='no' src='" + CRU.UTIL.urlBase(permaId) + "/reviewHistoryWrapper" + "' " + iframeStyle + "></iframe>";

        var header = "History of Review " + permaId;
        historyDialog.addHeader(header)
            .addPanel("History", cs);

        historyDialog.addButton("Done", function (dialog) {
            dialog.hide();
        }).show();

        AJS.$("#cru-review-history-dialog").data("dialog", historyDialog);//stores the object so we can access it from its contents
    };

    CRU.REVIEW.HISTORY.setupLinks = function () {
        var $document = AJS.$(document);
        $document.delegate("a.action-link", "click", function () {
            parent.top.AJS.$("#cru-review-history-dialog").data("dialog").hide();
        });
        $document.delegate("a.comment-link", "click", function () {
            var comment_nav = parent.top.CRU.COMMENT.NAV;
            var comment_id = AJS.$(this).prop('hash').replace('#c', '');

            var scrollToMap = comment_nav.navigateFindComment({commentId: comment_id});
            comment_nav.navigateDirectlyToElement({commentId: comment_id}, scrollToMap);
        });
        $document.delegate("a.frx-link", "click", function () {
            var frx_id = AJS.$(this).prop('hash').replace('#CFR-','');

            parent.top.CRU.FRX.NAV.gotoFrx({frxId: frx_id, destination: ''});
        });

    };
})(AJS.$);
/*[{!review_history_js_4j3b51c!}]*/