(function ($, analytics) {
    var send = function (name, meta) {
        analytics.send('cru.review.history.' + name, meta);
    };
    var sendItemClick = function (type) {
        send('item.click', {
            type: type
        });
    };
    var installListenersOnDetailsPage = function ($fbody) {
        $fbody.on('click', '.action-link.frx-link', function () {
            sendItemClick('details.frx');
        });
        $fbody.on('click', '.user', function () {
            sendItemClick('details.user');
        });
        $fbody.on('click', '.action-link.comment-link', function () {
            sendItemClick('details.comment');
        });
    };

    $(function () {
        analytics.sendOn('[data-analytics-event="history-export-csv"]', {
            name: 'cru.review.history.csv.export'
        });
        analytics.sendOn('[data-analytics-event="history-details"]', {
            name: 'cru.review.history.details.click'
        });
        analytics.sendOn('[data-analytics-event="history-timeline"]', {
            name: 'cru.review.history.timeline.click'
        });

        var detailsTab = $('#history-navigation-details');
        if (detailsTab.hasClass('active')) {
            send('details.show');
            $('#reviewHistory2Iframe').load(function () {
                installListenersOnDetailsPage($(this).contents(), analytics);
            });
        } else {
            send('timeline.show');
        }
    });
})(AJS.$, FECRU.ANALYTICS);