if (!CRU.REVIEW.EVENTS) {
    CRU.REVIEW.EVENTS = {};
}

(function () {
    var $document = AJS.$(document);
    $document.ready(function () {
        var cru_util = CRU.UTIL;
        var cru_review = CRU.REVIEW;
        var cru_review_util = CRU.REVIEW.UTIL;

        var $frxPane = AJS.$("#frx-pane");

        $frxPane.delegate('.frxouter:not(.activeFrx)', 'mousedown', function (e) {
            var $target = AJS.$(e.target || e.srcElement);
            if ($target.is('#generalComments, .frx-actions')
                || $target.parents('.frx-actions').length === 1) {
                return true;
            }
            CRU.FRX.NAV.setCurrentFrx(this, {sticky: true});
            var $parentRow = $target.closest('tr');
            if ($parentRow.length > 0 && !e.altKey) {
                return commentator.selectLine_down($parentRow, true);
            }
            return true;
        });

        var mouseDown = false;
        var onMouseOver = function () {
            return commentator.selectLine_over(AJS.$(this));
        };

        $frxPane.delegate('.activeFrx .inlineSource .commentableLine td:not(.tetrisColumn, .diffNav, .author, .revision)', "mousedown", function (e) {
            // only accept left clicks
            if (e.altKey || e.which !== 1) {
                return true;
            }

            if (!mouseDown) {
                // Event delegation for frx commentable lines.
                // Huge performance boost for reviews with thousands of lines of frx lines
                // Listener is needed only when mouse button is pressed
                $frxPane.delegate('.activeFrx .commentableLine', "mouseover", onMouseOver);
            }
            mouseDown = true;
            return commentator.selectLine_down(AJS.$(this).closest('tr.commentableLine'));
        });

        $frxPane.delegate('.activeFrx', "mouseup", function () {
            if (mouseDown) {
                mouseDown = false;
                $frxPane.undelegate('.activeFrx .commentableLine', "mouseover", onMouseOver);
                var frxId = this.id.replace('frxouter', '');
                var $inlineSource = AJS.$('#sourcefrxinner' + frxId).children('.inlineSource');
                return commentator.selectLine_up($inlineSource);
            }
            return true;
        });

        AJS.$("#parentReviewId, #linkReviewSaveButton").keypress(function (e) {
            var key = e.which || e.keyCode;
            var el = e.target || e.srcElement;
            if ((key === AJS.$.ui.keyCode.ENTER || key === AJS.$.ui.keyCode.TAB) && el.type !== 'textarea') {
                if (cru_review_util.postLinkedReview) {
                    cru_review_util.postLinkedReview();
                }
                return false;
                //TODO: Port to jQuery events and e.stopPropagation();
            }
        });

        $document.delegate("#linkReviewSaveButton", "click", function () {
            cru_review_util.postLinkedReview();
            return false;
        });

        $document.delegate("#linkReviewUnlinkButton", "click", function () {
            cru_review_util.postUnlinkReview();
            return false;
        });

        $document.delegate("#addInviteeButton", "click", function () {
            CRU.CREATE.addInvitee();
        });

        // Jira links get loaded by Ajax
        $document.delegate("#jiraIssueQuickLink", "click", function () {
            var suggestedIssueKey = AJS.$(this).siblings("input[name=suggestedIssueKey]").val();
            cru_review_util.findAndLinkJiraIssue(suggestedIssueKey);
            return false;
        });

        $document.delegate("#jiraFindButton", "click", function () {
            cru_review_util.findJiraIssue();
            return false;
        });

        $document.delegate("#jiraClearButton", "click", function () {
            cru_review_util.unlinkJiraIssue();
            return false;
        });

        var toggleAndResize = function ($elem) {
            $elem.toggle();
            CRU.UI.columnFillHeight();
        };

        AJS.$("#patchList").click(function () {
            toggleAndResize(AJS.$(this).siblings(".expandable"));
        });

        AJS.$('#clear-filter-link').click(function () {
            AJS.$('#frxFilterOptions li.selected').removeClass("selected");
            CRU.FRX.changedFrxFilter();
        });

        $document.delegate('#frxFilterOptions li.frx-filter-option:not(.disabled)', 'click', function (e) {
            AJS.$(this).toggleClass("selected");
            CRU.FRX.changedFrxFilter();
            e.stopPropagation(); // Don't let the menu be closed when selecting options
        });

        $document.delegate('#element-navigation', 'click', function (e) {
            if (e.target.id === 'element-navigation') {
                AJS.$('#element-link').click();
            }
        });

        $document.delegate('#element-navigation li.search-option', 'click', function (e) {
            var $option = AJS.$(this);
            // Only allow toggling of the item if one or more of the other options is still selected, to avoid being
            // able to select none of them (which is nonsensical)
            if ($option.siblings(".selected").length > 0) {
                $option.toggleClass("selected");
            }
            e.stopPropagation();
        });

        AJS.$('#next-element-link').click(function () {
            CRU.FRX.goToNextElement('next', AJS.$('#next-element-link'));
        });

        AJS.$('#prev-element-link').click(function () {
            CRU.FRX.goToNextElement('previous', AJS.$('#prev-element-link'));
        });

        AJS.$("#set-inline-comments a").click(function () {
            commentator.toggleComments('inline');
            CRU.COMMENT.NAV.visibleCommentsChanged();
        });

        AJS.$("#set-above-comments a").click(function () {
            commentator.toggleComments('top');
            CRU.COMMENT.NAV.visibleCommentsChanged();
        });

        AJS.$("#set-hidden-comments a").click(function () {
            commentator.toggleComments('none');
            CRU.COMMENT.NAV.visibleCommentsChanged();
        });

        AJS.$("#set-side-by-side-diffs a").click(function () {
            AJS.$("#set-unified-diffs").removeClass("selected");
            AJS.$("#set-side-by-side-diffs").addClass("selected");
            CRU.FRX.toggleAllFrxsDiffMode('s');
        });

        AJS.$("#set-unified-diffs a").click(function () {
            AJS.$("#set-side-by-side-diffs").removeClass("selected");
            AJS.$("#set-unified-diffs").addClass("selected");
            CRU.FRX.toggleAllFrxsDiffMode('u');
        });

        AJS.$("#set-soft-wrapping-on a").click(function () {
            AJS.$("#set-soft-wrapping-off").removeClass("selected");
            AJS.$("#set-soft-wrapping-on").addClass("selected");
            CRU.FRX.toggleAllFrxsSoftWrapping(true);
        });

        AJS.$("#set-soft-wrapping-off a").click(function () {
            AJS.$("#set-soft-wrapping-on").removeClass("selected");
            AJS.$("#set-soft-wrapping-off").addClass("selected");
            CRU.FRX.toggleAllFrxsSoftWrapping(false);
        });

        $document.delegate("#mark-comments-read-button:not(.disabled)", "click", function () {
            CRU.COMMENT.markAllCommentsRead();
        });

        $document.delegate("#addReviewCommentLink:not(.disabled)", "click", function () {
            cru_review.WIKI.resetPreview();
            commentator.displaySimpleCommentForm(null, 'generalCommentForm');
            AJS.$(this).hide();
        });

        $document.delegate(".addFileCommentLink:not(.disabled)", "click", function () {
            var frxId = this.id.replace('addFileCommentLink', '');
            cru_review.WIKI.resetPreview();
            commentator.displayFileCommentForm(null, 'fileCommentForm' + frxId, frxId);
        });

        $document.delegate("#review-updated-warning .close", "click", function () {
            AJS.$('#review-updated-warning').slideUp('fast');
            AJS.$('body').removeClass('review-updated');
        });

        $document.delegate("#review-updated-warning .collapse", "click", function () {
            var warning = AJS.$('#review-updated-warning');
            if (warning.hasClass('collapsed')) {
                warning.removeClass('collapsed');
                AJS.$('#review-updated-warning a.collapse').text('Collapse');
            } else {
                warning.addClass('collapsed');
                AJS.$('#review-updated-warning a.collapse').text('Expand');
            }
        });

        /** previous value of time-tracking field, in case of invalid update **/
        var prevMins = null;
        /** has current value of time-tracking field value been posted to server **/
        var savedMins = false;

        AJS.$("#time-spent-input")
            .live("click", function () {
                prepTimeSpentForInput();
            })
            .bind("blur", function () {
                saveUpdatedTimeSpent();
            })
            .keypress(function (e) {
                if (e.which === AJS.$.ui.keyCode.ENTER) {
                    e.preventDefault();
                    saveUpdatedTimeSpent();
                }
            });

        /** truncate 'minutes' from editable time field **/
        var prepTimeSpentForInput = function () {
            if (!cru_review.TIMER.editing) {
                cru_review.TIMER.startEditing();
                var $in = AJS.$("#time-spent-input");
                prevMins = $in.val();
                $in.parent().addClass("edit");
                savedMins = false;
            }
        };

        /** dispatch updated time spent to server (if valid) **/
        var saveUpdatedTimeSpent = function () {
            if (savedMins) {
                return; //don't dispatch twice
            }
            savedMins = true;

            var $in = AJS.$("#time-spent-input");
            var $container = $in.parent();

            $in.prop("disabled", true);
            $container.addClass('spinner');

            var url = cru_util.jsonUrlBase(permaId) + "/updateTimeTrackingAjax";
            var params = {timeText: $in.val()};
            FECRU.AJAX.ajaxUpdate(url, params, 'time-spent-input', function (resp) {
                $container.removeClass('spinner');
                cru_review.TIMER.stopEditing(resp.worked);
                if (!resp.worked) {
                    $container.css('background-color', 'pink');
                    setTimeout(function () {
                        $container.css('background-color', '');
                        $in.val(prevMins);
                    }, 750);
                } else {
                    $in.val(resp.payload);
                }
                $in.removeProp("disabled");
                $in.parent().removeClass("edit");
                //ensure focus is removed (e.g. when switching tabs/windows blur is triggered, but the input is still selected)
                $in.blur();
            }, true);
        };

        $document.delegate(".submit-time-dialog .submit-time-button", "click", function () {
            var $contentDiv = AJS.$(this).closest(".contents");
            $contentDiv.find(".submit-time-spinner").show();
            var url = cru_util.jsonUrlBase(review.id()) + '/updateJiraTimeAjax-post';
            var params = {
                "comment": $contentDiv.find("#time-comment").val(),
                "timeToSubmit": $contentDiv.find("#time-amount").val()
            };
            var done = function (resp) {
                /** todo - maybe show a little fade-in/fade-out "time has been updated" message on completeion **/
                var dialogHider = $contentDiv.data("dialogHider");
                dialogHider.hideDialog();
                $contentDiv.find("#time-comment").val(""); //clear comment (may have been customised)
                dialogHider.refreshContentDiv($contentDiv); //refresh contents on submit
                $contentDiv.find(".submit-time-spinner").hide();
            };
            FECRU.AJAX.ajaxDo(url, params, done, false);
        });

        /**
         * name of the cookie that is used to if the "Add Content" dialog has shown
         * @type {String}
         */
        var COOKIE_NAME_ADD_CONTENT_SHOWN = "editReviewShown";

        /**
         * name of the cookie that is used to record if the "Shown Details" dialog has shown
         * @type {String}
         */
        var COOKIE_NAME_REVIEW_DETAIL_SHOWN = "editReviewDetailShown";

        /**
         * Whether the edit review dialog has been shown during this browser session.
         *
         * Used to make sure a user is presented with this at least once for draft reviews.
         */
        var hasReviewPopupBeenShown = function (cookieName) {
            return AJS.$.inArray(review.id(), reviewIdsPopupShownFor(cookieName)) >= 0;
        };

        var reviewIdsPopupShownFor = function (cookieName) {
            var popupShown = AJS.$.cookie(cookieName);
            var ids = popupShown ? popupShown.split(',') : [];
            return ids;
        };


        /**
         * Capable of storing approximately 15 draft reviews
         * The total size for editReviewShown & editReviewDetailShown will be kept around 400 bytes.
         *
         * @type {Number}
         */
        var MAX_COOKIE_LIST_SIZE = 180;

        var addReviewIdToCookie = function (cookieName, reviewId) {
            var popupShown = reviewIdsPopupShownFor(cookieName);
            if (AJS.$.inArray(reviewId, popupShown) < 0) {
                popupShown.push(reviewId);
                writePopupShownToCookie(cookieName, popupShown);
            }
        }

        /**
         * This method will try to concatenate items with ','.
         * Meanwhile, the total size will be restricted to a certain limit. (MAX_COOKIE_LIST)
         * If it exceeds the limit, drop some item following FIFO rule.
         * Finally, the result string will be written to cookie.
         *
         * @param cookieName : string
         *  'editReviewShown' | 'editReviewDetailShown'
         * @param items : []
         *  _: string
         *
         */
        var writePopupShownToCookie = function (cookieName, items, skipLimitCheck) {
            items = items || [];
            var cookieValue = items.join(',');
            while (cookieValue.length > MAX_COOKIE_LIST_SIZE && !skipLimitCheck) {
                items.shift();
                cookieValue = items.join(',');
            }

            AJS.$.cookie(cookieName, cookieValue, {path: FECRU.pageContext + '/cru/'});
        };

        /**
         * Remove a review id from the cookie once the review is started
         */
        var removePopupShownFromCookie = function () {
            var reviewId = review.id();

            var removeCookie = function (cookieName, ids) {
                var index = AJS.$.inArray(reviewId, ids);
                if (index > -1) {
                    ids.splice(index, 1);
                    writePopupShownToCookie(cookieName, ids, true);
                }
            };
            removeCookie(COOKIE_NAME_ADD_CONTENT_SHOWN, reviewIdsPopupShownFor(COOKIE_NAME_ADD_CONTENT_SHOWN));
            removeCookie(COOKIE_NAME_REVIEW_DETAIL_SHOWN, reviewIdsPopupShownFor(COOKIE_NAME_REVIEW_DETAIL_SHOWN));
        };

        /**
         * When the review transits from draft to started,
         * we will remove the review id from cookie as it will not be used any more.
         */
        CRU.UTIL.onReviewStateTransit("remove-popup-shown-cookie", function (command, resp) {
            if ((command === 'action:approveReview' && resp.showDialog === false)
                || (command === 'confirmApprove')) {
                removePopupShownFromCookie();
            }
        });

        cru_review.baseUrlSuffix = '';

        $document.delegate('#add-content-methods .method:not(.disabled)', 'click', function () {
            var $self = AJS.$(this);
            $self.trigger('add-content-item-selected.review');
            manageFiles('/edit-' + $self.attr('id'), $self.data('url'));
        });

        var manageFilesDialog;

        var removeManageFilesDialog = function () {
            if (manageFilesDialog) {
                manageFilesDialog.remove();
                manageFilesDialog = null;
            }
            if (cru_review.EDIT) {
                cru_review.EDIT.closeSuggestions();
            }
        };

        cru_review.showManageFilesDialog = function (callback) {
            if (manageFilesDialog) {
                cru_util.stopAjaxDialogSpin();
                manageFilesDialog.show();
                callback && callback();
            }
        };

        var cachedAddContentPage;

        var getAddContentPage = function () {
            if (!cachedAddContentPage) {
                cachedAddContentPage = AJS.$(AJS.template.load("add-content-popup").toString());
            }
            return cachedAddContentPage;
        };

        //only add it if it exists in the tools dropdown
        var addTransitionIfExists = function (manageFilesDialog, $toolMenuBar, actionName, actionFunction) {
            var $button = $toolMenuBar.find(".action-" + actionName);
            if ($button.length > 0) {
                manageFilesDialog.addButton($button.first().text(), actionFunction);
            }
        };
        var performActionOnReview = function (action) {
            var done = function () {
                removeManageFilesDialog();
                cru_util.stateTransition('action:' + action, permaId);
            };
            cru_review_util.postEditDetailsForm(done);
        };
        /**
         * Returns a function that calls targetFunction in current context with given arguments
         *
         * @param {Function} targetFunction
         * @param {...*} targetFunctionArguments
         * @return {Function}
         */
        var prepopulateFunctionArguments = function (targetFunction, targetFunctionArguments) {
            var args = Array.prototype.slice.call(arguments, 1);
            return function () {
                return targetFunction.apply(this, args);
            };
        };

        var bindDetailsHovers = function () {
            var $dialog = AJS.$('#dialog-response-holder');
            $dialog.delegate('#reviewers-chosen .reviewer-span-holder', 'mouseenter', function () {
                AJS.$(this).find('.remove-reviewer').show();
            }).delegate('#reviewers-chosen .reviewer-span-holder', 'mouseleave', function () {
                AJS.$(this).find('.remove-reviewer').hide();
            });

            $dialog.delegate('#linked-issue-container', 'mouseenter', function () {
                AJS.$('#jiraClearButton').show();
            }).delegate('#linked-issue-container', 'mouseleave', function () {
                AJS.$('#jiraClearButton').hide();
            });

            $dialog.delegate('#linked-review-container', 'mouseenter', function () {
                AJS.$('#linkReviewUnlinkButton').show();
            }).delegate('#linked-review-container', 'mouseleave', function () {
                AJS.$('#linkReviewUnlinkButton').hide();
            });
        };

        var manageFiles = function (editPage, customUrl) {

            var userIntendedAction;
            var userIntendedActionContext;
            var setUserIntendedAction = function (func, context) {
                userIntendedAction = func;
                userIntendedActionContext = context || window;
            };
            var getIframe = function () {
                return document.getElementById('editReviewIframe')
            };
            var doesIframeHasOnBeforeUnload = function () {
                var iframe = getIframe();
                return !!(iframe && iframe.contentWindow && iframe.contentWindow.onbeforeunload);
            };
            var confirmIframeClose = function () {
                var iframe = getIframe();
                // there is no such thing for iframe like "unload",
                // so in order to simulate "unload" we must change the SRC of the iframe
                iframe.src = 'about:blank';
            };
            var listenOnIframeUnload = function () {
                var iframe = getIframe();
                var iframeWindow = iframe.contentWindow;

                // do not duplicate event handlers
                iframeWindow.removeEventListener('unload', callUserIntendedAction);
                iframeWindow.addEventListener('unload', callUserIntendedAction);
            };
            var callUserIntendedAction = function () {
                var iframe = getIframe();
                iframe.contentWindow.removeEventListener('unload', callUserIntendedAction);
                if (!userIntendedAction) {
                    return;
                }
                // necessary to prevent safari from crash
                setTimeout(function () {
                    userIntendedAction.call(userIntendedActionContext);
                }, 0);
            };
            var confirmIframeCloseBeforeExecutingAnAction = function (actionFunction) {
                if (doesIframeHasOnBeforeUnload()) {
                    setUserIntendedAction(actionFunction, this);
                    listenOnIframeUnload();
                    confirmIframeClose();
                } else {
                    actionFunction.call(this);
                }
            };
            var createButtonHandlerThatConfirmsIframeClose = function (realButtonHandler) {
                return prepopulateFunctionArguments(confirmIframeCloseBeforeExecutingAnAction, realButtonHandler);
            };

            // Clear the watches on the unsaved fields, since edit details/add content will reload this content
            CRU.UNSAVED.clearWatchForUnsavedChanges();
            CRU.FRX.AJAX.blockFrxLoading();
            cru_review_util.blockReviewUpdatePolling();

            removeManageFilesDialog();
            cru_util.startAjaxDialogSpin();
            var reviewId = review.id();
            addReviewIdToCookie(COOKIE_NAME_ADD_CONTENT_SHOWN, reviewId);


            var isAddContent = editPage === '/add-content-method';
            var isEditDetails = editPage === '/edit-details';
            var dialogName = isAddContent ? 'cru-add-content-dialog' : (isEditDetails ? 'cru-edit-details-dialog' : 'cru-manage-files-dialog');
            var HEADER_HEIGHT = 56; //height of the dialog header, in px
            var BUTTON_HEIGHT = 51; //height of the buttons at bottom of dialog, in px.
            var BODY_PADDING = 20; // needs to be the same as .aui-dialog .dialog-panel-body declaration in dialog.css
            var IFRAME_SPACING = 5; // under html5 the iframe gets arbtirary following spacing, and this removes the scrollbar it causes
            var OUTERHEIGHT = HEADER_HEIGHT + BUTTON_HEIGHT + BODY_PADDING + IFRAME_SPACING;

            manageFilesDialog = FECRU.DIALOG.create(1200, 700, dialogName);

            var iframeHeight = manageFilesDialog.height - OUTERHEIGHT;
            var iframeStyle = "style='width:100%;height:" + (iframeHeight) + "px'";

            var url;
            var params;
            var done;
            var cs;

            if (customUrl) {
                customUrl = customUrl.replace(/{baseUrlSuffix}/g, cru_review.baseUrlSuffix);
                cs = "<iframe frameborder='0' id='editReviewIframe' name='editReviewIframe' src='" + customUrl + "' " + iframeStyle + "></iframe>";
            } else {
                cs = "<div id='dialog-response-holder'></div>";
                if (!isAddContent) {
                    url = cru_util.jsonUrlBase(permaId) + editPage + cru_review.baseUrlSuffix;
                    params = {};
                    done = function (resp) {
                        cru_util.stopAjaxDialogSpin();
                        if (resp.worked) {
                            AJS.$('#dialog-response-holder').html(resp.payloadHtml);

                            cru_review.baseUrlSuffix = resp.baseUrlSuffix;
                            FECRU.DIALOG.triggerAjaxDialogLoaded();
                            manageFilesDialog.show();
                            bindDetailsHovers();
                        }
                    };
                }
            }

            var header = (isEditDetails ? 'Edit Review Details' : 'Add content to Review') + ' ' + review.id();
            manageFilesDialog.addHeader(header)
                .addPanel("Manage", cs);

            if (url) {
                FECRU.AJAX.ajaxDo(url, params, done);
            }

            if (isEditDetails) {
                manageFilesDialog.addButton("Add content", function () {
                    cru_review_util.postEditDetailsForm();
                    removeManageFilesDialog();
                    addContent();
                });
            } else {
                if (!isAddContent) {
                    manageFilesDialog.addButton("Add More Content",
                        createButtonHandlerThatConfirmsIframeClose(
                            function () {
                                removeManageFilesDialog();
                                addContent();
                            }
                        )
                    );
                }
                manageFilesDialog.addButton("Edit Details",
                    createButtonHandlerThatConfirmsIframeClose(
                        function () {
                            removeManageFilesDialog();
                            editReview();
                        }
                    )
                );
            }

            var $toolMenuBar = AJS.$("#page-actions");
            if (review.isEmpty() || review.isDraft()) {
                addTransitionIfExists(manageFilesDialog, $toolMenuBar, "abandonReview",
                    createButtonHandlerThatConfirmsIframeClose(
                        prepopulateFunctionArguments(performActionOnReview, "abandonReview")
                    )
                );
            }

            if (review.isDraft()) {
                addTransitionIfExists(manageFilesDialog, $toolMenuBar, "approveReview",
                    createButtonHandlerThatConfirmsIframeClose(
                        prepopulateFunctionArguments(performActionOnReview, "approveReview")
                    )
                );
                addTransitionIfExists(manageFilesDialog, $toolMenuBar, "submitReview",
                    createButtonHandlerThatConfirmsIframeClose(
                        prepopulateFunctionArguments(performActionOnReview, "submitReview")
                    )
                );
                addTransitionIfExists(manageFilesDialog, $toolMenuBar, "rejectReview",
                    createButtonHandlerThatConfirmsIframeClose(
                        prepopulateFunctionArguments(performActionOnReview, "rejectReview")
                    )
                );
            }

            manageFilesDialog.addButton("Done",
                createButtonHandlerThatConfirmsIframeClose(function () {
                        CRU.CREATE.submitDetailsForm();
                        removeManageFilesDialog();
                    }
                )
            );

            if (isAddContent) {
                var $dialog = AJS.$('#dialog-response-holder');
                $dialog.html(getAddContentPage());

                cru_util.stopAjaxDialogSpin();
                manageFilesDialog.show();
                $document.trigger('add-content-dialog-shown.review');
            } else if (customUrl) {
                AJS.$('#editReviewIframe').load(function () {
                    var wnd = this.contentWindow;
                    CRU.REVIEW.showManageFilesDialog(wnd.onIframeContentLoaded);
                });
            }
        };

        // Live event: button is replaced by ajax content load after saving an edited review
        $document.delegate("#edit-review-link:not(.disabled)", "click", function () {
            editReview();
            return false;
        });

        // Live event: button is replaced by ajax content load after saving an edited review
        $document.delegate(".add-content-link:not(.disabled)", "click", function () {
            addContent();
            return false;
        });

        $document.delegate("#toggle-tree", "click", function () {
            CRU.UI.toggleTree();
        });

        AJS.$("#content-resizable").bind('resizestart', function (event, ui) {
            // The collapsed class forces a fixed width, which we don't want to do when resizing. This lets us resize when expanded.
            AJS.$(this).removeClass("collapsed");
        });

        $document.delegate(".edit-content-link:not(.disabled)", "click", function () {
            var $body = AJS.$('body');
            var $this = AJS.$(this);
            if ($body.hasClass('edit-mode')) {
                $body.removeClass('edit-mode');
                $this.attr('title', 'Edit the content in this review');
                AJS.$('#navigation-tree').find('.edit-mode-help').slideUp('fast');
            } else {
                //going into edit mode
                //show inline dialog if cookie is set
                $body.addClass('edit-mode');
                $this.attr('title', 'Stop editing the content in this review');
                AJS.$('#navigation-tree').find('.edit-mode-help').slideDown('fast');
            }
        });

        $document.delegate('.edit-mode-help h3', 'click', function () {
            var $info = AJS.$('#navigation-tree').find('.edit-mode-help').find('.info');
            if ($info.filter(':visible').length > 0) {
                FECRU.PREFS.setPreferences({
                    semh: "N"
                });
                AJS.$(this).addClass('closed').removeClass('open');
                $info.slideUp('fast');
            } else {
                FECRU.PREFS.setPreferences({
                    semh: "Y"
                });
                AJS.$(this).removeClass('closed').addClass('open');
                $info.slideDown('fast');
            }
        });

        var editReviewDone = function() {
            var reviewId = review.id();
            addReviewIdToCookie(COOKIE_NAME_REVIEW_DETAIL_SHOWN, reviewId);
        };

        var editReview = function () {
            editReviewDone();
            manageFiles('/edit-details');
        };

        var addContent = function () {
            manageFiles('/add-content-method');
        };

        var addContentWithMethod = function (addContentMethod) {
            editReviewDone();
            var addContentMethodSelector = ".method." + addContentMethod;
            var addContentMethodUrlWithReviewParam = getAddContentPage().find(addContentMethodSelector).first().data().url;
            manageFiles(null, addContentMethodUrlWithReviewParam + "&" + location.search.substring(1));
        };

        var summarizeDialog = 0;
        cru_review.createSummarizeDialog = function () {
            summarizeDialog = FECRU.DIALOG.ajaxDialog(640, 485, {}, "summarize-dialog");
            summarizeDialog.addHeader("Summarize Review")
                .addPanel("Summarize", AJS.$("#closingComment"));

            if (AJS.$('#action-menu-link-primary').find('.tools-trans .action-reopenReview').length > 0) {
                summarizeDialog.addButton("Reopen Review", function (summarizeDialog) {
                    var opt = {summary: AJS.$("#reviewSummaryInput").val()};
                    cru_util.stateTransition('action:reopenReview', permaId, opt);
                    summarizeDialog.hide();
                });
            }
            summarizeDialog.addButton("Continue Without Closing", function (summarizeDialog) {
                var opt = {newValue: AJS.$("#reviewSummaryInput").val()};
                cru_review_util.updateReviewField('summary', '/updateReviewSummaryAjax', opt);
                summarizeDialog.hide();
            })
                .addButton("Close Review", function (summarizeDialog) {
                    cru_review_util.closeReviewAjax();
                    summarizeDialog.hide();
                });
        };

        cru_review.openSummarizeDialog = function () {
            if (summarizeDialog === 0) {
                cru_review.createSummarizeDialog();
            }
            summarizeDialog.show();
        };

        if (AJS.$('#reviewpage').length === 1 && review.writable()) {
            var addContentMethod = FECRU.parseUri(window.location.href).params.addContentMethod;
            if (addContentMethod) {
                addContentWithMethod(addContentMethod);
                FECRU.removeQueryParams(['addContentMethod', 'projectKey', 'origin', 'changesetId', 'repositoryName']);
            } else if (review.isDraft()) {
                if (review.isEmpty() && !hasReviewPopupBeenShown(COOKIE_NAME_ADD_CONTENT_SHOWN)) {
                    addContent();
                } else if (!hasReviewPopupBeenShown(COOKIE_NAME_REVIEW_DETAIL_SHOWN)) {
                    editReview();
                }
            } else if (review.isSummarize()) {
                cru_review.openSummarizeDialog();
            }
        }

        cru_review_util.reorderParticipants();

        $document.delegate('.show-source-button', 'click', function () {
            CRU.FRX.toggleSource();
        });

        /*
         Use to clear all set FRX viewing filters on the review
         */
        $document.delegate("#filter-frxs-clear:not(.disabled)", "click", function (e) {
            AJS.$(this).addClass("disabled");
            AJS.$("#frxFilterOptions").find("li.selected").removeClass("selected");
            CRU.FRX.changedFrxFilter();
            e.preventDefault();
        });

        FECRU.UI.filterToggle("#frxFilterOptions");
    });
})();
/*[{!review_event_js_ilq351b!}]*/
