/** General review navigation */
CRU.NAV = {};

(function () {

    CRU.NAV.CONST = {
        DESTINATIONS: {
            LAST_ELEMENT: 'last',
            FIRST_ELEMENT: 'first'
        }
    };

    /**
     * Locates the next element (currently frx/comment/defect/diff) to display when navigating using next and previous arrows.
     * Also called for predicting next frxes to load after the initial call.
     * @param opts search options, @see CRU.FRX.goToNextElement()
     * @return {*} { frxId, type='comment'/'comment-unloaded'/'diff'/'frx', nextFrxId }, null if nothing found
     */
    /*eslint-disable complexity, max-depth, eqeqeq*/
    CRU.NAV.findNextElement = function (opts) {
        // WARNING: there is a known issue with this function that it returns
        // same comment element under some circumstances, e.g. when being
        // called with 'previous' direction and starting frx of generalComments.
        // This can lead to infinite loops.
        // See frx-tests.js test for more details.
        var frxIds = review.frxIds();
        frxIds.unshift("generalComments");

        var forwards = opts.destination === 'next' || opts.destination === 'first';
        if (!forwards) {
            frxIds.reverse();
        }

        // start with opts.startingFrxId if it's in the review
        var startingFrxId = opts.startingFrxId;
        var i = AJS.$.inArray(startingFrxId, frxIds);
        if (i === -1) {
            i = 0;
        }

        // for each frx
        for (var len = frxIds.length; i < len; i++) {
            var frxId = frxIds[i];
            var frx = review.frx(frxId);

            // skipping reviewed frxes
            if (frx && (frx.isFiltered() ||
                opts.skipCompleteFrxs && frx.isComplete())) {
                continue;
            }

            // if going forward and, stopping on frxes and this is not the starting one, that's our result
            if (forwards && opts.findFrx && (frxId != startingFrxId)) {
                return {
                    gotoElem: frxId,
                    frxId: frxId,
                    type: 'frx'
                };
            }

            // if searching for comments and  the frx has no comments (or only read comments) skip it
            if (!opts.findFrx && frx && !opts.findDiff && (
                !frx.hasComments() ||
                (opts.findDefect && !opts.findComment && !frx.hasDefects()) ||
                (opts.skipReadComments && !frx.hasUnreadComments()))) {
                continue;
            }

            if (opts.findComment || opts.findDefect || opts.findDiff) {
                var nextFrxId = (i + 1 < frxIds.length ? frxIds[i + 1] : null);
                // we hit an unloaded frx, return with that, and have it loaded
                if (frx && !frx.isLoaded()) {
                    return {
                        frxId: frxId,
                        type: 'comment-unloaded',
                        nextFrxId: nextFrxId
                    };
                }

                var nextDiff;
                if (opts.findDiff) {
                    nextDiff = CRU.DIFF.NAV.findNextDiff(frx, forwards, nextFrxId, opts);

                    // if we're not looking for comments and we have a diff, that's our result
                    if (nextDiff != null && !opts.findDefect && !opts.findComment) {
                        return nextDiff;
                    }
                }

                if (opts.findComment || opts.findDefect) {
                    var nextComment = CRU.COMMENT.NAV.findNextComment(frxId, startingFrxId, forwards, opts, nextFrxId);
                    if (nextComment != null) {
                        if (!opts.findDiff || nextDiff == null) {
                            // if we're not looking for diffs, or don't have a diff in the current frx, the comment is our result
                            return nextComment;
                        } else {
                            // we got both a diff and a comment, pick closest to top/bottom
                            var $nextDiff = AJS.$(nextDiff.gotoElem);
                            var $nextComment = AJS.$('#' + review.comment(nextComment.gotoElem).domId());
                            var diffAfterComment = CRU.DIFF.NAV.diffAfterComment($nextDiff, $nextComment, forwards);
                            if (diffAfterComment) {
                                return nextComment;
                            } else {
                                return nextDiff;
                            }
                        }
                    } else if (opts.findDiff && nextDiff != null) {
                        // we got no comment, but got a diff, return that
                        return nextDiff;
                    }
                }
            }

            // if going backwards, and stopping at frxes, stop at the frx even if we found nothing else
            if (!forwards && opts.findFrx && (frxId != startingFrxId) && !opts.stopIfNothingFound) {
                return {
                    gotoElem: frxId,
                    frxId: frxId,
                    type: 'frx'
                };
            }
        }

        // Nothing found in all the frxes
        return null;
    };
    /*eslint-enable*/

})();
/*[{!nav_js_vpu251a!}]*/