var User = (function (navBuilder) {
    var _usersIndex = Object.create(null);

    /**
     * @param {Number} id
     * @param {String} userName
     * @param {String} displayName
     * @param {String} avatarUrl
     * @class User
     */
    function User(id, userName, displayName, avatarUrl) {
        this.id = id;
        this.userName = userName;
        this.displayName = displayName;
        this.avatarUrl = avatarUrl;
    }

    /**
     * Updates username and display name
     *
     * @deprecated use setUsername and setDisplayName
     *
     * @param {String} userName
     * @param {String} displayName
     */
    User.prototype.update = function (userName, displayName) {
        this.userName = userName;
        this.displayName = displayName;
    };

    User.prototype.getId = function () {
        return this.id;
    };

    User.prototype.getUserName = function () {
        return this.userName;
    };

    /**
     * @param {String} userName
     * @return {User}
     */
    User.prototype.setUserName = function (userName) {
        this.userName = userName;
        return this;
    };

    User.prototype.getDisplayName = function () {
        return this.displayName;
    };

    /**
     * @param {String} displayName
     * @return {User}
     */
    User.prototype.setDisplayName = function (displayName) {
        this.displayName = displayName;
        return this;
    };

    User.prototype.getAvatarUrl = function () {
        return this.avatarUrl || navBuilder.avatar(this.userName);
    };

    User.prototype.setAvatarUrl = function (avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    };

    /**
     * @typedef {Object} User.data
     * @property {String} userName
     * @property {String} displayName
     * @property {String} avatarUrl
     */

    /**
     * Returns an instance of User object for given id if it exists in local index.
     * Otherwise creates it, populate the index and returns it.
     *
     * @param {Number} id
     * @param {User.data} userData
     * @return {User}
     */
    User.getFromLocalIndexOrCreate = function (id, userData) {
        var user = _usersIndex[id];
        if (!user) {
            user = new User(id);
            _usersIndex[id] = user;
        }

        user.setUserName(userData.userName)
            .setDisplayName(userData.displayName)
            .setAvatarUrl(userData.avatarUrl);

        return user;
    };
    return User;

})(FECRU.NAVBUILDER);
/*[{!user_js_m92i520!}]*/