var Reviewer = (function (mixins, navBuilder) {

    function calcPercentageComplete(percentageComplete) {
        percentageComplete = Math.floor(percentageComplete / 20) * 20;
        if (isNaN(percentageComplete)) {
            return 0;
        }
        return percentageComplete;
    }

    function Reviewer(id, username, displayName, percentageComplete, hasCompleted) {
        this.m_id = parseInt(id, 10);
        this.m_username = username;
        this.m_displayName = displayName;
        this.m_percentageComplete = calcPercentageComplete(percentageComplete);
        this.m_hasCompleted = hasCompleted;
    }

    AJS.$.extend(Reviewer.prototype, mixins.EventProducer);

    // returns true if the values have changed
    Reviewer.prototype.updateReviewer = function (percentageComplete, hasCompleted) {
        var oldPercent = this.m_percentageComplete;
        var oldCompleted = this.m_hasCompleted;

        this.m_percentageComplete = calcPercentageComplete(percentageComplete);

        var previouslyCompleted = this.m_hasCompleted;
        this.m_hasCompleted = hasCompleted;
        if (previouslyCompleted !== hasCompleted) {
            this.trigger("reviewerCompletenessChanged", {reviewer: this});
        }
        return oldPercent !== this.m_percentageComplete || oldCompleted !== this.m_hasCompleted;
    };

    Reviewer.prototype.getId = function () {
        return this.m_id;
    };

    Reviewer.prototype.getUserName = function () {
        return this.m_username;
    };

    Reviewer.prototype.getDisplayName = function () {
        return this.m_displayName;
    };

    Reviewer.prototype.getAvatarUrl = function () {
        return this.avatarUrl || navBuilder.avatar(this.m_username);
    };

    Reviewer.prototype.setAvatarUrl = function (avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    };

    Reviewer.prototype.getSortName = Reviewer.prototype.getUserName;

    Reviewer.prototype.getPercentageComplete = function () {
        return this.m_percentageComplete;
    };

    Reviewer.prototype.getHasCompleted = function () {
        return this.m_hasCompleted;
    };

    return Reviewer;

})(FECRU.MIXINS, FECRU.NAVBUILDER);
/*[{!reviewer_js_84vh51z!}]*/