function Review() {
    // Member variables
    this.m_permaId = undefined;
    this.m_projectKey = undefined;
    this.m_frxs = {};
    this.m_firstFrx = undefined;
    this.m_lastFrx = undefined;
    this.m_frxCacheDirty = true;
    this.m_frxArrayCache = []; // Optimisation array, should never be accessed directly but through this.frxs()
    this.m_comments = {};
    this.m_commentCacheDirty = true;
    this.m_commentArrayCache = []; // Optimisation array, should never be accessed directly but through this.comments()
    this.m_loaded = false;
    this.m_writable = false;
    this.m_commentable = false; // true if the user is allowed to add comments and mark comments as read/unread.
    this.m_stateName = undefined;
    this.m_stateVerbage = undefined;
    this.m_metaStateName = undefined;
    this.m_name = undefined;
    this.m_summarize = undefined;
    this.m_renderTime = undefined;
    this.m_lastUpdatedTime = undefined;
    this.m_lastCheckedUpdateTime = undefined;
    this.m_commentFrxId = {};
    this.m_author = undefined;
    this.m_moderator = undefined;
    this.m_reviewerCompleteness = {};
    this.m_statePercentComplete = 0;
    this.m_loggedInUser = undefined;
    this.m_autoMarkFilesRead = true;
    this.m_issueKey = undefined;
    this.m_activityItems = [];

    this.recentlyViewedFrxIds = new FECRU.DATA_STRUCTURES.LeastRecentlyUsedQueue();

    this.m_pending = new ReviewPending();
}
AJS.$.extend(Review.prototype, FECRU.MIXINS.EventProducer);

Review.prototype.getPending = function () {
    return this.m_pending;
};

// Function which maps an array of [FRX|Comment] -> array of object ids
Review.prototype.idArray = function (obj) {
    return AJS.$.map(obj, function (obj) {
        return obj.id();
    });
};

// Convert to a plain array instead of associative
Review.prototype.map2array = function (map) {
    var array = [];
    AJS.$.each(map, function () {
        array.push(this);
    });

    return array;
};

Review.prototype.id = function () {
    return this.m_permaId;
};


Review.prototype.setId = function (id) {
    this.m_permaId = id;
    return this;
};

Review.prototype.projectKey = function () {
    return this.m_projectKey;
};

Review.prototype.setProjectKey = function (projectKey) {
    this.m_projectKey = projectKey;
    return this;
};

Review.prototype.isLoaded = function () {
    return this.m_loaded;
};

Review.prototype.setLoaded = function (loaded) {
    this.m_loaded = loaded;
    return this;
};

Review.prototype.writable = function () {
    return this.m_writable;
};

Review.prototype.setWritable = function (writable) {
    this.m_writable = writable;
    return this;
};

Review.prototype.commentable = function () {
    return this.m_commentable;
};

Review.prototype.setCommentable = function (commentable) {
    this.m_commentable = commentable;
    return this;
};

Review.prototype.isOpen = function () {
    return this.getMetaStateName() === 'OPEN';
};

Review.prototype.isClosed = function () {
    return this.getMetaStateName() === 'CLOSED';
};

Review.prototype.isDraft = function () {
    return this.getMetaStateName() === 'DRAFT';
};

Review.prototype.getStateName = function () {
    return this.m_stateName;
};

Review.prototype.setStateName = function (stateName) {
    this.m_stateName = stateName;
    return this;
};

Review.prototype.getStateVerbage = function () {
    return this.m_stateVerbage;
};

Review.prototype.setStateVerbage = function (stateVerbage) {
    this.m_stateVerbage = stateVerbage;
    return this;
};

Review.prototype.getMetaStateName = function () {
    return this.m_metaStateName;
};

Review.prototype.setMetaStateName = function (metaStateName) {
    this.m_metaStateName = metaStateName;
    return this;
};

Review.prototype.isOverdue = function () {
    return this.m_overdue;
};

Review.prototype.setOverdue = function (overdue) {
    this.m_overdue = overdue;
    return this;
};

Review.prototype.isEmpty = function () {
    return this.frxs().length === 0;
};

Review.prototype.setName = function (name) {
    this.m_name = name;
    return this;
};

Review.prototype.setLoggedInUser = function (user) {
    if (this.m_author && user && this.m_author.id === user.id) {
        this.m_author = user;
    }
    if (this.m_moderator && user && this.m_moderator.id === user.id) {
        this.m_moderator = user;
    }

    this.m_loggedInUser = user;
    return this;
};

Review.prototype.autoMarkFilesRead = function () {
    return this.m_autoMarkFilesRead;
};

Review.prototype.setAutoMarkFilesRead = function (autoMarkFilesRead) {
    this.m_autoMarkFilesRead = autoMarkFilesRead;
    return this;
};

Review.prototype.getLoggedInUser = function () {
    return this.m_loggedInUser;
};

Review.prototype.isSummarize = function () {
    return this.m_summarize;
};

Review.prototype.setSummarize = function (summarize) {
    this.m_summarize = summarize;
    return this;
};

Review.prototype.issueKey = function () {
    return this.m_issueKey;
};

Review.prototype.setIssueKey = function (issueKey) {
    this.m_issueKey = issueKey;
    return this;
};

Review.prototype.activityItems = function () {
    return this.m_activityItems;
};

Review.prototype.addActivityItem = function (activityItem) {
    this.m_activityItems.push(activityItem);
    return this;
};

Review.prototype.addActivityItems = function (activityItems) {
    this.m_activityItems = this.m_activityItems.concat(activityItems);
    return this;
};

Review.prototype.clearActivityItems = function () {
    this.m_activityItems = [];
    return this;
};

Review.prototype.setRenderTime = function (date) {
    this.m_renderTime = new Date(date.getTime());
    return this;
};

Review.prototype.getRenderTime = function () {
    return (this.m_renderTime) ? new Date(this.m_renderTime.getTime()) : null;
};

Review.prototype.setLastUpdatedTime = function (date) {
    this.m_lastUpdatedTime = new Date(date.getTime());
    return this;
};

Review.prototype.getLastUpdatedTime = function () {
    return (this.m_lastUpdatedTime) ? new Date(this.m_lastUpdatedTime.getTime()) : null;
};

Review.prototype.setLastCheckedUpdateTime = function (date) {
    this.m_lastCheckedUpdateTime = new Date(date.getTime());
    return this;
};

Review.prototype.getLastCheckedUpdateTime = function () {
    if (!this.m_lastCheckedUpdateTime) {
        return undefined;
    }
    return new Date(this.m_lastCheckedUpdateTime.getTime());
};

/******************
 ****   FRXS   ****
 ******************/

Review.prototype.frxs = function () {
    if (this.m_frxCacheDirty) {
        this.m_frxArrayCache = this.frxArray();
        this.m_frxCacheDirty = false;
    }
    return this.m_frxArrayCache;
};

Review.prototype.frxArray = function () {
    var array = [];
    var nextFrx = this.m_firstFrx;
    while (nextFrx) {
        array.push(nextFrx);
        nextFrx = nextFrx.getNextFrx();
    }
    return array;
};

Review.prototype.frxMap = function () {
    return this.m_frxs;
};

Review.prototype.frx = function (frxId) {
    return this.m_frxs[frxId];
};

Review.prototype.frxIds = function () {
    return this.idArray(this.frxs());
};

Review.prototype.addFrx = function (frx, prevFrxId) {
    var id = frx.id();
    var existingFrx = this.frx(id);
    var prevFrx = this.frx(prevFrxId);

    //first remove any existing frx with the same id
    if (existingFrx) {
        prevFrx = existingFrx.getPrevFrx();
        prevFrxId = prevFrx ? prevFrx.id() : 'generalComments';
        this.removeFrx(existingFrx);
    }

    if (prevFrxId === 'generalComments') {
        if (this.m_firstFrx) {
            frx.setNextFrx(this.m_firstFrx);
            this.m_firstFrx.setPrevFrx(frx);
            this.m_firstFrx = frx;
        } else {
            //the only frx
            this.m_firstFrx = frx;
            this.m_lastFrx = frx;
        }
    } else {
        if (!prevFrx) {
            //if no prev - append to the end
            prevFrx = this.m_lastFrx;
        }
        if (!prevFrx) {
            //if still no prevFrx - this is the only frx
            this.m_firstFrx = frx;
            this.m_lastFrx = frx;
        } else {
            //insert frx between prevFrx and prevFrx.next
            var nextFrx = prevFrx.getNextFrx();
            prevFrx.setNextFrx(frx);
            frx.setPrevFrx(prevFrx);
            frx.setNextFrx(nextFrx);
            if (!nextFrx) {
                //there was no next frx - frx is the new last
                this.m_lastFrx = frx;
            } else {
                nextFrx.setPrevFrx(frx);
            }
        }
    }

    frx.setNavItemSelector(id === 'generalComments' ? '#frx-overview' : '#frx-list-item' + id);
    frx.setFrxControlsSelector(id === 'generalComments' ? null : '#frxControlsContainer' + id);
    frx.setFrxOuterSelector(id === 'generalComments' ? '#generalComments' : '#frxouter' + id);
    frx.setFrxInnerSelector(id === 'generalComments' ? '#generalCommentsInner' : '#frxinner' + id);

    this.m_frxs[frx.id()] = frx;
    this.m_frxCacheDirty = true;
    return this;
};

Review.prototype.removeFrx = function (frx) {
    var that = this;
    AJS.$.each(frx.comments(), function () {
        that.removeComment(this);
    });
    var prevFrx = frx.getPrevFrx();
    var nextFrx = frx.getNextFrx();
    if (prevFrx) {
        prevFrx.setNextFrx(frx.getNextFrx());
    } else {
        this.m_firstFrx = frx.getNextFrx();
    }
    if (nextFrx) {
        nextFrx.setPrevFrx(frx.getPrevFrx());
    } else {
        this.m_lastFrx = frx.getPrevFrx();
    }

    frx.dispose();

    delete this.m_frxs[frx.id()];
    this.m_frxCacheDirty = true;
    return this;
};

Review.prototype.completeFrxs = function () {
    return AJS.$.grep(this.frxs(), function (frx) {
        return frx.isComplete();
    });
};

Review.prototype.completeFrxIds = function () {
    return this.idArray(this.completeFrxs());
};

Review.prototype.incompleteFrxs = function () {
    return AJS.$.grep(this.frxs(), function (frx) {
        return !frx.isComplete();
    });
};

Review.prototype.incompleteFrxIds = function () {
    return this.idArray(this.incompleteFrxs());
};

Review.prototype.visibleFrxIdsWithComments = function () {
    return this.idArray(AJS.$.grep(this.frxs(), function (frx) {
        return frx.hasComments() && !frx.isFiltered();
    }));
};

/******************
 **** COMMENTS ****
 ******************/
Review.prototype.addComment = function (comment) {
    this.m_comments[comment.id()] = comment;
    this.m_commentCacheDirty = true;
    return this;
};

Review.prototype.removeComment = function (comment) {
    comment.clearReplies();
    if (comment.isReply()) {
        // remove the dead comment from the parent's children list
        var siblings = comment.replyTo().getReplies();
        for (var i = 0, len = siblings.length; i < len; i++) {
            if (siblings[i] === comment) {
                siblings.splice(i, 1);
                break;
            }
        }
    }
    delete this.m_comments[comment.id()];
    if (comment.frx()) {
        comment.frx().removeComment(comment);
    }
    this.m_commentCacheDirty = true;
    return this;
};

Review.prototype.comment = function (id) {
    return this.m_comments[id];
};

Review.prototype.comments = function () {
    if (this.m_commentCacheDirty) {
        this.m_commentArrayCache = this.map2array(this.m_comments);
        this.m_commentCacheDirty = false;
    }
    return this.m_commentArrayCache;
};

Review.prototype.commentIds = function () {
    return this.idArray(this.comments());
};

Review.prototype.generalComments = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return /^general/.test(comment.type());
    });
};

Review.prototype.domOrderedGeneralComments = function () {
    var commentArray = [];
    var idSelectors = [];
    AJS.$.each(this.generalComments(), function () {
        idSelectors.push("#" + this.visibleDomId());
    });
    if (idSelectors.length > 0) {
        var $commentObjects = AJS.$(idSelectors.join(','));
        for (var i = 0, len = $commentObjects.length; i < len; i++) {
            var commentDom = $commentObjects[i];
            var commentId = commentDom.id.replace(/\D+/, '');
            var comment = this.m_comments[commentId];
            if (comment) {
                commentArray.push(comment);
            }
        }
    }
    return commentArray;
};

Review.prototype.unreadGeneralComments = function () {
    return AJS.$.grep(this.generalComments(), function (comment) {
        return comment.status() === 'unread' || comment.status() === 'leaveUnread';
    });
};

Review.prototype.generalCommentIds = function () {
    return this.idArray(this.generalComments());
};

Review.prototype.fileComments = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return /^revision/.test(comment.type());
    });
};

Review.prototype.fileCommentIds = function () {
    return this.idArray(this.fileComments());
};

Review.prototype.inlineComments = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return /^inline/.test(comment.type());
    });
};

Review.prototype.inlineCommentIds = function () {
    return this.idArray(this.inlineComments());
};

Review.prototype.unreadComments = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return comment.status() === 'unread' || comment.status() === 'leaveUnread';
    });
};

Review.prototype.draftComments = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return comment.draft();
    });
};

/** Should only be used when generating the initial response. */
Review.prototype.setCommentFrxId = function (commentId, frxId) {
    this.m_commentFrxId[commentId] = frxId;
    return this;
};

/** @return undefined if it is not an frx or inline comment. */
Review.prototype.getCommentFrxId = function (commentId) {
    var comment = review.comment(commentId);
    if (comment) {
        var frx = comment.frx();
        return frx ? frx.id() : undefined;
    } else {
        return this.m_commentFrxId[commentId];
    }
};

Review.prototype.setAuthor = function (id, username, displayName, avatarUrl) {
    //if we already have a user object for this id under the other role, use it.
    if (this.m_moderator && this.m_moderator.id === id) {
        this.m_author = this.m_moderator;
    }
    if (this.m_loggedInUser && this.m_loggedInUser.id === id) {
        this.m_author = this.m_loggedInUser;
    }

    if (this.m_author && this.m_author.id === id) {
        this.m_author.update(username, displayName);
    } else {
        this.m_author = new User(id, username, displayName);
    }
    this.m_author.setAvatarUrl(avatarUrl);

    return this;
};

Review.prototype.getAuthor = function () {
    return this.m_author;
};

Review.prototype.setModerator = function (id, username, displayName, avatarUrl) {
    //if we already have a user object for this id under the other role, use it.
    if (this.m_author && this.m_author.id === id) {
        this.m_moderator = this.m_author;
    }
    if (this.m_loggedInUser && this.m_loggedInUser.id === id) {
        this.m_moderator = this.m_loggedInUser;
    }

    if (this.m_moderator && this.m_moderator.id === id) {
        this.m_moderator.update(username, displayName);
    } else {
        this.m_moderator = new User(id, username, displayName);
    }
    this.m_moderator.setAvatarUrl(avatarUrl);

    return this;
};

Review.prototype.getModerator = function () {
    return this.m_moderator;
};

Review.prototype.setReviewer = function (id, username, displayName, percentComplete, isCompleted, avatarUrl) {
    this.m_reviewerCompleteness[id] = new Reviewer(id, username, displayName, percentComplete, isCompleted);
    this.m_reviewerCompleteness[id].setAvatarUrl(avatarUrl);

    var self = this;
    this.m_reviewerCompleteness[id].bind("reviewerCompletenessChanged", function (e) {
        self.trigger("reviewerCompletenessChanged", {reviewer: e.reviewer, review: self});
    });
};

// returns true if the values have changed
Review.prototype.updateReviewerCompleteness = function (id, percentComplete, isCompleted) {
    var reviewer = this.m_reviewerCompleteness[id];
    if (!reviewer) {
        // this is a reviewer that has been added to the review, we're not displaying new reviewers so we should ignore it
        return false;
    } else {
        return reviewer.updateReviewer(percentComplete, isCompleted);
    }
};

Review.prototype.clearReviewers = function () {
    this.m_reviewerCompleteness = {};
};

Review.prototype.setStatePercentComplete = function (percent) {
    this.m_statePercentComplete = percent;
};

Review.prototype.getStatePercentComplete = function () {
    return this.m_statePercentComplete;
};

Review.prototype.getBlockers = function () {
    var m_reviewerCompleteness = this.m_reviewerCompleteness;
    var userList = [];
    for (var reviewerId in m_reviewerCompleteness) {
        if (m_reviewerCompleteness.hasOwnProperty(reviewerId)) {
            var reviewer = m_reviewerCompleteness[reviewerId];
            if (reviewer !== undefined && !reviewer.getHasCompleted()) {
                var user = {
                    type: 'user',
                    id: reviewer.getUserName(),
                    avatarUrl: reviewer.getAvatarUrl(),
                    displayPrimary: reviewer.getDisplayName()
                };
                userList.push(user);
            }
        }
    }
    if (!userList.length) {
        // then the moderator / author is the blocker
        var blocker = this.getModerator() || this.getAuthor();
        userList.push({
            type: 'user',
            id: blocker.getUserName(),
            avatarUrl: blocker.getAvatarUrl(),
            displayPrimary: blocker.getDisplayName()
        })
    }
    return userList;
};

Review.prototype.getReviewersSortedByCompletedness = function () {
    var m_reviewerCompleteness = this.m_reviewerCompleteness;
    var reviewerList = [];
    for (var reviewerId in m_reviewerCompleteness) {
        if (m_reviewerCompleteness.hasOwnProperty(reviewerId)) {
            var reviewer = m_reviewerCompleteness[reviewerId];
            if (reviewer !== undefined) {
                reviewerList.push(reviewer);
            }
        }
    }
    reviewerList.sort(function (reviewerA, reviewerB) {
        //if a reviewer has completed, their weighting should be more than 100%
        var aCompleted = reviewerA.getHasCompleted() ? 101 : reviewerA.getPercentageComplete();
        var bCompleted = reviewerB.getHasCompleted() ? 101 : reviewerB.getPercentageComplete();

        var diff = aCompleted - bCompleted;
        if (diff !== 0) {
            return diff;
        }
        if (reviewerA.getSortName() === reviewerB.getSortName()) {
            return 0;
        } else if (reviewerA.getSortName() < reviewerB.getSortName()) {
            return -1;
        } else {
            return 1;
        }
    });
    return reviewerList;
};

// Both variables are populated in elementIds.jspf
var review = new Review();
var permaId;
/*[{!review_js_1eq551y!}]*/