function ReviewPending() {
    this.m_reloadRequired = false;
    this.m_detailsChanged = false;
    this.m_addedFrxIds = [];
    this.m_updatedFrxIds = [];
    this.m_removedFrxIds = [];
    this.m_unreadFrxIds = [];
    this.m_updatedReviewCommentIds = []; // ids
    this.m_updatedFileCommentIds = []; // ids
    this.m_updatedInlineCommentIds = []; // ids
    this.m_reviewersToBeAdded = 0;
    this.m_reviewersToBeRemoved = 0;
    this.m_authorChanged = false;
    this.m_moderatorChanged = false;
    this.m_roleChanged = false;
    this.m_pendingStateName = undefined;
    this.m_pendingMetaStateName = undefined;
    this.m_hasBeenUncompleted = false;
}

ReviewPending.prototype.getPendingStateName = function () {
    return this.m_pendingStateName;
};

ReviewPending.prototype.setPendingStateName = function (stateName) {
    this.m_pendingStateName = stateName;
    return this;
};

ReviewPending.prototype.isPendingClosed = function () {
    return this.getPendingMetaStateName() === 'CLOSED';
};

ReviewPending.prototype.getPendingMetaStateName = function () {
    return this.m_pendingMetaStateName;
};

ReviewPending.prototype.setPendingMetaStateName = function (stateName) {
    this.m_pendingMetaStateName = stateName;
    return this;
};

ReviewPending.prototype.hasBeenUncompleted = function () {
    return this.m_hasBeenUncompleted;
};

ReviewPending.prototype.setHasBeenUncompleted = function (uncompleted) {
    this.m_hasBeenUncompleted = uncompleted;
    return this;
};

ReviewPending.prototype.isReloadRequired = function () {
    return this.m_reloadRequired;
};

ReviewPending.prototype.setReloadRequired = function (reloadRequired) {
    this.m_reloadRequired = reloadRequired;
    return this;
};

ReviewPending.prototype.getDetailsChanged = function () {
    return this.m_detailsChanged;
};

ReviewPending.prototype.setDetailsChanged = function (changed) {
    this.m_detailsChanged = changed;
    return this;
};

ReviewPending.prototype.getAddedFrxIds = function () {
    return this.m_addedFrxIds;
};

ReviewPending.prototype.setAddedFrxIds = function (frxIds) {
    this.m_addedFrxIds = frxIds || [];
    return this;
};

ReviewPending.prototype.getUpdatedFrxIds = function () {
    return this.m_updatedFrxIds;
};

ReviewPending.prototype.setUpdatedFrxIds = function (frxIds) {
    this.m_updatedFrxIds = frxIds || [];
    return this;
};

ReviewPending.prototype.getRemovedFrxIds = function () {
    return this.m_removedFrxIds;
};

ReviewPending.prototype.setRemovedFrxIds = function (frxIds) {
    this.m_removedFrxIds = frxIds || [];
    return this;
};

ReviewPending.prototype.getUnreadFrxIds = function () {
    return this.m_unreadFrxIds;
};

ReviewPending.prototype.setUnreadFrxIds = function (frxIds) {
    this.m_unreadFrxIds = frxIds;
    return this;
};

ReviewPending.prototype.getUpdatedReviewCommentIds = function () {
    return this.m_updatedReviewCommentIds;
};

ReviewPending.prototype.getUpdatedFileCommentIds = function () {
    return this.m_updatedFileCommentIds;
};

ReviewPending.prototype.getUpdatedInlineCommentIds = function () {
    return this.m_updatedInlineCommentIds;
};

ReviewPending.prototype.setUpdatedReviewCommentIds = function (comments) {
    this.m_updatedReviewCommentIds = comments || [];
    return this;
};

ReviewPending.prototype.setUpdatedFileCommentIds = function (comments) {
    this.m_updatedFileCommentIds = comments || [];
    return this;
};

ReviewPending.prototype.setUpdatedInlineCommentIds = function (commentIds) {
    this.m_updatedInlineCommentIds = commentIds || [];
    return this;
};

ReviewPending.prototype.clearUpdatedReviewCommentIds = function () {
    return this.setUpdatedReviewCommentIds([]);
};

ReviewPending.prototype.clearUpdatedFileCommentIds = function () {
    return this.setUpdatedFileCommentIds([]);
};

ReviewPending.prototype.clearUpdatedInlineCommentIds = function () {
    return this.setUpdatedInlineCommentIds([]);
};

ReviewPending.prototype.setReviewersToBeAddedCount = function (count) {
    this.m_reviewersToBeAdded = count;
    return this;
};

ReviewPending.prototype.setReviewersToBeRemovedCount = function (count) {
    this.m_reviewersToBeRemoved = count;
    return this;
};

ReviewPending.prototype.getReviewersToBeAddedCount = function () {
    return this.m_reviewersToBeAdded;
};

ReviewPending.prototype.getReviewersToBeRemovedCount = function () {
    return this.m_reviewersToBeRemoved;
};

ReviewPending.prototype.setAuthorChanged = function (changed) {
    this.m_authorChanged = changed;
    return this;
};

ReviewPending.prototype.getAuthorChanged = function () {
    return this.m_authorChanged;
};

ReviewPending.prototype.setModeratorChanged = function (changed) {
    this.m_moderatorChanged = changed;
    return this;
};

ReviewPending.prototype.getModeratorChanged = function () {
    return this.m_moderatorChanged;
};

ReviewPending.prototype.setRoleChanged = function (changed) {
    this.m_roleChanged = changed;
    return this;
};

ReviewPending.prototype.getRoleChanged = function () {
    return this.m_roleChanged;
};

ReviewPending.prototype.setLastLogItemTimestamp = function (timestamp) {
    this.m_lastLogItemTimestamp = timestamp;
};

ReviewPending.prototype.getLastLogItemTimestamp = function () {
    return this.m_lastLogItemTimestamp;
};
/*[{!review_pending_js_gnr551x!}]*/