function reviewObserver(eventBus) {
    var callBeforeMethod = function (object, methodName, callback) {

        var originalMethod = object[methodName];
        object[methodName] = function () {
            //todo temporary fix while synchronisation is not fully working
            try {
                callback.apply(this, arguments);
            } catch (e) {
                console.log("Error in callback: " + e)
            }
            return originalMethod.apply(this, arguments);
        };
    };

    callBeforeMethod(Review.prototype, 'addComment', function (comment) {
        eventBus.trigger('comment:add', comment);
    });

    callBeforeMethod(Review.prototype, 'removeComment', function (comment) {
        eventBus.trigger('comment:remove', comment);
    });

    callBeforeMethod(Comment.prototype, 'setStatus', function (status) {
        eventBus.trigger('comment:setStatus', this.m_id, status);
    });

    callBeforeMethod(Comment.prototype, 'setMessageAsHtml', function (message) {
        eventBus.trigger('comment:setMessageAsHtml', this.m_id, message);
    });

    callBeforeMethod(Comment.prototype, 'setMetrics', function (metrics) {
        eventBus.trigger('comment:setMetrics', this.m_id, metrics);
    });

    callBeforeMethod(Comment.prototype, 'setDraft', function (isDraft) {
        eventBus.trigger('comment:setDraft', this.m_id, isDraft);
    });

    callBeforeMethod(Comment.prototype, 'setDefect', function (isDefect) {
        eventBus.trigger('comment:setDefect', this.m_id, isDefect);
    });
}