function Frx(id, review) {
    this.m_id = id;
    this.m_review = review;

    this.m_prevFrx = undefined;
    this.m_nextFrx = undefined;

    this.m_readStatus = undefined;
    this.m_readStatusLocked = false;
    this.m_colspan = 4;
    this.m_isLoaded = false;
    this.m_isLoading = false;
    this.m_isExpanded = false;
    this.m_isFiltered = false;
    this.m_isBinary = false;
    this.m_isDirectory = false;
    this.m_isNewSinceComplete = false;
    this.m_toBeRemoved = false;

    this.m_path = undefined;
    this.m_pathTruncated = undefined;
    this.m_branch = undefined;
    this.m_sourceName = undefined;

    // revision stuff
    this.m_frxRevisions = [];
    this.m_sliderFrxRevisions = undefined;
    this.m_visibleFromRevision = undefined;
    this.m_visibleToRevision = undefined;
    this.m_visibleFromSCMRevision = undefined;
    this.m_visibleToSCMRevision = undefined;
    this.m_frxRevisionToCruRevisionMap = {};

    this.m_commentCacheDirty = true;
    this.m_commentArrayCache = []; // Optimisation array, should never be accessed directly but through this.comments()
    this.m_comments = {};

    // diff opts
    this.m_context = undefined;
    this.m_whitespace = undefined;
    this.m_diffLayout = undefined;
    this.m_ignoreBlankLines = undefined;

    this.m_lastScrollTop = 0;

    //DOM pointers
    this.m_navItemSelector = undefined;
    this.m_frxControlsSelector = undefined;
    this.m_frxOuterSelector = undefined;
    this.m_frxInnerSelector = undefined;

}

Frx.prototype.getContext = function () {
    return this.m_context;
};

Frx.prototype.getWhitespace = function () {
    return this.m_whitespace;
};

Frx.prototype.getDiffLayout = function () {
    return this.m_diffLayout;
};

Frx.prototype.setContext = function (context) {
    this.m_context = context;
    return this;
};

Frx.prototype.setWhitespace = function (whitespace) {
    this.m_whitespace = whitespace;
    return this;
};

Frx.prototype.setDiffLayout = function (diffLayout) {
    this.m_diffLayout = diffLayout;
    return this;
};

Frx.prototype.getIgnoreBlankLines = function () {
    return this.m_ignoreBlankLines;
};

Frx.prototype.setIgnoreBlankLines = function (ignoreBlankLines) {
    this.m_ignoreBlankLines = ignoreBlankLines;
    return this;
};

Frx.prototype.getLastScrollTop = function () {
    return this.m_lastScrollTop;
};

Frx.prototype.setLastScrollTop = function (lastScrollTop) {
    this.m_lastScrollTop = lastScrollTop;
    return this;
};

// Methods
Frx.prototype.id = function () {
    return this.m_id;
};

Frx.prototype.review = function () {
    return this.m_review;
};

Frx.prototype.getPrevFrx = function () {
    return this.m_prevFrx;
};

Frx.prototype.setPrevFrx = function (frx) {
    this.m_prevFrx = frx;
    return this;
};

Frx.prototype.getNextFrx = function () {
    return this.m_nextFrx;
};

Frx.prototype.setNextFrx = function (frx) {
    this.m_nextFrx = frx;
    return this;
};

Frx.prototype.isComplete = function () {
    return this.m_readStatus === "read";
};

Frx.prototype.colspan = function () {
    return this.m_colspan;
};

Frx.prototype.setColspan = function (colspan) {
    this.m_colspan = colspan;
    return this;
};

Frx.prototype.isLoaded = function () {
    return this.m_isLoaded;
};

Frx.prototype.setLoaded = function (loaded) {
    this.m_isLoaded = loaded;
    return this;
};

Frx.prototype.isLoading = function () {
    return this.m_isLoading;
};

Frx.prototype.setLoading = function (loading) {
    this.m_isLoading = loading;
    return this;
};

Frx.prototype.isExpanded = function () {
    return this.m_isExpanded;
};

Frx.prototype.setExpanded = function (expanded) {
    this.m_isExpanded = expanded;
    return this;
};

Frx.prototype.isFiltered = function () {
    return this.m_isFiltered;
};

Frx.prototype.setFiltered = function (filtered) {
    this.m_isFiltered = filtered;
    return this;
};

Frx.prototype.isBinary = function () {
    return this.m_isBinary;
};

Frx.prototype.setBinary = function (binary) {
    this.m_isBinary = binary;
    return this;
};

Frx.prototype.isDirectory = function () {
    return this.m_isDirectory;
};

Frx.prototype.setDirectory = function (directory) {
    this.m_isDirectory = directory;
    return this;
};

Frx.prototype.isNewSinceComplete = function () {
    return this.m_isNewSinceComplete;
};

Frx.prototype.setNewSinceComplete = function (newSinceComplete) {
    this.m_isNewSinceComplete = newSinceComplete;
    return this;
};

Frx.prototype.path = function () {
    return this.m_path;
};

Frx.prototype.setPath = function (path) {
    this.m_path = path;
    return this;
};

Frx.prototype.pathTruncated = function () {
    return this.m_pathTruncated;
};

Frx.prototype.setPathTruncated = function (pathTruncated) {
    this.m_pathTruncated = pathTruncated;
    return this;
};

Frx.prototype.branch = function () {
    return this.m_branch;
};

Frx.prototype.setBranch = function (branch) {
    this.m_branch = branch;
    return this;
};

Frx.prototype.sourceName = function () {
    return this.m_sourceName;
};

Frx.prototype.setSourceName = function (sourceName) {
    this.m_sourceName = sourceName;
    return this;
};

// FRX Revision Stuff
Frx.prototype.addFrxRevision = function (frxRev) {
    this.m_frxRevisions.push(frxRev);
    return this;
};

Frx.prototype.frxRevisions = function () {
    return this.m_frxRevisions;
};

Frx.prototype.setSliderFrxRevisions = function (revs) {
    this.m_sliderFrxRevisions = AJS.$.makeArray(revs);
    return this;
};

Frx.prototype.getSliderFrxRevisions = function () {
    return this.m_sliderFrxRevisions;
};

Frx.prototype.setVisibleFromRevision = function (frxRev) {
    this.m_visibleFromRevision = frxRev;
    return this;
};

Frx.prototype.setVisibleToRevision = function (frxRev) {
    this.m_visibleToRevision = frxRev;
    return this;
};

Frx.prototype.setVisibleFromSCMRevision = function (rev) {
    this.m_visibleFromSCMRevision = rev;
    return this;
};

Frx.prototype.setVisibleToSCMRevision = function (rev) {
    this.m_visibleToSCMRevision = rev;
    return this;
};

Frx.prototype.visibleFromRevision = function () {
    return this.m_visibleFromRevision;
};

Frx.prototype.visibleToRevision = function () {
    return this.m_visibleToRevision;
};

Frx.prototype.visibleFromSCMRevision = function () {
    return this.m_visibleFromSCMRevision;
};

Frx.prototype.visibleToSCMRevision = function () {
    return this.m_visibleToSCMRevision;
};

Frx.prototype.setFrxRevisionToCruRevisionMap = function (map) {
    this.m_frxRevisionToCruRevisionMap = map;
    return this;
};

Frx.prototype.frxRevisionToCruRevisionMap = function () {
    return this.m_frxRevisionToCruRevisionMap;
};

Frx.prototype.hasComments = function () {
    return this.comments().length > 0;
};

Frx.prototype.hasDefects = function () {
    return this.defects().length > 0;
};

Frx.prototype.hasUnreadComments = function () {
    return this.unreadComments().length > 0;
};

Frx.prototype.defects = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return comment.defect();
    });
};

Frx.prototype.addComment = function (comment) {
    this.m_comments[comment.id()] = comment;
    this.m_commentCacheDirty = true;
    return this;
};

Frx.prototype.comments = function () {
    if (this.m_commentCacheDirty) {
        this.m_commentArrayCache = [];
        var that = this;
        AJS.$.each(this.m_comments, function () {
            that.m_commentArrayCache.push(this);
        });
        this.m_commentCacheDirty = false;
    }
    return this.m_commentArrayCache;
};

Frx.prototype.domOrderedComments = function () {
    var commentArray = [];
    var idSelectors = [];
    AJS.$.each(this.m_comments, function () {
        idSelectors.push("#" + this.visibleDomId());
    });
    if (idSelectors.length > 0) {
        var $commentObjects = AJS.$(idSelectors.join(','));
        for (var i = 0, len = $commentObjects.length; i < len; i++) {
            var commentDom = $commentObjects[i];
            var commentId = commentDom.id.replace(/\D+/, '');
            var comment = this.m_comments[commentId];
            if (comment) {
                commentArray.push(comment);
            }
        }
    }
    return commentArray;
};

Frx.prototype.unreadComments = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return comment.status() === 'unread' || comment.status() === 'leaveUnread';
    });
};

Frx.prototype.fileComments = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return /^revision/.test(comment.type());
    });
};

Frx.prototype.removeComment = function (comment) {
    delete this.m_comments[comment.id()];
    this.m_commentCacheDirty = true;
    return this;
};

Frx.prototype.readStatus = function () {
    return this.m_readStatus;
};

Frx.prototype.setReadStatus = function (status) {
    this.m_readStatus = status;
    return this;
};

Frx.prototype.isReadStatusLocked = function () {
    return this.m_readStatusLocked;
};

Frx.prototype.lockReadStatus = function () {
    this.m_readStatusLocked = true;
    return this;
};

Frx.prototype.unlockReadStatus = function () {
    this.m_readStatusLocked = false;
    return this;
};

Frx.prototype.navItem = function () {
    var navItem = AJS.$(this.m_navItemSelector);
    if (navItem.length) {
        this.navItem = function () {
            return navItem;
        };
        return this.navItem();
    }
    return navItem;
};
Frx.prototype.setNavItemSelector = function (value) {
    this.m_navItemSelector = value;
    delete this.navItem;
    return this;
};

Frx.prototype.frxControls = function () {
    var frxControls = AJS.$(this.m_frxControlsSelector);
    if (frxControls.length) {
        this.frxControls = function () {
            return frxControls;
        };
        return this.frxControls();
    }
    return frxControls;
};
Frx.prototype.setFrxControlsSelector = function (value) {
    this.m_frxControlsSelector = value;
    delete this.frxControls;
    return this;
};

Frx.prototype.frxOuter = function () {
    var frxOuter = AJS.$(this.m_frxOuterSelector);
    if (frxOuter.length) {
        this.frxOuter = function () {
            return frxOuter;
        };
        return this.frxOuter();
    }
    return frxOuter;
};
Frx.prototype.setFrxOuterSelector = function (value) {
    this.m_frxOuterSelector = value;
    delete this.navItem;
    return this;
};

Frx.prototype.frxInner = function () {
    var frxInner = AJS.$(this.m_frxInnerSelector);
    if (frxInner.length) {
        this.frxInner = function () {
            return frxInner;
        };
        return this.frxInner();
    }
    return frxInner;
};
Frx.prototype.setFrxInnerSelector = function (value) {
    this.m_frxInnerSelector = value;
    delete this.frxInner;
    return this;
};

/**
 * Unload references to DOM elements to avoid memory leaks.
 * The frx is no longer in a usable state once this method is called.
 * */
Frx.prototype.dispose = function () {
    this.setNavItemSelector(null);
    this.setFrxControlsSelector(null);
    this.setFrxOuterSelector(null);
    this.setFrxInnerSelector(null);
};

/** Forces re-executing selectors for these items on next request */
Frx.prototype.invalidateCachedSelectors = function () {
    delete this.frxOuter;
    delete this.frxInner;
    delete this.navItem;
    delete this.frxControls;
};
/*[{!frx_js_t1nr51w!}]*/