(function ($,
           reviewActivityProvider) {

    $(document).ready(function () {
// {define $FECRU.Keynav}
        var CNAV = CRU.COMMENT.NAV;
        var FNAV = CRU.FRX.NAV;
        var WIKIHELP = CRU.REVIEW.WIKI.HELP;

        // Enables key handling when review activity is opened.
        function performIfReviewActivityOpened(func) {
            return function () {
                var reviewActivity = reviewActivityProvider();
                if (reviewActivity.isOpen()) {
                    return func.call(this, reviewActivity);
                }
            };
        }

        // Disables key handling when any dialog is showing.
        function performIfNoDialogsOpened(f) {
            return function () {
                CRU.REVIEW.UTIL.resetInactivityTimer();
                if (!CRU.UTIL.isAnyDialogShowing()) {
                    return f.apply(this, arguments);
                }
            };
        }

        // Disables key navigation when any dialog or overlay is showing.
        function performIfNoDialogOrOverlayOpened(f) {
            return function () {
                CRU.REVIEW.UTIL.resetInactivityTimer();
                if (!CRU.UTIL.isAnyDialogShowing() && !CRU.UTIL.isAnyOverlayShowing()) {
                    return f.apply(this, arguments);
                }
            };
        }

        function commentNavigator(successor, opts, init) {
            opts = opts || {};
            init = init || successor;

            return performIfNoDialogOrOverlayOpened(function () {
                var commentDomId = CNAV.getCurrentCommentDomId();
                CNAV.navigateToComment($.extend({
                    destination: commentDomId ? successor : init
                }, opts));
                // stop the event propagating
                return false;
            });
        }

        function nextComment(opts) {
            return commentNavigator('next', opts, 'first');
        }

        function previousComment(opts) {
            return commentNavigator('previous', opts, 'last');
        }

        function frxNavigator(successor, opts, init) {
            opts = opts || {};
            init = init || successor;

            return performIfNoDialogOrOverlayOpened(function () {
                var frxId = FNAV.getCurrentFrxId();
                FNAV.gotoFrx($.extend({
                    frxId: frxId,
                    destination: frxId ? successor : init
                }, opts));
                FNAV.scrollToCommentForm();
                return false;
            });
        }

        function nextFrx(opts) {
            return frxNavigator('next', opts, 'first');
        }

        function previousFrx(opts) {
            return frxNavigator('previous', opts, 'last');
        }

        function currentCommentId() {
            return CNAV.commentIdFromAnchor(CNAV.getCurrentCommentDomId());
        }

        function toggleFileReviewed() {
            return performIfNoDialogOrOverlayOpened(function () {
                if (review.writable()) {
                    var frxId = FNAV.getCurrentFrxId();
                    CRU.FRX.AJAX.toggleFileRead(frxId, true);
                }
                return false;
            });
        }

        function setFileReviewedAndMoveOn() {
            return performIfNoDialogOrOverlayOpened(function () {
                var ajsFrx = CRU.FRX;
                if (review.writable()) {
                    var frxId = ajsFrx.NAV.getCurrentFrxId();
                    var nextFrx = function () {
                        ajsFrx.goToNextElement('next', null, {
                            startingFrxId: frxId,
                            skipCompleteFrxs: true,
                            findFrx: true,
                            findComment: false,
                            findDiff: false,
                            findDefect: false
                        });
                    };
                    if (frxId === 'generalComments') {
                        CRU.COMMENT.markAllCommentsRead('generalComments');
                        nextFrx();
                    } else {
                        var frx = review.frx(frxId);
                        if (frx) {
                            ajsFrx.AJAX.markFile(true, frx.id(), true);
                            CRU.COMMENT.markAllCommentsRead(frx.id());
                            nextFrx();
                        }
                    }
                }
                return false;
            });
        }

        function navigatePrev() {
            var $prevLink = $('#prev-element-link');
            return performIfNoDialogOrOverlayOpened(function () {
                CRU.FRX.goToNextElement('previous', $prevLink, {
                    navLast: navigateLast()
                });
                return false;
            });
        }

        function navigateNext() {
            var $nextLink = $('#next-element-link');
            return performIfNoDialogOrOverlayOpened(function () {
                CRU.FRX.goToNextElement('next', $nextLink, {
                    navFirst: navigateFirst()
                });
                return false;
            });
        }

        /**
         *
         * @param destination 'first-element' | 'last-element'
         * <p> see CRU.NAV.CONST.DESTINATIONS
         * @return
         */
        function navigateToEdge(destination) {
            var $prevLink = $('#prev-element-link');
            var $nextLink = $('#next-element-link');

            return performIfNoDialogOrOverlayOpened(function () {
                // scroll to first/last frx
                var frxId = FNAV.getCurrentFrxId();
                FNAV.gotoFrx($.extend({
                    frxId: frxId,
                    destination: destination
                }, {}));
                FNAV.scrollToCommentForm();

                // and scroll back to find the closest valid element
                setTimeout(function () {
                    CRU.COMMENT.NAV.setCurrentComment(null);
                    CRU.DIFF.NAV.setCurrentDiffId(null, null);
                    CRU.FRX.goToNextElement(
                        destination === 'first' ? 'next' : 'previous',
                        destination === 'first' ? $prevLink : $nextLink,
                        {stopIfNothingFound: true}
                    );
                }, 0);
            });
        }

        function navigateFirst() {
            return navigateToEdge(CRU.NAV.CONST.DESTINATIONS.FIRST_ELEMENT);
        }

        function navigateLast() {
            return navigateToEdge(CRU.NAV.CONST.DESTINATIONS.LAST_ELEMENT);
        }

        /**
         *
         *
         * $$: []
         *  $_: {}
         *      category: string -- name of the category
         *      shortcuts: []
         *          $_: {}
         *              keys: [] -- key combination
         *                  $_: string
         *                  -- examples: '.', 'k', 'shift+k', 'ctrl+k'
         *              desc: string -- shortcut description
         *              action: fn -- the function to be called when the shortcut is detected
         *                  @param: ()
         *                      event: $Jquery.eventObject
         */
        var categories = [
            {
                category: 'Custom Navigation',
                shortcuts: [
                    // note: if you change these values, also change the tooltips where relevant
                    {
                        keys: ['.'],
                        desc: 'open action dialog',
                        action: false
                    },
                    {
                        keys: ['k'],
                        desc: 'previous element',
                        action: navigatePrev()
                    },
                    {
                        keys: ['j'],
                        desc: 'next element',
                        action: navigateNext()
                    }
                ]
            },
            {
                category: 'Comment Navigation',
                shortcuts: [
                    {
                        keys: ['p'],
                        desc: 'previous comment',
                        action: previousComment()
                    },
                    {
                        keys: ['n'],
                        desc: 'next comment',
                        action: nextComment()
                    },
                    {
                        keys: ['shift+p'],
                        desc: 'previous unread comment',
                        action: previousComment({skipReadComments: true})
                    },
                    {
                        keys: ['shift+n'],
                        desc: 'next unread comment',
                        action: nextComment({skipReadComments: true})
                    },

                    {
                        keys: ['h'],
                        desc: 'previous thread (skips replies)',
                        action: previousComment({nextThread: true})
                    },
                    {
                        keys: ['l'],
                        desc: 'next thread (skips replies)',
                        action: nextComment({nextThread: true})
                    },
                    {
                        keys: ['r'],
                        desc: 'reply to comment',
                        action: performIfNoDialogOrOverlayOpened(function () {
                            commentator.replyToComment(currentCommentId());
                            return false;
                        })
                    },

                    {
                        keys: ['m'],
                        desc: 'toggle comment read/unread',
                        action: performIfNoDialogOrOverlayOpened(function () {
                            commentator.toggleCommentRead(currentCommentId(), true);
                            return false;
                        })
                    }
                ]
            },

            {
                category: 'File Navigation',
                shortcuts: [
                    {
                        keys: ['i'],
                        desc: 'previous unread file',
                        action: previousFrx({skipCompleteFrxs: true})
                    },
                    {
                        keys: ['u'],
                        desc: 'next unread file',
                        action: nextFrx({skipCompleteFrxs: true})
                    },

                    {
                        keys: ['y'],
                        desc: 'read file and its comments and go to next unread file',
                        action: setFileReviewedAndMoveOn()
                    },
                    {
                        keys: ['shift+y'],
                        desc: 'toggle file read/unread',
                        action: toggleFileReviewed()
                    }
                ]
            },

            {
                category: 'Reviews',
                shortcuts: [
                    {
                        keys: ['alt'],
                        desc: 'hold down then click and drag to select source line contents',
                        action: performIfNoDialogOrOverlayOpened(function () {
                            // handled by commentator.js (selectLine_* functions)
                        })
                    },
                    {
                        keys: ['shift+['],
                        desc: 'toggle sidebar',
                        action: performIfNoDialogsOpened(function () {
                            CRU.UI.toggleTree();
                        })
                    }
                ]
            },

            {
                category: 'Help',
                shortcuts: [
                    {
                        keys: ['shift+w'],
                        desc: 'show wiki help',
                        action: performIfNoDialogsOpened(function () {
                            WIKIHELP.showPopup();
                        })
                    },
                    {
                        keys: ['?'],
                        desc: 'show help',
                        action: performIfNoDialogsOpened(function () {
                            if (!popupShowing) {
                                popup.show();
                                popupShowing = true;
                                return false;
                            }
                        })
                    },
                    {
                        keys: ['esc'],
                        action: function () {
                            if (popupShowing) {
                                popup.hide();
                                popupShowing = false;
                                return false;
                            }
                            if (WIKIHELP.popupShowing) {
                                WIKIHELP.hidePopup();
                                return false;
                            }
                        }
                    }
                ]
            }
        ];

        if ($('.review-activity-button').length > 0) {
            categories.push({
                category: 'Review Activity',
                shortcuts: [
                    {
                        keys: ['shift+]'],
                        desc: 'toggle review activity',
                        action: performIfNoDialogsOpened(function () {
                            reviewActivityProvider().toggle();
                        })
                    },
                    {
                        keys: ['esc'],
                        action: performIfReviewActivityOpened(function (reviewActivity) {
                            reviewActivity.close();
                        })
                    },
                    {
                        keys: ['p'],
                        desc: 'previous comment',
                        action: performIfReviewActivityOpened(function (reviewActivity) {
                            reviewActivity.goToPreviousElement();
                        })
                    },
                    {
                        keys: ['n'],
                        desc: 'next comment',
                        action: performIfReviewActivityOpened(function (reviewActivity) {
                            reviewActivity.goToNextElement();
                        })
                    },
                    {
                        keys: ['shift+n'],
                        desc: 'next unread comment',
                        action: performIfReviewActivityOpened(function (reviewActivity) {
                            reviewActivity.goToNextElement('unread-comment');
                        })
                    },
                    {
                        keys: ['shift+p'],
                        desc: 'previos unread comment',
                        action: performIfReviewActivityOpened(function (reviewActivity) {
                            reviewActivity.goToPreviousElement('unread-comment');
                        })
                    },
                    {
                        keys: ['m'],
                        desc: 'toggle comment read/unread',
                        action: function () {
                            // will be handled by CRAS itself
                        }
                    },
                    {
                        keys: ['return'],
                        desc: 'navigate to comment',
                        action: function () {
                            // will be handled by CRAS itself
                        }
                    }
                ]
            })
        }

        function keyEventWrangler(key) {
            if ($.inArray(key, $.hotkeys.keypressKeys) >= 0) {
                return 'keypress';
            } else {
                return 'keydown';
            }
        }

        var openHelpDialog = function () {
            if (!popupShowing) {
                popup.show();
                popupShowing = true;
                return false;
            }
        };
        // the menu item under page tools
        $(document).delegate("#keyboard-shortcut-help", 'click', openHelpDialog);
        // the keyboard shortcuts help icon in the toolbar
        $("#review-info-container").delegate('.toolbar-keyboard-shortcuts', 'click', openHelpDialog);


        // Bind key handlers and generate help html.
        var strs = [];
        $.each(categories, function (i, category) {
            strs.push('<h3>' + category.category + '</h3>');
            strs.push('<table>');

            $.each(category.shortcuts, function (j, shortcut) {
                $.each(shortcut.keys, function (k, key) {
                    if (shortcut.action) {
                        $(document).bind(keyEventWrangler(key), key, shortcut.action);
                    }
                });
                if (shortcut.desc) {
                    strs.push(shortcutHtml(shortcut));
                }
            });

            strs.push('</table>');
        });

        // Create the popup.
        var popupShowing = false;
        var popup = FECRU.DIALOG.create(800, 550, 'keynavHelp')
            .addHeader('Keyboard Shortcuts')
            .addPanel('All', strs.join(''))
            .addButton('Close', function (dialog) {
                dialog.hide();
                popupShowing = false;
            });

        function shortcutHtml(shortcut) {
            var keysHtml = $.map(shortcut.keys, keyComboHtml).join(' or ');
            return '<tr><th>' + keysHtml + ' :</th><td>' + shortcut.desc + '</td></tr>';
        }

        function keyComboHtml(keyCombo) {
            return $.map(keyCombo.split('+'), function (key) {
                return '<kbd>' + key + '</kbd>';
            }).join(' + ');
        }
    });

})(
    AJS.$,
    function () {
        return REVIEW_ACTIVITY_PLUGIN.app;
    }
);

// {/define  $FECRU.Keynav}/*[{!keynav_js_neh1518!}]*/