CRU.FRX = (function ($, reviewUtil) {
    var postPostLoadSummarize;
    var postPostLoadFunc = function () {
        review.setLoaded(true);
        reviewUtil.startPollingForReviewUpdates();
        // This is executed after all diffs are finished.
        if (postPostLoadSummarize) {
            res.toggleSource();
        }
        commentator.setCommentWidths(null, true);
        commentator.g_pageCompletelyLoaded = true;
    };

    /*eslint-disable complexity, max-depth*/
    var optimizedFrxList = function (alreadyLoadedFrx, frxIdsToList) {
        var frxsToList;
        if (frxIdsToList) {
            frxsToList = [];
            for (var idIndex = 0; idIndex < frxIdsToList.length; idIndex++) {
                frxsToList[frxsToList.length] = review.frx(frxIdsToList[idIndex]);
            }
        } else { // default to all
            frxsToList = review.frxs();
        }

        var currentFrxId = CRU.FRX.NAV.getCurrentFrxId();
        var loadingCurrentFrxId = false;

        var idsWithUnreadDefects = [];
        var idsWithUnreadComments = [];
        var idsIncomplete = [];
        var idsWithDefects = [];
        var idsWithComments = [];
        var idsWithoutComments = [];
        var idsThatAreDirs = []; // less likely that we want these really

        for (var i = 0, len = frxsToList.length; i < len; i++) {
            var frx = frxsToList[i];
            if (frx) {
                var id = frx.id();
                if (id === alreadyLoadedFrx) {
                    continue;
                }
                if (id === currentFrxId) {
                    loadingCurrentFrxId = true;
                    continue;
                }

                var unreadComments = frx.unreadComments();
                if (unreadComments.length > 0) {
                    var hasUnreadDefect;
                    for (var j = 0; j < unreadComments.length; j++) {
                        hasUnreadDefect = unreadComments[j].defect();
                        if (hasUnreadDefect) {
                            break;
                        }
                    }
                    (hasUnreadDefect ? idsWithUnreadDefects : idsWithUnreadComments).push(id);
                } else if (!frx.isComplete()) {
                    idsIncomplete.push(id);
                } else if (frx.hasDefects()) {
                    idsWithDefects.push(id);
                } else if (frx.hasComments()) {
                    idsWithComments.push(id);
                } else if (frx.isDirectory()) {
                    idsThatAreDirs.push(id);
                } else {
                    idsWithoutComments.push(id);
                }
            }
        }

        return (loadingCurrentFrxId ? [currentFrxId] : [])
            .concat(idsWithUnreadDefects)
            .concat(idsWithUnreadComments)
            .concat(idsIncomplete)
            .concat(idsWithDefects)
            .concat(idsWithComments)
            .concat(idsWithoutComments)
            .concat(idsThatAreDirs);
    };
    /*eslint-enable*/

    var filterFrxsFromHash = function () {
        if (/^#f-/.test(window.location.hash)) {
            var csv = window.location.hash.replace(/^#f-/, '');
            reviewUtil.filterAndExpandFrxs(csv.split(','));
        }
    };

    var activateFirstUnfilteredFrx = function () {
        var frxToActivate;
        var $generalComments = $('#generalComments');

        if (!$generalComments.hasClass('filtered')) {
            frxToActivate = $generalComments[0];
        } else {
            var nonFilteredFrxs = $.grep(review.frxs(), function (frx) {
                return !frx.isFiltered();
            });
            if (nonFilteredFrxs.length > 0) {
                frxToActivate = $('#frxouter' + nonFilteredFrxs[0].id())[0];
            }
        }

        if (frxToActivate) {
            CRU.FRX.NAV.setCurrentFrxAndScroll(frxToActivate);
        }
    };
    var activateFirstUnfilteredComment = function (filter, currentFrx) {
        var frxComments;
        var $generalComments = $('#generalComments');

        if (currentFrx && !currentFrx.isFiltered()) { // stay on the current frx if it's unfiltered
            frxComments = currentFrx.comments();
        } else if (!$generalComments.hasClass('filtered')) {
            frxComments = review.generalComments();
        } else {
            var nonFilteredFrxs = $.grep(review.frxs(), function (frx) {
                return !frx.isFiltered();
            });
            if (nonFilteredFrxs.length > 0) {
                frxComments = nonFilteredFrxs[0].comments();
            }
        }

        // scroll to the first matching comment in the first unfiltered frx
        if (frxComments) {
            for (var i = 0, len = frxComments.length; i < len; i++) {
                var comment = frxComments[i];
                if (commentMatchesFilter(comment, filter)) {
                    CRU.COMMENT.NAV.scrollDirectlyToComment(comment.domId());
                    break;
                }
            }
        }
    };

    function showFrx(frx) {
        frx.navItem().removeClass('filtered');
        frx.frxOuter().removeClass('filtered');
        frx.setFiltered(false);
    }

    function hideFrx(frx) {
        frx.navItem().addClass('filtered');
        frx.frxOuter().addClass('filtered');
        frx.setFiltered(true);
    }

    function getFrxFilter() {
        var filterItems = $('li.selected', document.getElementById('frxFilterOptions'));
        var filter = {
            isEnabled: !!filterItems.length
        };

        for (var i = 0, l = filterItems.length; i < l; i++) {
            filter[filterItems[i].id.replace("frx-filter-", "")] = true;
        }
        return filter;
    }

    function isCommentLevelFilter(filter) {
        return filter.unreadcomments ||
            filter.subtasks ||
            filter.unresolvedsubtasks ||
            filter.draftcomments ||
            filter.defects;
    }

    function frxMatchesFilter(frx, filter) {
        //if any frx-level filters do not match, hide this frx
        if ((filter.incomplete && frx.isComplete()) ||
            (filter.comments && !frx.hasComments()) ||
            (filter.binary && !frx.isBinary()) ||
            (filter.nonbinary && frx.isBinary()) ||
            (filter.nondirectory && frx.isDirectory()) ||
            (filter.newsincecomplete && !frx.isNewSinceComplete())) {
            return false;
        }
        if (isCommentLevelFilter(filter)) {
            var matchesCommentFilter = false;
            //on a comment-level filter, hide if no comments
            var frxComments = frx.comments();
            for (var j = 0, cLen = frxComments.length; j < cLen; j++) {
                var frxComment = frxComments[j];
                //show this frx if any comment matches all the comment-level filters
                if (commentMatchesFilter(frxComment, filter)) {
                    matchesCommentFilter = true;
                    break;
                }
            }
            if (!matchesCommentFilter) {
                return false;
            }
        }

        //matches all filters
        return true;
    }

    function generalCommentsFrxMatchesFilter(filter) {
        if (isCommentLevelFilter(filter)) {
            //on a comment-level filter, hide if no comments
            var frxComments = review.generalComments();
            for (var j = 0, cLen = frxComments.length; j < cLen; j++) {
                var frxComment = frxComments[j];
                //show this frx if any comment matches all the comment-level filters
                if (commentMatchesFilter(frxComment, filter)) {
                    return true;
                }
            }
            return false;
        } else {
            return true;
        }
    }

    function commentMatchesFilter(comment, filter) {
        var status = comment.issueStatus();
        if (status) {
            status = status.toLowerCase();
        }

        return !(
            filter.unreadcomments && !(comment.status() === 'unread' || comment.status() === 'leaveUnread') ||
            filter.subtasks && !(comment.issueKey() && comment.issueKey() !== '') ||
            filter.unresolvedsubtasks && !(comment.issueKey() && status !== 'resolved' && status !== 'closed') ||
            filter.draftcomments && !(comment.draft()) ||
            filter.defects && !(comment.defect())
        );
    }

    var filter = null;

    function changedFrxFilter() {
        filter = getFrxFilter();

        if (filter.isEnabled) {
            $("#filter-frxs-clear").removeClass("disabled");
        } else {
            $("#filter-frxs-clear").addClass("disabled");
        }

        filterFrxs(null, true);
    }

    function filterFrxs(frxs, jumpToFirstUnfiltered) {
        filter = filter || getFrxFilter();

        var isCommentLevel = isCommentLevelFilter(filter);

        if (!frxs) {
            frxs = review.frxs();
            var $generalComments = $('#scroll-to-general-comments').closest('li').add('#generalComments');

            //We should filter out general comments as well if it doesn't match a comment filter
            $generalComments.toggleClass('filtered', !generalCommentsFrxMatchesFilter(filter));
        }
        for (var i = 0, len = frxs.length; i < len; ++i) {
            var frx = frxs[i];
            if (frxMatchesFilter(frx, filter)) {
                showFrx(frx);
            } else {
                hideFrx(frx);
            }
        }

        CRU.COMMENT.NAV.visibleCommentsChanged();
        CRU.FRX.NAV.visibleFrxsChanged();
        if (jumpToFirstUnfiltered) {
            if (isCommentLevel) {
                activateFirstUnfilteredComment(filter, review.frx(CRU.FRX.NAV.getCurrentFrxId()));
            } else {
                var $currentFrx = $(CRU.FRX.NAV.getCurrentFrxElement());
                if (!$currentFrx.hasClass('frxouter') || $currentFrx.hasClass('filtered')) {
                    activateFirstUnfilteredFrx();
                }
            }
        }
        var navigationTree = $('#navigation-tree');
        $('.folder', navigationTree).parent().addClass('filtered');
        $('.frx-list-item:has(li.frx-list-item:not(.filtered))', navigationTree).removeClass('filtered');
        CRU.FRX.updateFiltererdFrxCount();
    }

    //unload an frx to save on heap space
    function unloadFrx(frxId) {
        var frx = review.frx(frxId);
        if (frx) {
            reviewUtil.triggerSourceCodeReset(frxId);
            frx.setLoaded(false)
                .frxInner()
                .empty()
                .append('<div id="frxLoadDiff' + frxId + '" class="frx-unloaded">' +
                '<a onclick="CRU.FRX.AJAX.frxLoad(' + frxId + ');return false;">Click to load diff</a>' +
                '</div>');
        }
    }

    var res = {

        reloadFrxs: function (opts, frxIds) {
            frxIds = optimizedFrxList(null, frxIds);

            //reset some global vars to reload the diffs
            for (var i = 0, len = frxIds.length; i < len; i++) {
                var frxId = frxIds[i];
                var frx = review.frx(frxId);
                reviewUtil.triggerSourceCodeReset(frxId);
                frx.setLoaded(false);
            }
            commentator.g_pageCompletelyLoaded = false;
            var loadOpts = {
                diffMode: opts.diffOpts,
                isForcedReload: true
            };
            CRU.FRX.AJAX.prioritisedFrxLoad(frxIds, null, loadOpts);
        },

        unloadFrx: unloadFrx,

        updateFiltererdFrxCount: function () {
            var unfilteredCount = $('#navigation-tree .frx-list-item:not(.filtered) > .frx').length;
            var filteredCount = $('#navigation-tree .frx-list-item.filtered > .frx').length;

            $('#filter-frxs-shown-count').text(unfilteredCount);
            $('#filter-frxs-unshown-count').text(filteredCount);

            if ($('#frxFilterOptions li.selected').length > 0) {
                $("#navigation-filter-link").parent().addClass("filter-enabled");
            } else {
                $("#navigation-filter-link").parent().removeClass("filter-enabled");
            }

            if (review.frxs().length > 0 && unfilteredCount === 0) {
                $('#frxs-filtered-warning').show();
            } else {
                $('#frxs-filtered-warning').hide();
            }
        },

        /**
         *
         * @param destination
         * This is for determining how the navigation is done. e.g. scroll to the next element..
         * possible values: 'first' | 'last' | 'next' | 'previous'
         *
         * @param $elementWithSpinner
         * This is the buttons of "navigation up / down"
         * In crucible, when a user reaches the bottom or top of the review, if he tries to go further, he will cycle up
         * the elements, and this $elementWithSpinner will get highlighted to notice the user.
         *
         * @param opts : {} -- the opts will contain two callback functions. When a user reaches the edge of the review,
         *                  -- this callback functions will be triggered
         *      navFirst :  function ()
         *          -- when a user reaches the top and try go "previous"
         *      navLast :   function ()
         *          -- when a user reaches the bottom and try go "next"
         */
        goToNextElement: function (destination, $elementWithSpinner, opts) {
            var numPredictedFrxsToLoad = 2;
            var comment_nav = CRU.COMMENT.NAV;

            opts = $.extend({
                startingCommentDomId: comment_nav.getCurrentCommentDomId(),
                destination: destination,
                findFrx: $('#search-file').hasClass('selected'),
                findComment: $('#search-comment').hasClass('selected'),
                findDefect: $('#search-defect').hasClass('selected'),
                findDiff: $('#search-diff').hasClass('selected'),
                startingFrxId: CRU.FRX.NAV.getCurrentFrxId(),
                stopIfNothingFound: false
            }, opts);

            var navigateForwards = destination === 'first' || destination === 'next';
            var nextElementMap = CRU.NAV.findNextElement(opts);

            CRU.COMMENT.commentScrollTracker && CRU.COMMENT.commentScrollTracker.setTrackingEnabled(false);

            var preloadNextFrxes = function () {
                opts.startingFrxId = nextElementMap.frxId;
                var predictions = CRU.FRX.getPredictedFrxsToLoad(opts, numPredictedFrxsToLoad);
                predictions.unshift(nextElementMap.frxId);
                CRU.FRX.AJAX.prioritisedFrxLoad(predictions);
            };
            if (nextElementMap && (nextElementMap.type === 'comment' ||
                nextElementMap.type === 'comment-unloaded')) {
                preloadNextFrxes();
                var scrollToComment = review.comment(nextElementMap.gotoElem);
                comment_nav.navigateDirectlyToElement(opts, {
                    gotoElem: scrollToComment ? scrollToComment.id() : null,
                    frxId: nextElementMap.frxId,
                    type: 'comment'
                }, $elementWithSpinner);
                CRU.DIFF.NAV.setCurrentDiffId(null, null);
            } else if (nextElementMap && nextElementMap.type === 'diff' && nextElementMap.gotoElem && nextElementMap.frxId) {
                preloadNextFrxes();
                comment_nav.setCurrentComment(null);
                CRU.DIFF.NAV.gotoDiff(nextElementMap);
            } else if (nextElementMap) {
                preloadNextFrxes();
                // prevent focusing comments and scrolling to the last position
                comment_nav.setCurrentComment(null);
                CRU.FRX.NAV.setCurrentFrx(nextElementMap.frxId, {gotoTop: true});
            } else {

                if (navigateForwards) {
                    if (opts.navFirst) {
                        opts.navFirst();
                    }
                } else {
                    if (opts.navLast) {
                        opts.navLast();
                    }
                }

                var $button = $('#' + (navigateForwards ? 'next' : 'prev') + '-element-link');
                $button.effect('highlight', {color: '#f00'}, 800);
            }

            CRU.COMMENT.commentScrollTracker && CRU.COMMENT.commentScrollTracker.setTrackingEnabled(true, true);
        },

        getPredictedFrxsToLoad: function (opts, count) {
            var options = $.extend({}, opts);
            var predictNext = [];
            if (options.destination === 'bidirectional') {
                options.destination = 'next';
                predictNext = CRU.FRX.getPredictedFrxsToLoad(options, count);
                options.destination = 'previous';
                predictNext = predictNext.concat(CRU.FRX.getPredictedFrxsToLoad(options, count));
            } else {
                // if there is only one frx on the review and the count is 2, the loop would be infinite.
                // so count can't be larger than number of existent frxes
                count = Math.min(count, review.frxIds().length);
                var prevGotoElem = null;
                while (count) {
                    var nextElementMap = CRU.NAV.findNextElement(options);
                    if (!nextElementMap) {
                        break;
                    }
                    nextElementMap.frxId = nextElementMap.frxId || "generalComments";
                    nextElementMap.nextFrxId = nextElementMap.nextFrxId || "generalComments";

                    if ($.inArray(nextElementMap.frxId, predictNext) === -1) {
                        predictNext.push(nextElementMap.frxId);
                        count--;
                    }

                    var gotoElem = nextElementMap.gotoElem;
                    if (gotoElem === prevGotoElem) {
                        break; // loop detected, same comment as in the previous run
                    }
                    prevGotoElem = gotoElem;

                    //we only care about frxs, so skip ahead to the next frxId on anything else
                    options.startingFrxId = nextElementMap.type !== 'frx' ? nextElementMap.nextFrxId : nextElementMap.frxId;
                }
            }
            return predictNext;
        },

        changedFrxFilter: changedFrxFilter,
        filterFrxs: filterFrxs,

        postPostLoadFunc: postPostLoadFunc,

        defaultPostLoad: function (summarize) {
            postPostLoadSummarize = summarize;
            $(window).bind('panes-resized', function () {
                commentator.setCommentWidths(null, true);
            });
        },

        revPostLoad: function (summarize) {
            CRU.COMMENT.commentScrollTracker && CRU.COMMENT.commentScrollTracker.setTrackingEnabled(false);
            var MAX_FRX_AUTOLOAD = 10; // The number of FRXs to automatically load when the the initial review page has loaded.

            res.defaultPostLoad(summarize);
            var cru = CRU;
            var cru_frx = cru.FRX;
            var anchoredFrx = cru_frx.NAV.checkFrxAnchor();
            if (!anchoredFrx) {
                anchoredFrx = cru.COMMENT.NAV.checkCommentAnchor();
            }
            if (!anchoredFrx) {
                filterFrxsFromHash();
            }
            if (!anchoredFrx) {
                anchoredFrx = res.checkSegmentAnchor();
            }
            if (!anchoredFrx && window.location.hash.replace('#', '')) {
                CRU.FRX.scrollFrxPane('generalComments', window.location.hash.replace('#', ''));
                CRU.UI.highlightElements($(window.location.hash).children('.overview-item'));
            }
            cru_frx.AJAX.setIsInitialFrxLoad();
            cru_frx.AJAX.frxLoad(optimizedFrxList(anchoredFrx).slice(0, MAX_FRX_AUTOLOAD));
            CRU.COMMENT.commentScrollTracker && CRU.COMMENT.commentScrollTracker.setTrackingEnabled(true, true);
        },

        checkSegmentAnchor: function () {
            var m = /^#frx([0-9]+)_seg/.exec(window.location.hash);
            if (m) {
                var frxId = m[1];
                var frx = review.frx(frxId);
                var $segment = $(window.location.hash);

                var isInlineButNotLoaded = $segment.length === 0;
                if (isInlineButNotLoaded) {
                    if (frx.isLoaded()) {
                        res.scrollToSegment(frxId, window.location.hash);
                    } else {
                        var onDone = function () {
                            res.scrollToSegment(frxId, window.location.hash);
                        };
                        CRU.FRX.AJAX.prioritisedFrxLoad(frx.id(), onDone);
                    }
                    return frxId;
                } else {
                    window.location.hash = '';
                    CRU.FRX.NAV.setCurrentFrxAndScroll('generalComments');
                }
            }
            return null;
        },

        //todo: use this method instead of hashes to jump between them - for now this is only used when loading the page
        scrollToSegment: function (frxId, segId) {
            CRU.FRX.NAV.setCurrentFrx(frxId);
            var $seg = $(segId);
            if ($seg.length > 0) {
                CRU.UI.scrollToElement($seg[0], {
                    offset: 43
                });
            }
        },

        toggleAllFrxsSoftWrapping: function (enabled) {
            if (enabled) {
                $('#reviewpage').removeClass('noWrapping').addClass('wrapping');
            } else {
                $('#reviewpage').addClass('noWrapping').removeClass('wrapping');
            }
        },

        toggleAllFrxsDiffMode: function (mode) {
            res.reloadFrxs({diffOpts: {diffLayout: mode}});
        },

        toggleSource: function () {
            var currentFrxId = CRU.FRX.NAV.getCurrentFrxId();
            if (commentator.showSource) {
                commentator.showSource = false;
                $('#reviewpage').addClass("hide-source");
                $('#show_source_button').removeClass('selected');

                reviewUtil.triggerSourceCodeHidden(currentFrxId);
                commentator.toggleComments("above");
            } else {
                commentator.showSource = true;
                $('#reviewpage').removeClass("hide-source");
                $('#show_source_button').addClass('selected');

                reviewUtil.triggerSourceCodeShown(currentFrxId);
            }
        },

        changeBlankLines: function (permaId, frxId, bl) {
            res.changeWhitespace(permaId, frxId, null, bl);
        },

        changeWhitespace: function (permaId, frxId, ws, bl) {
            var params = res.diffParams(frxId, {whiteSpace: ws, blankLines: bl}) + "&showDiffContextBar=true";
            params += CRU.FRX.AJAX.frxRevisionParams(frxId);
            CRU.FRX.AJAX.toggleSourceType(permaId, frxId, false, params);
        },

        whiteSpaceParams: function (frx, ws) {
            if (ws) {
                frx.setWhitespace(ws);
            } else {
                ws = frx.getWhitespace();
            }
            return ws;
        },

        blankLinesParams: function (frx, bl) {
            if (bl !== null && bl !== undefined) {
                frx.setIgnoreBlankLines(bl);
            } else {
                bl = frx.getIgnoreBlankLines();
            }
            return bl;
        },

        contextParams: function (frx, context) {
            if (context) {
                frx.setContext(context);
            } else {
                context = frx.getContext();
            }
            return context;
        },

        diffLayoutParams: function (frx, opt) {
            if (opt) {
                frx.setDiffLayout(opt);
            } else {
                opt = frx.getDiffLayout();
            }
            return opt;
        },

        diffParamsMap: function (frxId, map) {
            var frx = review.frx(frxId);
            map = map || {};
            if (frx) {
                map.context = res.contextParams(frx, map.context);
                map.diffLayout = res.diffLayoutParams(frx, map.diffLayout);
                map.blankLines = res.blankLinesParams(frx, map.blankLines);
                map.whiteSpace = res.whiteSpaceParams(frx, map.whiteSpace);
            }
            return map;
        },

        diffParams: function (frxId, map) {
            map = res.diffParamsMap(frxId, map);
            var result = '';
            if (map.context) {
                result += '&u=' + map.context;
            }
            if (map.diffLayout) {
                result += '&fv=' + map.diffLayout;
            }
            // this is a boolean value, so a value of false would be ignored here
            if (map.blankLines !== undefined && map.blankLines !== null) {
                result += '&bl=' + map.blankLines;
            }
            if (map.whiteSpace) {
                result += '&ws=' + map.whiteSpace;
            }
            return result;
        },

        reloadSingleFrx: function (permaId, frxId, diffLayout) {
            var params = res.diffParams(frxId, {'diffLayout': diffLayout}) + "&showDiffContextBar=true";
            params += CRU.FRX.AJAX.frxRevisionParams(frxId);
            CRU.FRX.AJAX.toggleSourceType(permaId, frxId, false, params, null);
        },

        toggleDiffModeAjax: function (permaId, frxId, u, done) {
            var params = res.diffParams(frxId, {'context': u});
            params += CRU.FRX.AJAX.frxRevisionParams(frxId);
            CRU.FRX.AJAX.toggleSourceType(permaId, frxId, false, params, done);
        },

        frxActivated: function (frxOuter, options) {
            var cruFrx = CRU.FRX;
            var cruFrxNav = cruFrx.NAV;
            var cruFrxAjax = cruFrx.AJAX;
            var cruCommentNav = CRU.COMMENT.NAV;

            options = $.extend({
                changeHash: true
            }, options);
            var frxId = frxOuter.id.replace('frxouter', '');
            if (frxId === 'generalComments') {
                $('#frx-overview').addClass("activeFrx");
                $('#generalComments').addClass("activeFrx");
                $(frxOuter).trigger('frx-visible');
            } else {
                var frx = review.frx(frxId);
                var $frxOuter = frx.frxOuter();
                var $navItem = frx.navItem();

                $navItem.addClass("activeFrx");
                $frxOuter.addClass("activeFrx");

                if (options.changeHash) {
                    window.location.hash = "#CFR-" + frxId;
                }

                if (frx.isLoaded()) {
                    cruCommentNav.visibleCommentsChanged();
                    $(frxOuter).trigger('frx-visible');
                } else {
                    // If the frx hasn't loaded yet, then we should push it to the top of the load stack.
                    cruFrxAjax.prioritisedFrxLoad(frxId, function () {
                        $(frxOuter).trigger('frx-visible');
                    });
                }

                if (!cruFrxAjax.isFrxControlsRendered(frxId)) {
                    cruFrxAjax.unshelveFrxControls(frxId);
                }
            }
            cruFrxNav.visibleFrxsChanged();

        },

        frxDeactivated: function (frxOuter) {
            if (!frxOuter) {
                return;
            }
            var frxId = frxOuter.id.replace('frxouter', '');
            $(frxOuter).removeClass("activeFrx");

            if (frxId === 'generalComments') {
                // general controls
                $("#frx-overview").removeClass("activeFrx");
            } else {
                var $prev = $("#frx-list-item" + frxId).removeClass("activeFrx");
                cancelPrevHightlights($prev.children('span'));
            }
        },

        dimFrxContent: function () {
            var $inner = $("#frx-content");
            var $blanket = $("#frx-dim-content");
            if ($blanket.length > 0) {
                return;
            }
            $blanket = $("<div id='frx-dim-content' class='frx-dim'><div id='frx-dim-msg' class='frx-dim-msg'>Updating source...</div></div>");
            $inner.append($blanket);
        },

        unDimFrxContent: function () {
            var $blanket = $("#frx-dim-content");
            if ($blanket.length > 0) {
                $blanket.remove();
            }
        },

        dimFrx: function (frxId) {
            // sanity check
            if (!review.frx(frxId)) {
                return;
            }
            var $inner = $("#sourcefrxinner" + frxId);

            var $blanket = $("#frx-dim-" + frxId);
            if ($blanket.length > 0) {
                return;
            }

            $blanket = $("<div id='frx-dim-" + frxId + "' class='frx-dim'><div id='frx-dim-msg-" + frxId + "' class='frx-dim-msg'>Updating source...</div></div>");

            $blanket.css({
                height: $inner.height(),
                width: $("#sourceTable" + frxId).width() // Source table can push out from parent dimensions
            });
            $inner.prepend($blanket);
        },

        unDimFrx: function (frxId) {
            // sanity check
            if (!review.frx(frxId)) {
                return;
            }
            var $blanket = $("#frx-dim-" + frxId);
            if ($blanket.length > 0) {
                $blanket.remove();
            }
        },

        scrollFrxPane: function (containerId, innerId) {
            var cruFrxNav = CRU.FRX.NAV;
            if (innerId) {
                cruFrxNav.setCurrentFrx(containerId);
                var $inner = $(cruFrxNav.getCurrentFrxElement()).find('#' + innerId);
                if ($inner.length === 1) {
                    CRU.UI.scrollToElement($inner[0]);
                }
            } else {
                cruFrxNav.setCurrentFrxAndScroll(containerId);
            }
        }
    };

    var setFrxDimHeight = function (frxId) {
        $("#frx-dim" + frxId).css("height", $("#sourcefrxinner" + frxId).height());
    };

    var highlightElement = function ($elem, color) {
        $elem.effect("highlight", {color: color}, 1200, function () {
            $(this).css("background-color", "");
        });
        $elem.css('background-image', '');
    };

    var cancelPrevHightlights = function ($elem) {
        $elem.stop().css('background-color', '');
    };

    return res;
})(
    AJS.$,
    CRU.REVIEW.UTIL
);

/*[{!frx_js_o47d51u!}]*/