CRU.FRX.NAV = {};

(function (reviewUtil) {

    var currentFrxId = null;

    function asFrxId(frxHandle) {
        if (frxHandle instanceof AJS.$) {
            frxHandle = frxHandle[0];
        }
        if (!frxHandle) {
            return null;
        } else if (frxHandle.nodeType) {
            return frxHandle.id.replace(/(frxouter|frxinner)/, '');
        } else if (typeof frxHandle === 'string') {
            return frxHandle;
        }
        return null;
    }

    CRU.FRX.NAV.setCurrentFrxAndScroll = function (frxHandle, options) {
        CRU.FRX.NAV.setCurrentFrx(frxHandle, AJS.$.extend({
            scroll: true
        }, options || {}));
    };

    CRU.FRX.NAV.setCurrentFrx = function (frxHandle, options) {
        var cruFrx = CRU.FRX;
        var cruFrxAjax = cruFrx.AJAX;
        var cruFrxNav = cruFrx.NAV;

        options = AJS.$.extend({
            scroll: false,
            gotoTop: false,
            changeHash: true
        }, options);

        var currentFrx = review.frx(currentFrxId);
        var frxId = asFrxId(frxHandle);

        if (currentFrxId !== frxId) {
            reviewUtil.triggerSourceCodeHidden(currentFrxId);

            if (currentFrxId !== null) {
                currentFrx && currentFrx.setLastScrollTop(CRU.UI.getReviewContentScrollTopPosition());
                var $currentOuter = AJS.$(cruFrxNav.getCurrentFrxElement());
                cruFrx.frxDeactivated($currentOuter[0]);
                AJS.$(document).trigger('frx-deactive', [frxId]);
            }

            currentFrxId = frxId;

            cruFrx.dimFrxContent();
            //trick to force rendering The Dimmer Spinner
            setTimeout(function() {
                if (frxId !== null) {
                    var $itemOuter = AJS.$(cruFrxNav.getCurrentFrxElement());

                    cruFrx.frxActivated($itemOuter[0], {
                        changeHash: options.changeHash
                    });

                    var frx = review.frx(frxId);
                    if (frx && frx.isLoaded()) {
                        if (frxId !== 'generalComments') {
                            reviewUtil.triggerSourceCodeShown(frxId);
                        }

                        if (review.autoMarkFilesRead()) {
                            cruFrxAjax.markFile(true, frxId);
                        }

                        if (options.scroll) {
                            if (!options.gotoTop) {
                                CRU.UI.scrollReviewContentTo(frx.getLastScrollTop());
                            } else {
                                frx.setLastScrollTop(0); // get's re-executed from the hashchange event handler
                                CRU.UI.scrollReviewContentTo(0);
                            }
                        }
                    }
                }
                cruFrx.unDimFrxContent();
                scrollNavigationTreeToFrxLink(frxId);
            }, 0);
        } else {
            // Process the options on the current FRX.
            if (options.scroll) {
                if (currentFrx && currentFrx.isLoaded()) {
                    CRU.UI.scrollReviewContentTo(currentFrx.getLastScrollTop());
                } else {
                    CRU.UI.scrollToElement(cruFrxNav.getCurrentFrxElement());
                }
            }
        }

        review.recentlyViewedFrxIds.save(currentFrxId);
    };

    var scrollNavigationTreeToFrxLink = function (frxId) {
        var scrollToId = frxId === 'generalComments' ? 'frx-overview' : ('frx-list-item' + frxId);
        var threshold = 40;
        var $link = AJS.$('#' + scrollToId);
        if ($link.filter(':in-viewport-vert(' + threshold + ', content-navigation-panel)').length === 0) {
            var offset = -threshold;
            if ($link.filter(':above-the-top(' + threshold + ', content-navigation-panel)').length === 0) {
                offset = threshold - AJS.$('#content-navigation-panel').height();
            }
            AJS.$('#content-navigation-panel').scrollTo($link[0], {
                axis: 'y',
                offset: offset
            });
        }
    };

    CRU.FRX.NAV.visibleFrxsChanged = function () {
        var cruFrx = CRU.FRX;
        var cruFrxNav = cruFrx.NAV;

        // We always have at least the general comments.
        var frxs = [document.getElementById("generalComments")];
        AJS.$.each(review.frxs(), function () {
            frxs.push.apply(frxs, this.frxOuter().get());
        });

        if (currentFrxId) {
            if (AJS.$.inArray(cruFrxNav.getCurrentFrxElement(), frxs) < 0) {
                cruFrxNav.setCurrentFrx(frxs[0]);
            }
        } else {
            cruFrxNav.setCurrentFrx(frxs[0]);
        }
        AJS.$(window).trigger('panes-resized');
        AJS.$('#navigation-tree .file-count').text(review.frxs().length);
    };

    CRU.FRX.NAV.getCurrentFrxId = function () {
        return currentFrxId;
    };

    CRU.FRX.NAV.getCurrentFrxElement = function () {
        if (currentFrxId) {
            var domId = currentFrxId === 'generalComments' ? 'generalComments' : 'frxouter' + currentFrxId;
            return AJS.$('#' + domId)[0];
        } else {
            return null;
        }
    };

    var defaultOpts = {
        destination: 'first',
        skipCompleteFrxs: false
    };

    /**
     * @param {String} opts.destination location to scroll to - may be <tt>first</tt>, <tt>last</tt>, <tt>previous</tt> or <tt>next</tt>.
     * @param {String} opts.frxId the frx id of the frx to scroll to. This value is ignored if the <tt>opts.destination</tt> is <tt>first</tt> or <tt>last</tt>.
     * @param {Boolean} opts.skipCompleteFrxs if true, frxs which have been marked as complete will be passed over and ignored.
     */
    CRU.FRX.NAV.gotoFrx = function (opts) {
        var frx = review.frx(opts.frxId);
        // if the frx is loaded, just go to it
        if (!frx || frx.isLoaded()) {
            scrollToFrx(opts);
            return;
        }

        // otherwise, we must make sure to load the frx first
        var onComp = function () {
            commentator.setCommentWidths(null, true);
            scrollToFrx(opts);
        };
        CRU.FRX.AJAX.prioritisedFrxLoad(opts.frxId, onComp);
    };

    CRU.FRX.NAV.getGotoFrxId = function (opts) {
        return getScrollToFrxId(opts);
    };

    /**
     * Scroll to a comment form if one exists inside the current frx
     *
     */
    CRU.FRX.NAV.scrollToCommentForm = function () {
        var frxId = CRU.FRX.NAV.getCurrentFrxId();

        //if there is a comment form open, scroll to it
        var forms = commentator.getDisplayingForms();
        for (var i = 0, len = forms.length; i < len; i++) {
            var $form = forms[i].getForm();
            var $frxouter = $form.closest('.frxouter');
            if ($frxouter.length > 0) {
                var commentFormFrxId = $frxouter.attr('id').replace('frxouter', '');
                if (commentFormFrxId === frxId) {
                    //scroll to it
                    CRU.UI.scrollToElement($form, {
                        offset: 55
                    });
                    $form.find('.commentTextarea').focus();
                    break;
                }
            }
        }
    };

    CRU.FRX.NAV.checkFrxAnchor = function () {
        var frxId;
        if (/^#CFR-\d+/.test(window.location.hash)) {
            frxId = window.location.hash.replace(/^#CFR-(\d+).*$/, '$1');
            if (review.frx(frxId)) {
                CRU.FRX.NAV.setCurrentFrxAndScroll(frxId, {
                    initialScroll: true
                });
                return frxId;
            } else {
                window.location.hash = '';
                CRU.FRX.NAV.setCurrentFrxAndScroll('generalComments', {
                    initialScroll: true
                });
            }
        }
    };

    CRU.FRX.NAV.frxDiffLoaded = function (frxId) {
        // For some reason frxId here is a number (not a string as currentFrxId).
        // Just not to break the app I'm going to cast frxId to string and then compare.
        if (currentFrxId === String(frxId)) {
            AJS.$(window).trigger('panes-resized');
            AJS.$('#frxinner' + frxId).trigger('current-frx-loaded');
            reviewUtil.triggerSourceCodeShown(frxId);
        }
    };

    var scrollToFrx = function (settings) {
        var frxId = getScrollToFrxId(settings);
        if (frxId) {
            CRU.FRX.NAV.setCurrentFrxAndScroll(frxId);
        }
    };

    /*eslint-disable complexity*/
    var getScrollToFrxId = function (settings) {
        var opts = {};

        AJS.$.extend(opts, defaultOpts, settings);

        var frxIds = AJS.$.merge(["generalComments"],
            AJS.$.grep(review.frxIds(), function (frxId) {
                return !review.frx(frxId).isFiltered();
            })
        );

        if (!frxIds || frxIds.length === 0) {
            return null;
        }

        var destinationFrxId = null;
        var destination = opts.destination;
        var skipCompleteFrxs = opts.skipCompleteFrxs;

        if (destination === 'first' && !skipCompleteFrxs) {
            destinationFrxId = frxIds[0];
        } else if (destination === 'last' && !skipCompleteFrxs) {
            destinationFrxId = frxIds[frxIds.length - 1];
        } else {
            // Find the source frx index in the list of frxs
            var index = -1;
            if (destination === 'last') {
                index = frxIds.length;
            } else if (destination !== 'first') {
                for (var j = 0, len = frxIds.length; j < len; j++) {
                    if (opts.frxId == frxIds[j]) { // eslint-disable-line eqeqeq
                        index = j;
                        break;
                    }
                }
            }

            // If we're iterating over unread comments, we want to keep jumping comments
            // when the comment is marked as 'read'.
            do {
                if (destination === 'previous' || destination === 'last') {
                    if (frxIds[index - 1]) {
                        destinationFrxId = frxIds[index - 1];
                        index--;
                    } else {
                        destinationFrxId = skipCompleteFrxs ? destinationFrxId : frxIds[index];
                        break;
                    }
                } else if (destination === 'next' || destination === 'first') {
                    if (frxIds[index + 1]) {
                        destinationFrxId = frxIds[index + 1];
                        index++;
                    } else {
                        destinationFrxId = skipCompleteFrxs ? destinationFrxId : frxIds[index];
                        break;
                    }
                } else {
                    destinationFrxId = frxIds[index];
                    break;
                }
                var frx = review.frx(destinationFrxId);
                var isFrxComplete = frx && frx.isComplete();
            } while (skipCompleteFrxs && isFrxComplete);
        }

        return destinationFrxId;
    };
    /*eslint-enable*/

})(CRU.REVIEW.UTIL);
/*[{!frx_nav_js_vdea51t!}]*/