AJS.$(document).ready(function () {

    var cruFrx = CRU.FRX;
    var cruFrxNav = cruFrx.NAV;
    var cruFrxAjax = cruFrx.AJAX;
    var cruUi = CRU.UI;

    cruFrx.updateFiltererdFrxCount(); // Setup the count in the filter div

    // Clicking on nav tree directories:
    //   1. If we click on the actual link, then if it is an FRX directory, activate it
    //      (handled by .scroll-to-frx live event).
    //   2. Otherwise, toggle the subtree
    //   3. If we click on the parent span.folder, then toggle it (dont activate the frx)

    var $frxPane = AJS.$("#frx-pane");
    var $navTree = AJS.$("#navigation-tree");

    $navTree.delegate(".tree span.folder", 'click', function (event) {
        var $folder = AJS.$(this);
        var $icon = $folder.find('.node-icon');
        var frxLinkClicked = AJS.$(event.target).is('a.frx-dir-item');

        // Don't close when clicking the link of an frxdir
        if ($folder.hasClass("open") && frxLinkClicked) {
            return;
        }

        if ($folder.hasClass("open")) {
            $folder.removeClass("open")
                .addClass("closed");

            $icon.removeClass('aui-iconfont-devtools-folder-open')
                .addClass('aui-iconfont-devtools-folder-closed');
        } else {
            $folder.removeClass("closed")
                .addClass("open");

            $icon.removeClass('aui-iconfont-devtools-folder-closed')
                .addClass('aui-iconfont-devtools-folder-open')
        }
        $folder.next('.tree').toggle();
        commentator.updateTreeFolderCommentCount($folder);
    });

    $frxPane.delegate("a.diff-segment-link", 'click', function (event) {
        var dest = AJS.$(this).attr("href");
        var frx = dest.replace("#frx", '').replace(/_seg\d+/, '');
        CRU.UI.scrollToElement(AJS.$(dest), {
            offset: 55
        });
        event.preventDefault();
        return false;
    });

    $frxPane.delegate(".frxControls a.toggleFileRead,.frxControls a.toggleFileRead-manual", "click", function () {
        var frx = review.frx(AJS.$(this).closest('.frxControls').attr('id').replace('frxControls', ''));
        cruFrx.AJAX.toggleFileRead(frx.id(), true);
    });

    function scrollToGeneralComments(innerId) {
        cruFrx.scrollFrxPane('generalComments', innerId);
        cruFrxNav.scrollToCommentForm();
    }

    var initUnreadCommentTooltips = function () {
        var tooltipOptions = {
            live: true,
            gravity: 'w',
            title: function () {
                var unreadCount = parseInt(this.dataset.unread || 0, 10);
                if (unreadCount > 0) {
                    return unreadCount + ' unread comment' + (unreadCount > 1 ? 's' : '');
                }
                return '';
            }
        };

        AJS.$('.aui-badge', AJS.$('#tree-root'))
            .tooltip(tooltipOptions);

        AJS.$('.aui-badge', AJS.$('#review-meta'))
            .tooltip(tooltipOptions);
    };


    if (AJS.$('#reviewpage').length === 1) {
        $navTree.delegate('.frx-list-item:not(.filtered) > span > a.scroll-to-frx', 'click', function () {
            var frxId = AJS.$(this).attr('id').replace(/scroll-to-frx/, '');
            cruFrxNav.setCurrentFrx(frxId);
            cruFrxNav.scrollToCommentForm();
            //we should load the nearest frxs ahead of time in case they click around
            var predictionOpts = {
                startingCommentDomId: null,
                destination: 'bidirectional',
                findFrx: true,
                findComment: false,
                findDefect: false,
                findDiff: false,
                startingFrxId: frxId
            };
            cruFrxAjax.prioritisedFrxLoad(cruFrx.getPredictedFrxsToLoad(predictionOpts, 1));
        });

        var $document = AJS.$(document);
        var changeHashAndBlockScroll = function (link) {
            var $link = AJS.$(link);
            var $window = AJS.$(window);
            var scrollTop = $window.scrollTop();

            document.location.hash = $link.attr('href');
            $window.scrollTop(scrollTop);
        };

        $document.delegate('#frx-overview:not(.filtered) .comments a', 'click', function (e) {
            e.preventDefault();
            changeHashAndBlockScroll(this);
            scrollToGeneralComments('general-comments');
            cruUi.highlightElements(AJS.$('#general-comments').children('.overview-item'));
        });

        $document.delegate('#frx-overview:not(.filtered) .details a', 'click', function (e) {
            e.preventDefault();
            changeHashAndBlockScroll(this);
            scrollToGeneralComments('details');
            cruUi.highlightElements(AJS.$('#details').children('.overview-item'));
        });

        $document.delegate('#frx-overview:not(.filtered) .objectives a', 'click', function (e) {
            e.preventDefault();
            changeHashAndBlockScroll(this);
            scrollToGeneralComments('objectives');
            cruUi.highlightElements(AJS.$('#objectives').children('.overview-item'));
        });

        $document.delegate('#frx-overview:not(.filtered) .summary a', 'click', function (e) {
            e.preventDefault();
            changeHashAndBlockScroll(this);
            scrollToGeneralComments('summary');
            cruUi.highlightElements(AJS.$('#summary').children('.overview-item'));
        });

        $document.delegate('#frx-overview:not(.filtered) .notifications a', 'click', function (e) {
            e.preventDefault();
            changeHashAndBlockScroll(this);
            scrollToGeneralComments('notifications');
            cruUi.highlightElements(AJS.$('#notifications').children('.overview-item'));
        });


        initUnreadCommentTooltips();

        if (!window.location.hash && AJS.$('#frx-pane').length > 0) {
            CRU.FRX.NAV.setCurrentFrx('generalComments');
        }
    }
});
/*[{!frx_event_js_snix51s!}]*/