CRU.FRX.AJAX = (function (reviewUtil) {

    var FRXS_FOR_LOAD = [];
    var IS_AUTO_LOADING = false;
    var IS_INITIAL_FRX_LOAD = false;

    var setFrxRevisionParams = function (frxId, from, to) {
        to = to || "";
        from = from || "";
        review
            .frx(frxId)
            .setVisibleFromRevision(from)
            .setVisibleToRevision(to);
    };

    var setFrxToBeLoadedHtml = function (frxId) {
        var html = [
            "<div id='frxDisplayDiff" + frxId + "' class='frx-unloaded'>",
            "<div class='preAjaxLoad'>Loading diff...</div>",
            "</div>"
        ].join("");

        AJS.$("#frxinner" + frxId).html(html);
    };

    var frxLoadDiff = function (frxId, onCompleteFunc, loadOpts) {
        loadOpts = loadOpts || {};

        var cruFrx = CRU.FRX;
        var cruFrxNav = cruFrx.NAV;

        var frx = review.frx(frxId);

        //frx could have been removed in the meantime
        if (!frx) {
            if (onCompleteFunc) {
                onCompleteFunc();
            }
            return;
        }

        var fromRev = loadOpts.fromRev || frx.visibleFromRevision();
        var toRev = loadOpts.toRev || frx.visibleToRevision();

        var changeDiff = !(fromRev === frx.visibleFromRevision() && toRev === frx.visibleToRevision());
        var shouldReload = !frx.isLoading() && (!frx.isLoaded() || loadOpts.isForcedReload || changeDiff);

        var onComplete = function (resp) {
            if (resp) {
                AJS.$("#frxinner" + frxId).removeClass("frx-loading");
                frx.setLoading(false);
            }
            if (resp && resp.worked && shouldReload) {
                res.reloadFrxModel(frxId, resp, false);
                res.updateFrxDiffControls(frxId, resp);
                res.updateFrxSlider(frxId, resp);
                res.updateNavListClasses(frxId, resp);
                rebindEventsAndRefreshComments(frxId);
                if (loadOpts.rescanComments || cruFrxNav.getCurrentFrxId() === frxId) {
                    CRU.COMMENT.NAV.visibleCommentsChanged();
                }
                // need to get the new object out of review
                frx = review.frx(frxId);
                AJS.$('#frxControls' + frxId).removeClass('read unread leaveUnread').addClass(frx.readStatus());
                frx.setLoaded(true);
                commentator.reloadFrxCommentCount(frx);

                review.recentlyViewedFrxIds.save(frxId);
                while (review.recentlyViewedFrxIds.length() > CRU.REVIEW.MAX_FRXS_LOADED) {
                    CRU.FRX.unloadFrx(review.recentlyViewedFrxIds.remove());
                }

                // trigger lazy loading of any JIRA issue details
                CRU.UI.loadInlineJiraIssues();
                CRU.FRX.NAV.frxDiffLoaded(frxId);
            }

            if (onCompleteFunc) {
                onCompleteFunc();
            }
        };

        if (shouldReload) {
            frx.setLoading(true);
            setFrxToBeLoadedHtml(frxId);
            cruFrx.dimFrx(frxId);
            var elementIdToUpdate = 'frxinner' + frxId;
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/loadFrxAjax';
            var diffModeOpts = cruFrx.diffParams(frxId, loadOpts.diffMode);
            var noCacheRand = Math.floor(Math.random() * 999999);
            setFrxRevisionParams(frxId, fromRev, toRev);
            var pars = 'frxid=' + frxId + '&dontCache=' + noCacheRand + diffModeOpts + res.frxRevisionParams(frxId);
            FECRU.AJAX.ajaxUpdate(url, pars, elementIdToUpdate, onComplete);
        } else {
            onComplete(null); //allow the onComplete to finish despite not loading.
        }
    };

    var inFrxLoadQueue = function (frxId) {
        var queue = FRXS_FOR_LOAD;
        for (var i = 0, len = queue.length; i < len; i++) {
            if (frxId === queue[i].id) {
                return i;
            }
        }
        return -1;
    };

    var isFrxLoadBlocked = false;

    var frxIdsToFilter = [];

    // Initial frxs which are loaded are limited to 20 in CRU.FRX.optimizedFrxList()
    var doSerialisedFrxLoad = function () {

        if (isFrxLoadBlocked) {
            IS_AUTO_LOADING = false;
            return;
        }

        IS_AUTO_LOADING = true;

        // load and chain
        if (FRXS_FOR_LOAD.length > 0) {
            // We store either an integer id or a map of id/onDone in the array, so here we check for the objects
            var frxOpts = FRXS_FOR_LOAD[0];
            var frxId = frxOpts.id;
            var loadOpts = frxOpts.loadOpts;

            var onComp = function () {
                // onDone might have change since it's been queued
                var onDone = frxOpts.onDone;

                CRU.CREATE.bindUpdateFrxFromFormToggle('#add-revisions-link-' + frxId, frxId);
                if (CRU.FRX.NAV.getCurrentFrxId() === frxId && review.autoMarkFilesRead()) {
                    res.markFile(true, frxId, false);
                }

                // Order of FRX load queue may have changed, so we need to do a lookup.
                // we do this before the onDone() call, because the frx is now considered to be loaded
                var queueIndex = inFrxLoadQueue(frxId);
                if (queueIndex >= 0) {
                    // This should always be the case, since only this method should remove items from the queue.
                    FRXS_FOR_LOAD.splice(queueIndex, 1);
                }

                frxIdsToFilter.push(frxId);

                // Execute the callback if it exists
                onDone && onDone();
                doSerialisedFrxLoad(); // chain
            };

            frxLoadDiff(frxId, onComp, loadOpts); // load
        } else { // when finished chaining
            if (IS_INITIAL_FRX_LOAD) {
                var cru_frx = CRU.FRX;

                if (cru_frx.postPostLoadFunc) {
                    cru_frx.postPostLoadFunc();
                }
                AJS.$("#show_source_button").removeClass("disabled").addClass("selected").children("a").click(function () {
                    cru_frx.toggleSource();
                });
                commentator.setCommentWidths(null, true);
                commentAjaxController.loadCommentIssueStatuses();
                IS_INITIAL_FRX_LOAD = false;
            }

            IS_AUTO_LOADING = false;
            CRU.FRX.filterFrxs(AJS.$.map(frxIdsToFilter, function (frxId) {
                return review.frx(frxId) || null;
            }));
            frxIdsToFilter = [];
        }
    };

    var rebindEventsAndRefreshComments = function (frxId) {
        tetrisCommentController.renderTetrisCommentMarkersForFrx(frxId);
        commentAjaxController.loadCommentIssueStatuses(frxId);
    };

    var res = {
        blockFrxLoading: function () {
            isFrxLoadBlocked = true;
        },
        unblockFrxLoading: function () {
            isFrxLoadBlocked = false;
            doSerialisedFrxLoad();
        },
        frxRevisionParams: function (frxId) {
            var frx = review.frx(frxId);
            var params = "";
            if (!frx) {
                return params;
            }
            if (frx.visibleFromRevision()) {
                params += "&fromRev=" + frx.visibleFromRevision();
            }
            params += "&toRev=" + frx.visibleToRevision();
            return params;
        },

        updateFrxView: function (from, to, frxId) {
            setFrxRevisionParams(frxId, from, to);
            CRU.FRX.dimFrx(frxId);
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/updateFrxViewAjax';
            var pars = "frxid=" + frxId + res.frxRevisionParams(frxId) + CRU.FRX.diffParams(frxId);

            reviewUtil.triggerSourceCodeReset(frxId);

            var onComp = function (origRequest) {
                if (!origRequest.worked) {
                    CRU.FRX.unDimFrx(frxId);
                } else {
                    res.shelveFrxControls(frxId);
                    var $frxOuter = AJS.$('#frxouter' + frxId);
                    $frxOuter.html(origRequest.payload);
                    res.unshelveFrxControls(frxId);
                    res.reloadFrxModel(frxId, origRequest, true);
                    commentator.setCommentWidths(null, true);
                    commentator.reloadFrxCommentCount(review.frx(frxId));
                    res.updateFrxDiffControls(frxId, origRequest);
                    rebindEventsAndRefreshComments(frxId);
                    CRU.COMMENT.NAV.visibleCommentsChanged();
                    $frxOuter.trigger('view-range-change');
                    reviewUtil.triggerSourceCodeShown(frxId);
                }
            };
            FECRU.AJAX.ajaxUpdate(url, pars, null, onComp);
            return false;
        },

        isFrxControlsRendered: function (frxId) {
            return AJS.$('#frx-context-info-' + frxId).children('.frxControls:first').length === 1;
        },

        shelveFrxControls: function (frxId) {
            var $frxControls = AJS.$('#frx-context-info-' + frxId).children('.frxControls:first');
            $frxControls.append(AJS.$('#add-revisions-link-' + frxId));
            AJS.$('#frxControlsContainer' + frxId).append($frxControls);
        },

        unshelveFrxControls: function (frxId) {
            AJS.$('#add-revisions-link-box-' + frxId).append(AJS.$('#add-revisions-link-' + frxId));
            AJS.$('#frx-context-info-' + frxId).append(AJS.$('#frxControlsContainer' + frxId).children('.frxControls:first'));
            AJS.$('#frxouter' + frxId).trigger('frx-header-unshelved');
        },

        reloadFrxModel: function (frxId, resp, keepSliderRevs) {
            var oldFrx = review.frx(frxId);
            var isExpanded = oldFrx.isExpanded();
            if (keepSliderRevs) {
                var sliderFrxRevisions = oldFrx.getSliderFrxRevisions();
            }

            eval('var frxModelLoader = ' + resp.frxModelLoader);
            frxModelLoader();

            var newFrx = review.frx(frxId);
            newFrx
                .setLoaded(true)
                .setExpanded(isExpanded);
            if (keepSliderRevs) {
                newFrx.setSliderFrxRevisions(sliderFrxRevisions);
            }
            commentator.reloadFrxCommentCount(newFrx);
        },

        updateFrxDiffControls: function (frxId, frxAjaxResp) {
            var contents = frxAjaxResp.diff;
            if (contents) {
                AJS.$('#diffOptionsFormPlaceholder' + frxId).html(frxAjaxResp.diff);
            } else {
                AJS.$('#diffOptionsFormPlaceholder' + frxId).hide();
            }
            // reset the fisheye diff link
            var toRev = review.frx(frxId).visibleToSCMRevision();
            var fromRev = review.frx(frxId).visibleFromSCMRevision();
            if (toRev === fromRev) {
                AJS.$('#fisheyeDiffUrl' + frxId).hide();
            } else {
                AJS.$('#fisheyeDiffUrl' + frxId + ' a')
                    .attr('href', AJS.$('#baseFisheyeDiffUrl' + frxId).val() + '?r1=' + fromRev + '&r2=' + toRev);
                AJS.$('#fisheyeDiffUrl' + frxId).show();
            }
        },

        updateFrxSlider: function (frxId, frxAjaxResp) {
            var $sliderDiv = AJS.$('#frxSliderDiv-' + frxId);
            $sliderDiv.html(frxAjaxResp.slider);
            // Sliders in the edit content panel of manage files should be disabled
            if ($sliderDiv.hasClass('editContent')) {
                AJS.$('#frxSlider_' + frxId).slider('disable');
            }
        },

        updateFrxEditRevisionsDropdown: function (frxId) {
            // Synchronize the edit revisions select options.
            var frx = review.frx(frxId);
            var $revisionSelect = AJS.$('#changeDiffSelect' + frxId);
            if ($revisionSelect.length === 1) {
                var crucibleRevision = frx.frxRevisionToCruRevisionMap();
                $revisionSelect.find('option:disabled').prop('disabled', false);
                $revisionSelect.find(
                    AJS.$.map(frx.frxRevisions(), function (frxRevision) {
                        return 'option[value=' + crucibleRevision[frxRevision] + ']';
                    }).join()
                ).prop('disabled', true);
                // Select the option that says "select a revision to add"
                $revisionSelect[0].selectedIndex = 0;
                AJS.$('#changeDiffAddRevision' + frxId).attr(
                    'disabled',
                    $revisionSelect.find('option:enabled').length === 0
                );
            }
        },

        updateNavListClasses: function (frxId, frxAjaxResp) {
            AJS.$('#frx-list-item' + frxId + ' > span, #frx-list-item' + frxId + ' > span')
                .removeClass('frx-added frx-copied frx-deleted frx-changed frx-complete frx-incomplete')
                .addClass(frxAjaxResp.navListClasses);
        },

        /**
         * Causes an frx to be marked for immediate loading from the server. If there is a queue of frxs to be loaded, then it
         * is prepended to the front of the list, otherwise it is automatically loaded.
         * @param {Array} frxIds the ids of the frxs to load. May be a single frx id.
         * @param {Function} onDone callback to execute after each frx has been loaded
         * @param {Object} loadOpts options to pass to the server for loading of the frx
         */
        prioritisedFrxLoad: function (frxIds, onDone, loadOpts) {
            frxIds = AJS.$.makeArray(frxIds);
            // Reverse through the list to preserve original order as we push onto the front of the array
            for (var i = frxIds.length - 1; i >= 0; i--) {
                var frxId = frxIds[i];
                var queueIndex = inFrxLoadQueue(frxId);
                if (queueIndex < 0) {
                    // Push this frxId to the front of the list of loading frxs
                    FRXS_FOR_LOAD.unshift({
                        id: frxId,
                        onDone: onDone,
                        loadOpts: loadOpts,
                        rescanComments: i === 0 && !IS_AUTO_LOADING // only rescan comments for the first frx if we aren't already loading
                    });
                } else {
                    if (queueIndex > 0) {
                        // Move to the front if not already there.
                        var frxOpts = FRXS_FOR_LOAD.splice(queueIndex, 1)[0];
                        FRXS_FOR_LOAD.unshift(frxOpts);
                    }

                    // attach the passed onDone handler, to make sure the spinner is cleaned up, and navigation happens
                    var firstFrx = FRXS_FOR_LOAD[0];
                    if (onDone) {
                        var originalOnDone = firstFrx.onDone;
                        if (!originalOnDone) {
                            firstFrx.onDone = onDone;
                        } else {
                            firstFrx.onDone = function () {
                                originalOnDone();
                                onDone();
                            }
                        }
                    }
                }
            }
            if (!IS_AUTO_LOADING) {
                doSerialisedFrxLoad();
            }
        },

        /**
         * Causes an frx to be marked for loading from the server. If there is a queue of frxs to be loaded, then it
         * is pushed to the back of the list, otherwise it is automatically loaded.
         * @param {Array} frxIds the ids of the frxs to load. May be a single frx id.
         * @param {Function} onDone callback to execute after each frx has been loaded
         * @param {Object} loadOpts options to pass to the server for loading of the frx
         */
        frxLoad: function (frxIds, onDone, loadOpts) {
            frxIds = AJS.$.makeArray(frxIds);
            for (var i = 0, len = frxIds.length; i < len; i++) {
                var frxId = frxIds[i];
                var queueIndex = inFrxLoadQueue(frxId);
                if (queueIndex < 0) {
                    var frx = review.frx(frxId);

                    // Add the loading spinner to the frx
                    if (frx && !frx.isLoaded()) {
                        setFrxToBeLoadedHtml(frxId);
                    }

                    // Push this frxId to the end of the list of loading frxs
                    FRXS_FOR_LOAD.push({
                        id: frxId,
                        onDone: onDone,
                        loadOpts: loadOpts,
                        rescanComments: i === 0 && !IS_AUTO_LOADING // only rescan comments for the first frx if we aren't already loading
                    });
                }
            }
            if (!IS_AUTO_LOADING) {
                doSerialisedFrxLoad();
            }
        },

        setIsInitialFrxLoad: function () {
            IS_INITIAL_FRX_LOAD = true;
        },

        toggleFileRead: function (frxId, force) {
            var frx = review.frx(frxId);
            if (!frx) {
                return;
            }
            var oldStatus = frx.readStatus();

            if (oldStatus === 'read' || (oldStatus === 'unread' && review.autoMarkFilesRead())) {
                res.markFile(false, frxId);
            } else {
                res.markFile(true, frxId, force);
            }
        },

        changeFileReadStatusClass: function (frxId, markAsRead, newStatus) {
            var frx = review.frx(frxId);
            // sanity check
            if (!frx) {
                return;
            }
            var $frxControls = AJS.$('#frxControls' + frxId);
            var oldStatus = frx.readStatus();
            if (oldStatus === newStatus) {
                return;
            }
            $frxControls.removeClass(oldStatus).addClass(newStatus);
            var toggleCompleteSelectors = "#frx-list-item" + frxId + " > span.frx," +
                "#frx-list-item" + frxId + " > span.folder," +
                "#frxouter" + frxId;
            var $frxElems = AJS.$(toggleCompleteSelectors);
            if (markAsRead) {
                $frxElems.removeClass("frx-incomplete")
                    .addClass("frx-complete");
            } else {
                $frxElems.addClass("frx-incomplete")
                    .removeClass("frx-complete");
            }

            frx.setReadStatus(newStatus);

            // if we're filtering on unreviewed, we need to
            // update the styling in the navigation pane
            CRU.FRX.filterFrxs([frx]);
        },

        updateFileReadStatus: function (frxId, permaId, markAsRead) {
            var frx = review.frx(frxId);
            var oldStatus = frx.readStatus();
            var newStatus = markAsRead ? 'read' : (review.autoMarkFilesRead() ? 'leaveUnread' : 'unread');
            if (!review.writable() || frx.isReadStatusLocked() || oldStatus === newStatus) {
                return false;
            }
            // Prevent simultaneous requests.
            frx.lockReadStatus();

            var $frxControls = AJS.$('#frxControls' + frxId)
                .removeClass(oldStatus)
                .addClass('readStatusLocked');

            var done = function (resp) {
                $frxControls.removeClass('readStatusLocked');
                if (resp.worked) {
                    res.changeFileReadStatusClass(frxId, markAsRead, newStatus);
                } else {
                    $frxControls.addClass(oldStatus);
                }
                frx.unlockReadStatus();
            };

            var url = CRU.UTIL.jsonUrlBase(permaId) + '/fileReadStatusAjax/';
            var params = {"frxId": frxId, "markAsRead": markAsRead};

            FECRU.AJAX.ajaxDo(url, params, done);

            return false;
        },

        markFile: function (read, frxId, force) {
            if (read && review.isDraft()) {
                return;
            }
            var frx = review.frx(frxId);
            if (!frx) {
                return;
            }
            var leaveUnread = frx.readStatus() === 'leaveUnread'; // with manual complete, this is never true
            if (!read || !leaveUnread || force) {
                res.updateFileReadStatus(frxId, permaId, read);
            }
        },

        toggleSourceType: function (permaId, frxId, showAnnotation, params, handler) {
            CRU.FRX.dimFrx(frxId);
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/toggleSourceTypeAjax';
            var showAnnotationStr = '';
            var $dof = AJS.$('#diffOptionsForm');
            var $diffContextToggle = AJS.$('#diffControlsToggle' + frxId);

            reviewUtil.triggerSourceCodeReset(frxId);

            var onComp = function (origRequest) {
                if (!origRequest.worked) {
                    CRU.FRX.unDimFrx(frxId);
                } else {
                    res.shelveFrxControls(frxId);
                    var $frxOuter = AJS.$('#frxouter' + frxId);
                    $frxOuter.html(origRequest.payload);
                    res.unshelveFrxControls(frxId);
                    res.reloadFrxModel(frxId, origRequest, true);
                    commentator.setCommentWidths(null, true);
                    commentator.reloadFrxCommentCount(review.frx(frxId));
                    res.updateFrxDiffControls(frxId, origRequest);
                    rebindEventsAndRefreshComments(frxId);
                    CRU.COMMENT.NAV.visibleCommentsChanged();
                    $frxOuter.trigger('diff-mode-changed');
                    reviewUtil.triggerSourceCodeShown(frxId);
                    if (handler) {
                        handler(origRequest);
                    }
                }
            };
            if (showAnnotation) {
                showAnnotationStr = '&showAnnotation=true';
                $dof.hide();
                $diffContextToggle.hide();
            } else {
                $dof.show();
                $diffContextToggle.show();
            }
            var pars = 'frxid=' + frxId + showAnnotationStr + params;
            FECRU.AJAX.ajaxUpdate(url, pars, null, onComp);
            return false;
        }
    };
    return res;
})(CRU.REVIEW.UTIL);
/*[{!frx_ajax_js_9miu51r!}]*/