window.CRU = window.CRU || {};
if (!CRU.REVIEW) {
    CRU.REVIEW = {};
}
if (!CRU.REVIEW.INLINE) {
    CRU.REVIEW.INLINE = {};
}

(function ($) {
    var reviewInline = CRU.REVIEW.INLINE;
    var CON_titleAndButtonsMargin = 90;
    var keyCode = AJS.$.ui.keyCode;

    var headerAlreadySetup = false;
    var reSetupTitle = null;
    /**
     *
     * @param name the name of the field to be used in user error messages
     * @param display selector for the normal display
     * @param input selector for the input field
     */
    reviewInline.setUpEditableHeader = function (name, display, input, isUpdate) {
        if (headerAlreadySetup && !isUpdate) {
            return;
        }
        headerAlreadySetup = true;
        var $reviewHeadInput = AJS.$(input);
        var $inputField = $reviewHeadInput.children('.input');
        var $submitTitle = $reviewHeadInput.children('.submit-title');

        AJS.$(display + '.editable').click(function (e) {
            var $target = AJS.$(e.target);
            if ($target.closest('a').length === 1) {
                return true;
            }
            AJS.$(this).hide();
            $reviewHeadInput.show();
            $inputField.focus();
        });

        CRU.UNSAVED.watchForUnsavedChanges($inputField, name);

        $inputField.keypress(function (e) {
            if (e.keyCode === keyCode.ENTER) {
                updateReviewTitle();
                e.preventDefault();
            } else if (e.keyCode === keyCode.ESCAPE) {
                discardNewTitle();
            }
        });

        var discardNewTitle = function () {
            if ($submitTitle.hasClass('spinner')) {
                return;
            }
            $reviewHeadInput.hide();
            AJS.$(display).show();

            // this needs a timeout because of a conflict with leaving the input box (or something like that)
            setTimeout(function () {
                var title = $reviewHeadInput.children('.backup').val();
                $inputField.val(title);
            }, 200);
        };

        var updateReviewTitle = function () {
            $submitTitle.addClass('spinner');
            var util = CRU.UTIL;
            var url = util.jsonUrlBase(permaId) + '/updateReviewTitleAjax';
            var params = {
                title: $inputField.val()
            };
            FECRU.AJAX.ajaxDo(url, params, function (resp) {
                $submitTitle.removeClass('spinner');
                if (resp.worked) {
                    AJS.$(display).children('.title').html(resp.titleHtml).attr('title', resp.title);
                    $reviewHeadInput.children('.backup, .input').val(resp.title);
                    discardNewTitle();
                }
            });
        };

        $submitTitle.click(updateReviewTitle);
        $reviewHeadInput.children('.discard-title').click(discardNewTitle);

        if (!reSetupTitle) {
            reSetupTitle = function () {
                reviewInline.setUpEditableHeader(name, display, input, true);
            }
        }
    };

    reviewInline.reSetupEditableTitle = function () {
        reSetupTitle && reSetupTitle();
    };

    var hasAdjustedReviewTitle = false;
    reviewInline.adjustReviewTitle = function () {
        var resizeReviewTitle = function () {
            var $buttons = $('#page-actions');

            if (!$buttons.length) {
                $buttons = $('#context-navigation')
            }

            var buttonLeft = $buttons.position().left;
            var titleWidth = buttonLeft - CON_titleAndButtonsMargin;
            $('#reviewHead, #reviewHeadInput').width(titleWidth);
        };
        if (!hasAdjustedReviewTitle) {
            $(window).bind('resize', AJS.$.throttle(400, function () {
                resizeReviewTitle();
            }));
            hasAdjustedReviewTitle = true;
        }
        resizeReviewTitle();
    };

    // from here is the logic of setting up the new editable title on review page
    // these change should be soon applied to snippet page when its page header is changed
    reviewInline.setUpReviewEditableTitle = function (name, $title) {
        var $titleInput = $title.find('.title-input > input');
        var title = $titleInput.val();

        $title.on('click', 'a', function (e) {            // Right click fires a click event in Firefox but not in Chrome
            if ($(this).parent().is('.jira-hover-trigger')) {
                // according to the UserTextRender, the jira issue links will be encapsulated in a span.jira-hover-trigger
                if (FECRU.isRightClick(e) || !FECRU.openInSameTab(e)) {
                    return;
                } else {
                    e.preventDefault();
                }
            } else {
                e.stopPropagation();
            }
        });

        $title.click(function (e) {
            var $target = $(e.target);
            if ($target.parent().is('.jira-hover-trigger')) {
                return;
            }

            if ($title.is('.read-mode')) {
                var width = $title.width();
                $titleInput.css('width', width);
                $title.removeClass('read-mode');
                $titleInput.select();
            }

            e.stopPropagation();
        });

        var submitAndSaveTitle = function () {
            var newTitle = $titleInput.val();
            if (newTitle === title) {
                $title.addClass('read-mode');
                return;
            }

            $title.removeClass('read-mode')
                .addClass('saving-mode');
            var util = CRU.UTIL;
            var url = util.jsonUrlBase(permaId) + '/updateReviewTitleAjax';
            var params = {
                title: newTitle,
                adgified: true
            };

            newTitle = $.trim(newTitle);

            if (newTitle) {
                $title.find('.title-content').text(newTitle);
            } else {
                $title.find('.title-content').html('<em>Untitled</em>');
            }

            FECRU.AJAX.ajaxDo(url, params, function (resp) {
                if (resp.worked) {
                    $title.replaceWith(resp.titleHtml);
                    $('#frx-pane').trigger('editable-title-updated');
                }
            });
        };

        $title.find('.aui-button.submit').click(function (e) {
            submitAndSaveTitle();
            e.stopPropagation();
        });

        $title.find('.aui-button.cancel').click(function (e) {
            $title.addClass('read-mode');
            $titleInput.val(title);
            e.stopPropagation();
        });

        $titleInput.keydown(function (e) {
            if (e.keyCode === keyCode.ENTER) {
                submitAndSaveTitle();
                e.stopPropagation();
                e.preventDefault();
            }
        });

        $(document).click(function () {
            if (!$title.is('.read-mode') && !$title.is('.saving-mode')) {
                submitAndSaveTitle();
            }
        });

        return {
            setTitle: function (newTitle, newTitleHtml) {
                $title.find('.title-content').html(newTitleHtml);
                title = newTitle;
                $titleInput.val(newTitle);
            }
        }
    }


})(AJS.$);
/*[{!editableHeader_js_td3k516!}]*/