(function ($) {

    //every time the dialog is reopened, these need to be done again.
    function initEachTime() {

        AJS.toInit(function () {
            $("#reviewTitle").placeholder("Click to add title");

            initDueDate();
            initReminder();
        });

    }

    //these only need to be done the first time the dialog opens.
    function initOnce() {
        var cruReviewEdit = CRU.REVIEW.EDIT;
        var cruUtil = CRU.UTIL;

        var rolesMap;

        var AUTHOR = "author";
        var MODERATOR = "moderator";
        var REVIEWER = "reviewer";

        cruReviewEdit.rolesForUser = function (userId) {
            var roles = rolesMap.getRoles(userId);
            return roles.join("|");
        };

        var setupRolesMap = function () {
            rolesMap = (function () {
                var map = {};
                var currentModerator = "";
                var currentAuthor = "";

                return {
                    addRole: function (userId, role) {
                        userId = "" + userId;
                        if (userId && role) {
                            if (map.hasOwnProperty(userId)) {
                                map[userId].push(role);
                            } else {
                                map[userId] = [role];
                            }
                            if (role === AUTHOR) {
                                currentAuthor = userId;
                            } else if (role === MODERATOR) {
                                currentModerator = userId;
                            }
                        }
                    },
                    getRoles: function (userId) {
                        userId = "" + userId;
                        if (map.hasOwnProperty(userId)) {
                            return map[userId];
                        } else {
                            return [];
                        }
                    },
                    removeRole: function (userId, role) {
                        userId = "" + userId;
                        if (userId && role) {
                            if (map.hasOwnProperty(userId)) {
                                var roles = map[userId];
                                map[userId] = AJS.$.grep(roles, function (e) {
                                    if (e === role) {
                                        if (role === AUTHOR) {
                                            currentAuthor = "";
                                        } else if (role === MODERATOR) {
                                            currentModerator = "";
                                        }
                                        return false; // remove it
                                    }
                                    return true; // keep it
                                });
                            }
                        }
                    },
                    getModerator: function () {
                        return currentModerator;
                    },
                    getAuthor: function () {
                        return currentAuthor;
                    },
                    getReviewers: function () {
                        var revs = [];
                        for (var userId in map) {
                            if (AJS.$.inArray(REVIEWER, map[userId]) >= 0) {
                                revs.push(userId);
                            }
                        }
                        return revs;
                    }
                }
            })();
        };

        cruReviewEdit.setupRoles = function () {
            if (!rolesMap) {
                setupRolesMap();
            }

            rolesMap.addRole(AJS.$("#author-selected").val(), AUTHOR);
            rolesMap.addRole(AJS.$("#moderator-selected").val(), MODERATOR);

            var $reviewers = AJS.$('#reviewers-chosen').find(".reviewer-span-holder");

            for (var i = 0, len = $reviewers.length; i < len; i++) {
                var userId = AJS.$($reviewers[i]).children("input").val();
                rolesMap.addRole(userId, REVIEWER);
            }
        };

        cruReviewEdit.authorOrModeratorChanged = function (changingType) {
            var userId = AJS.$('#' + changingType + "-selected").val();

            var oldRoles = rolesMap.getRoles(userId);
            for (var i = 0, len = oldRoles.length; i < len; i++) {
                var oldRole = oldRoles[i];
                if (oldRole === REVIEWER) {
                    cruReviewEdit.removeReviewer(userId);
                    break;
                }
            }

            CRU.CREATE.markChanged();

            if (changingType === AUTHOR) {
                rolesMap.removeRole(rolesMap.getAuthor(), AUTHOR);
                rolesMap.addRole(userId, AUTHOR);
            } else if (changingType === MODERATOR) {
                rolesMap.removeRole(rolesMap.getModerator(), MODERATOR);
                rolesMap.addRole(userId, MODERATOR);
            }
        };

        var $suggestReviewersInlineDialog;

        /*eslint-disable indent*/
        var suggestionContainerHtml = [
            '<div id="suggestionBox" class="suggestionContainer">',
                '<div id="suggestedReviewers">',
                    '<a class="close-suggestions" title="Close suggestions">x</a>',
                    '<table class="suggest">',
                        '<thead>',
                            '<tr>',
                                '<th class="suggest-user">User</th>',
                                '<th class="suggest-contributions">Contribution (%)</th>',
                                '<th class="suggest-loc">Total LoC</th>',
                                '<th class="suggest-open">Open Reviews</th>',
                            '</tr>',
                        '</thead>',
                        '<tbody></tbody>',
                    '</table>',
                '</div>',
            '</div>'
        ].join('');

        var suggestionRowHtml = [
            '<tr class="suggestReviewer">',
                '<td class="suggest-user"></td>',
                '<td class="suggest-contributions"></td>',
                '<td class="suggest-loc"></td>',
                '<td class="suggest-open"></td>',
            '</tr>'
        ].join('');
        /*eslint-enable*/

        var createSuggestionsHtml = function (resp) {
            var $suggetionsContainer = AJS.$(suggestionContainerHtml);

            var showLocData = resp.showLocData;

            var suggestionTableColSpan = 4;

            if (!showLocData) {
                $suggetionsContainer.find(".suggest-loc").remove();
                suggestionTableColSpan--;
            }

            var showContribution = resp.showContribution;

            if (!showContribution) {
                $suggetionsContainer.find(".suggest-contributions").remove();
                suggestionTableColSpan--;
            }

            var users = resp.suggestions || [];

            // Get the array of usernames from the existing reviewers
            var existingReviewerUsernames = rolesMap.getReviewers();

            // Remove any users that have been returned from the suggestions that may have already been added to the reviewer list
            users = AJS.$.map(users, function (u) {
                if (AJS.$.inArray(u.id, existingReviewerUsernames) !== -1) {
                    return null; // remove from the array
                }
                return u;
            });

            var $tbody = $suggetionsContainer.find("tbody");
            var $thead = $suggetionsContainer.find("thead");
            if (!resp.worked) {
                AJS.$('<td class="suggest-error"><h3>Error finding suggestions:</h3> ' + resp.errorMsg + '</td>')
                    .attr("colspan", suggestionTableColSpan)
                    .appendTo($tbody);
                $thead.remove();
                return $suggetionsContainer;
            } else if (!users || users.length === 0) {
                AJS.$('<td class="suggest-nothing">No suggestions were found.</td>')
                    .attr("colspan", suggestionTableColSpan)
                    .appendTo($tbody);
                $thead.remove();
                return $suggetionsContainer;
            }

            for (var i = 0, len = users.length; i < len; i++) {
                var user = users[i];
                var $row = AJS.$(suggestionRowHtml);

                if (!showLocData) {
                    $row.find(".suggest-loc").remove();
                } else {
                    $row.children(".suggest-loc")
                        .text(user.loc ? user.loc : "?");
                }

                if (!showContribution) {
                    $row.find(".suggest-contributions").remove();
                } else {
                    var $contribution = $row.children(".suggest-contributions");
                    $contribution.text(user.contribution);
                    $contribution.html($contribution.html().split('/').join('/&#8203;'));
                }

                $row.children(".suggest-user")
                    .html(user.suggestionLink);
                $row.children(".suggest-open")
                    .text(user.openReviews);
                $row.data("user", user)
                    .appendTo($tbody);
            }
            return $suggetionsContainer;
        };

        var createSuggestions = function ($trigger, resp) {
            var $table = createSuggestionsHtml(resp);

            var PADDING = 2;

            var options = {
                onHover: false,
                showArrow: true,
                fadeTime: 200,
                hideDelay: 400,
                showDelay: 0,
                width: 600 + PADDING,
                container: "body",
                cacheContent: false,
                posX: $trigger.offset().left,
                posY: $trigger.height() + $trigger.offset().top + PADDING,
                hideCallback: cruReviewEdit.closeSuggestions
            };

            var populate = function ($contents, trigger, callback) {
                $contents.html($table);
                callback && callback();
            };

            // InlineDialog expects one of two "data" objects:
            //   a) a URL which it loads via ajax, and expects html data to put into the content
            //   b) html content.
            // There is no way of loading a url via ajax and provide a way to parse/prepare the result (the url returns
            // json, not html).
            //
            // We work around this by doing the ajax call ourselves, parsing and creating the data, and then creating the
            // InlineDialog. Lo and behold, this still isn't enough, because the dialog is only shown when the "trigger"
            // elements are clicked. So, I emulate the click and unbind it immediately so future clicks doesn't rebind the
            // same functions.
            $suggestReviewersInlineDialog = AJS.InlineDialog($trigger, "suggest-reviewers-inline-dialog", populate, options);

            $trigger.click()
                .unbind("click"); // FUCK YOU
        };

        cruReviewEdit.getSuggestions = function ($trigger) {
            var url = cruUtil.jsonUrlBase(permaId) + "/suggestReviewersAjax/";

            $trigger
                .removeClass('suggest-toggle')
                .addClass('suggest-toggle-spinning disabled');

            var onDone = function (resp) {
                $trigger
                    .removeClass('suggest-toggle-spinning')
                    .addClass('suggest-toggle');
                createSuggestions($trigger, resp);
            };

            FECRU.AJAX.ajaxDo(url, {}, onDone, false);
        };

        cruReviewEdit.addSuggestedReviewer = function ($row) {
            var user = $row.data('user');
            cruReviewEdit.addReviewer(user);

            var visibleSuggestions = $row.siblings().length;
            if (visibleSuggestions === 0) {
                $suggestReviewersInlineDialog.hide();
            }
            $row.remove();
            $suggestReviewersInlineDialog.refresh();
        };

        cruReviewEdit.closeSuggestions = function () {
            AJS.$('.suggest-toggle').removeClass('disabled');
            if ($suggestReviewersInlineDialog) {
                $suggestReviewersInlineDialog.hide();
            }
        };

        /*eslint-disable indent*/
        var reviewerRowHtml = [
            '<div class="reviewer-span-holder">',
                '<input type="hidden" name="reviewers" value="">',
                '<span class="reviewer-span">',
                    '<div class="user-link"></div>',
                    '<a class="remove-reviewer" title="Remove reviewer">x</a>',
                '</span>',
            '</div>'
        ].join('');
        /*eslint-enable*/

        cruReviewEdit.removeReviewer = function (userId) {
            if (!userId) {
                return;
            }
            rolesMap.removeRole(userId, REVIEWER);
            AJS.$("#reviewer-span-holder-" + userId).remove();
            cruReviewEdit.reorderReviewers();
            CRU.CREATE.markChanged();
        };

        cruReviewEdit.addReviewer = function (user) {
            var mod = AJS.$('#moderator-selected').val();
            var auth = AJS.$('#author-selected').val();

            var $elTextbox = AJS.$('#reviewer-input');

            var userId = user.id;
            if (userId === mod || userId === auth) {
                var reason = (userId === mod) ? 'Moderator' : 'Author';
                alert("You can't add the " + reason + " as a Reviewer");
            } else {
                var $existing = AJS.$("#reviewer-span-holder-" + userId);
                // Only add the reviewer if it doesn't already exist in the dom
                if ($existing.length === 0) {
                    var $row = AJS.$(reviewerRowHtml)
                        .attr("id", "reviewer-span-holder-" + userId);
                    $row.children("input")
                        .val(userId);
                    $row.children("span")
                        .children(".user-link")
                        .replaceWith(user.link);
                    AJS.$("#reviewers-chosen").children(".hidden-column").append($row);

                    rolesMap.addRole(userId, REVIEWER);
                    cruReviewEdit.reorderReviewers(userId);

                    CRU.CREATE.markChanged();
                }
            }

            $elTextbox.val("");

            // wait until the browser tab event has fired, note that safari silently steals focus when
            // tabbing so this (nor anything else I've tried) works.
            setTimeout(function () {
                $elTextbox.focus();
            }, 100);
        };

        cruReviewEdit.reorderReviewers = function (userId) {
            var minReviewersInColumn = 2;
            var $columns = AJS.$('#reviewers-chosen').children();
            var $reviewers = $columns.find(".reviewer-span-holder").remove();
            var reviewerCount = $reviewers.length;

            var $leftCol = $columns.filter(".left-reviewers-column");
            var $middleCol = $columns.filter(".middle-reviewers-column");
            var $rightCol = $columns.filter(".right-reviewers-column");

            if (reviewerCount <= minReviewersInColumn) {
                $leftCol.append($reviewers);
            } else {
                var maxInColumn = minReviewersInColumn;
                if (reviewerCount > 3 * minReviewersInColumn) {
                    maxInColumn = Math.ceil(reviewerCount / 3);
                }
                for (var i = 0; i < reviewerCount; i++) {
                    var reviewer = $reviewers.get(i);
                    if (i < maxInColumn) {
                        $leftCol.append(reviewer);
                    } else if (i < maxInColumn * 2) {
                        $middleCol.append(reviewer);
                    } else {
                        $rightCol.append(reviewer);
                    }
                }
            }
            if (userId) {
                CRU.UI.highlightElements(AJS.$('#reviewer-span-holder-' + userId));
            }
        };
    }

    /* Due Date */

    function initDueDate() {
        var $dueDateInput = $("#due-date-input");
        $dueDateInput.attr("autocomplete", "off").datepicker({
            dateFormat: 'dd M yy', //display format
            altFormat: 'yy-mm-dd',  //storage/POST format
            altField: '#due-date-store',
            minDate: new Date(),
            onClose: function () {
                var parent = $(this).parent();
                var timeString = parent.find("#due-time-store").val();//stores in "T00:00:00" format;
                var dateString = parent.find("#due-date-store").val().replace(/\//g, "-");
                if (dateString && !timeString) {
                    timeString = "T17:00:00";//a default time if the date is set
                }
                parent.find("#dueDateString").attr("value", dateString + timeString).trigger('change');
            }
        });
        AJS.$("#due-time-select").editableSelect({
            bg_iframe: false,
            onSelect: function ($li) {
                var timeString = $li.find("input").val();
                var $dueDateStore = $("#due-date-store");
                var selectedDate = $dueDateStore.val();

                if (!selectedDate) {
                    var d = new Date();
                    var monthStr = FECRU.pad(d.getMonth() + 1, 2, false, '0');
                    var dayStr = FECRU.pad(d.getDate(), 2, false, '0');

                    selectedDate = d.getFullYear() + "-" + monthStr + "-" + dayStr;
                    $dueDateInput.datepicker('setDate', d);
                    $dueDateStore.val(selectedDate);
                }
                $("#dueDateString").attr("value", selectedDate + timeString).trigger('change');
                $("#due-time-store").val(timeString);
            },
            selectStrategy: function (editableSelectInstance) {
                var nearestSelection = parseAndStoreTimeInput(editableSelectInstance.text.val());
                if (nearestSelection) {
                    editableSelectInstance.selectListItem(nearestSelection);
                } else {
                    editableSelectInstance.selectFirstListItem();
                }
            },
            case_sensitive: false,
            items_then_scroll: 7
        })
            // Add a `text` class manually to autogenerated input.
            // Plugin's API doesn't provide any ability to add it in a proper way.
            .siblings('#due-time-select').addClass('text');

        var timePOSTFormat = /^T(\d{2}):(\d{2}):(\d{2})$/;
        var snapToDefault = function () {
            var timeString = $("#due-time-store").val();
            var matches = timePOSTFormat.exec(timeString);
            if (matches) {
                var hours = parseInt(matches[1], 10);
                var minutes = parseInt(matches[2], 10);
                var halfday = 'AM';
                if (hours > 12) {
                    hours = hours % 12;
                    halfday = 'PM';
                }
                if (hours === 0) {
                    hours = 12;
                }

                AJS.$("#due-time-select").val(FECRU.pad(hours, 2, false, '0') + ":" +
                    FECRU.pad(minutes, 2, false, '0') +
                    (" " + halfday));
            }
        };
        var timeInputFormat = /^\s*(\d{1,2})\s*:\s*(\d{2})\s*(AM|PM)\s*$/i;
        var parseAndStoreTimeInput = function (inputStr) {
            var matches = timeInputFormat.exec(inputStr);
            if (matches) {
                try {
                    var hours = parseInt(matches[1], 10);
                    var minutes = parseInt(matches[2], 10);
                    var halfday = matches[3].toUpperCase();

                    //normalize hours+minutes, error out if wrong
                    if (hours > 24) {
                        snapToDefault();
                        return;
                    } else if (hours > 12) {
                        hours = hours % 12;
                        if (hours === 0) {
                            hours = 12;
                        }
                        halfday = (halfday === 'PM' ? 'AM' : 'PM');
                    }

                    if (hours === 0) {
                        hours = 12;
                    }

                    if (minutes > 60) {
                        snapToDefault();
                        return;
                    } else if (minutes === 60) {
                        minutes = 0;
                    }

                    //construct the proper dueDateString and save
                    var hours24 = hours + (halfday === 'PM' ? 12 : 0);
                    //pad
                    var minutesString = minutes < 10 ? "0" + "" + minutes : minutes;
                    var hoursString = hours24 < 10 ? "0" + hours24 : hours24;
                    var timeString = "T" + hoursString + ":" + minutesString + ":" + "00";
                    var selectedDate = AJS.$("#due-date-store").val();
                    AJS.$("#dueDateString").val(selectedDate + timeString).trigger('change');
                    AJS.$("#due-time-store").val(timeString);
                    //update display, use 12 hour time
                    var $timeInput = AJS.$("#due-time-select");
                    $timeInput.val(hours + ":" + minutesString + " " + halfday);

                    //sync the editable select to the nearest half hour
                    var nearestHalfHour = roundToNearestHalfHour(hours, minutes, halfday);
                    var $timeOptions = $timeInput.siblings(".editable-select-options");
                    $timeOptions.find(".selected").removeClass("selected");
                    var nearestHalfHourString = nearestHalfHour.hours + ":" + nearestHalfHour.minuteString + " " +
                        nearestHalfHour.halfday;
                    return $timeOptions.find("li:contains('" + nearestHalfHourString + "')").addClass("selected");
                } catch (e) {
                    snapToDefault();
                }
            } else {
                snapToDefault();
            }
        };
        var roundToNearestHalfHour = function (hours, minutes, halfday) {
            var minuteString;
            if (15 <= minutes && minutes < 45) {
                minuteString = "30";
            } else {
                minuteString = "00";
                //need to tweak hours if nearest half-hour is next hour
                if (minutes > 45) {
                    hours++;
                    hours = hours % 12;
                    if (hours === 0) { //midday/midnight, need to switch the halfday sign
                        hours = 12;
                        halfday = (halfday === 'PM' ? 'AM' : 'PM');
                    }
                }
            }
            var paddedHours = (hours < 10 ? "0" + hours : hours);
            return {
                hours: paddedHours,
                minuteString: minuteString,
                halfday: halfday
            };
        };
        $("#due-time-select").change(function (e) {
            parseAndStoreTimeInput($("#due-time-select").val());
        });
    }

    /* Reminder */

    function initReminder() {
        var $reminderBlock = $('#reminder-days-block');
        if ($reminderBlock.length === 0) {
            return;
        }

        var $editReminder = $('.edit-reminder', $reminderBlock);
        var $hiddenReminderDaysBefore = $('#reminderDays');
        var $reminderDaysBefore = $('#reminder-days');
        var $dayOrDaysLabel = $(".day-or-days", $editReminder);
        var $removeReminder = $('.remove-reminder a', $reminderBlock);
        var $error = $('.error', $reminderBlock);
        var $addReminder = $('.add-reminder', $reminderBlock);
        var $hiddenDueDate = $('#dueDateString');

        function isDisabled() {
            return $reminderBlock.hasClass('disabled');
        }

        function getElapsedWorkDays(startDate, endDate) {
            var currDate = new Date(endDate);

            var workDays = 0;

            while (currDate >= startDate) {
                if (currDate.getDay() !== 6 && currDate.getDay() !== 0) {
                    workDays++;
                }
                currDate.setDate(currDate.getDate() - 1);
            }

            // If the first day is a work day, we have counted it, even though no time is elapsed.
            // So we remove that 1 day here.  An alternative explanation would be that
            // this handles the case where startDate is a weekend.  This way the difference between
            // any time Saturday and any time Friday is 0 days, Friday 4pm to Monday 3pm is 0 days, and
            // Friday 4pm to Monday 5pm is 1 day.
            workDays = Math.max(workDays - 1, 0);

            return workDays;
        }

        function getReminderDaysBefore() {
            var unrounded = parseFloat($reminderDaysBefore.val(), 10);
            return isNaN(unrounded) ? unrounded : Math.round(unrounded);
        }

        function getDaysTilDue() {
            return FECRU.getElapsedWorkingDays(new Date(), FECRU.parseISO8601Date($hiddenDueDate.val()));
        }

        function validate() {
            var daysBefore = getReminderDaysBefore();
            var isValid = false;
            if (isNaN(daysBefore) && /\S/.test($reminderDaysBefore.val())) {
                $error.text('Only numbers are allowed');

            } else if (isNaN(daysBefore)) { // empty input
                // no visible error message
                $error.text('');

            } else if (daysBefore < 1) {
                $error.text("The reminder must be sent before the due date.");

            } else if (daysBefore > getDaysTilDue()) {
                $error.text("There are only " + getDaysTilDue() + " working days until the review is due.");

            } else { // no error
                $error.text('');
                isValid = true;
            }

            if (isValid) {
                $dayOrDaysLabel.text(FECRU.pluralise("day", "days", daysBefore));
            }

            return isValid;
        }

        function revertToLastValidated() {
            var hiddenVal = $hiddenReminderDaysBefore.val();
            var shouldRemove = !hiddenVal;

            if (shouldRemove) {
                $removeReminder.click();
                $dayOrDaysLabel.text("days");
            } else {
                $reminderDaysBefore.val(hiddenVal);
                $dayOrDaysLabel.text(FECRU.pluralise("day", "days", parseInt(hiddenVal, 10)));
            }
        }

        function updateDisabledStatus() {
            var shouldDisable = getDaysTilDue() < 1;

            $reminderBlock.toggleClass('disabled', shouldDisable);
            $reminderDaysBefore.prop('disabled', shouldDisable);
            $error.text(shouldDisable ? "Automated reminder is disabled." : "");
            $error.attr('title', shouldDisable ? "The due date is within one working day." : '');
        }

        function initEvents() {
            $addReminder.click(function () {
                if (!isDisabled()) {
                    $hiddenReminderDaysBefore.val('1');
                    $reminderDaysBefore.val('1');
                    $addReminder.addClass('hidden');
                    $editReminder.removeClass('hidden');
                    $reminderDaysBefore[0].select();
                }
            });

            $removeReminder.click(function () {
                if (!isDisabled()) {
                    $hiddenReminderDaysBefore.val('');
                    $reminderDaysBefore.val('');
                    $error.text('');
                    $editReminder.addClass('hidden');
                    $addReminder.removeClass('hidden');
                }
            });

            $reminderDaysBefore.blur(function () {
                // doing this on blur instead of change so we can also revert to "Add reminder" when they click
                // "Add reminder", make no changes, and click away.
                if (validate()) {
                    var daysBefore = getReminderDaysBefore();
                    $hiddenReminderDaysBefore.val(daysBefore);
                    $reminderDaysBefore.val(daysBefore);
                } else {
                    revertToLastValidated();
                    $error.text('');
                }
            }).keyup(function () {
                if (validate()) {
                    var daysBefore = getReminderDaysBefore();
                    $hiddenReminderDaysBefore.val(daysBefore);
                    $reminderDaysBefore.val(daysBefore);
                } // else don't revert
            }).focus(function () {
                var self = this;
                setTimeout(function () {
                    self.select();
                }, 0);
            });

            $hiddenDueDate.change(updateDisabledStatus);
        }

        initEvents();
        updateDisabledStatus();
    }

    var inited = false;
    CRU.REVIEW.initialiseEditReview = function () {
        var alreadyInited = inited;
        inited = true;

        if (!alreadyInited) {
            CRU.REVIEW.EDIT = {};
        }

        initEachTime();

        if (alreadyInited) {
            return;
        }

        initOnce();
    };

})(AJS.$);
/*[{!edit_review_js_cud6515!}]*/