if (CRU.REVIEW.EDIT) {
    CRU.REVIEW.EDIT.editReviewEventInitialised = false;
}

CRU.REVIEW.initialiseEditReviewEvent = function () {
    var $document = AJS.$(document);
    $document.ready(function () {
        var cruUtil = CRU.UTIL;
        var cruReviewEdit = CRU.REVIEW.EDIT;
        var cruReviewUtil = CRU.REVIEW.UTIL;

        var $form = AJS.$("#editDetailsForm");

        if (!cruReviewEdit.editReviewEventInitialised) {
            //dont want to set up live events etc twice
            cruReviewEdit.editReviewEventInitialised = true;

            cruReviewEdit.setupRoles();

            $document.delegate('#reviewers-chosen .remove-reviewer', 'click', function () {
                var userId = AJS.$(this).parent().siblings('input').val();
                cruReviewEdit.removeReviewer(userId);
            });
            $document.delegate('#editDetailsForm .view', 'click', function () {
                var $this = AJS.$(this);
                if ($this.hasClass('wiki-preview-pane')) {
                    $this.siblings('.wiki-preview-button-holder:first').find('.wiki-preview-button').click();
                    $this.siblings('.reviewDescription:first').focus();
                    return;
                }
                $this.hide().siblings('.edit').show().focus();
            });

            $document.delegate('#suggestionBox tr.suggestReviewer', 'click', function () {
                cruReviewEdit.addSuggestedReviewer(AJS.$(this));
            });

            $document.delegate('#suggestedReviewers .close-suggestions, .suggest-toggle.disabled', 'click', function () {
                cruReviewEdit.closeSuggestions();
            });

            $document.delegate(".suggest-toggle:not(.disabled)", 'click', function () {
                cruReviewEdit.getSuggestions(AJS.$(this));
            });

        }

        var $title = AJS.$('#reviewTitle');
        if (!$title.val()) {
            $title.focus().siblings('.title').find('.required').show();
        }

        cruReviewEdit.reorderReviewers();

        (function ($, cruReviewUtil) {
            var entryTemplate = '<span class="entry">';
            entryTemplate += '<span class="ac-display-primary"></span>';
            entryTemplate += '<span class="ac-display-secondary"></span>';
            entryTemplate += '</span>';
            var input = $("#parentReviewId")
                .fecruAutocomplete({
                    url: cruUtil.jsonUrlBase() + "/reviewFinder",
                    searchOnFocus: false,
                    matchContains: true,
                    minChars: 2,
                    max: 10,
                    width: 300,
                    formatItem: function (data) {
                        var entry = $(entryTemplate);
                        if (data.notFound) {
                            entry.addClass('ac-disabled');
                            entry.find('.ac-display-primary').text('No matching reviews found')
                        } else {
                            entry.find('.ac-display-primary').text(data.name);
                            entry.find('.ac-display-secondary').text(data.permaId);
                        }
                        return entry;
                    },
                    notFoundData: [
                        {
                            notFound: true
                        }
                    ]
                }
            )
                .on('result', function (domElement, entry) {
                    input.val(entry.permaId);
                    cruReviewUtil.postLinkedReview();
                });

        })(AJS.$, CRU.REVIEW.UTIL);

        // Don't allow text inputs in the Edit Review dialog to submit the form
        $form.find("input[type='text']").keypress(function (e) {
            // ignore the 'return' key
            if (e.which === 13) {
                e.preventDefault();
                e.stopPropagation();
            }
        });

        AJS.$('#author-input').bind('change', function () {
            cruReviewEdit.authorOrModeratorChanged('author');
        });

        AJS.$('#moderator-input').bind('change', function () {
            cruReviewEdit.authorOrModeratorChanged('moderator');
        });

        $form.find('.edit').bind('blur', function () {
            var $this = AJS.$(this);
            if ($this.parents('.edit').length === 1) {
                return;
            }
            if ($this.hasClass('reviewDescription')) {
                $this.siblings('.wiki-preview-button-holder:first').find('.wiki-preview-button').click();
                return;
            } else if ($this.hasClass('reviewTitle')) {
                return;
            }
            var $selectedOption = $this.find('option:selected');
            var text;
            if ($selectedOption.length === 1) {
                text = $selectedOption.text();
            } else {
                text = $this.val();
            }
            $this.hide().siblings('.view').text(text).show();
        });

        AJS.$('#reviewTitle').bind('blur', function () {
            var $this = AJS.$(this);
            if (!$this.val() || $this.val() === '') {
                $this.siblings('.title').find('.required').show();
            }
        });

    });
};
/*[{!edit_review_event_js_rguc514!}]*/