CRU.DIFF = {};
CRU.DIFF.NAV = {};

(function () {
    var currentDiffId = null;
    var currentFrxId = null;

    var diffClasses = '.ediffContentA,.ediffContentB,.diffContentA,.diffContentB';

    CRU.DIFF.NAV.getCurrentDiffId = function (frxId) {
        if (currentFrxId === frxId && CRU.FRX.NAV.getCurrentFrxId() === currentFrxId) {
            return currentDiffId;
        } else {
            return null;
        }
    };

    CRU.DIFF.NAV.setCurrentDiffId = function (frxId, diffId) {
        currentFrxId = frxId;
        currentDiffId = diffId;
    };

    CRU.DIFF.NAV.getDiffs = function (frx) {
        if (frx == null) {
            return null;
        }

        // select diff anchors that are in rows with an actual diff class content
        var diffSelector = 'tr:has(' + diffClasses + ') a[id^=frx' + frx.id() + '_seg]';
        // TODO: cache this for a given frx possibly
        return frx.frxInner().find(diffSelector);
    };

    // determines the order between a diff and comment selector
    CRU.DIFF.NAV.diffAfterComment = function ($diff, $comment, forwards) {
        if (!$diff) {
            return !forwards;
        }
        if (!$comment) {
            return forwards;
        }

        var diffRowIndex = $diff.parents("tr").first().index();
        var commentRowIndex = $comment.parents("tr").first().index();
        return forwards ? diffRowIndex > commentRowIndex : diffRowIndex <= commentRowIndex;
    };

    // find the next diff in the frx
    CRU.DIFF.NAV.findNextDiff = function (frx, forwards, nextFrxId, opts) {
        var diffs = CRU.DIFF.NAV.getDiffs(frx);

        if (diffs == null || diffs.length === 0) {
            return null;
        }

        var currentDiff = CRU.DIFF.NAV.getCurrentDiffId(frx.id());
        if (currentDiff == null && frx.id() === opts.startingFrxId && (opts.findComment || opts.findDefect) && opts.startingCommentDomId) {
            var $previousComment = frx.frxInner().find('#' + opts.startingCommentDomId);
            if ($previousComment) {
                // if we were on a comment previously we want to have the next/previous diff from that
                // determine the last diff before the comment and go off that
                var lastDiffBeforeComment = forwards ? -1 : diffs.length;
                do {
                    var nextCandidate = forwards ? lastDiffBeforeComment + 1 : lastDiffBeforeComment - 1;
                    currentDiff = lastDiffBeforeComment;
                    if (CRU.DIFF.NAV.diffAfterComment(diffs.eq(nextCandidate), $previousComment, forwards)) {
                        break;
                    }
                    lastDiffBeforeComment = nextCandidate;
                } while (lastDiffBeforeComment >= 0 && lastDiffBeforeComment < diffs.length)
            }
        }

        var nextDiff;
        if (currentDiff == null) {
            nextDiff = forwards ? 0 : diffs.length - 1;
        } else {
            nextDiff = forwards ? currentDiff + 1 : currentDiff - 1;
            if (nextDiff >= diffs.length || nextDiff < 0) {
                return null;
            }
        }

        return {
            frxId: frx.id(),
            diffId: nextDiff,
            type: 'diff',
            gotoElem: diffs[nextDiff],
            nextFrxId: nextFrxId
        };
    };

    CRU.DIFF.NAV.gotoDiff = function (nextElementMap) {
        if (nextElementMap.frxId !== CRU.FRX.NAV.getCurrentFrxId()) {
            CRU.FRX.NAV.setCurrentFrx(nextElementMap.frxId);
        }

        CRU.DIFF.NAV.scrollToDiff(nextElementMap);
    };

    CRU.DIFF.NAV.scrollToDiff = function (nextElementMap) {
        CRU.DIFF.NAV.setCurrentDiffId(nextElementMap.frxId, nextElementMap.diffId);
        CRU.UI.scrollToElement(nextElementMap.gotoElem, {
            offset: 55,
            onAfter: function() {
                var $diffRow = AJS.$(nextElementMap.gotoElem).parents('tr').first();
                var $visibleChildren = $diffRow.find('td:visible');
                CRU.UI.highlightElements($visibleChildren);
            }
        });
        window.location.hash = 'd' + nextElementMap.gotoElem.getAttribute('id'); // using an existing anchor (without the 'd') adds additional popping
    };
})();/*[{!diff_nav_js_0exh51q!}]*/