(function ($) {
    CRU.COMMENT = (function () {
        var g_mousedown = false;
        var g_modeSelecting = false;
        var g_currentTable = null;
        var g_mouseDownFirstRow = null;
        var lastSelectedLine = null;
        var firstTimeDisplayingInlineForm = true;
        var frxPaneWidth = null;
        var commentDivPrefixes = ['general', 'revision', 'inline', 'above', 'defect'];
        var statusXhrs = {};

        var commentFormNS = CRU.COMMENT.FORMS;
        var scFormWrangler = new commentFormNS.CommentFormWrangler(new commentFormNS.GeneralCommentForm('simpleCommentForm'), 'general', 'commentAjaxController.autoSaveGeneralComment');
        var rcFormWrangler = new commentFormNS.CommentFormWrangler(new commentFormNS.RevisionCommentForm('revisionCommentForm'), 'revision', 'commentAjaxController.autoSaveRevisionComment');
        var fcFormWrangler = new commentFormNS.CommentFormWrangler(new commentFormNS.FileCommentForm('fileCommentForm'), 'file', 'commentAjaxController.autoSaveRevisionComment');
        var replyFormWrangler = new commentFormNS.CommentFormWrangler(new commentFormNS.ReplyCommentForm('replyCommentForm'), 'reply', 'commentAjaxController.autoSaveReply');

        commentFormNS.CommentFormWrangler.forms = [
            scFormWrangler, rcFormWrangler, fcFormWrangler, replyFormWrangler
        ];

        var highlightedLines = [];
        var editingRCHandleId;

        var selectTR = function (tr, select) {
            var $tr = AJS.$(tr);
            if ($tr.hasClass('commentableLine')) {
                $tr.toggleClass('lineHighlighted', select)
                    .toggleClass('sourceLine', !select);
                if (!select) {
                    $tr.removeClass('hoveringComment');
                }
            }
        };

        var clearSelectedRows = function () {
            g_modeSelecting = false;
            if (g_currentTable) {
                AJS.$(g_currentTable).find("tr.lineHighlighted").each(function () {
                    selectTR(this, false);
                });
            } else {
                AJS.$("tr.lineHighlighted").each(function () {
                    selectTR(this, false);
                });
            }
            rcFormWrangler.getCommentForm().clearComment();
            g_modeSelecting = false;
            g_currentTable = null;
            g_mouseDownFirstRow = null;
            firstTimeDisplayingInlineForm = true;
        };

        /**
         * Convert array of line number into simpler more readable form
         * Example:
         *  [1,2,3] => '1-3'
         *
         * @param {Array.<string>} lines
         * @return {string}
         */
        var convertLinesToRange = function (lines) {
            var ranges = [];
            lines = lines.map(function (line) {
                return +line;
            });

            var rangeStart;
            var rangeEnd;
            for (var i = 0; i < lines.length; i++) {
                rangeStart = lines[i];
                rangeEnd = rangeStart;
                while (lines[i + 1] === lines[i] + 1) {
                    rangeEnd = lines[i + 1];
                    i++;
                }
                ranges.push(rangeStart === rangeEnd ? rangeStart : (rangeStart + '-' + rangeEnd));
            }
            return ranges.join(', ');
        };

        var convertRangeToLines = function (ranges) {
            var lines = [];
            if (!ranges) {
                return lines;
            }
            var range = ranges.split(",");
            for (var i = 0, len = range.length; i < len; i++) {
                var s = range[i].split("-");
                var s0 = s[0];
                if (s.length === 1) {
                    lines.push(parseInt(s0, 10));
                } else {
                    for (var b = 0; b <= (s[1] - s0); b++) {
                        lines.push(parseInt(s0, 10) + b);
                    }
                }
            }
            return lines;
        };

        var displayCommentForm = function (handleId, parentId, commentId, wrangler, exchanger) {
            var parent = AJS.$("#" + parentId);
            //display before setting the new values because safari/konqueror don't let you change the values
            //if not attached to the document unlike IE and FF
            if (exchanger) {
                exchanger();
            } else {
                wrangler.exchange(parent, null, handleId);
            }
            var isDraft = true;
            if (commentId) {
                var comment = review.comment(commentId);
                wrangler.getCommentForm().populateFromComment(comment);
                isDraft = comment.draft();
            } else {
                wrangler.getCommentForm().clearComment();
            }
            wrangler.formOpened(isDraft);
            wrangler.getCommentForm().setDefaultFocus();
        };

        var clearForm = function (wrangler) {
            wrangler.removeAndSwitch();
            wrangler.getCommentForm().clearComment();
        };

        var copyCommentAttributes = function (sourceComment, destinationComment) {
            var author = User.getFromLocalIndexOrCreate(sourceComment.author.id, sourceComment.author);
            destinationComment.setMessage(sourceComment.message)
                .setMessageAsHtml(sourceComment.messageAsHtml)
                .setToLineRange(sourceComment.toLineRange)
                .setFromLineRange(sourceComment.fromLineRange)
                .setGutterLine(sourceComment.gutterLine)
                .setToRevId(sourceComment.toRevId)
                .setFromRevId(sourceComment.fromRevId)
                .setDefect(sourceComment.defect)
                .setDraft(sourceComment.draft)
                .setMetrics(sourceComment.metrics)
                .setIssueKey(sourceComment.issueKey)
                .setStatus(sourceComment.status)
                .setAuthor(author)
                .setDate(new Date(sourceComment.createDate));

        };

        /******************************************************************
         ******************** INLINE COMMENTS *****************************
         ******************************************************************/

        var rowClassMatchFrom = /.*\bfrom(\d+)\b.*/;
        var rowClassMatchTo = /.*\bto(\d+)\b.*/;

        var getInlineCommentContainer = function (lastSelected) {
            var $lastSelected = $(lastSelected);

            var $container;
            if ($lastSelected.next().is('.comment-row')) {
                $container = $lastSelected.next();
            } else {
                $container = $(rcFormWrangler.getCommentRow($lastSelected)).insertAfter($lastSelected);
            }
            return $container.find('> td > .comment-list');
        };

        var checkInlineCommentBox = function ($tableElement, forceFormExchange) {
            if (res.commentLock) {
                return false;
            }
            var toLinesSelected = [];
            var fromLinesSelected = [];
            var lastSelected = null;

            $tableElement.children('tbody').children("tr.lineHighlighted:not(.hoveringComment)").each(function () {
                var className = this.className;
                var fromMatches = className.match(rowClassMatchFrom);
                var toMatches = className.match(rowClassMatchTo);

                if (fromMatches && fromMatches.length > 1) {
                    fromLinesSelected.push(fromMatches[1]);
                }
                if (toMatches && toMatches.length > 1) {
                    toLinesSelected.push(toMatches[1]);
                }
                lastSelected = this;
            });

            var commentForm = rcFormWrangler.getCommentForm();
            if (lastSelected != null) {
                var $table = AJS.$(lastSelected).closest("table");
                var frxId = $table.attr("id").replace("sourceTable", "");
                //must display first before setting values or safari/konqueror bork
                //can't use .is(':hidden') on a form element: it has height & width of 0px, so is always hidden.
                //use .is(':hidden') on its parent (the wrapper div) instead.
                var formHidden = commentForm.getForm().parent().is(":hidden");
                var $container = getInlineCommentContainer(lastSelected);

                if (forceFormExchange || formHidden) {
                    if (formHidden) {
                        rcFormWrangler.exchange($container, lastSelected, null);
                    } else {
                        rcFormWrangler.move($container, lastSelected);
                    }

                }
                //only if displaying for the first time do we want to clear the comment text
                //so that if they click a line after entering text it doesn't clear
                if (firstTimeDisplayingInlineForm) {
                    commentForm.clearComment();
                    commentForm.setDefaultFocus();
                    rcFormWrangler.formOpened(true);
                    firstTimeDisplayingInlineForm = false;
                }
                commentForm.setFromLines(convertLinesToRange(fromLinesSelected));
                commentForm.setToLines(convertLinesToRange(toLinesSelected));
                commentForm.setFrxId(frxId);
                var frx = review.frx(frxId);
                commentForm.setFromFrxRevision(frx.visibleFromRevision());
                commentForm.setToFrxRevision(frx.visibleToRevision());
                if (rcFormWrangler.isDisplayingRow()) {
                    rcFormWrangler.setWidth(getInlineCommentFormWidth());
                } else {
                    rcFormWrangler.unsetWidth();
                }
                lastSelectedLine = lastSelected;
            } else {
                //clean up
                if (commentForm.getTextBox().val() !== '') {
                    var popupDeleteResponse = window.confirm("You've deselected all lines\n\n" +
                        "Delete the comment?\n");
                    if (popupDeleteResponse) {
                        if (commentForm.hasCommentId()) {
                            commentator.deleteComment(commentForm.getCommentId(), permaId);
                        }
                        res.clearRevisionCommentBox();
                    }
                } else {
                    res.clearRevisionCommentBox();
                }
            }
            return false;
        };

        var insertAjaxRevisionComment = function (resp) {
            fcFormWrangler.removeAndSwitch();
            AJS.$('#addFileCommentLink' + fcFormWrangler.getCommentForm().getFormElement('frxId').val()).show();
            if (resp.worked) {
                var commentId = resp.comment.id;
                var containerId = 'revision_comments_frxinner' + resp.frxId;
                var $commentFormPlaceholder = $('#' + containerId).children('.fileCommentForm');
                var $comment = $(resp.commentHtml);
                commentator.replaceOrInsertComment('revision', commentId, $comment,
                    'revision_comments_frxinner' + resp.frxId,
                    {
                        $beforeElem: $commentFormPlaceholder
                    });
            }
        };

        var triggerCommentAddedEvent = function (commentDivId) {
            var $comment = $('#' + commentDivId);
            $comment.trigger('comment-added');
        };

        var triggerEventOnCommentsFrxElement = function (commentId, eventName) {
            var frx = review.comment(commentId).frx();
            var $targetFrx;
            if (frx) {
                $targetFrx = frx.frxOuter();
            } else {
                $targetFrx = $('#generalComments');
            }
            $targetFrx.trigger(eventName);
        };

        /*eslint-disable max-depth*/
        var insertAjaxInlineComment = function (resp) {
            if (resp.worked) {
                res.clearRevisionCommentBox();
                var commentId = resp.comment.id;
                var $oldComment = AJS.$('#inlinecomment' + commentId);
                var isEdit = $oldComment.length === 1;

                var createNewRow = true;

                var $comment = AJS.$(resp.inlineCommentHtml);
                var commentDivId = $comment.attr('id');

                // comment exists, let's update it
                if (isEdit) {
                    if (lastSelectedLine) {
                        var $row = $oldComment.closest("tr");
                        // check to see if the updated comment is on a different last line.
                        var $oldLastLine = $row.prevAll(".sourceLine:first");
                        if ($oldLastLine.length === 1) {
                            var sameLastLine = $oldLastLine[0].className === lastSelectedLine.className;
                            if (sameLastLine) {
                                $oldComment.replaceWith($comment);
                                createNewRow = false;
                            } else {
                                var $commentList = $oldComment.closest('.comment-list');
                                $oldComment.remove();
                                if (!$commentList.children('.comment-container').length) {
                                    $commentList.closest('.comment-row').remove();
                                }
                            }
                        }
                        editingRCHandleId = null;
                    } else {
                        // the parent is the td which holds the contents of the inline comment
                        $oldComment.parent().html($comment);
                        AJS.log("TODO: Check how this gets called");
                    }
                }

                if (createNewRow) {
                    if (lastSelectedLine) {
                        var $container = getInlineCommentContainer(lastSelectedLine);

                        var frx = review.frx(resp.frxId);
                        var colSpan = frx.colspan();
                        $container.prepend($comment);
                    }
                }


                if (isEdit) {
                    // aboveCommentHtml contains the edit div too, so just remove it
                    AJS.$("#abovecommentEdit" + commentId).remove();
                    AJS.$("#abovecomment" + commentId).replaceWith(resp.aboveCommentHtml);
                } else {
                    AJS.$("#inline_comments_frxinner" + resp.frxId).append(resp.aboveCommentHtml);
                }
                res.setCommentWidths('inlinecomment' + commentId, true);
                triggerCommentAddedEvent(commentDivId);
            }
        };
        /*eslint-enable*/

        var leaveCommentUnread = function (commentId) {
            if (canChangeCommentStatus(commentId, 'leaveUnread')) {
                res.updateCommentReadStatus(commentId, permaId, false);
            }
        };

        var canChangeCommentStatus = function (commentId, status) {
            var comment = review.comment(commentId);
            var $comment = AJS.$(res.commentContainerDivs(commentId)).children('.comment');
            return review.commentable() && !($comment.hasClass('readStatusLocked') || comment.status() === status);
        };

        var autosaveTimer = function () {
            try {
                rcFormWrangler.autosaveTimerPing();
                scFormWrangler.autosaveTimerPing();
                fcFormWrangler.autosaveTimerPing();
                replyFormWrangler.autosaveTimerPing();
            } finally {
                setTimeout(autosaveTimer, 10000); // every 10s
            }
        };

        var calculateFrxPaneWidth = function () {
            // Leave room for the scrollbar.
            return AJS.$('#frx-pane').width() - 8;
        };

        var getInlineCommentFormWidth = function () {
            var commentFormIndent = 30;
            var wikiPreviewIconWidth = 22;
            if (review.frxs()) {
                var currentWidth = calculateFrxPaneWidth();
                if (frxPaneWidth !== currentWidth) {
                    frxPaneWidth = currentWidth;
                }
            }
            return frxPaneWidth - commentFormIndent - 21 - wikiPreviewIconWidth;
        };

        var deleteComments = function (midFix, commentId) {
            for (var i = 0, len = commentDivPrefixes.length; i < len; i++) {
                var prefix = commentDivPrefixes[i];
                var comment = AJS.$("#" + prefix + midFix + commentId);
                var $commentParent = comment.parent();
                var $table = comment.closest('table');

                comment.remove();

                // check if the comment parent is a top-level comment,
                // remove the comment row if it is.
                if (!$commentParent.children().length && $commentParent.parent().is('td')) {
                    $commentParent.closest('tr').remove();
                } else if ($commentParent.is('.revision_comments_frxinner')
                    && !$commentParent.children('.comment-container').length) {
                    $commentParent.addClass('hidden');
                }

                triggerEventOnCommentsFrxElement(commentId, 'comment-removed');
            }
            res.clearCommentedLines();
        };

        var updateRevisionSliderCounts = function (comment, totalDelta, unreadDelta) {
            if (comment.isInline()) {
                if (comment.fromRevId()) {
                    updateCommentCountImpl('frxRev', comment.fromRevId(), totalDelta, true);
                    updateUnreadCommentCountImpl('frxRev', comment.fromRevId(), unreadDelta, true);
                }
                if (comment.toRevId() && comment.fromRevId() !== comment.toRevId()) {
                    updateCommentCountImpl('frxRev', comment.toRevId(), totalDelta, true);
                    updateUnreadCommentCountImpl('frxRev', comment.toRevId(), unreadDelta, true);
                }
            }
        };

        var updateFRXCommentCountImpl = function (frxId, commentCount, isDelta) {
            updateCommentCountImpl('frx', frxId, commentCount, isDelta);
            updateCommentCountImpl('frxpath', frxId, commentCount, isDelta);
            var hiddenCount = 0;
            var comments = review.frx(frxId).comments();
            for (var i = 0, len = comments.length; i < len; i++) {
                if (comments[i].isHidden()) {
                    hiddenCount++;
                }
            }
            AJS.$('#frxpathHiddenCommentCount' + frxId).html(hiddenCount === 0 ? '' : '&mdash; ' + hiddenCount + ' hidden')
        };

        var updateFRXUnreadCommentCount = function (frxId, unreadCommentCount, isDelta) {
            updateUnreadCommentCountImpl('frx', frxId, unreadCommentCount, isDelta);
            updateUnreadCommentCountImpl('frxpath', frxId, unreadCommentCount, isDelta);
        };

        // Comment counts
        var updateUnreadCommentCountImpl = function (idPrefix, idSuffix, unreadCommentCount, isDelta) {
            // Don't do complicated stuff if the change is nil
            if (isDelta && unreadCommentCount === 0) {
                return;
            }

            var $commentCount = AJS.$('#' + idPrefix + 'CommentCount' + idSuffix);
            var unreadCount = isDelta ? (parseInt($commentCount.attr('data-unread') || 0, 10) + unreadCommentCount) : unreadCommentCount;

            // different implementation for comment counts in review header

            $commentCount.attr('data-unread', unreadCount > 0 ? unreadCount : 0);
            if (idPrefix === 'frxpath') {
                var $realCommentCount = $commentCount.parent();
                $realCommentCount.find('.count-unread').text(unreadCount);
                $realCommentCount.find('.unreadCommentCount').toggleClass('hidden', unreadCount <= 0)
            } else {
                $commentCount.toggleClass('aui-badge-subtle', unreadCount <= 0);
            }
        };

        var updateCommentCountImpl = function (idPrefix, idSuffix, commentCount, isDelta) {
            // Don't do complicated stuff if the change is nil
            if (isDelta && commentCount === 0) {
                return;
            }
            var $commentCount = AJS.$('#' + idPrefix + 'CommentCount' + idSuffix);
            var currentTotal = parseInt($commentCount.attr('data-count') || 0, 10);
            var newCommentCount = isDelta ? currentTotal + commentCount : commentCount;

            $commentCount.text(newCommentCount)
                .attr('data-count', newCommentCount > 0 ? newCommentCount : 0);
            if (idPrefix === 'frxpath') {
                $commentCount
                    .toggleClass('hidden', newCommentCount <= 0)
                    .parent()
                    .toggleClass('hidden', newCommentCount <= 0);
            } else {
                $commentCount
                    .text(newCommentCount);
            }
        };

        var updateGeneralCommentCount = function (resp) {
            if (resp.worked) {
                var commentCountDelta = resp.generalCommentCountDelta;
                var unreadCommentCountDelta = resp.generalUnreadCommentCountDelta;
                updateCommentCountImpl('general', '', commentCountDelta, true);
                updateUnreadCommentCountImpl('general', '', unreadCommentCountDelta, true);
            }
        };

        var modifyIndicatorDisplay = function (midFix, commentId, value) {
            AJS.$.each(commentator.commentDivPrefixes, function () {
                AJS.$("#" + this + midFix + commentId).css('display', value);
            });
        };

        var removeCommentAction = function (commentId, selector) {
            AJS.$('#' + commentId).find(selector).closest('li').remove();
        }

        var res = {
            showCommentsInline: function () {
                return AJS.$("body").hasClass("show-inline-comments");
            },
            showCommentsAbove: function () {
                return AJS.$("body").hasClass("show-above-comments");
            },
            hideSourceComments: function () {
                return AJS.$("body").hasClass("hide-comments");
            },
            showSource: true,
            commentDivPrefixes: commentDivPrefixes,
            g_pageCompletelyLoaded: false,
            commentLock: false,

            /**
             *
             * @param commentType 'revision' | 'reply' | 'general'
             * @param commentId
             * @param commentHtml the comment html returning from backend
             * @param containerId the id of the container which will hold the comments
             * @param opts : {}
             *  $beforeElem: jquery object -- before which the comment shall be inserted
             */
            replaceOrInsertComment: function (commentType, commentId, commentHtml, containerId, opts) {
                var $oldComment = AJS.$('#' + commentType + 'comment' + commentId);
                if ($oldComment.length > 0) {
                    // commentHtml contains the edit div too, so just remove it
                    var $commentEdit = AJS.$('#' + commentType + 'commentEdit' + commentId);
                    $commentEdit.remove();
                    $oldComment.replaceWith(commentHtml);
                } else {
                    if (commentType === 'general') {
                        $('#general-comments-container .comment-form-placeholder')
                            .before(commentHtml);
                    } else {
                        if (opts.$beforeElem) {
                            opts.$beforeElem.before(commentHtml);
                        } else {
                            $('#' + containerId).prepend(commentHtml);
                        }
                    }
                }
            },

            /******************************************************************
             ******************** HELPER METHODS ******************************
             ******************************************************************/

            showCommentedLines: function (frxId, fromLineRange, toLineRange) {
                highlightedLines = res.getCommentedLines(frxId, fromLineRange, toLineRange);
                AJS.$(highlightedLines).addClass('lineHighlighted hoveringComment');
            },

            clearCommentedLines: function () {
                AJS.$(highlightedLines).removeClass('lineHighlighted hoveringComment');
                highlightedLines = [];
            },

            getHighlightedLines: function () {
                return highlightedLines;
            },

            /******************************************************************
             ******************** COMMON METHODS ******************************
             ******************************************************************/

            checkGeneralCommentsWarning: function (frxId) {
                if (frxId) {
                    if (review.frx(frxId).fileComments().length === 0) {
                        AJS.$('#addFileCommentLink' + frxId).hide();
                    } else {
                        AJS.$('#addFileCommentLink' + frxId).show();
                    }
                }
            },

            changeCommentStatus: function (commentId, newStatus, oldStatus) {
                AJS.$(res.commentContainerDivs(commentId))
                    .children('.comment')
                    .removeClass(oldStatus)
                    .addClass(newStatus);
                review.comment(commentId).setStatus(newStatus);
            },

            displaySimpleCommentForm: function (handleId, parentId, commentId) {
                displayCommentForm(handleId, parentId, commentId, scFormWrangler);
            },

            createOrUpdateComment: function (resp) {
                if (resp.worked) {
                    var commentResp = resp.comment;

                    var comment = review.comment(commentResp.id);
                    if (!comment) {
                        var position = 'general';
                        if (resp.replyToId) {
                            position = review.comment(resp.replyToId).position();
                        } else if (resp.frxId) {
                            if (resp.whole) {
                                position = 'revision';
                            } else {
                                position = 'inline';
                            }
                        }
                        var type = resp.replyToId ? 'reply' : 'comment';
                        var commentType = position + type;

                        comment = new Comment(commentResp.id, commentType);

                        if (resp.replyToId) {
                            var parent = review.comment(resp.replyToId);
                            comment.setReplyTo(parent);
                            parent.addReply(comment);
                        }
                        copyCommentAttributes(commentResp, comment);
                        comment.setReview(review);
                        if (resp.frxId) {
                            var frx = review.frx(resp.frxId);
                            comment.setFrx(frx);
                            frx.addComment(comment);
                        }
                        review.addComment(comment);
                    } else {
                        copyCommentAttributes(commentResp, comment);
                    }

                    if (!resp.frxId && !resp.autoSaveAction) {
                        res.checkGeneralCommentsWarning();
                    }

                    var replyComments = resp.replyComments;
                    if (replyComments) {
                        comment.clearReplies();
                        for (var i = 0, len = replyComments.length; i < len; i++) {
                            var replyComment = replyComments[i];
                            var replyParent = review.comment(replyComment.replyToId);
                            if (replyParent) {
                                replyParent.addReply(commentator.createOrUpdateComment(replyComment));
                            }
                        }
                    }

                    return comment;
                }
            },

            updateCommentCount: function (resp) {
                if (resp && resp.worked) {
                    res.updateTotalCommentCount(resp.totalCommentCountDelta, true);
                    res.updateTotalUnreadCommentCount(resp.totalUnreadCommentCountDelta, true);
                    if (resp.frxId) {
                        res.updateFRXCommentCount(resp);
                    } else {
                        updateGeneralCommentCount(resp);
                    }
                } else if (!resp) {
                    res.updateTotalCommentCount(review.comments().length, false);
                    res.updateTotalUnreadCommentCount(review.unreadComments().length, false);
                    updateCommentCountImpl('general', '', review.generalComments().length, false);
                    updateUnreadCommentCountImpl('general', '', review.unreadGeneralComments().length, false);
                    var frxs = review.frxs();
                    for (var i = 0, len = frxs.length; i < len; i++) {
                        res.reloadFrxCommentCount(frxs[i]);
                    }
                }
            },

            reloadFrxCommentCount: function (frx) {
                var comments = frx.comments();
                updateFRXCommentCountImpl(frx.id(), comments.length, false);
                updateFRXUnreadCommentCount(frx.id(), frx.unreadComments().length, false);
                var frxRevCommentCounts = {};
                var frxRevUnreadCommentCounts = {};
                var j;
                var innerLen;

                for (j = 0, innerLen = comments.length; j < innerLen; j++) {
                    var comment = comments[j];
                    if (comment.isInline()) {
                        var toRevId = comment.toRevId();
                        var toRevCount = frxRevCommentCounts[toRevId];
                        var toRevUnreadCount = frxRevUnreadCommentCounts[toRevId];
                        if (!toRevCount) {
                            toRevCount = 0;
                        }
                        if (!toRevUnreadCount) {
                            toRevUnreadCount = 0;
                        }
                        toRevCount++;
                        if (comment.status() === 'unread' || comment.status() === 'leaveUnread') {
                            toRevUnreadCount++;
                        }
                        frxRevCommentCounts[toRevId] = toRevCount;
                        frxRevUnreadCommentCounts[toRevId] = toRevUnreadCount;

                        var fromRevId = comment.fromRevId();
                        if (fromRevId !== toRevId) {
                            var fromRevCount = frxRevCommentCounts[fromRevId];
                            var fromRevUnreadCount = frxRevUnreadCommentCounts[fromRevId];
                            if (!fromRevCount) {
                                fromRevCount = 0;
                            }
                            if (!fromRevUnreadCount) {
                                fromRevUnreadCount = 0;
                            }
                            fromRevCount++;
                            if (comment.status() === 'unread' || comment.status() === 'leaveUnread') {
                                fromRevUnreadCount++;
                            }
                            frxRevCommentCounts[fromRevId] = fromRevCount;
                            frxRevUnreadCommentCounts[fromRevId] = fromRevUnreadCount;
                        }
                    }
                }
                var frxRevs = frx.frxRevisions();
                for (j = 0, innerLen = frxRevs.length; j < innerLen; j++) {
                    var revId = frxRevs[j];
                    updateCommentCountImpl('frxRev', revId, frxRevCommentCounts[revId] || 0, false);
                    updateUnreadCommentCountImpl('frxRev', revId, frxRevUnreadCommentCounts[revId] || 0, false);
                }
            },

            updateTotalCommentCount: function (count, isDelta) {
                var $total = AJS.$("#totalCommentCount");

                var total = parseInt($total.attr('data-count'), 10);
                if (isDelta) {
                    total += count;
                }
                $total.attr('data-count', total > 0 ? total : 0)
                    .html(total);
            },

            updateTotalUnreadCommentCount: function (count, isDelta) {
                var $total = AJS.$("#totalCommentCount");
                var unread = parseInt($total.attr('data-unread') || 0, 10);
                if (isDelta) {
                    unread += count;
                }
                $total.attr('data-unread', unread > 0 ? unread : 0)
                    .toggleClass('aui-badge-subtle', unread <= 0);
            },

            updateTreeFolderCommentCount: function ($folder, totalDelta, unreadDelta) {
                // Don't do expensive calculations if there are no comments
                if (review.comments().length === 0) {
                    return;
                }
                var $parent = $folder.parent();
                var parentDomId = $parent.attr("id");
                var isFrxDir = parentDomId.indexOf("folder-list-item") === -1;

                var frx;
                var folderId = parentDomId.replace(/^\D+/, "");
                var prefix = isFrxDir ? 'frx' : 'folder';

                // If the folder is open, we need to hide any comment counts
                if ($folder.is(".open")) {
                    // If we are opening a directory which is an frx, then we should use it's comment counts
                    if (isFrxDir) {
                        frx = review.frx(folderId);
                        updateCommentCountImpl(prefix, folderId, frx.comments().length, false);
                        updateUnreadCommentCountImpl(prefix, folderId, frx.unreadComments().length, false);
                    } else {
                        updateCommentCountImpl(prefix, folderId, 0, false);
                        updateUnreadCommentCountImpl(prefix, folderId, 0, false);
                    }
                } else {
                    // If we have explicitly been given the changes in the total/unread, then use them. Otherwise, calculate the
                    // comment counts to be used.
                    if (totalDelta !== undefined && unreadDelta !== undefined) {
                        updateCommentCountImpl(prefix, folderId, totalDelta, true);
                        updateUnreadCommentCountImpl(prefix, folderId, unreadDelta, true);
                    } else {
                        var total = 0;
                        var unread = 0;

                        function addChildCounts($elem) {
                            var $span = $elem.children("span");

                            // add the comment counts for this item (may be unnecessary)
                            var $frxLink = $span.children("a.scroll-to-frx");
                            if ($frxLink.length > 0) {
                                var frxId = $frxLink.attr("id").replace("scroll-to-frx", "");
                                var frx = review.frx(frxId);
                                if (frx) {
                                    total += frx.comments().length;
                                    unread += frx.unreadComments().length;
                                }
                            }

                            var subtrees = $elem.children("ul").children();
                            for (var i = 0, len = subtrees.length; i < len; i++) {
                                addChildCounts(AJS.$(subtrees[i]));
                            }
                        }

                        addChildCounts($parent);

                        updateCommentCountImpl(prefix, folderId, total, false);
                        updateUnreadCommentCountImpl(prefix, folderId, unread, false);
                    }
                }
            },

            discardComment: function (commentId) {
                var comment = review.comment(commentId);
                review.removeComment(comment);
                var $comment = comment.getDomElement()
                var $commentContainer = $comment.closest('.comment-list');
                if (!$comment.closest('.reply-container').length) {
                    if (!$commentContainer.children('.comment:visible').length) {
                        if ($commentContainer.parent().is('td')) {
                            $commentContainer.closest('.comment-row').remove();
                        } else if ($commentContainer.is('.revision_comments_frxinner')) {
                            $commentContainer.addClass('hidden');
                        }
                    }
                }
                $comment.remove();

            },

            discardFileCommentBox: function (commentId, permaId) {
                res.clearFileCommentBox();
                var done = function () {
                    commentator.discardComment(commentId);
                };
                commentAjaxController.deleteComment(commentId, permaId, done);
            },

            discardRevisionCommentBox: function (commentId, permaId) {
                res.clearRevisionCommentBox();
                var done = function () {
                    commentator.discardComment(commentId);
                };
                commentAjaxController.deleteComment(commentId, permaId, done);
            },

            clearFileCommentBox: function () {
                AJS.$('#addFileCommentLink' + fcFormWrangler.getCommentForm().getFormElement('frxId').val()).show();
                clearForm(fcFormWrangler);
                fcFormWrangler.formClosed();
            },

            clearRevisionCommentBox: function () {
                if (rcFormWrangler.isDisplaying()) {
                    //a little inefficient, but effective.
                    rcFormWrangler.removeAndSwitch();
                    clearSelectedRows();
                    if (editingRCHandleId) {
                        AJS.$("#" + editingRCHandleId).show();
                        editingRCHandleId = null;
                    }
                    rcFormWrangler.formClosed();
                }
            },

            /** Returns all occurences of the container divs. Needed due to inline/above. */
            commentContainerDivs: function (commentId) {
                var comment = review.comment(commentId);
                var domId = comment.domId();
                var domIds = ['#' + domId];
                if (/^inline/.test(comment.type())) {
                    domIds.push('#' + domId.replace('inline', 'above'));
                    domIds.push('.comment' + commentId);
                }
                return AJS.$(domIds.join(',')).get();
            },

            replyToComment: function (commentId) {
                var comment = review.comment(commentId);
                if (!comment) {
                    return;
                }
                if (comment.isReply()) {
                    comment = comment.replyTo(); // get the thread parent
                }
                var $commentElem = AJS.$("#" + comment.domId());
                $commentElem.find("div.comment:first div.comment-actions .replyToComment:first").click();
            },

            /******************************************************************
             ******************** COMMENT EDITING *****************************
             ******************************************************************/

            publishComment: function (commentId, permaId) {
                var done = function (commentId, resp) {
                    if (resp.worked) {
                        var commentDomId = review.comment(commentId).domId();
                        removeCommentAction(commentDomId, '> .comment .publishComment');
                        removeCommentAction(commentDomId, '> .comment .draft-indicator');

                        review.comment(commentId).setDraft(false);
                        var commentElement = AJS.$('.comment' + commentId + ' > .comment');
                        commentElement.removeClass('draft');
                        commentElement.find(".replyToComment").removeClass('disabled');
                        commentator.updateCommentCount(resp);

                    }
                };
                commentAjaxController.publishComment(commentId, permaId, done);
                return false;
            },

            /******************************************************************
             ******************** COMMENT DELETING ****************************
             ******************************************************************/

            deleteComment: function (commentId, permaId) {
                var done = function (resp) {
                    if (resp.worked) {
                        var comment = review.comment(commentId);
                        res.removeCommentHtml(comment);
                        if (comment.isInline()) {
                            updateRevisionSliderCounts(comment, -1, 0);
                        }
                        var parent = comment.replyTo(); // will be undefined for root comments
                        review.removeComment(comment);
                        res.updateCommentCount(resp);

                        res.checkGeneralCommentsWarning();

                        if (parent && !parent.hasReplies()) {
                            // Enable the delete link in the parent
                            AJS.$("#" + parent.domId() + " a.deleteComment:first")
                                .removeClass("disabled")
                                .removeAttr("title");
                        }

                        CRU.COMMENT.NAV.visibleCommentsChanged();
                    }
                };
                commentAjaxController.deleteComment(commentId, permaId, done);
                return false;
            },

            removeCommentHtml: function (comment) {
                var commentId = comment.id();
                //turn off all displayed comments with comment ID
                deleteComments("comment", commentId); // TODO optimise
                deleteComments("reply", commentId);   // TODO optimise

                if (comment.isInline()) {
                    tetrisCommentController.deleteTetrisCommentMarkers(commentId);
                }
            },

            /******************************************************************
             ******************** REPLY COMMENTS ******************************
             ******************************************************************/

            insertAjaxReply: function (resp) {
                replyFormWrangler.removeAndSwitch();
                if (resp.worked) {

                    var replyId = resp.comment.id;
                    var idPrefix = resp.type;
                    var isInline = idPrefix === 'inline';

                    var oldComment = review.comment(replyId);

                    // if we are editing, we want to replace the existing replies
                    if (oldComment && oldComment.domIdExists()) {
                        // html contains the edit div too, so just remove it
                        AJS.$("#" + idPrefix + "commentEdit" + replyId).remove();
                        AJS.$("#" + idPrefix + "reply" + replyId).replaceWith(resp.html[idPrefix]);

                        if (isInline) {
                            AJS.$("#abovecommentEdit" + replyId).remove();
                            AJS.$("#abovereply" + replyId).replaceWith(resp.html['above']);
                        }
                    } else {
                        var parentId = resp.replyToId;
                        AJS.$("#" + idPrefix + "replys" + parentId).append(resp.html[idPrefix]);

                        if (isInline) {
                            AJS.$("#abovereplys" + parentId).append(resp.html['above']);
                        }
                    }

                    res.createOrUpdateComment(resp);

                    // Disable the delete link in the parent
                    var parent = review.comment(resp.replyToId);
                    if (parent.hasReplies()) {
                        AJS.$("#" + parent.domId() + " > div.comment a.deleteComment")
                            .addClass("disabled")
                            .attr("title", "You cannot delete this comment as long as it has replies.");
                    }

                    CRU.COMMENT.NAV.visibleCommentsChanged();
                }
            },

            displayReplyCommentForm: function (handleId, parentId, replyToId, commentId) {
                if (replyFormWrangler.isDisplaying() && AJS.$("#" + parentId)[0] === replyFormWrangler.getParent()[0]) {
                    return;//already displaying here so do nothing
                }
                displayCommentForm(handleId, parentId, commentId, replyFormWrangler);
                //replyToId must be set or it ain't a reply
                replyFormWrangler.getCommentForm().setReplyToId(replyToId);

                // Disable the "Post" button for repies on drafts:
                AJS.$("#replyCommentForm .postButton")
                    .prop('disabled', review.comment(replyToId).draft());
            },

            discardReplyCommentForm: function (commentId, permaId) {
                res.clearReplyCommentForm();
                var done = function () {
                    commentator.discardComment(commentId);
                };
                commentAjaxController.deleteComment(commentId, permaId, done);
            },

            clearReplyCommentForm: function () {
                clearForm(replyFormWrangler);
                replyFormWrangler.formClosed();
            },

            /******************************************************************
             ******************** GENERAL COMMENTS ****************************
             ******************************************************************/

            insertAjaxGeneralComment: function (resp) {
                scFormWrangler.removeAndSwitch();
                if (resp.worked) {

                    var commentId = resp.comment.id;
                    var oldComment = review.comment(commentId);
                    res.replaceOrInsertComment('general', commentId, resp.commentHtml, 'general-comments-container');
                    res.createOrUpdateComment(resp);
                    res.updateCommentCount(resp);
                    CRU.COMMENT.NAV.visibleCommentsChanged();
                    triggerCommentAddedEvent(AJS.$(resp.commentHtml).attr('id'));
                }
            },

            discardGeneralCommentForm: function (commentId, permaId) {
                res.clearGeneralCommentForm();
                var done = function () {
                    commentator.discardComment(commentId);
                    res.checkGeneralCommentsWarning();
                };
                commentAjaxController.deleteComment(commentId, permaId, done);
            },

            clearGeneralCommentForm: function () {
                clearForm(scFormWrangler);
                scFormWrangler.formClosed();
                res.checkGeneralCommentsWarning();
            },

            clearFileCommentForm: function () {
                var frxId = fcFormWrangler.getCommentForm().getFormElement('frxId').val();
                AJS.$('#addFileCommentLink' + frxId).show();
                var $fileForm = fcFormWrangler.getCommentForm().getForm();
                var $parent = $fileForm.closest('.comment-list');

                clearForm(fcFormWrangler);
                if (!$parent.children('.comment-container').length) {
                    $parent.addClass('hidden');
                }

                fcFormWrangler.formClosed();
            },

            /******************************************************************
             ******************** REVISION COMMENTS ***************************
             ******************************************************************/

            displayFileCommentForm: function (handleId, parentId, frxId, commentId) {
                AJS.$('#addFileCommentLink' + frxId).hide();

                var $parent = $('#' + parentId);
                if (!$parent.is(':visible')) {
                    $parent.parent().removeClass('hidden');
                }
                displayCommentForm(handleId, parentId, commentId, fcFormWrangler);
                fcFormWrangler.getCommentForm().setFrxId(frxId);

                fcFormWrangler.unsetWidth();
            },

            /**
             * display a comment form as a child of parent with the details in the comment object
             *
             * @param handleId the switch you want to hide while displaying the form
             * @param parentId div/containing block id to display form in
             * @param commentId comment dom id
             */
            displayRevisionCommentForm: function (handleId, parentId, frxId, commentId) {
                clearSelectedRows();

                var comment = review.comment(commentId);
                if (comment) {
                    editingRCHandleId = handleId;
                    var lines = res.getCommentedLines(frxId, comment.fromLineRange(), comment.toLineRange());
                    AJS.$.each(lines, function (i) {
                        var $line = AJS.$(this);
                        if (i === 0) {
                            g_currentTable = $line.parent()[0];
                        }
                        selectTR(this, true);
                        lastSelectedLine = this;
                    });
                }

                var exchanger = function () {
                    var $container = $('#' + handleId).next('.comment-edit-form');
                    rcFormWrangler.exchange($container, lastSelectedLine, handleId);
                };
                displayCommentForm(handleId, parentId, commentId, rcFormWrangler, exchanger);

                var commentForm = rcFormWrangler.getCommentForm();
                commentForm.setFrxId(frxId);

                if (/^inline/.test(parentId)) {
                    var frx = review.frx(frxId);
                    commentForm.setFromFrxRevision(frx.visibleFromRevision());
                    commentForm.setToFrxRevision(frx.visibleToRevision());
                    firstTimeDisplayingInlineForm = false;
                } else {
                    rcFormWrangler.unsetWidth();
                    firstTimeDisplayingInlineForm = true;
                }
            },

            insertRevisionComment: function (resp) {
                if (resp.worked) {
                    if (resp.whole) {
                        insertAjaxRevisionComment(resp);
                    } else {
                        insertAjaxInlineComment(resp);
                    }
                    res.createOrUpdateComment(resp);
                    res.updateCommentCount(resp);
                    CRU.COMMENT.NAV.visibleCommentsChanged();
                }
            },

            /******************************************************************
             ******************** COMMENT READ STATUS *************************
             ******************************************************************/

            toggleCommentRead: function (commentId, force) {
                var comment = review.comment(commentId);
                if (!comment) {
                    return;
                }
                var oldStatus = comment.status();
                if (oldStatus === 'read' || oldStatus === 'unread') {
                    leaveCommentUnread(commentId);
                } else {
                    res.markCommentRead(commentId, force);
                }
            },

            markCommentRead: function (commentId, force) {
                var comment = review.comment(commentId);
                if (!comment || comment.draft()) {
                    return;
                }
                var leaveUnread = comment.status() === 'leaveUnread';
                if ((!leaveUnread || force) && canChangeCommentStatus(commentId, 'read')) {
                    res.updateCommentReadStatus(commentId, permaId, true);
                }
            },

            leaveCommentUnread: function (commentId) {
                if (canChangeCommentStatus(commentId, 'leaveUnread')) {
                    res.updateCommentReadStatus(commentId, permaId, false);
                }
            },

            markAllCommentsRead: function (frxId) {
                var updatedComments = [];
                var i;
                var len;
                var comment;
                var comments;

                if (!frxId) {
                    comments = review.comments();
                } else if (review.frx(frxId)) {
                    comments = review.frx(frxId).comments();
                } else {
                    comments = review.generalComments();
                }

                for (i = 0, len = comments.length; i < len; i++) {
                    comment = comments[i];
                    if (canChangeCommentStatus(comment.id(), 'read')) {
                        updatedComments.push(comment);
                    }
                }

                var done = function (resp) {
                    if (resp.worked) {
                        var _res = res; // store a local variable of the outer scope instance

                        for (i = 0, len = updatedComments.length; i < len; i++) {
                            comment = updatedComments[i];
                            _res.changeCommentStatus(comment.id(), 'read', comment.status());
                        }

                        _res.updateCommentCount();
                    }
                };

                commentAjaxController.markAllCommentsRead(updatedComments, permaId, done);
                return false;
            },

            // Comment read status
            updateCommentReadStatus: function (commentId, permaId, markAsRead) {
                var comment = review.comment(commentId);
                var oldStatus = comment.status();
                var newStatus = markAsRead ? 'read' : 'leaveUnread';
                var statusXhr = statusXhrs[commentId];
                var done = function (resp) {
                    if (resp.worked) {
                        commentator.updateCommentCount(resp);
                        if (comment.isInline()) {
                            commentator.updateFrxRevisionUnreadCommentCount(comment, resp.frxUnreadCommentCountDelta);
                        }
                    }
                };

                if (statusXhr) {
                    statusXhr.abort();
                    delete statusXhrs[commentId];
                }

                res.changeCommentStatus(commentId, newStatus, oldStatus);
                statusXhrs[commentId] = commentAjaxController.updateCommentReadStatus(commentId, permaId, markAsRead, done);

                return false;
            },

            /******************************************************************
             ******************** MISC METHODS    *****************************
             ******************************************************************/

            toggleComments: function (view) {
                AJS.$('.show-comment-container').removeClass('show-comment-container');

                AJS.$("#set-inline-comments, #set-above-comments, #set-hidden-comments").removeClass("selected");
                var $reviewpage = AJS.$("#reviewpage");
                $reviewpage.removeClass("hide-comments").removeClass("show-inline-comments").removeClass("show-above-comments");

                if (view === 'none') {
                    $reviewpage.addClass("hide-comments");
                    AJS.$("#set-hidden-comments").addClass("selected");
                } else if (view === 'inline') {
                    $reviewpage.addClass("show-inline-comments");
                    AJS.$("#set-inline-comments").addClass("selected");
                    if ($reviewpage.hasClass("hide-source")) {
                        AJS.$("#show_source_button").children("a").click();
                    }
                } else {
                    $reviewpage.addClass("show-above-comments");
                    AJS.$('#frxs').trigger('show-above-comments')
                    AJS.$("#set-above-comments").addClass("selected");
                }
                $('#frx-pane').trigger('comment-view-type-changed');
            },

            checkEmptyCommentList: function ($commentList) {
                if ($commentList.children('.comment-container').length) {
                    $commentList.removeClass('hidden');
                } else {
                    $commentList.addClass('hidden');
                }
            },

            convertRangeToLines: convertRangeToLines,

            /**
             * Returns a list of row objects which are to commented
             * line ranges are in the format of "1-3,5-9,14,16-25"
             */
            getCommentedLines: function (frxId, fromLineRange, toLineRange) {
                var commentedLines = [];

                if (!g_modeSelecting && (fromLineRange || toLineRange )) {
                    highlightedLines = [];

                    var $rows = AJS.$('#sourceTable' + frxId).find("tr.sourceLine");

                    // to/from line ranges are sorted
                    var toLines = convertRangeToLines(toLineRange);
                    var fromLines = convertRangeToLines(fromLineRange);

                    var currentToLine = toLines.length > 0 ? toLines.shift() : null;
                    var currentFromLine = fromLines.length > 0 ? fromLines.shift() : null;

                    $rows.each(function () {
                        if (!currentToLine && !currentFromLine) {
                            return false;
                        }

                        var thisFrom = -1;
                        var thisTo = -1;

                        var className = this.className;
                        var fromMatches = className.match(rowClassMatchFrom);
                        var toMatches = className.match(rowClassMatchTo);

                        if (fromMatches && fromMatches.length > 1) {
                            thisFrom = parseInt(fromMatches[1], 10);
                        }
                        if (toMatches && toMatches.length > 1) {
                            thisTo = parseInt(toMatches[1], 10);
                        }

                        var added = false;
                        while (currentToLine && currentToLine <= thisTo) {
                            if (currentToLine === thisTo) {
                                commentedLines.push(this);
                                added = true;
                            }
                            // pop the next to row number from the stack
                            currentToLine = toLines.length > 0 ? toLines.shift() : null;
                        }
                        while (currentFromLine && currentFromLine <= thisFrom) {
                            // Don't add the same row twice
                            if (!added && currentFromLine === thisFrom) {
                                commentedLines.push(this);
                            }
                            // pop the next from row number from the stack
                            currentFromLine = fromLines.length > 0 ? fromLines.shift() : null;
                        }
                    });
                }
                return commentedLines;
            },

            /**
             * set comment widths to the browser window width instead of the width of the overflowing div
             * it is contained in
             * @param commentId (optional) the id of the individual comment you wish to set the width of as used in ajax updated comments
             * @param forceUpdate (optional) force the comment widths to be set even if the width hasn't changed as used in ajax updates of frx's
             */
            setCommentWidths: function (commentId, forceUpdate) {
                var $commentToUpdate;
                if (commentId) {
                    if (commentId.jquery) {
                        $commentToUpdate = commentId;
                    } else {
                        $commentToUpdate = $("#" + commentId).closest('.comment-list');
                    }
                }
                var commentIndent = 27;
                var replyIndent = 57;

                if (review.frxs()) {
                    var currentWidth = calculateFrxPaneWidth();

                    if ($commentToUpdate) {
                        if (frxPaneWidth !== currentWidth || forceUpdate) {
                            frxPaneWidth = currentWidth;
                            $commentToUpdate.width(frxPaneWidth - commentIndent);
                        }
                    } else if (forceUpdate || frxPaneWidth !== currentWidth || !res.g_pageCompletelyLoaded) {
                        frxPaneWidth = currentWidth;
                        AJS.$.each(review.inlineComments().concat(review.fileComments()), function (i, comment) {
                            $('#' + comment.domId()).closest('.comment-list')
                                .width(frxPaneWidth - commentIndent);
                        });
                    }
                }
                return true;
            },

            updateFRXCommentCount: function (resp) {
                if (resp.worked) {
                    var frxId = resp.frxId;
                    var frxCommentCountDelta = resp.frxCommentCountDelta;
                    var frxUnreadCommentCountDelta = resp.frxUnreadCommentCountDelta;
                    updateFRXCommentCountImpl(frxId, frxCommentCountDelta, true);
                    updateFRXUnreadCommentCount(frxId, frxUnreadCommentCountDelta, true);

                    var parentItems = AJS.$("#frx-list-item" + frxId).parents("li.frx-list-item");
                    for (var i = 0, len = parentItems.length; i < len; i++) {
                        var $item = AJS.$(parentItems[i]);
                        var $folder = $item.children(".folder");
                        if ($folder.is(".closed")) {
                            res.updateTreeFolderCommentCount($folder, frxCommentCountDelta, frxUnreadCommentCountDelta);
                        }
                    }

                    if (resp.comment) {
                        var comment = review.comment(resp.comment.id);
                        updateRevisionSliderCounts(comment, frxCommentCountDelta, frxUnreadCommentCountDelta);
                    }
                }
            },

            updateFrxRevisionUnreadCommentCount: function (comment, unreadDelta) {
                updateRevisionSliderCounts(comment, 0, unreadDelta);
            },

            selectLine_down: function ($row, dontActuallySelectThisRow) {
                var $parent = $row.parents(":first");
                var parent = $parent[0];
                g_mousedown = true;
                if (g_currentTable !== parent) {
                    if (g_currentTable) {
                        clearSelectedRows();
                    }
                    g_currentTable = parent;
                }
                g_modeSelecting = !$row.hasClass("lineHighlighted");
                var row = $row.get(0);
                g_mouseDownFirstRow = row;
                if (!dontActuallySelectThisRow) {
                    selectTR(row, g_modeSelecting);
                    return false;
                } else {
                    return true;
                }
            },

            selectLine_over: function ($obj) {
                if (g_mouseDownFirstRow != null) {
                    selectTR(g_mouseDownFirstRow, g_modeSelecting);
                }
                if (g_mousedown) {
                    selectTR($obj.get(0), g_modeSelecting);
                    return false;
                }
                return true;
            },

            selectLine_up: function ($tableElement) {
                checkInlineCommentBox($tableElement, true);
                g_mouseDownFirstRow = null;
                return false;
            },

            commentFromInnerElement: function (button) {
                var id = AJS.$(button).closest(".comment-container")
                    .attr("id")
                    .replace(/^\D*/, "");
                return review.comment(id);
            },

            syncCommentButtons: function () {
                // Sync the comment nav buttons
                var hasUnread = review.unreadComments().length > 0;
                AJS.$("#mark-comments-read-button").toggleClass("disabled", !hasUnread);
                // If we have unread comments, then we obviously have comments...
                var $toolbars = AJS.$("#frxs").find("div.toolbar");
                if (hasUnread) {
                    $toolbars.find(".prev-comment-button, .next-comment-button").removeClass("disabled");
                } else {
                    // otherwise check if we actually have comments
                    var hasComments = review.comments().length > 0;
                    $toolbars.find(".prev-comment-button, .next-comment-button").toggleClass("disabled", !hasComments);
                }
            },

            getDisplayingCommentForm: function () {
                var forms = res.getDisplayingForms();
                if (forms.length > 0) {
                    return forms[0];
                } else {
                    return null;
                }
            },

            getDisplayingForms: function () {
                var forms = [];
                if (scFormWrangler.isDisplaying()) {
                    forms.push(scFormWrangler.getCommentForm());
                }
                if (fcFormWrangler.isDisplaying()) {
                    forms.push(fcFormWrangler.getCommentForm());
                }
                if (rcFormWrangler.isDisplaying()) {
                    forms.push(rcFormWrangler.getCommentForm());
                }
                if (replyFormWrangler.isDisplaying()) {
                    forms.push(replyFormWrangler.getCommentForm());
                }
                return forms;
            },

            getDisplayingReplyForm: function () {
                if (replyFormWrangler.isDisplaying()) {
                    return replyFormWrangler.getCommentForm();
                } else {
                    return null;
                }
            },
            reinitializeScrollTrackerForElement: (function () {
                var selectorFunction = function () {
                    var ids = [];
                    var comments;
                    var comment;
                    var domId;
                    var i;
                    var len;
                    var frxs = review.frxs();
                    var $body = AJS.$("body");
                    var isMultiFrxView = $body.hasClass("multi-frx-view");
                    var hideSourceComments = $body.hasClass("hide-comments");
                    var aboveComments = $body.hasClass("show-above-comments");

                    // Go over general comments when general comments are visible
                    // Since general comments are always at the top, we should use this exclusively if we can
                    if (AJS.$("#generalComments").hasClass("activeFrx")) {
                        comments = review.generalComments();
                        for (i = 0, len = comments.length; i < len; i++) {
                            comment = comments[i];
                            domId = comment.contentDomId();
                            ids.push("#" + domId);
                        }
                    }
                    // Go over frx comments when the frx is visible
                    else {
                        for (i = 0, len = frxs.length; i < len; i++) {
                            var frx = frxs[i];
                            if (!frx.isLoaded() || frx.isFiltered()) {
                                continue;
                            }

                            if (isMultiFrxView && !frx.isExpanded()) {
                                continue;
                            }

                            var $frxElement = AJS.$("#frxouter" + frx.id());
                            if (!$frxElement.hasClass("activeFrx")) {
                                continue;
                            }
                            comments = hideSourceComments ? frx.fileComments() : frx.comments();
                            for (var j = 0, clen = comments.length; j < clen; j++) {
                                comment = comments[j];
                                domId = comment.contentDomId();
                                if (comment.isInline() && aboveComments) {
                                    ids.push("#" + domId.replace('inline', 'above'));
                                } else {
                                    ids.push("#" + domId);
                                }
                            }
                        }
                    }
                    return AJS.$(ids.length > 0 ? ids.join(",") : []);
                };
                var activeFunction = function () {
                    CRU.COMMENT.NAV.setCurrentComment(this.parentNode);
                };
                var scrollTrackers = {};

                return function (element) {
                    var elementId = element.id;
                    if (!scrollTrackers[elementId]) {
                        scrollTrackers[elementId] = CRU.WIDGETS.makeScrollTracker({
                            threshold: 70,  // height of frx header
                            containerId: elementId,
                            selector: selectorFunction,
                            active: activeFunction
                        });
                    }
                    CRU.COMMENT.commentScrollTracker = scrollTrackers[elementId];
                    return scrollTrackers[elementId];
                }
            })(),
            // very nasty thing - but in order to test untestable code we need to do this
            convertLinesToRange: convertLinesToRange,
            // Another 2 ugly assignment - without them we are unable to split commentator definition
            // from initialization and thus get easy unit testing
            onMouseUp: function() {
                g_mousedown = false;
            },
            autosaveTimer: autosaveTimer
        };

        return res;
    })();

    if (!window.commentator) {
        var commentator = window.commentator = CRU.COMMENT;
        window.commentator.commentAjaxExecutor = FECRU.AJAX.createSequentialExecutor();
    }
})(AJS.$);
/*[{!commentator_js_94ay51p!}]*/