//TODO Arguments should be review-model objects, not ids.
var tetrisCommentController = (function () {

    var createAndShowHoverComment = function ($cell, $row) {
        var $hovercommentWrapper = $row.data("hoverCommentWrapper");
        if (!$hovercommentWrapper || $hovercommentWrapper.length === 0) {
            $hovercommentWrapper = AJS.$('<div>').addClass('hovercommentWrapper').hide();
            $hovercommentWrapper.hover(function () {
                openDropDown($hovercommentWrapper);
            }, function () {
                closeDropDown();
            });
            $row.data("hoverCommentWrapper", $hovercommentWrapper);
        }

        //only show the hover for comments where this is its first line
        var cellCommentArray = $row.data("tetrisCellVisibleFirstCount");
        if (!cellCommentArray) {
            cellCommentArray = $row.data("tetrisCellInvisibleCommentCount");
        }

        AJS.$.each(cellCommentArray, function () {
            //copy the above comment and make it a hover comment
            var $comment = AJS.$('#hovercomment' + this);
            if ($comment.length === 0) {
                $comment = AJS.$('#abovecomment' + this).clone().attr('id', 'hovercomment' + this);
                //remove comment buttons (edit, delete, etc)
                $comment.find('td.commentButton').replaceWith('<td>&nbsp;</td>');
                $comment.find('td.commentIssueKeyUnlinked').replaceWith('<td>&nbsp;</td>');
                //remove replyFormDivs
                $comment.find('#abovereplyFormDiv' + this).remove();
            }
            var $replyContainers = $comment.children(".reply-container").children(".comment-container");
            for (var i = 0, len = $replyContainers.length; i < len; i++) {
                var replyContainer = AJS.$($replyContainers[i]);
                var countReplies = replyContainer.find(".reply-container .comment").length;
                if (countReplies > 0) {
                    var excerpt = replyContainer.children('.comment').find(".excerpt");
                    var replyCountContainer = excerpt.find(".reply-count");
                    replyCountContainer.text(" ... " + countReplies + " " + (countReplies === 1 ? "reply" : "replies") + " hidden");
                }
            }

            $hovercommentWrapper.append($comment);
            $comment.find('.comment').addClass('hover-comment');
        });

        $cell.append($hovercommentWrapper);
        openDropDown($hovercommentWrapper);
    };

    var addElementToSetData = function ($o, name, element) {
        var array = $o.data(name);
        if (!array) {
            array = [];
        }
        if (AJS.$.inArray(element, array) === -1) {
            array.push(element);
        }
        $o.data(name, array);
    };

    var removeElementFromSetData = function ($o, name, element) {
        var array = $o.data(name);
        if (array) {
            var index = AJS.$.inArray(element, array);
            if (index >= 0) {
                array.splice(index, 1);
            }
        }
        $o.data(name, array);
    };

    var cleanupEmptyTetrisCell = function (array, $row, className, comment) {
        //if there are no more comments in this cell
        if (!array || array.length === 0) {
            var $cell = $row.children(".tetrisColumn");
            $cell.removeClass(className).removeClass(comment.commentColor()).unbind();
        }
        var hoverCommentWrapper = $row.data("hoverCommentWrapper");
        if (hoverCommentWrapper) {
            hoverCommentWrapper.remove();
        }
        $row.removeData("hoverCommentWrapper");

        if (className === 'tetrisCommentHidden') {
            $row.children(".tetrisColumn").children('.tetrisCommentHidden').remove();
        }
    };

    var res = {
        /**
         * Renders the comment markers for all comments in the specified FRX.
         */
        renderTetrisCommentMarkersForFrx: function (frxId) {
            var frxComments = review.frx(frxId).comments();
            AJS.$.each(frxComments, function () {
                if (this.isInline()) {
                    res.renderTetrisCommentMarkersForComment(this.id());
                }
            });
        },

        /**
         * given the comment id, return a jquery object of the first row that the comment is on.
         * @param commentId
         */
        getFirstCommentedLine: function (commentId) {
            var comment = review.comment(commentId);
            if (!comment) {
                return;
            }
            var frxId = comment.frx().id();
            var toLineNum = comment.toLineRange().split(',')[0].split('-')[0];
            var fromLineNum = comment.fromLineRange().split(',')[0].split('-')[0];
            var $srcTable = AJS.$('#sourceTable' + frxId);
            var $toRow = $srcTable.find('.to' + toLineNum);
            var $fromRow = $srcTable.find('.from' + fromLineNum);
            var $firstLine;
            if ($fromRow.length === 0) { //no from, use to
                $firstLine = $toRow;
            } else if ($toRow.length === 0) { //no to, use from
                $firstLine = $fromRow;
            } else {
                var allRows = $toRow.parent().children();
                if (allRows.index($toRow) < allRows.index($fromRow)) {
                    $firstLine = $toRow;
                } else {
                    $firstLine = $fromRow;
                }
            }
            return $firstLine;
        },

        /**
         * Renders the comment markers for the given comment.
         * TODO: commentator.getCommentedLines method runs in O(n) where n == frx line count. We _MUST_ improve this.
         */
        renderTetrisCommentMarkersForComment: function (commentId) {
            if (!commentId) {
                return;
            }
            var comment = review.comment(commentId);
            var frxId = comment.frx().id();
            var fromLines = [];
            var toLines = [];
            var allLines;
            var className = "tetrisCommentVisible";
            var cellCounterName = "tetrisCellVisibleFirstCount";
            var $firstLine;
            if (comment.isHidden()) {
                toLines = commentator.getCommentedLines(frxId, "", comment.gutterLine());
                if (toLines.length === 0) {
                    toLines.push(AJS.$('#' + frxId + '_last_line').attr('id', frxId + '_last_line')[0]);
                }
                className = "tetrisCommentHidden";
                cellCounterName = "tetrisCellInvisibleCommentCount";
                allLines = fromLines.concat(toLines);
            } else {
                //allLines = getAllCommentLines(comment, frxId);
                $firstLine = res.getFirstCommentedLine(commentId);
                $firstLine.find('.tetrisColumn').addClass('firstTetrisBlock');
                allLines = $firstLine;
                addElementToSetData($firstLine, cellCounterName, commentId);
            }
            var updateCellCounters = function (lines) {
                AJS.$(lines).each(function () {
                    var $row = AJS.$(this);
                    addElementToSetData($row, cellCounterName, commentId);
                    var $cell = $row.children(".tetrisColumn");
                    $cell.addClass(className).unbind();
                    //if it is a 'first' cell or it is a hidden comment, show hover
                    if ($cell.hasClass('firstTetrisBlock') || className === 'tetrisCommentHidden') {
                        var onMouseover = function () {
                            createAndShowHoverComment($cell, $row);
                        };
                        var onMouseout = function () {
                            closeDropDown();
                        };
                        $cell.hover(onMouseover, onMouseout);
                        if (className === 'tetrisCommentHidden') {
                            if ($cell.find('span').length !== 1) {
                                AJS.$('<span>').html('&nbsp;').addClass(className).appendTo($cell);
                            }
                        } else {
                            $cell.addClass(comment.commentColor());
                        }
                    }
                });
            };
            updateCellCounters(allLines);
        },

        deleteTetrisCommentMarkers: function (commentId) {
            var comment = review.comment(commentId);
            if (!comment) {
                return;
            }
            var frxId = comment.frx().id();
            var fromLines = [];
            var toLines = [];
            var allLines;
            var className = "tetrisCommentVisible";
            var cellCounterName = "tetrisCellVisibleFirstCount";
            if (comment.isHidden()) {
                toLines = commentator.getCommentedLines(frxId, "", comment.gutterLine());
                if (toLines.length === 0) {
                    toLines.push(AJS.$('#' + frxId + '_last_line').attr('id', frxId + '_last_line')[0]);
                }
                className = "tetrisCommentHidden";
                cellCounterName = "tetrisCellInvisibleCommentCount";
                allLines = fromLines.concat(toLines);
            } else {
                var $firstLine = res.getFirstCommentedLine(commentId);
                allLines = $firstLine;
                if ($firstLine.data(cellCounterName)) {
                    removeElementFromSetData($firstLine, cellCounterName, commentId)
                    cleanupEmptyTetrisCell($firstLine.data(cellCounterName), $firstLine, className, comment);
                }
            }
            var updateCellCounters = function (lines) {
                AJS.$.each(lines, function () {
                    var $row = AJS.$(this);
                    removeElementFromSetData($row, cellCounterName, commentId)
                    cleanupEmptyTetrisCell($row.data(cellCounterName), $row, className, comment);
                });
            };
            updateCellCounters(allLines);
        }
    };
    return res;
})();
/*[{!comment_tetris_js_x1zb51n!}]*/