CRU.COMMENT.NAV = (function () {

    var currentCommentId = null;
    var $previouslyHighlightedComment = null;

    function asCommentId(comment) {
        if (comment instanceof AJS.$) {
            comment = comment[0];
        }

        if (!comment) {
            return null;
        } else if (comment.nodeType) {
            return comment.id.replace(/(general|revision|inline|above)(comment|reply)(Content)?/, '');
        } else if (comment instanceof Comment) {
            return comment.id();
        } else if (typeof comment === 'string' ||
            typeof comment === 'number') {
            return comment;
        }
        return null;
    }

    var getCommentDomElements = function (opts, frxId) {
        var inlineComment = /^inlinecomment/;
        var inlineReply = /^inlinereply/;
        if (commentator.showCommentsAbove()) {
            inlineComment = /^abovecomment/;
            inlineReply = /^abovereply/;
        }

        // cache opts values into local variables for faster lookups
        var nextThread = opts.nextThread;

        var comments = frxId ?
            (
                commentator.hideSourceComments() ?
                    review.frx(frxId).fileComments() :
                    review.frx(frxId).comments()
            ) :
            review.generalComments();
        var commentDomIds = []; // List of comment ids to traverse over
        AJS.$.each(comments, function () {
            if (this.frx() && this.frx().isFiltered()) {
                return true;
            }
            var commentDomId = this.domId();
            if (commentator.showCommentsAbove() && /^inline/.test(this.type())) { // if it's an inline comment and they're shown above, change the id
                commentDomId = commentDomId.replace('inline', 'above');
            }

            if (nextThread) {
                if (inlineComment.test(commentDomId) ||
                    /^revisioncomment[0-9]/.test(commentDomId) ||
                    /^generalcomment[0-9]/.test(commentDomId)
                ) {
                    commentDomIds.push("#" + commentDomId);
                }
                // we need to make sure the current reply is also added to the comments
                // so we can find the next comment thread from the reply.
                else if (opts.commentId && opts.commentId == this.id()) { // eslint-disable-line eqeqeq
                    commentDomIds.push("#" + commentDomId);
                }
            }
            else if (inlineComment.test(commentDomId) ||
                inlineReply.test(commentDomId) ||
                /^revisioncomment[0-9]/.test(commentDomId) ||
                /^generalcomment[0-9]/.test(commentDomId) ||
                /^generalreply[0-9]/.test(commentDomId) ||
                /^revisionreply[0-9]/.test(commentDomId)
            ) {
                commentDomIds.push("#" + commentDomId);
            }
        });
        return AJS.$(commentDomIds.length > 0 ? commentDomIds.join(",") : []);
    };

    var scrollDirectlyToCommentImpl = function (destinationCommentId) {
        // ensure destination comment is visible
        var destId = destinationCommentId.replace(/[0-9]+/, '');
        var scrollToCommentId = destinationCommentId.replace(destId, '');
        var destinationComment;
        var $destinationComment;
        if (destId === 'unknownfrx' || destId === 'unknownfrxreply') {
            $destinationComment = AJS.$('#' + review.comment(scrollToCommentId).domId());
            destinationComment = $destinationComment[0];
        } else {
            $destinationComment = AJS.$('#' + destinationCommentId);
            destinationComment = $destinationComment[0];
        }

        //expand comment / comment's parent if it is collapsed, up the tree. Then do the scroll as callback
        CRU.COMMENT.THREAD.expandCommentThread($destinationComment.children("div.comment"), function () {
            var cruFrxNav = CRU.FRX.NAV;
            // scroll to the comment's frx
            var frx;
            if (scrollToCommentId && (frx = review.comment(scrollToCommentId).frx())) {
                cruFrxNav.setCurrentFrx(frx.id(), {
                    scroll: false,
                    changeHash: false
                });
            } else {
                cruFrxNav.setCurrentFrx('generalComments');
            }
            res.scrollToComment(destinationComment);
            window.location.hash = "c" + scrollToCommentId;
        });
    };

    var res = {
        scrollDirectlyToComment: function (destinationCommentId) {
            if (!destinationCommentId) {
                return;
            }
            // ensure destination comment is visible
            var scrollToCommentId = typeof(destinationCommentId) === 'number' ?
                destinationCommentId :
                destinationCommentId.replace(/[^0-9]+/, '');

            var comment = review.comment(scrollToCommentId);
            var frx = comment && comment.frx();

            if ((comment && comment.isHidden()) || (frx && !frx.isLoaded())) {
                var loadOpts;
                loadOpts = {};
                var $sliderRevs = AJS.$(frx.getSliderFrxRevisions());
                var commentFromRevId = comment.fromRevId() ? comment.fromRevId() : comment.toRevId();
                var commentFromRevIndex = $sliderRevs.index(commentFromRevId);
                var visibleToRevIndex = $sliderRevs.index(frx.visibleToRevision());
                if (commentFromRevIndex < visibleToRevIndex) {
                    loadOpts.fromRev = commentFromRevId;
                    loadOpts.toRev = frx.visibleToRevision();
                } else {
                    loadOpts.toRev = comment.toRevId() ? comment.toRevId() : comment.fromRevId();
                    loadOpts.fromRev = frx.visibleFromRevision();
                }

                loadOpts.isForcedReload = true;
                loadOpts.diffMode = CRU.FRX.diffParamsMap(comment.frx().id(), {});

                CRU.FRX.AJAX.prioritisedFrxLoad(frx.id(), function () {
                    scrollDirectlyToCommentImpl(destinationCommentId);
                }, loadOpts);
            } else {
                scrollDirectlyToCommentImpl(destinationCommentId);
            }
        },

        getCurrentCommentDomId: function () {
            if (currentCommentId) {
                var comment = review.comment(currentCommentId);
                if (comment) {
                    if (comment.isInline() && commentator.showCommentsAbove()) {
                        return comment.domId().replace('inline', 'above');
                    } else {
                        return comment.domId();
                    }
                }
                return null;
            } else {
                return null;
            }
        },

        getCurrentCommentContentDomId: function () {
            if (currentCommentId) {
                var comment = review.comment(currentCommentId);
                // The current comment can be deleted
                if (!comment) {
                    return null;
                } else if (comment.isInline() && commentator.showCommentsAbove()) {
                    return comment.contentDomId().replace('inline', 'above');
                } else {
                    return comment.contentDomId();
                }
            } else {
                return null;
            }
        },

        setCurrentComment: function (comment, options) {
            var commentId = asCommentId(comment);
            this.setCurrentCommentById(commentId, options);
        },

        setCurrentCommentById: function (commentId, options) {
            options = AJS.$.extend({sticky: false}, options);
            var scrollTracker = CRU.COMMENT.commentScrollTracker;
            if (currentCommentId !== commentId) {
                // Lookup the previous current comment in case it was deleted.
                if (review.comment(currentCommentId)) {
                    AJS.$('#' + res.getCurrentCommentContentDomId()).removeClass("current_comment");
                }
                currentCommentId = commentId;
                if (commentId) {
                    var $commentContent = AJS.$('#' + res.getCurrentCommentContentDomId())
                        .addClass("current_comment");
                    commentator.markCommentRead(commentId);
                    if (scrollTracker) {
                        scrollTracker.setCurrentElement($commentContent[0]);
                        if (options.sticky) {
                            scrollTracker.makeCurrentElementSticky();
                        }
                    }
                }
            }
        },

        visibleCommentsChanged: function () {
            var scrollTracker = CRU.COMMENT.commentScrollTracker;
            if (scrollTracker) {
                scrollTracker.rescan();
            } else {
                var frxId = CRU.FRX.NAV.getCurrentFrxId();
                var $commentElems = getCommentDomElements({}, frxId === 'generalComments' ? null : frxId);
                if ($commentElems.length > 0) {
                    // Lookup the previous current comment in case it was deleted.
                    if (review.comment(currentCommentId)) {
                        var $currentComment = AJS.$('#' + res.getCurrentCommentContentDomId());
                        if (AJS.$.inArray($currentComment[0], $commentElems.get()) < 0) {
                            res.setCurrentComment($commentElems[0]);
                        }
                    } else {
                        res.setCurrentComment($commentElems[0]);
                    }
                } else {
                    res.setCurrentComment(null);
                }
            }
        },

        scrollToComment: function (commentHandle) {
            var comment = review.comment(asCommentId(commentHandle));
            if (comment) {
                var scrollTracker = CRU.COMMENT.commentScrollTracker;
                var ui = CRU.UI;
                var $comment;

                scrollTracker && scrollTracker.ignoreNextScroll();
                $comment = AJS.$('#' + comment.contentDomId());
                $comment.closest('.comment-container').addClass('show-comment-container');

                if ($comment.length === 1) {
                    ui.scrollToElement($comment[0], {
                        offset: 55
                    });
                }
                res.setCurrentComment(comment.id());

                if ($previouslyHighlightedComment) {
                    $previouslyHighlightedComment.stop(true, true);
                }

                ui.highlightElements($comment, 'with-delay');
                $previouslyHighlightedComment = $comment;
            }
        },

        checkCommentAnchor: function () {
            if (/^#c/.test(window.location.hash)) {
                var commentId = res.commentIdFromAnchor(window.location.hash.replace(/^#/, ''));
                var comment = review.comment(commentId);
                var frxId = review.getCommentFrxId(commentId);

                //navigate to frx first to show frx loading spinner
                if (review.frx(frxId)) {
                    CRU.FRX.NAV.setCurrentFrx(frxId, {
                        initialScroll: false,
                        scroll: false,
                        changeHash: false
                    });
                }

                //then navigate to comment
                var isInlineButNotLoaded = !comment && frxId && !review.frx(frxId).isLoaded();
                if (comment || isInlineButNotLoaded) {
                    var scrollToMap = res.navigateFindComment({commentId: commentId});
                    res.navigateDirectlyToElement({commentId: commentId}, scrollToMap);
                    return scrollToMap.frxId || -1; // -1 for general comment
                } else {
                    window.location.hash = '';
                    CRU.FRX.NAV.setCurrentFrx('generalComments');
                }
            }
            return null;
        },

        nextComment: function (current) {
            current = current || res.getCurrentCommentDomId();
            var opts = {destination: 'next'};
            res.navigateToComment(opts);
        },

        prevComment: function (current) {
            current = current || res.getCurrentCommentDomId();
            var opts = {destination: 'previous'};
            res.navigateToComment(opts);
        },

        nextCommentThread: function (current) {
            current = current || res.getCurrentCommentDomId();
            var opts = {destination: 'next', nextThread: true};
            res.navigateToComment(opts);
        },

        previousCommentThread: function (current) {
            current = current || res.getCurrentCommentDomId();
            var opts = {destination: 'previous', nextThread: true};
            res.navigateToComment(opts);
        },

        /**
         * @param {String} opts.destination location to scroll to - may be <tt>first</tt>, <tt>last</tt>, <tt>previous</tt> or <tt>next</tt>.
         * @param {String} opts.commentId the id of the comment to scroll to. This value overrides the <tt>opts.destination</tt> is <tt>first</tt> and <tt>last</tt>.
         * @param {Boolean} opts.skipReadComments if true, comments which have been marked as read will be passed over and ignored.
         * @param {Boolean} opts.nextThread if true, comment replies will be passed over and ignored.
         * @return the frxId of the frx of the comment if it has one
         */

        navigateToComment: function (opts) {
            var $elementWithSpinner;
            if (opts.destination === 'first' || opts.destination === 'next') {
                $elementWithSpinner = AJS.$('#next-element-link');
            } else {
                $elementWithSpinner = AJS.$('#prev-element-link');
            }
            res.navigateDirectlyToElement(opts, res.navigateFindComment(opts), $elementWithSpinner);
        },

        navigateDirectlyToElementInner: function (opts, scrollToMap, scrollToCommentDomId, $elementWithSpinner) {
            if (scrollToCommentDomId) {
                res.scrollDirectlyToComment(scrollToCommentDomId);
            } else {
                opts.startingFrxId = scrollToMap.frxId;
                opts.startingCommentDomId = null;
                var nextElementMap = CRU.NAV.findNextElement(opts);
                if (nextElementMap && nextElementMap.type === 'comment-unloaded') {
                    // if we landed on another unloaded frx, the navigation is requeued here
                    res.navigateDirectlyToElement(opts, nextElementMap, $elementWithSpinner);
                    return;
                }
                if (nextElementMap && nextElementMap.type === 'frx') {
                    CRU.FRX.scrollFrxPane(nextElementMap.frxId);
                    return;
                }
                if (nextElementMap && nextElementMap.type === 'diff') {
                    CRU.DIFF.NAV.gotoDiff(nextElementMap)
                    return;
                }
                if (!nextElementMap || nextElementMap.type !== 'comment') {
                    AJS.log('no comment found in frx ' + scrollToMap.frxId + ' with ' + opts);
                    return;
                }
                var destCommentId = nextElementMap.gotoElem;
                var destCommentModel = review.comment(destCommentId);
                var destinationComment = AJS.$('#' + destCommentModel.visibleDomId()).get(0);
                if (!destinationComment || !destinationComment.id) {
                    AJS.log('no comment found in frx ' + scrollToMap.frxId + ' with ' + opts);
                    return;
                }
                res.scrollDirectlyToComment(destinationComment.id);
            }
        },

        navigateDirectlyToElement: function (opts, scrollToMap, $elementWithSpinner) {
            if (scrollToMap.type === 'frx') {
                CRU.FRX.scrollFrxPane(scrollToMap.frxId);
            }
            var scrollToComment = review.comment(scrollToMap.gotoElem);
            var scrollToCommentDomId = scrollToComment ? scrollToComment.visibleDomId() : null;
            if (!scrollToMap.frxId) {
                res.scrollDirectlyToComment(scrollToCommentDomId);
            } else {
                var frx = review.frx(scrollToMap.frxId);
                if (frx.isLoaded()) {
                    res.navigateDirectlyToElementInner(opts, scrollToMap, scrollToCommentDomId, $elementWithSpinner);
                } else {
                    //load frx here
                    if ($elementWithSpinner) {
                        $elementWithSpinner.find('span').addClass('spinner');
                    }
                    var onDone = function () {
                        if ($elementWithSpinner) {
                            $elementWithSpinner.find('span').removeClass('spinner');
                        }
                        res.navigateDirectlyToElementInner(opts, scrollToMap, scrollToCommentDomId, $elementWithSpinner);
                    };
                    CRU.FRX.AJAX.prioritisedFrxLoad(frx.id(), onDone);
                }
            }
        },

        /*eslint-disable complexity*/
        findNextComment: function (frxId, startingFrxId, forwards, opts, nextFrxId) {
            var comments;
            var frx = review.frx(frxId);
            if (frxId === "generalComments") {
                comments = review.domOrderedGeneralComments();
            } else {
                comments = frx.domOrderedComments();
            }
            if (!forwards) {
                comments.reverse();
            }

            var j = 0;
            if (frxId === startingFrxId) {
                var startingCommentDomId = opts.startingCommentDomId;
                var startingComment = startingCommentDomId ? review.comment(startingCommentDomId.replace(/^\D*/, "")) : null;
                if (startingCommentDomId) {
                    var $startingComment = AJS.$('#' + startingCommentDomId);
                    j = AJS.$.inArray(startingComment, comments);
                    if (j === -1 ||
                        (forwards && $startingComment.filter(':below-the-fold(5, frx-pane)').length === 0) ||
                        (!forwards && $startingComment.filter(':above-the-top(5, frx-pane)').length === 0)) {
                        j++;
                    }
                } else {
                    // if the previous item we went to was a diff, try to find the next comment from it
                    var currentDiffId = CRU.DIFF.NAV.getCurrentDiffId(frxId);
                    if (currentDiffId != null) {
                        var $diff = CRU.DIFF.NAV.getDiffs(frx).eq(currentDiffId);
                        while ($diff && comments[j] && comments[j].domId() && CRU.DIFF.NAV.diffAfterComment($diff, frx.frxInner().find('#' + comments[j].domId()), forwards)) {
                            j++;
                        }
                    }
                }
            }

            for (var jlen = comments.length; j < jlen; j++) {
                var comment = comments[j];

                if ((opts.findDefect && !opts.findComment) && !comment.defect()) {
                    continue;
                }
                if (opts.skipReadComments && comment.status() === 'read') {
                    continue;
                }
                if (opts.nextThread && comment.isReply()) {
                    continue;
                }
                return {
                    gotoElem: comment.id(),
                    frxId: comment.frx() ? comment.frx().id() : null,
                    type: 'comment',
                    nextFrxId: nextFrxId
                };
            }
        },
        /*eslint-enable*/

        navigateFindComment: function (opts) {
            if (opts.commentId) {
                var comment = review.comment(opts.commentId);
                if (comment) {
                    return {
                        gotoElem: comment.id(),
                        frxId: comment.frx() ? comment.frx().id() : null
                    };
                }
            }

            opts.findComment = true;
            if (opts.destination !== 'first' && opts.destination !== 'last') {
                opts.startingFrxId = CRU.FRX.NAV.getCurrentFrxId();
                opts.startingCommentDomId = res.getCurrentCommentDomId();
            }

            var nextElementMap = CRU.NAV.findNextElement(opts);
            return nextElementMap ? nextElementMap : {};
        },

        // TODO Deprecate, everything should be using the Comment Object
        commentIdFromAnchor: function (commentId) {
            return commentId.replace(/^\D*/, "");
        },

        commentIdFromDomId: function (commentDomId) {
            return commentDomId.replace(/^\D*(\d+)$/, '$1');
        }
    };

    return res;
})();
/*[{!comment_nav_js_ezf451m!}]*/