(function () {

    AJS.$(document).ready(function () {
        var dialogHider = {};

        var contentHandler = function ($contentDiv, trigger, showPopup) {
            var $trigger = AJS.$(trigger);
            var MAX_SUMMARY_LENGTH = 255;
            AJS.$(".create-issue-template").removeClass("create-issue-template").appendTo($contentDiv).show();
            var comment = CRU.COMMENT.commentFromInnerElement($trigger);
            $contentDiv.find(".create-issue-comment-id").val(comment.id());
            var summary = comment.message();
            if (summary && summary.length > MAX_SUMMARY_LENGTH) {
                summary = summary.substr(0, MAX_SUMMARY_LENGTH - 3) + "...";
            }
            $contentDiv.find(".create-issue-summary").val(summary);

            var url = CRU.UTIL.jsonUrlBase(review.id()) + '/assignableUsersForSubtaskAjax/';
            var params = {"commentId": comment.id()};

            var done = function (resp) {
                if (resp.worked) {
                    var assigneeSelect = $contentDiv.find(".create-issue-assignee");
                    assigneeSelect.children(".from-server").remove();
                    var assignees = resp.users;
                    for (var i = 0; i < assignees.length; i++) {
                        var assignee = assignees[i];
                        assigneeSelect.append(AJS.$("<option class='from-server' />")
                            .val(assignee.username)
                            .text(assignee.display));
                    }
                    var assignToMe = $contentDiv.find(".issue-assign-to-me");
                    if (resp.sharedUserBase && review.getLoggedInUser()) {
                        assignToMe.show();
                    } else {
                        assignToMe.hide();
                    }
                }
                $contentDiv.find(".issue-assignee-spinner").hide();
            };

            $contentDiv.find(".issue-assignee-spinner").show();
            FECRU.AJAX.ajaxDo(url, params, done, false);

            $contentDiv.data("dialogHider", dialogHider);
            showPopup();
        };

        var options = {
            onHover: false,
            showArrow: true,
            fadeTime: 200,
            hideDelay: 200,
            showDelay: 200,
            width: 393,
            container: "body",
            useLiveEvents: true,
            cacheContent: false,
            upfrontCallback: function () {
                //provide a hook into the hide function
                var that = this;
                dialogHider.hideDialog = function () {
                    that.hide();
                };
            }
        };

        AJS.InlineDialog(".commentIssueKeyUnlinked", "create-issue-inline-dialog", contentHandler, options);
    });

})();
/*[{!comment_issue_js_foev51l!}]*/