CRU.COMMENT.FORMS = {};

(function ($) {

    /**
     * CommentForm class
     * Base commentForm class extend for specific forms
     */
    var CommentForm = function (id) {
        var name = id;
        var $form;
        var $textBox;
        this.inited = false;

        this.con = function (id) {
            name = id;
        };

        this._init = function () {
            if (!this.inited) {
                var formSourceHtml = CRU.COMMENT.TEMPLATES[name];
                if (formSourceHtml) {
                    $form = AJS.$(formSourceHtml);
                    this.inited = true;
                }
                $form.on('keydown', 'textarea', function (e) {
                    if ((e.metaKey || e.ctrlKey) && e.keyCode === AJS.keyCode.ENTER) {
                        $form.find('.postButton').trigger('click');
                    }
                })
                return false;
            }
            return true;
        };

        this.init = function () {
            return this._init();
        };

        this.getForm = function (skipInit) {
            if (!skipInit) {
                this.init();
            }
            return $form;
        };

        this.getFormElement = function (name) {
            this.init();
            return $form.find('[name=' + name + ']');
        };

        this.getTextBox = function () {
            if (!$textBox || $textBox.length !== 1) {
                $textBox = this.getFormElement('newText');
            }
            return $textBox;
        };

        this.setTextChangeListener = function (l) {
            this.getTextBox().keyup(l);
        };

        this.getCommentText = function () {
            return this.getTextBox().val();
        };

        this.setDefaultFocus = function () {
            (this.getTextBox()[0]).focus();
        };

        this.clearForm = function () {
            this.resetButtons();
            var clear = function (element) {
                try {
                    var $element = AJS.$(element);
                    var type = $element.attr("type");
                    if (type === "checkbox") {
                        $element.removeAttr("checked");
                        $element.val(false);
                    } else if (type === "button" || type === "submit") {
                        // don't do anything to button's values
                        // (in IE6/7, clearing .value clears the button text)
                        $element.removeProp("disabled"); // but make sure they are enabled
                    } else {
                        $element.val("");
                    }
                } catch (e) {
                    //ignore. happens in safari/konqueror when comment form is cleared when not displayed
                }
            };

            // this.getForm().find('input, select, textarea') fails under
            // Safari 3.2 and jQuery 1.3.2 when the form is not yet in the DOM.
            // See http://dev.jquery.com/ticket/4554
            var $form = this.getForm();

            var i;
            var len;
            var $inputs;

            $inputs = $form.find('input')
                .add($form.find('textarea'))
                .add($form.find('select'));

            for (i = 0, len = $inputs.length; i < len; i++) {
                clear($inputs[i]);
            }
        };

        this.resetButtons = function () {
            this.toggleButtons(true);
            this.getFormElement("saveAsDraft").text("Save as draft");
            this.getFormElement("cancelComment").show();
            this.getFormElement("discardComment").hide();
        };

        this.activateAutosaveButtons = function () {
            this.getFormElement("saveAsDraft").text("Keep as draft");
            this.getFormElement("cancelComment").hide();
            this.getFormElement("discardComment").show();
        };

        this.toggleButtons = function (enable) {
            this.getForm().find("button").each(function () {
                try {
                    this.disabled = !enable;
                } catch (e) {
                    //ignore. happens in safari/konqueror when comment form is cleared when not displayed
                }
            });
        };

        this.hasCommentId = function () {
            var cid = this.getCommentId();
            return cid !== "" && cid !== "-1";
        };

        this.getCommentId = function () {
            return this.getFormElement("commentId").val();
        };

        this.setFormVal = function (name, val) {
            this.init();
            try {
                var $formEl = this.getFormElement(name);
                if ($formEl.attr("type") === "checkbox") {
                    $formEl.prop("checked", val);
                }
                $formEl.val(val);
            } catch (e) {
                //ignore. happens in safari/konqueror when comment form is cleared when not displayed
            }
        };

        this.setFormElementVis = function (name, val) {
            this.init();
            try {
                this.getFormElement(name).css("display", val);
            } catch (e) {
                //ignore. happens in safari/konqueror when comment form is cleared when not displayed
            }
        };

        this.showMetrics = function (prefix, show) {
            var nodeName = prefix + "DefectFields";
            toggleNodeAndImage(nodeName, show, !show, true);
        };
    };

    /**
     * CommentForm class
     * This holds a single revision comment form and controls access to the form as well as providing
     * useful methods
     */
    var RevisionCommentForm = function (n) {
        this.con(n);

        this.setFromLines = function (fromLines) {
            this.setFormVal("fromLineRange", fromLines);
        };

        this.init = function () {
            if (this._init()) {
                return;
            }
            var $form = this.getForm(true);
            var permaId = review.id();

            $form
                .on('click', '.postButton', function () {
                    commentAjaxController.addRevisionComment(permaId, $form, false, 'revision');
                }).on('click', '[name=saveAsDraft]', function () {
                    commentAjaxController.addRevisionComment(permaId, $form, true, 'revision');
                }).on('click', '[name=cancelComment]', function () {
                    commentator.clearRevisionCommentBox();
                }).on('click', '[name=discardComment]', function () {
                    var commentId = $form.find('[name=commentId]').val();
                    commentator.discardRevisionCommentBox(commentId, permaId);
                });
        };

        this.setToLines = function (toLines) {
            this.setFormVal("toLineRange", toLines);
        };

        this.setFrxId = function (id) {
            this.setFormVal("frxId", id);
        };

        this.setFromFrxRevision = function (id) {
            this.setFormVal("fromFrxRevisionId", id);
        };

        this.setToFrxRevision = function (id) {
            this.setFormVal("toFrxRevisionId", id);
        };

        this.clearComment = function () {
            this.clearForm();
            this.showMetrics("revision", false);
            this.setFormElementVis("saveAsDraft", "");
        };

        this.populateFromComment = function (comment) {
            this.setFormVal("newText", comment.message());
            this.setFormVal("commentId", comment.id());
            this.setFormVal("toLineRange", comment.toLineRange());
            this.setFormVal("fromLineRange", comment.fromLineRange());
            this.setFormVal("defect", comment.defect());
            var rcf = this;
            AJS.$.each(comment.metrics(), function () {
                rcf.setFormVal(this.key, this.value);
            });
            this.showMetrics("revision", comment.defect());
            if (!comment.draft()) {
                this.setFormElementVis("saveAsDraft", "none");
            }
        };
    };
    RevisionCommentForm.prototype = new CommentForm();

    CRU.COMMENT.FORMS.RevisionCommentForm = RevisionCommentForm;


    var FileCommentForm = function (n) {
        this.con(n);

        this.setFrxId = function (id) {
            this.setFormVal("frxId", id);
        };

        this.clearComment = function () {
            this.clearForm();
            this.showMetrics("file", false);
            this.setFormElementVis("saveAsDraft", "");
        };


        this.init = function () {
            if (this._init()) {
                return;
            }
            var $form = this.getForm(true);
            var permaId = review.id();

            $form.on('click', '.postButton', function () {
                commentAjaxController.addRevisionComment(permaId, $form, false, 'file');
            }).on('click', '[name=saveAsDraft]', function () {
                commentAjaxController.addRevisionComment(permaId, $form, true, 'file');
            }).on('click', '[name=cancelComment]', function () {
                commentator.clearFileCommentForm();
            }).on('click', '[name=discardComment]', function () {
                var commentId = $form.find('[name=commentId]').val();
                commentator.discardFileCommentBox(commentId, permaId);
            });
        };

        this.populateFromComment = function (comment) {
            this.setFormVal("newText", comment.message());
            this.setFormVal("commentId", comment.id());
            this.setFormVal("defect", comment.defect());
            var rcf = this;
            var metrics = comment.metrics();
            for (var i = 0, len = metrics.length; i < len; i++) {
                var m = metrics[i];
                rcf.setFormVal(m.key, m.value);
            }
            this.showMetrics("file", comment.defect());
            if (!comment.draft()) {
                this.setFormElementVis("saveAsDraft", "none");
            }
        };
    };
    FileCommentForm.prototype = new CommentForm();

    CRU.COMMENT.FORMS.FileCommentForm = FileCommentForm;

    var GeneralCommentForm = function (n) {
        this.con(n);

        this.clearComment = function () {
            this.clearForm();
            this.showMetrics("general", false);
            this.setFormElementVis("saveAsDraft", "");
        };

        this.init = function () {
            if (this._init()) {
                return;
            }
            var $form = this.getForm(true);
            var permaId = review.id();

            $form.on('click', '.postButton', function () {
                commentAjaxController.addGeneralComment(permaId, $form, false);
            }).on('click', '[name=saveAsDraft]', function () {
                commentAjaxController.addGeneralComment(permaId, $form, true);
            }).on('click', '[name=cancelComment]', function () {
                commentator.clearGeneralCommentForm();
            }).on('click', '[name=discardComment]', function () {
                var commentId = $form.find('[name=commentId]').val();
                commentator.discardGeneralCommentForm(commentId, permaId);
            });
        };

        this.populateFromComment = function (comment) {
            this.setFormVal("newText", comment.message());
            this.setFormVal("commentId", comment.id());
            this.setFormVal("defect", comment.defect());
            var gcf = this;
            var metrics = comment.metrics();
            for (var i = 0, len = metrics.length; i < len; i++) {
                var m = metrics[i];
                gcf.setFormVal(m.key, m.value);
            }
            this.showMetrics("general", comment.defect());
            if (!comment.draft()) {
                this.setFormElementVis("saveAsDraft", "none");
            }
        };
    };

    GeneralCommentForm.prototype = new CommentForm();

    CRU.COMMENT.FORMS.GeneralCommentForm = GeneralCommentForm;

    var ReplyCommentForm = function (n) {
        this.con(n);

        this.clearComment = function () {
            this.clearForm();
            this.setFormElementVis("saveAsDraft", "");
        };

        this.init = function () {
            if (this._init()) {
                return;
            }
            var $form = this.getForm(true);
            var permaId = review.id();

            $form.on('click', '.postButton', function () {
                commentAjaxController.addReply(permaId, $form, false);
            }).on('click', '[name=saveAsDraft]', function () {
                commentAjaxController.addReply(permaId, $form, true);
            }).on('click', '[name=cancelComment]', function () {
                commentator.clearReplyCommentForm();
            }).on('click', '[name=discardComment]', function () {
                var commentId = $form.find('[name=commentId]').val();
                commentator.discardReplyCommentForm(commentId, permaId);
            });
        };

        this.setReplyToId = function (replyToId) {
            this.setFormVal("replyToId", replyToId);
        };

        this.populateFromComment = function (comment) {
            this.setFormVal("newText", comment.message());
            this.setFormVal("commentId", comment.id());
            if (!comment.draft()) {
                this.setFormElementVis("saveAsDraft", "none");
            }
        };
    };
    ReplyCommentForm.prototype = new CommentForm();

    CRU.COMMENT.FORMS.ReplyCommentForm = ReplyCommentForm;
    var $commentFormsHolder = null;

    /**
     * This is a CommentForm handler class that looks after inserting/removing a comment form inside a parent element
     * It also manages other elements you wish to hide or unhide while displaying the element
     */
    var CommentFormWrangler = function (commentform, namePrefix, autosaveFuncName) {
        var that = this;
        var $switchElement;
        var $frxPane;
        var cForm = commentform;
        var $insertParent;
        var $insertPoint;
        var insertRow = false;
        var displaying = false;
        var $wrapperDiv;
        var divWidth;
        var inited = false;
        var changeParentDisplay = false;
        var autosaveChecksEnabled = false;
        var lastAutosaveDate = new Date();
        var lastTextChangeDate = new Date();
        var lastAutosaveText = "";

        var TableRow = function (id) {
            var $cell = AJS.$(document.createElement('td'));
            var $row = AJS.$(document.createElement('tr'))
                .attr('id', id)
                .append($cell);

            this.setSpan = function (colSpan) {
                $cell.attr('colSpan', colSpan);
            };

            this.getCell = function () {
                return $cell;
            };

            this.getRow = function () {
                return $row;
            };
        };

        function init() {
            if (!inited) {
                $wrapperDiv = $('<div class="commentForm"></div>');
                $wrapperDiv.append(cForm.getForm());
                cForm.setTextChangeListener(that.autosaveTextChanged);
                inited = true;
            }
        }

        this.getCommentForm = function () {
            init();
            return cForm;
        };

        this.setWidth = function (width) {
            $wrapperDiv.width(width);
            divWidth = width;
        };

        this.unsetWidth = function () {
            $wrapperDiv.width('');
            divWidth = null;
        };

        this.setInsertPoint = function (parent, insertAfter) {
            init();
            $insertParent = AJS.$(parent);
            $insertPoint = AJS.$(insertAfter);
            insertRow = $insertParent.is('TABLE') || ($insertParent.is('TBODY') );
        };


        this.setSwitchElement = function (elementId) {
            init();
            $switchElement = AJS.$("#" + elementId);
        };

        this.isDisplaying = function () {
            if (!inited) {
                return false;
            }
            return displaying;
        };

        this.getParent = function () {
            return $insertParent;
        };

        this.isDisplayingRow = function () {
            if (!inited) {
                return false;
            }
            return insertRow;
        };

        function switchParentOn() {
            if ($insertParent.is(":hidden")) {
                changeParentDisplay = true;
                $insertParent.show();
            } else {
                changeParentDisplay = false;
            }
            $switchElement.hide();
        }

        function switchParentOff() {
            if (changeParentDisplay) {
                $insertParent.hide();
            }
            changeParentDisplay = false;
            $switchElement.show();
        }

        /*
         insert/append the element to the parent and hide all the switch elements
         */
        this.insertAndSwitch = function (opts) {
            init();
            if (!displaying) {
                $wrapperDiv.prependTo($insertParent);
                $wrapperDiv.show();
                switchParentOn();
                displaying = true;

                var $generalCommentContainer = $wrapperDiv.parents('#general-comments-container');
                if (!$generalCommentContainer.length) {
                    commentator.setCommentWidths($wrapperDiv.closest('.comment-list'), true);
                } else {
                    $generalCommentContainer.toggleClass('no-comment',
                        !$generalCommentContainer.find('div.comment:visible').length);
                }
            }
            var $wrapperRow = $wrapperDiv.closest('.comment-row');
            $wrapperRow.removeClass('hidden');
            CRU.UI.ensureElementVisible($wrapperDiv, {offset:55});

            var $generalCommentContainer = $wrapperDiv.closest('#generalCommentForm');
            if ($generalCommentContainer.length) {
                $generalCommentContainer.siblings('.comment-form-placeholder').addClass('hidden');
            }
            $wrapperDiv.trigger('comment-form-added');
        };

        this.getCommentRow = function ($lastRow) {
            // Calculate the span of the row
            var $earlierTds = $lastRow.children();
            var colSpan = 0;
            for (var i = 0, len = $earlierTds.length; i < len; i++) {
                var $td = AJS.$($earlierTds[i]);
                var span = parseInt($td.attr('colspan'), 10);
                if (span) {
                    colSpan += span;
                } else {
                    colSpan++;
                }
            }

            var $wrapperRow = $('<tr class="comment-row"><td><div class="comment-list"></div></td></tr>');
            $wrapperRow.find('td').attr('colspan', colSpan);
            return $wrapperRow;
        };

        this.removeAndSwitch = function (opts) {
            init();
            opts = opts || {};

            if (displaying) {
                var $wrapperRow = $wrapperDiv.closest('.comment-row');
                if (!$commentFormsHolder) {
                    $commentFormsHolder = $('<div id="comment-forms-holder"></div>').appendTo('body');
                }

                var $generalCommentContainer = $wrapperDiv.closest('#generalCommentForm');
                if ($generalCommentContainer.length) {
                    $generalCommentContainer.siblings('.comment-form-placeholder').removeClass('hidden');
                }

                $wrapperDiv.appendTo($commentFormsHolder);
                if (opts.isMoving) {
                    if ($wrapperRow.find('> td > .comment-list > .comment-container').children('.comment:visible').length === 0) {
                        $wrapperRow.addClass('hidden');
                    }
                } else {
                    if ($wrapperRow.find('> td > .comment-list').children().length === 0) {
                        $wrapperRow.remove();
                    }
                    switchParentOff();
                    var $commentWrapperRow = $switchElement.closest('.comment-row');
                    $commentWrapperRow.removeClass('hidden');
                }
                displaying = false;
                $('#frx-pane .frxouter.activeFrx').trigger('comment-form-removed');
            }
        };

        /* remove the element from current insertpoint restoring all current switch elements and
         put it in the new insert point with the new switch and display
         */
        this.exchange = function (parent, insertBefore, newSwitchElementId, withoutCommentList) {
            init(withoutCommentList);
            var requireResetParent = !$insertParent || parent.get(0) !== $insertParent.get(0);
            if (displaying && requireResetParent) {
                this.removeAndSwitch();
            }
            this.setSwitchElement(newSwitchElementId);
            if (requireResetParent) {
                this.setInsertPoint(parent, insertBefore);
            }
            this.insertAndSwitch();
        };

        this.move = function ($parent, insertBefore) {
            this.setInsertPoint($parent, insertBefore);
            this.removeAndSwitch({
                isMoving: true
            });
            this.insertAndSwitch({
                isMoving: true
            });
        };

        this.formOpened = function (isdraft) {
            cForm.resetButtons();
            autosaveChecksEnabled = isdraft;
            AJS.$("#" + namePrefix + "AutosaveMsg").html("");
            if (autosaveChecksEnabled) {
                if (cForm.hasCommentId()) {
                    cForm.activateAutosaveButtons();
                }
                lastAutosaveDate = new Date();
                lastTextChangeDate = new Date();
                lastAutosaveText = cForm.getCommentText();
            }
        };

        this.formClosed = function () {
            autosaveChecksEnabled = false;
        };

        /**
         * Converts a date object to a string in the format of HH:MM [AM|PM]
         * @param d date object to stringify
         */
        var date2TimeOfDay = function (d) {
            var s = "AM";
            var h = d.getHours();
            var m = d.getMinutes();

            if (h === 12) {
                s = "PM";
            } else if (h > 12) {
                s = "PM";
                h = h - 12;
            }
            m = "" + m;
            if (m.length < 2) {
                m = "0" + m;
            }
            return h + ":" + m + " " + s;
        };

        this.autosaveTimerPing = function () {
            if (!autosaveChecksEnabled || CRU.COMMENT.commentAjaxExecutor.isPending() || !that.isDisplaying()) {
                return;
            }

            var now = new Date();
            var sinceLastSave = now.getTime() - lastAutosaveDate.getTime();
            var sinceLastEdit = now.getTime() - lastTextChangeDate.getTime();

            if ((sinceLastSave < 30000) && (sinceLastEdit < 2000)) {
                // don't bother saving if they have edited in the last 2s
                // until 30s passes
                return;
            }

            var currentText = cForm.getCommentText();
            if (currentText === lastAutosaveText) {
                return;
            }

            if (/^\s*$/.test(currentText)) {
                return; // you can't save empty comments at the moment
            }

            lastAutosaveText = currentText;
            lastAutosaveDate = now;

            cForm.toggleButtons(false);

            var done = function (resp) {
                cForm.toggleButtons(true);

                if (resp.worked) {
                    resp.autoSaveAction = true;

                    AJS.$("#" + namePrefix + "AutosaveMsg").text("Autosaved at " + date2TimeOfDay(new Date()));
                    cForm.setFormVal("commentId", resp.comment.id);
                    commentator.createOrUpdateComment(resp);
                    commentator.updateCommentCount(resp);

                    cForm.activateAutosaveButtons();
                } else {
                    AJS.$("#" + namePrefix + "AutosaveMsg").text("problem autosaving");
                }
            };

            var autosaveFunc = eval(autosaveFuncName);
            autosaveFunc(permaId, cForm.getForm(), done); // NB: permaId is a global
            AJS.$("#" + namePrefix + "AutosaveMsg").text("Autosaving...");
        };

        this.autosaveTextChanged = function () {
            if (!autosaveChecksEnabled) {
                return;
            }
            var currentText = cForm.getCommentText();
            if (currentText === lastAutosaveText) {
                return;
            }

            lastTextChangeDate = new Date();

            var $autosaveMsg = AJS.$("#" + namePrefix + "AutosaveMsg");
            var msg = $autosaveMsg.text();
            if (msg !== "" && !/\*$/.test(msg)) {
                // put an astrix at the end when it is unsaved
                $autosaveMsg.text(msg + " *");
            }
            msg = "changed, not saved";
        };
    };

    CRU.COMMENT.FORMS.CommentFormWrangler = CommentFormWrangler;
})(AJS.$);
/*[{!comment_form_js_c5hu51k!}]*/