(function ($) {
    var $document = $(document);
    // On load
    $document.ready(function () {

        var $panelTarget = $('#panel-target');

        $panelTarget.delegate("input[name='defect']", 'click', function () {
            var $this = $(this);
            var $fields = $this.parent().siblings(".defectFields");
            var isChecked = $this.is(':checked');
            $this.val(isChecked);
            if (isChecked) {
                $fields.show();
            } else {
                $fields.hide();
            }
        });

        $panelTarget.delegate(".commentForm .copyCode", 'click', function () {
            var $lines = $(this).closest('.inlineSource').find('.lineHighlighted .lineContent');

            var text = "{code}";
            for (var i = 0, len = $lines.length; i < len; i++) {
                if (i !== 0) {
                    text += '\n';
                }
                text += $($lines[i]).text();
            }
            text += '{code}';

            var $textarea = $(this).closest('.commentForm').find('.commentTextarea');
            $textarea.val($textarea.val() + '\n' + text);
        });

        var isCommentToggling = false;
        //comment collapse live event
        $panelTarget.delegate(".comment:not(.hover-comment) .author, .comment:not(.hover-comment) .reply-count",
            "click.collapse_comment", function () {
                var comment = $(this).closest(".comment");
                var commentContainer = comment.parent();
                if (isCommentToggling) {
                    return;
                }
                isCommentToggling = true;

                //check whether the edit comment form is being displayed on a comment that is a child of the comment being
                //collapsed, and if it is, stop the collapse - lest we lose the edit
                var commentForm = commentator.getDisplayingReplyForm();
                if (commentForm) {
                    var $commentForm = $(commentForm.getForm());
                    var containsOpenEditForm = $commentForm.closest("#" + commentContainer.attr("id")).length > 0;
                    if (containsOpenEditForm) {
                        $commentForm.find(".autosavemessage").text("please save or cancel before collapsing a comment");
                        commentForm.getTextBox().focus();
                        return;
                    }
                }

                var commentBody = comment.find(".comment-body");
                var excerpt = comment.find(".excerpt");
                var replyContainer = commentContainer.children(".reply-container");
                var height;
                var COLLAPSED_HEIGHT = 60;

                if (commentContainer.hasClass("comment-collapsed")) {
                    commentContainer.addClass('comment-expanding')
                        .removeClass("comment-collapsed");
                    height = commentContainer.data('old-height');
                    commentContainer.height(height);

                    setTimeout(function () {
                        commentContainer.height('auto')
                            .removeClass('comment-expanding');
                        isCommentToggling = false;
                        commentBody.trigger('comment-collapsed');
                    }, 800);

                } else {
                    var count = replyContainer.find(".comment").length;
                    if (count > 0) {
                        var replyCountContainer = excerpt.find(".reply-count");
                        replyCountContainer.html('<span class="aui-badge">' + count + '</span><span class="link">'
                            + (count === 1 ? "reply" : "replies") + ' hidden</span>');
                    }
                    height = commentContainer.height();
                    commentContainer.data('old-height', height)
                        .height(height);
                    var newHeight = COLLAPSED_HEIGHT;

                    setTimeout(function () {
                        commentContainer.height(newHeight);
                        commentContainer.addClass('comment-collapsing');
                        setTimeout(function () {
                            commentContainer.removeClass('comment-collapsing')
                                .addClass("comment-collapsed");
                            isCommentToggling = false;
                            commentBody.trigger('comment-collapsed');
                        }, 800);
                    }, 20);
                }
            });

        $panelTarget.delegate('.hover-comment .comment-permalink', 'click', function () {
            var comment_nav = CRU.COMMENT.NAV;
            var commentId = $(this).attr('href').replace(/[^0-9]+/g, '');
            var scrollToMap = comment_nav.navigateFindComment({commentId: commentId});
            comment_nav.navigateDirectlyToElement({commentId: commentId}, scrollToMap);
        });

        // Click to focus comments and mark as read.
        $panelTarget.delegate('#frxs .frxouter .comment', 'click', function () {
            var commentId = this.id.replace(/(general|revision|inline|above)commentContent/, '');
            if (!$(this).is('.hover-comment')) {
                CRU.COMMENT.NAV.setCurrentComment(commentId, {sticky: true});
            }
        });

        $panelTarget.delegate(".comment a.publishComment:not(.disabled)", "click", function () {
            var comment = CRU.COMMENT.commentFromInnerElement(this);
            commentator.publishComment(comment.id(), permaId);
        });

        $panelTarget.delegate(".comment a.replyToComment", "click", function () {
            var cru = CRU;
            var comment = cru.COMMENT.commentFromInnerElement(this);
            var visiblePos = comment.visiblePosition();
            var id = comment.id();
            var handleId = visiblePos + "replyFormDiv" + id + "Handle";
            var parentId = visiblePos + "replyFormDiv" + id;
            commentator.displayReplyCommentForm(handleId, parentId, comment.id());
            cru.REVIEW.WIKI.resetPreview();
        });

        $panelTarget.delegate(".comment a.editComment", "click", function () {
            var cru = CRU;
            var comment = cru.COMMENT.commentFromInnerElement(this);
            var commentId = comment.id();
            var position = comment.visiblePosition();
            var handleId = position + "commentContent" + commentId;
            var parentId = position + "commentEdit" + commentId;

            var isReply = comment.isReply();
            var $p = $("#" + parentId);
            cru.REVIEW.WIKI.resetPreview();

            if (isReply) {
                commentator.displayReplyCommentForm(handleId, parentId, comment.replyTo().id(), commentId);
            } else {
                var frx = comment.frx();
                if (frx) {
                    var frxId = frx.id();
                    if (comment.isInline()) {
                        commentator.displayRevisionCommentForm(handleId, parentId, frxId, commentId);
                    } else {
                        commentator.displayFileCommentForm(handleId, parentId, frxId, commentId);
                    }
                } else {
                    commentator.displaySimpleCommentForm(handleId, parentId, commentId);
                }
            }
        });

        $panelTarget.delegate(".comment a.deleteComment:not(.disabled)", "click", function () {
            var comment = CRU.COMMENT.commentFromInnerElement(this);
            commentator.deleteComment(comment.id(), permaId);
        });

        $panelTarget.delegate(".comment a.toggleCommentRead", "click", function () {
            var comment = CRU.COMMENT.commentFromInnerElement(this);
            commentator.toggleCommentRead(comment.id(), true);
        });

        $document.delegate(".create-issue-dialog input.create-issue-button", "click", function () {
            var dialog = $(this).closest(".contents");
            commentAjaxController.linkIssue(dialog);
            dialog.data("dialogHider").hideDialog();
        });

        $document.delegate(".create-issue-dialog span.issue-assign-to-me", "click", function () {
            $(this).closest(".contents").find(".create-issue-assignee").val(review.getLoggedInUser().userName);
        });

        $document.delegate(".create-issue-dialog span.close", "click", function () {
            $(this).closest(".contents").data("dialogHider").hideDialog();
        });

        $panelTarget.delegate(".comment a.commentIssueResolveButton", "click", function () {
            var comment = CRU.COMMENT.commentFromInnerElement(this);
            commentAjaxController.resolveIssue(comment.id());
        });

        $panelTarget.delegate("a.comment-skipped", "click", function () {
            var commentId = this.id.replace('comment-skipped', '');
            var comment = review.comment(commentId);

            // Presumably, this should never happen - you can't have a skipped comment which isn't inline
            if (!comment || !comment.frx()) {
                return;
            }

            var done = function () {
                CRU.COMMENT.NAV.scrollDirectlyToComment(comment.domId());
            };

            // show full context for the frx
            CRU.FRX.toggleDiffModeAjax(review.id(), comment.frx().id(), '-1', done);
        });
    });

})(AJS.$);
/*[{!comment_event_js_nqut51j!}]*/