window.CRU = window.CRU || {};
CRU.COMMENT = {};

var commentAjaxController = (function () {
    /*****************
     * PRIVATE STUFF *
     *****************/
    function isEmptyComment(form, nameprefix) {
        var empty = false;
        var newText = form['newText'];

        if (newText && /^\s*$/.test(newText.value)) {
            empty = true;
            AJS.$("#" + nameprefix + "AutosaveMsg").html("Cannot save or post an empty comment.");
            AJS.$(form).removeClass('disabled');
        }

        return empty;
    }

    function progressIssueLinkClass(commentId, from, to) {
        getCommentElements(commentId, 'commentIssueKey_')
            .removeClass('commentIssueKey' + from)
            .addClass('commentIssueKey' + to);
        getCommentElements(commentId, 'commentIssueStatus_')
            .removeClass('commentIssueStatus' + from)
            .addClass('commentIssueStatus' + to);
        if (to === "Linking") {
            getCommentElements(commentId, 'busyCommentIssue').show();
        } else {
            getCommentElements(commentId, 'busyCommentIssue').hide();
        }
    }

    function getCommentElements(commentId, elementSuffix) {
        var comment = review.comment(commentId);
        if (comment.isInline()) {
            return AJS.$('#above' + elementSuffix + commentId +
                ',#inline' + elementSuffix + commentId);
        } else if (comment.frx()) {
            return AJS.$('#revision' + elementSuffix + commentId);
        } else {
            return AJS.$('#general' + elementSuffix + commentId);
        }
    }

    function commentButtonSyncWrapper(callback) {
        return function (resp) {
            if (callback) {
                callback(resp);
            }
            commentator.syncCommentButtons();
        };
    }

    /*****************
     * PUBLIC  STUFF *
     *****************/
    var res = {
        // General comment methods
        publishComment: function (commentId, permaId, done) {
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/publishCommentAjax/';
            var params = {"commentId": commentId};

            var onDone = function (resp) {
                if (done) {
                    done(commentId, resp);
                    // Re-enable child draft post links
                    var children = review.comment(commentId).getReplies();
                    for (var i = 0, len = children.length; i < len; i++) {
                        var child = children[i];
                        if (child.draft()) {
                            AJS.$("#generaldraftPublish" + child.id() + "," +
                                "#revisiondraftPublish" + child.id() + "," +
                                "#inlinedraftPublish" + child.id()).removeClass("disabled");
                        }
                    }
                }
            };
            var onComplete = commentButtonSyncWrapper(onDone);
            FECRU.AJAX.ajaxDo(url, params, onComplete);
            return false;
        },

        addReply: function (permaId, form, draft) {
            var $form = AJS.$(form);
            $form.addClass('disabled');
            $form.find('textarea').blur();
            if (!isEmptyComment(form, "reply")) {

                var done = function (resp) {

                    $form.removeClass('disabled');
                    if (resp.worked) {
                        commentator.insertAjaxReply(resp);
                        commentator.updateCommentCount(resp);
                        var readCommentIds = resp.readCommentIds;
                        for (var i = 0, len = readCommentIds.length; i < len; i++) {
                            var readCommentId = readCommentIds[i];
                            var readComment = review.comment(readCommentId);
                            if (readComment) { // just being defensive
                                commentator.changeCommentStatus(readCommentId, "read", readComment.status());
                            }
                        }
                        CRU.COMMENT.NAV.setCurrentComment(resp.comment.id);

                        var $commentElement = AJS.$('.comment' + resp.comment.id + ' .comment');
                        $commentElement.trigger('comment-reply-added');
                    }
                };
                var onComplete = commentButtonSyncWrapper(done);
                CRU.COMMENT.commentAjaxExecutor.executeAjaxJob({
                    url: CRU.UTIL.jsonUrlBase(permaId) + '/replyAjax/',
                    params: function () {
                        return $form.serialize() + "&draft=" + (draft ? draft : false);
                    },
                    callback: onComplete
                });
            }
            return false;
        },

        addGeneralComment: function (permaId, $form, draft) {
            // todo: need a spinner?
            $form.addClass('disabled');
            $form.find('textarea').blur();
            if (!isEmptyComment($form.get(0), "general")) {

                var done = function (resp) {
                    $form.removeClass('disabled');
                    commentator.insertAjaxGeneralComment(resp); //checks worked
                };
                var onComplete = commentButtonSyncWrapper(done);
                CRU.COMMENT.commentAjaxExecutor.executeAjaxJob({
                    url: CRU.UTIL.jsonUrlBase(permaId) + '/generalCommentAjax/',
                    params: function () {
                        return $form.serialize() + "&draft=" + (draft ? draft : false);
                    },
                    callback: onComplete
                });
            }
            return false;
        },

        addRevisionComment: function (permaId, form, draft, namePrefix) {
            var $form = AJS.$(form);
            if (!isEmptyComment(form, namePrefix)) {
                $form.addClass('disabled');
                $form.find('textarea').blur();
                var done = function (resp) {
                    $form.removeClass('disabled');
                    commentator.insertRevisionComment(resp); //checks worked
                    if (resp.worked) {
                        tetrisCommentController.renderTetrisCommentMarkersForComment(resp.comment.id);
                    }
                };
                var onComplete = commentButtonSyncWrapper(done);
                CRU.COMMENT.commentAjaxExecutor.executeAjaxJob({
                    url: CRU.UTIL.jsonUrlBase(permaId) + '/revisionCommentAjax/',
                    params: function () {
                        return $form.serialize() + "&draft=" + (draft ? draft : false);
                    },
                    callback: onComplete
                });
            }
            return false;
        },

        autoSaveReply: function (permaId, form, done) {
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/replyAjax/';
            var params = AJS.$(form).serialize() + "&draft=true";
            CRU.COMMENT.commentAjaxExecutor.executeAjax(url, params, done, true);
        },

        autoSaveGeneralComment: function (permaId, form, done) {
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/generalCommentAjax/';
            var params = AJS.$(form).serialize() + "&draft=true";
            CRU.COMMENT.commentAjaxExecutor.executeAjax(url, params, done, true);
        },

        autoSaveRevisionComment: function (permaId, form, done) {
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/revisionCommentAjax/';
            var params = AJS.$(form).serialize() + "&draft=true";
            CRU.COMMENT.commentAjaxExecutor.executeAjax(url, params, done, true);
        },

        deleteComment: function (commentId, permaId, done) {
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/deleteCommentAjax/';
            var params = {"commentId": commentId};
            var onComplete = commentButtonSyncWrapper(done);
            FECRU.AJAX.ajaxDo(url, params, onComplete);
            return false;
        },

        // Comment read status
        updateCommentReadStatus: function (commentId, permaId, markAsRead, done) {
            // Prevent simultaneous requests.

            var url = CRU.UTIL.jsonUrlBase(permaId) + '/commentReadStatusAjax/';
            var params = {"commentId": commentId, "markAsRead": markAsRead};
            var onComplete = commentButtonSyncWrapper(done);

            return FECRU.AJAX.ajaxDo(url, params, onComplete);
        },

        markAllCommentsRead: function (updatedComments, permaId, done) {
            if (updatedComments.length > 0) {
                var url = CRU.UTIL.jsonUrlBase(permaId) + '/commentReadStatusAjax/';
                var params = {
                    markAsRead: true,
                    cid: AJS.$.map(updatedComments, function (comment) {
                        return comment.id();
                    })
                };

                var onComplete = commentButtonSyncWrapper(done);
                FECRU.AJAX.ajaxDo(url, params, onComplete);
            }
            return false;
        },

        loadCommentIssueStatuses: function (frxId) {
            var commentIdsWithLinkedIssues = [];
            var comments;
            if (frxId) {
                comments = review.frx(frxId).comments();
            } else {
                comments = review.generalComments();
            }
            AJS.$.each(comments, function () {
                var comment = review.comment(this.id());
                if (comment.issueKey() && comment.issueKey() !== "") {
                    commentIdsWithLinkedIssues.push(comment.id());
                }
            });
            if (commentIdsWithLinkedIssues.length === 0) {
                return;
            }
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/getCommentIssueStatusAjax/';
            var params = {"commentIds": commentIdsWithLinkedIssues};
            var done = function (resp) {
                if (resp.worked) {
                    var issues = resp.issues;
                    for (var i = 0, len = issues.length; i < len; i++) {
                        var issue = issues[i];
                        res.processStatusText(issue.commentId, issue);
                    }
                }
            };
            FECRU.AJAX.ajaxDo(url, params, done);
        },

        resolveIssue: function (commentId) {
            getCommentElements(commentId, 'busyCommentIssue_').show();
            getCommentElements(commentId, 'commentIssueResolve_').hide();

            var url = CRU.UTIL.jsonUrlBase(permaId) + '/resolveCommentIssueAjax/';
            var params = {"commentId": commentId};
            var done = function (resp) {
                res.processStatusText(commentId, resp);
            };
            FECRU.AJAX.ajaxDo(url, params, done);
        },

        processStatusText: function (commentId, resp) {
            var $statusElems = getCommentElements(commentId, 'commentIssueStatus_');
            if (resp.worked) {
                var key = getCommentElements(commentId, 'commentIssueKey_').find('.jira-hover-trigger').children('a').text();
                FECRU.HOVER.invalidateCache(FECRU.HOVER.CACHE_FOREVER, key);
                $statusElems.text(resp.issueStatus);
                review.comment(commentId).setIssueStatus(resp.issueStatus);
            }
            var $statusElem = $statusElems.filter(':first');
            var statusElemText = $statusElem.text().toLowerCase();
            if (statusElemText === 'resolved' || statusElemText === 'closed' || statusElemText === 'error') {
                getCommentElements(commentId, 'commentIssueResolve_').hide();
            } else {
                getCommentElements(commentId, 'commentIssueResolve_').show();
            }
            getCommentElements(commentId, 'busyCommentIssue_').hide();
        },

        linkIssue: function (issueDialog) {
            var summary = issueDialog.find(".create-issue-summary").val();
            var commentId = issueDialog.find(".create-issue-comment-id").val();
            var assignee = issueDialog.find(".create-issue-assignee").val();
            getCommentElements(commentId, 'busyCommentIssue_').show();
            progressIssueLinkClass(commentId, 'Unlinked', 'Linking');
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/linkCommentIssueAjax/';
            var params = {"commentId": commentId, "summary": summary, "assignee": assignee};
            var done = function (resp) {
                if (resp.worked) {
                    var comment = review.comment(commentId);
                    getCommentElements(commentId, 'commentIssueKey_').html(resp.issueHoverHtml);
                    comment.setIssueKey(resp.issueKey);
                    progressIssueLinkClass(commentId, 'Linking', 'Linked');

                    res.processStatusText(commentId, resp);
                } else {
                    progressIssueLinkClass(commentId, 'Linking', 'Unlinked');
                }
                getCommentElements(commentId, 'busyCommentIssue_').hide();
            };
            FECRU.AJAX.ajaxDo(url, params, done);
        }

    };
    return res;
})();
/*[{!comment_ajax_js_35np51i!}]*/