window.CRU = window.CRU || {};
CRU.PATCHES = (function ($) {

    var fecruAjax = FECRU.AJAX;

    function ajaxCall($controls, params, callback) {
        if ($controls.is('.disabled')) {
            return;
        }

        params = params || {};
        if (params.patchId == null) {
            params.patchId = $controls.attr('id').replace('patch-controls-', '');
        }

        fecruAjax.startSpin($controls);
        $controls.find('select').prop('disabled', true);
        var $controlButtons = $controls.find('.patch-control-buttons');
        $controlButtons.addClass('disabled');
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/anchor-patch/';

        var cancelled = false;
        var ended = false;

        fecruAjax.ajaxDo(url, params, function (resp) {
            $controls.data('cancel', null);
            if (cancelled) {
                return;
            }
            ended = true;

            //replace controls

            var $messagesContainer = $("#anchor-messages-container");
            $messagesContainer.html('');
            if (resp.showErrors) {
                var errorTitle;
                if (params && params.allrepos) {
                    errorTitle = 'No repository found to anchor patch to';
                } else if (params && params.anchorSource) {
                    errorTitle = 'Crucible cannot anchor the patch to this repository'
                } else {
                    errorTitle = null;
                }

                $.each(resp.errors, function (index, value) {
                    AJS.messages.warning($messagesContainer, {
                        title: errorTitle,
                        body: value
                    })
                });
            }

            if (resp.showMessages) {
                $.each(resp.messages, function (index, value) {
                    AJS.messages.success($messagesContainer, {
                        body: value
                    })
                });
            }

            endAjaxCall($controls, $controlButtons);
            callback && callback(resp);
        });

        $controls.data('cancel', function cancel() {
            if (ended) {
                return;
            }
            cancelled = true;
            callback && callback();
            endAjaxCall($controls, $controlButtons);
        });
    }

    function endAjaxCall($controls, $controlButtons) {
        fecruAjax.stopSpin($controls[0], 'span');

        $controls.find('select').prop('disabled', false);
        $controlButtons.removeClass('disabled');
    }

    function removePaths($repoSelect, $pathSelectSection) {
        $repoSelect.val('');
        $pathSelectSection.addClass('hidden').data('forRepo', '');
    }

    function populatePaths($repoSelect, $pathSelectSection, optionsString, anchorSource) {

        if ($pathSelectSection.data('forRepo') === anchorSource) {
            return;
        }

        if (optionsString == null) {
            removePaths($repoSelect, $pathSelectSection);
            return;
        }

        $repoSelect.val(anchorSource);

        var $pathSelect = $pathSelectSection.find("select.anchored-path-edit");
        if (optionsString !== "") {
            $pathSelect.html(optionsString);
            $pathSelectSection.removeClass('hidden');
        } else {
            $pathSelectSection.addClass('hidden');
        }
        $pathSelectSection.data('forRepo', anchorSource);
    }

    function anchorPatch($controls, params) {
        $controls.removeClass('editing viewing').addClass('anchoring');
        ajaxCall($controls, params, function (resp) {
            $controls.removeClass('anchoring');

            if (resp && resp.worked) {
                if (resp.anchorSucceeded) { // true if the anchor succeeds or the unanchor succeeds, but not if there are errors either way.
                    var anchored = !!resp.anchorRepo;
                    $controls.addClass('viewing')
                        .toggleClass('anchored', anchored)
                        .toggleClass('unanchored', !anchored);

                    var $currentAnchor = $controls.find('.current-anchor');
                    $currentAnchor.children('.anchored-source').text(resp.anchorRepo);
                    $currentAnchor.children('.anchored-path').text(resp.anchorPath);
                    updateIterablePatches(params)
                } else {
                    $controls.addClass('editing');
                    updateIterablePatches(null)
                }

                populatePaths(
                    $controls.find('.anchored-source-edit'),
                    $controls.find('.anchor-path-selection'),
                    resp.candidatePaths,
                    resp.anchorRepo || params && params.anchorSource);
            } else if (!resp) {
                // cancelled
                removePaths(
                    $controls.find('.anchored-source-edit'),
                    $controls.find('.anchor-path-selection'));
                updateIterablePatches(null)
            }
        });
    }

    function getPaths($controls, anchorSource, callback) {
        if (!anchorSource) {
            callback && callback();
            return;
        }

        var $pathSelectSection = $controls.find('.anchor-path-selection');
        if ($pathSelectSection.data('forRepo') === anchorSource) {
            callback && callback();
        } else {
            var params = {
                anchorSource: anchorSource,
                showCandidatePaths: true
            };
            ajaxCall($controls, params, function (resp) {
                if (resp && resp.worked) {
                    populatePaths(
                        $controls.find('.anchored-source-edit'),
                        $pathSelectSection,
                        resp.candidatePaths,
                        anchorSource);

                    callback && callback();
                } else if (!resp) {
                    // cancelled
                    removePaths(
                        $controls.find('.anchored-source-edit'),
                        $controls.find('.anchor-path-selection'));
                }
            });
        }
    }

    function updateIterablePatches(params) {
        var $choosePatch = $('#choose-existing-patch');
        if (!params) {
            $choosePatch.html('');
            $('#add-to-existing-patch').prop('disabled', true);
            $('#new-patch').prop('checked', true);
        } else {
            getIterablePatches($choosePatch, params.patchId)
        }
    }

    function getIterablePatches($target, patchId) {
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/iterable-patches/';
        fecruAjax.startSpin($('#anchor-repository'));
        fecruAjax.ajaxDo(url, {patchId: patchId}, function (resp) {
            fecruAjax.stopSpin($('#anchor-repository'));
            if (resp.found === 'true') {
                $('#patch-action').show();
                $target.html(resp.payload);
                var $add = $("#add-to-existing-patch");
                $add.prop('disabled', false);
                $add.prop('checked', true);
                $target.find('input').first().prop('checked', 'true')
            } else {
                $target.html('');
            }
        });
    }

    return {
        getPaths: getPaths,
        anchorPatch: anchorPatch
    };
})(AJS.$);
/*[{!patch_ui_js_yvkx50u!}]*/