(function () {

    var $container = FECRU.DIALOG.getAjaxDialogContainer();

    var dialogHandler = function (callbacks) {
        return function (event) {
            var dialog = $container.data('dialog');
            var permaId = $container.data('permaId');

            if (CRU.UTIL.isReviewPage() && callbacks.review) {
                return callbacks.review(dialog, permaId, event);
            } else if (!CRU.UTIL.isReviewPage() && callbacks.external) {
                return callbacks.external(dialog, permaId, event);
            }
        };
    };

    var viewFiltersHandler = function (filters) {
        return dialogHandler({
            review: function (dialog) {
                if (AJS.$('body').hasClass('review-updated')) {
                    window.location.hash = 'f-' + filters.join(',');
                    window.location.reload(true);
                } else {
                    CRU.REVIEW.UTIL.filterAndExpandFrxs(filters);
                    dialog.remove();
                }
            },
            external: function (dialog, permaId) {
                window.location = CRU.UTIL.urlBase(permaId) + '#f-' + filters.join(',');
            }
        });
    };

    var batchProcessDraftComments = function (action, permaId, onComplete) {
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/draftCommentsAjax';
        var params = {
            action: action
        };
        var done = function (resp) {
            if (onComplete) {
                onComplete(resp);
            }
        };
        FECRU.AJAX.ajaxDo(url, params, done, true);
    };

    var draftCommentsHandler = function (action) {
        return dialogHandler({
            review: function (dialog, permaId) {
                function toggleSpinner(spinnerSelector) {
                    var spinner = AJS.$(spinnerSelector);
                    if (spinner.is(':hidden')) {
                        spinner.removeClass('hidden');
                        spinner.spin();
                    } else {
                        spinner.spinStop();
                        spinner.addClass('hidden');
                    }
                }

                var successMsg;
                var failMsg;
                var closeButton = AJS.$('#' + dialog.id).find('.button-panel-button');
                closeButton.prop('disabled', true);

                if (action === 'publish') {
                    closeButton.text('Posting drafts');
                    toggleSpinner('#dialog-post-drafts-spinner');

                    successMsg = 'Your draft comments have been posted.';
                    failMsg = 'Posting some of your draft comments failed with an error: ';
                }

                batchProcessDraftComments(action, permaId, function (resp) {
                    AJS.$('#dialog-drafts-links').hide();
                    closeButton.prop('disabled', false);
                    if (resp.worked) {
                        AJS.$('#dialog-drafts-message').html(successMsg);
                        closeButton.text('Close');
                        CRU.REVIEW.UTIL.reloadReview(true);
                    } else {
                        var msg;
                        if (resp.errorMsg) {
                            msg = failMsg + '<br/>' + resp.errorMsg;
                        } else {
                            msg = "Request has failed with an status error: " + resp.status;
                        }
                        AJS.$('#dialog-drafts-message').html(msg);
                        closeButton.text('Close Anyway');
                    }
                });
            },
            external: function (dialog, permaId) {
                batchProcessDraftComments(action, permaId, function (resp) {
                    if (resp.worked) {
                        AJS.$('#dialog-drafts-links').hide();
                    } else {
                        // TODO Show error message within dialog panel.
                    }
                });
            }
        });
    };

    var resolveUnresolvedJiras = function () {
        var doIt = function (dialog, permaId) {
            AJS.$('#dialog-unresolved-jiras-controls').hide();
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/resolveAllSubtasksAjax';
            var params = {};
            AJS.$('#dialog-unresolved-jiras-spinner').show();
            var done = function (resp) {
                AJS.$('#dialog-unresolved-jiras-spinner').hide();
                if (resp.worked) {
                    AJS.$('#dialog-unresolved-jiras-title').html("There are no unresolved subtasks.").show();
                } else {
                    AJS.$('#dialog-unresolved-jiras-results').addClass("jira-error").html(resp.errorMsg).show();
                }
            };
            FECRU.AJAX.ajaxDo(url, params, done, true);
        };
        return dialogHandler({review: doIt, external: doIt});
    };

    AJS.$(document).ready(function () {
        var $document = AJS.$(document);
        $document.delegate('#dialog-view-drafts', 'click', viewFiltersHandler(['draftcomments']));
        $document.delegate('#dialog-view-unread-comments', 'click', viewFiltersHandler(['unreadcomments']));
        $document.delegate('#dialog-view-incomplete-frxs', 'click', viewFiltersHandler(['incomplete']));
        $document.delegate('#dialog-view-unresolved-jiras', 'click', viewFiltersHandler(['unresolvedsubtasks']));

        $document.delegate('#dialog-post-drafts', 'click', draftCommentsHandler('publish'));
        $document.delegate('#dialog-resolve-unresolved-jiras', 'click', resolveUnresolvedJiras());
    });

})();
/*[{!dialog_event_js_bq41511!}]*/