window.CRU = window.CRU || {};
CRU.CREATE = {};

(function ($) {
    var cruCreate = CRU.CREATE;

    cruCreate.changesets = {}; // map of csid -> array of revids
    cruCreate.revid2csid = {};
    cruCreate.revidsInIteration = {};
    cruCreate.repnameInUse = "";
    cruCreate.explorer = {};

    cruCreate.addLatestRevision = function (frxId, revid) {
        var done = function (resp) {
            if (resp.worked) {
                $("#frx-outdated" + frxId).hide();
            }
        };
        return cruCreate.addRevisionFromView('add', frxId, revid, done);
    };

    cruCreate.addRevisionFromView = function (command, frxId, revid, done) {
        var cruFrx = CRU.FRX;
        var frx = review.frx(frxId);
        var params = {
            "revid": revid,
            "command": command,
            "frxId": frxId,
            "attachMethod": "ITERATION",     // string value of Review.AttachMethod.ITERATION
            "fromRev": frx.visibleFromRevision(),
            "toRev": frx.visibleToRevision()
        };
        $.extend(params, CRU.FRX.diffParamsMap(frxId));

        var url = CRU.UTIL.jsonUrlBase(permaId) + "/editRevisionsFromRevisionAjax/";

        cruFrx.dimFrx(frxId);
        var onComp = function (resp) {
            if (!resp.worked) {
                cruFrx.unDimFrx(frxId);
            } else {
                if (resp.reloadReview) {
                    // we are refreshing the entire review
                    CRU.REVIEW.UTIL.reloadReview(true);
                }
                if (resp.reviewDueDate) {
                    //update review due date text
                    $('#review-meta-info .review-due-text').html(resp.reviewDueDate);
                }
                if (resp.frxExists) {
                    var cruFrxAjax = cruFrx.AJAX;
                    cruFrxAjax.shelveFrxControls(frxId);
                    $('#frxouter' + frxId).html(resp.payload);
                    cruFrxAjax.unshelveFrxControls(frxId);
                    cruFrxAjax.reloadFrxModel(frxId, resp, false);
                    cruFrxAjax.updateFrxSlider(frxId, resp);
                    cruFrxAjax.updateFrxDiffControls(frxId, resp);
                    cruFrxAjax.updateFrxEditRevisionsDropdown(frxId);
                    commentator.reloadFrxCommentCount(review.frx(frxId));
                } else {
                    cruCreate.removeFrxFromPage(frxId);
                }
            }
            if (done) {
                done({worked: resp.worked});
            }
        };
        FECRU.AJAX.ajaxUpdate(url, params, null, onComp);
        return false;
    };

    //remove an frx from the page entirely - only should be done if the file was removed from the review.
    cruCreate.removeFrxFromPage = function (frxId) {
        //remove frx
        var frx = review.frx(frxId);
        // frx may not actually be in the page for any number of reasons. do a sanity check.
        if (!frx) {
            return;
        }

        var currentlyViewing;
        var currentFrxElem = CRU.FRX.NAV.getCurrentFrxElement();
        if (currentFrxElem) {
            var currentFrxElementId = $(currentFrxElem).attr('id');
            var id = currentFrxElementId !== 'generalComments' ?
                currentFrxElementId.replace(/^frxouter/, '') :
                currentFrxElementId;

            currentlyViewing = frxId == id; // eslint-disable-line eqeqeq
        }
        review.removeFrx(frx);
        var $toRemove = $('#frx-list-item' + frxId);
        var $selectNext;
        var $toRemoveFolderSpan = $toRemove.children(".folder");
        if ($toRemoveFolderSpan.length > 0) {
            var $toRemoveFolderFrxDirItem = $toRemoveFolderSpan.children(".frx-dir-item");
            //if this is an frx with children, dont remove it, just remove the classes on it
            $toRemove.removeClass("activeFrx");
            $toRemoveFolderSpan.removeClass("frx-incomplete");
            $toRemoveFolderFrxDirItem.replaceWith($toRemoveFolderFrxDirItem.html());
            $toRemoveFolderSpan.find('.removeFrx, .spinner').remove();
            if (currentlyViewing) {
                $selectNext = $toRemove.find('.frx:first');
            }
        } else {
            while ($toRemove.hasClass('frx-list-item') && $toRemove.siblings().length === 0) {
                if ($toRemove.parent().attr('id') === 'tree-root') {
                    break;
                }
                var _$toRemove = $toRemove.parents('.frx-list-item:first');
                if (_$toRemove.length === 1) {
                    $toRemove = _$toRemove;
                } else {
                    break;
                }
            }
            //get next frx to select
            if (currentlyViewing) {
                $selectNext = $toRemove.next().find('.frx:first');
            }
            if ($toRemove) {
                $toRemove.remove();
            }
        }

        if (currentlyViewing) {
            if ($selectNext.length !== 1) {
                $selectNext = $('#navigation-tree .frx').filter(':last');
            }
            if ($selectNext.length !== 1) {
                $('#scroll-to-general-comments').click();
            } else {
                $selectNext.find('.scroll-to-frx').click();
            }
        }
        $('#frxouter' + frxId).remove();
        $('#frxControlsContainer' + frxId).remove();

        CRU.FRX.NAV.visibleFrxsChanged();
        CRU.COMMENT.NAV.visibleCommentsChanged();
    };

    cruCreate.retrieveNewFrxs = function (done) {
        var url = CRU.UTIL.jsonUrlBase(permaId) + "/retrieveNewFrxsAjax/";

        var onComp = function (resp) {
            if (resp.worked) {
                var activeTreeElem = $('#navigation-tree .activeFrx').attr('id');
                $('#navigation-tree').html(resp.navTree);
                $('#navigation-tree .activeFrx').removeClass('activeFrx');
                $('#' + activeTreeElem).addClass('activeFrx');
                AJS.$.each(review.frxs(), function (idx, frx) {
                    frx.invalidateCachedSelectors();
                });

                var insertAfter = 'generalComments';
                var frxs = resp.frxs;
                var frxIds = [];
                for (var i = 0, len = frxs.length; i < len; i++) {
                    var frxId = frxs[i].frxId;
                    var frxHtml = frxs[i].frxHtml;
                    if (!review.frx(frxId)) {
                        $(frxHtml).insertAfter('#' + (insertAfter !== 'generalComments' ? 'frxouter' + insertAfter : insertAfter));
                        eval('var frxModelLoader = ' + frxs[i].frxModelLoader);
                        frxModelLoader(insertAfter);
                        frxIds.push(frxId);
                    }
                    if (review.frx(frxId)) {
                        insertAfter = frxId;
                    }
                }

                if (done) {
                    done();
                }

                CRU.FRX.AJAX.prioritisedFrxLoad(frxIds);
            }
        };

        FECRU.AJAX.ajaxUpdate(url, {}, null, onComp);
        return false;

    };

    var addRemoveRevisionToIter = function (add, revid) {
        var busyid = "busyRev" + revid;
        var nochangeid = "";
        var $revPath = $("#revPath" + revid);
        toggleNodeAndImage(busyid, true, false, true);
        if (add) {
            toggleNodeAndImage("addRev" + revid, false, true, true);
            nochangeid = "addRev" + revid;
            $revPath.css("textDecoration", "");
        } else {
            toggleNodeAndImage("remRev" + revid, false, true, true);
            nochangeid = "remRev" + revid;
            $revPath.css("textDecoration", "line-through");
        }
        var params = {
            "revid": revid,
            "command": add ? "add" : "remove",
            "attachMethod": $("#attachMethod").val(),
            "fromRevision": $("#fromRevision").val()
        };
        var url = CRU.UTIL.jsonUrlBase(permaId) + "/editRevisionsAjax/";
        return doAddRemoveCall(url, params, busyid, nochangeid);
    };

    cruCreate.addRevisionToIter = function (revid) {
        addRemoveRevisionToIter(true, revid);
    };

    cruCreate.removeRevisionFromIter = function (revid) {
        addRemoveRevisionToIter(false, revid);
    };

    cruCreate.addAllSearchRevisions = function (url, spinnerId) {
        $('#' + spinnerId).css('display', 'inline');
        url += "&command=addSearch";
        url += "&search=" + $("#qlStr").val();
        url += "&spage=" + $("#results.thisPageNum").val();
        url += "&attachMethod=" + $("#attachMethod").val();
        url += "&fromRevision=" + $("#fromRevision").val();
        FECRU.XSRF.postUri(url);
    };

    var doAddMultipleCall = function (url, params) {
        var done = function (resp) {
            if (!resp.worked || FECRU.AJAX.checkError(resp)) {
                return false;
            }
            updateRespMsgBusy(resp.msgHtml);

            var updatedChangesets = {};

            $.each(resp.addedRevids, function () {
                var addedRevid = this;
                updatedChangesets[cruCreate.revid2csid[addedRevid]] = 1;
                cruCreate.revidsInIteration[addedRevid] = 1;
                toggleNodeAndImage("addRev" + addedRevid, false, true, true);
                toggleNodeAndImage("remRev" + addedRevid, true, false, true);
            });
            for (var csid in updatedChangesets) {
                if (updatedChangesets.hasOwnProperty(csid)) {
                    updateChangesetAddRemove(csid);
                }
            }
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    cruCreate.addRevisionsToIter = function (permaId, revIdArray) {
        $.each(revIdArray, function () {
            $("#revPath" + this).css("textDecoration", "");
        });
        var params = {
            "revid": revIdArray,
            "command": "add",
            "attachMethod": $("#attachMethod").val(),
            "fromRevision": $("#fromRevision").val()
        };
        var url = CRU.UTIL.jsonUrlBase(permaId) + "/editRevisionsAjax/";

        return doAddMultipleCall(url, params);
    };


    var doAddRemoveCall = function (url, params, busyid, nochangeid, extraDone) {
        var done = function (resp) {
            if (!resp.worked || FECRU.AJAX.checkError(resp)) {
                toggleNodeAndImage(busyid, false, true, true);
                toggleNodeAndImage(nochangeid, true, false, true);
                return false;
            }
            updateRespMsgBusy(resp.msgHtml);

            var updatedChangesets = {};

            toggleNodeAndImage(busyid, false, true, true);
            toggleNodeAndImage(nochangeid, true, false, true);

            $.each(resp.addedRevids, function () {
                updatedChangesets[cruCreate.revid2csid[this]] = 1;
                cruCreate.revidsInIteration[this] = 1;
                toggleNodeAndImage("addRev" + this, false, true, true);
                toggleNodeAndImage("remRev" + this, true, false, true);
            });
            $.each(resp.removedRevids, function () {
                updatedChangesets[cruCreate.revid2csid[this]] = 1;
                cruCreate.revidsInIteration[this] = 0;
                toggleNodeAndImage("addRev" + this, true, false, true);
                toggleNodeAndImage("remRev" + this, false, true, true);
            });

            for (var csid in updatedChangesets) {
                if (updatedChangesets.hasOwnProperty(csid)) {
                    updateChangesetAddRemove(csid);
                }
            }

            extraDone && extraDone(resp);
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    /**
     *
     * @param csid
     * @param showRemove show a tick / everything is already in review
     * @param showSome show an orange box / some items are in review
     * @param showAdd show an empty box / no items are in review
     */
    var updateChangesetAddRemove = function (csid, showRemove, showSome, showAdd) {
        var revids = cruCreate.changesets[csid];
        if (!showRemove && !showSome && !showAdd) {
            if (!revids) {
                return;
            }
            var inCount = 0;
            $.each(revids, function () {
                if (cruCreate.revidsInIteration[this] == 1) { // eslint-disable-line
                    inCount++;
                }
            });
            showAdd = inCount < revids.length;
            showRemove = inCount > 0;
            showSome = showAdd && showRemove;
            if (showSome) {
                showAdd = false;
                showRemove = false;
            }
        }
        var $csidLi = AJS.$("#csid-" + csid);
        var isMetadataOnlyChange = $csidLi.data('metadataonlychange');
        var isPartialMetadataChange = $csidLi.data('partialmetadatachange');

        //partial metadata changes will never fully be selected
        showSome = showSome || (showRemove && isPartialMetadataChange);
        //partial metadata changes will never be fully selected
        showRemove = showRemove && !isPartialMetadataChange;
        //metadata only changes will never show the add all checkbox state
        showAdd = showAdd && !isMetadataOnlyChange;

        toggleNodeAndImage("addCs" + csid, showAdd, !showAdd, true);
        toggleNodeAndImage("remCs" + csid, showRemove, !showRemove, true);
        toggleNodeAndImage("containsSome" + csid, showSome, !showSome, true);
        toggleNodeAndImage("metadataOnlyCs" + csid, isMetadataOnlyChange, !isMetadataOnlyChange, true);
    };

    cruCreate.addChangesetToIter = function (csid) {
        addRemoveChangesetToIter(true, csid);
    };

    cruCreate.removeChangesetFromIter = function (csid) {
        addRemoveChangesetToIter(false, csid);
    };

    var addRemoveChangesetToIter = function (add, csid) {
        var addCsIsHidden = $("#addCs" + csid).is(":hidden");
        var isPartialMetadataChange = $("#csid-" + csid).data("partialmetadatachange");

        // used to revert the spinner
        var showRemove = !add;
        var showSome = add && addCsIsHidden;
        var showAdd = add && !addCsIsHidden;

        var busyid = "busyCs" + csid;
        var nochangeid = "";
        if (!add) {
            if (isPartialMetadataChange) {
                nochangeid = "containsSome" + csid;
            } else {
                nochangeid = "remCs" + csid;
            }
        } else if (addCsIsHidden) {
            nochangeid = "containsSome" + csid;
        } else {
            nochangeid = "addCs" + csid;
        }
        toggleNodeAndImage(nochangeid, false, true, true);
        toggleNodeAndImage(busyid, true, false, true);

        var params = {
            "csid": csid,
            "command": add ? "add" : "remove",
            "sourceName": cruCreate.repnameInUse,
            "attachMethod": $("#attachMethod").val(),
            "fromRevision": $("#fromRevision").val()
        };

        var url = CRU.UTIL.jsonUrlBase(permaId) + '/editRevisionsAjax/';

        var done = function (resp) {
            if (!!resp.csReviewState) { // otherwise revert the spinner
                showRemove = resp.csReviewState === 'FULL';
                showSome = resp.csReviewState === 'PARTIAL';
                showAdd = resp.csReviewState === 'NONE';
            }
            updateChangesetAddRemove(csid, showRemove, showSome, showAdd);
        };

        doAddRemoveCall(url, params, busyid, nochangeid, done);
    };

    cruCreate.removeAllRevs = function (done) {
        var pars = 'command=removeAll&sourceName=' + cruCreate.repnameInUse;
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/editRevisionsAjax/';
        doAddRemoveCall(url, pars, null, null, done);
    };

    cruCreate.addSearchFileRevToReview = function (revisionId) {
        addRemoveRevisionToIter(true, revisionId);
    };

    cruCreate.removeSearchFileRevToReview = function (revisionId) {
        addRemoveRevisionToIter(false, revisionId);
    };

    cruCreate.dirListRevs = [];

    //this is for the file browse tab
    cruCreate.addFileRevisionToReview = function (latestRevId) {
        var newSelectedRevId = document.forms["selectRevisionForm" + latestRevId].revId.value;
        addRemoveFileRevisionReview(true, newSelectedRevId, latestRevId);
    };

    cruCreate.removeFileRevisionFromReview = function (latestRevId) {
        var newSelectedRevId = document.forms["selectRevisionForm" + latestRevId].revId.value;
        addRemoveFileRevisionReview(false, newSelectedRevId, latestRevId);
    };

    var addRemoveFileRevisionReview = function (add, revid, latestRevId, onEval) {
        var busyid = "busyRev" + latestRevId;
        var nochangeid = "";
        toggleNodeAndImage(busyid, true, false, true);
        if (add) {
            toggleNodeAndImage("addRev" + latestRevId, false, true, true);
            nochangeid = "addRev" + latestRevId;
        } else {
            toggleNodeAndImage("remRev" + latestRevId, false, true, true);
            nochangeid = "remRev" + latestRevId;
        }

        var params = {
            "revid": revid,
            "sourceName": cruCreate.repnameInUse,
            "command": add ? "add" : "remove",
            "attachMethod": $("#attachMethod").val(),
            "fromRevision": $("#fromRevision").val()
        };
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/editRevisionsAjax/';

        return doAddRemoveFRCall(url, params, busyid, nochangeid, latestRevId, onEval);
    };

    var doAddRemoveFRCall = function (url, params, busyid, nochangeid, latestRevId, onEval) {
        var done = function (resp) {
            try {
                // take out the spinner image regardless of what the response is
                toggleNodeAndImage(busyid, false, true, true);
                toggleNodeAndImage(nochangeid, true, false, true);
                if (!resp.worked || FECRU.AJAX.checkError(resp)) {
                    return false;
                }
                updateRespMsgBusy(resp.msgHtml);
                //todo fix this looks wrong
                for (var i = 0; i < resp.removedRevids.length; i++) {
                    cruCreate.dirListRevs[latestRevId] = "";
                    toggleNodeAndImage("addRev" + latestRevId, true, false, true);
                    toggleNodeAndImage("remRev" + latestRevId, false, true, true);
                }
                for (i = 0; i < resp.addedRevids.length; i++) {
                    cruCreate.dirListRevs[latestRevId] = resp.addedRevids[i];
                    toggleNodeAndImage("addRev" + latestRevId, false, true, true);
                    toggleNodeAndImage("remRev" + latestRevId, true, false, true);
                }
                if (onEval) {
                    onEval();
                }
            } catch (error) {
                window.alert(error);
            }
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    var loadFullHistoryDropdown = function (latestRevId) {
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/loadFullHistoryDropdownAjax/';
        var params = {"latestRevId": latestRevId};
        var elementIdToUpdate = "selectDiff" + latestRevId;

        return FECRU.AJAX.ajaxUpdate(url, params, elementIdToUpdate);
    };

    cruCreate.updateSelectedRev = function (latestRevId) {
        var selectBox = document.forms["selectRevisionForm" + latestRevId].revId;
        var formval = selectBox.value;
        if (formval === "__LOADFULL__") {
            FECRU.AJAX.startSpin(selectBox, "", true);
            loadFullHistoryDropdown(latestRevId);
            return;
        }
        var onEval = function () {
            addRemoveFileRevisionReview(true, formval, latestRevId);
        };
        addRemoveFileRevisionReview(false, cruCreate.dirListRevs[latestRevId], latestRevId, onEval);
    };

    /* patch file revision functions */
    cruCreate.patches = [];
    cruCreate.patchesInc = [];
    cruCreate.patchRevs = [];
    cruCreate.incPatchRevs = [];

    cruCreate.addAllPatch = function (patchId) {
        addRemoveAllPatch(true, patchId);
    };

    cruCreate.removeAllPatch = function (patchId) {
        addRemoveAllPatch(false, patchId);
    };

    // must match Source.SEPARATOR
    cruCreate.SOURCE_SEPARATOR = ":";

    var addRemoveAllPatch = function (add, patchID) {
        var incRevs = cruCreate.patchesInc[patchID];
        var revs = cruCreate.patches[patchID];
        $("#addAll" + patchID).hide();
        $("#remAll" + patchID).hide();
        $("#containsSome" + patchID).hide();
        $("#busy" + patchID).show();

        var params = {
            "revid": cruCreate.patches[patchID],
            "command": add ? "add" : "remove"
        };

        var url = CRU.UTIL.jsonUrlBase(permaId) + '/editRevisionsAjax/';

        var done = function (resp) {
            var remRev = function (revId) {
                incRevs[revId] = "";
            };
            var addRev = function (revId) {
                incRevs[revId] = revId;
            };
            updateRespMsgBusy(resp, "busy" + patchID);
            if (resp.worked) {
                updateRevTicks(resp.removedRevids, true, remRev);
                updateRevTicks(resp.addedRevids, false, addRev);
            }
            cruCreate.setAddRemAll(patchID, incRevs, revs);
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    cruCreate.setAddRemAll = function (patchID, incRevs, revs) {
        var $addAll = $("#addAll" + patchID).hide();
        var $remAll = $("#remAll" + patchID).hide();
        var $hasSome = $("#containsSome" + patchID).hide();

        var count = countSelected(incRevs);
        if (count === 0) {
            $addAll.show();
        } else if (count < revs.length) {
            $hasSome.show();
        } else {
            $remAll.show();
        }
    };

    var countSelected = function (incRevs) {
        if (!incRevs) {
            return 0;
        }

        var count = 0;
        for (var i = 0, len = incRevs.length; i < len; i++) {
            if (incRevs[i]) {
                count++;
            }
        }
        return count;
    };

    var updateRespMsgBusy = function (resp, busyId) {
        if (resp.worked) {
            resp.msgHtml && $("#messages").html(resp.msgHtml);
        }
        resp.errors && $("#error-container").html(resp.errors);
        if (busyId) {
            $("#" + busyId).hide();
        }
    };

    var updateRevTicks = function (ids, removed, forEachFunc) {
        $.each(ids, function () {
            if (removed) {
                $("#addRev" + this).show();
                $("#remRev" + this).hide();
            } else {
                $("#addRev" + this).hide();
                $("#remRev" + this).show();
            }
            if (forEachFunc) {
                forEachFunc(this);
            }
        });
    };

    cruCreate.addRemoveFileRevision = function (add, revid, imgPostfix, sourceName) {
        var create = cruCreate;
        var patchID = sourceName.split(create.SOURCE_SEPARATOR)[1];
        var incRevs = create.patchesInc[sourceName];
        var revs = create.patches[sourceName];
        var busyId = "busyRev" + imgPostfix;
        $("#addRev" + imgPostfix).hide();
        $("#remRev" + imgPostfix).hide();
        $("#" + busyId).show();

        var params = {
            "revid": revid,
            "command": add ? "add" : "remove"
        };

        var url = CRU.UTIL.jsonUrlBase(permaId) + "/editRevisionsAjax/";

        var done = function (resp) {
            var remRev = function (revId) {
                if (incRevs) {
                    incRevs[revId] = "";
                }
            };
            var addRev = function (revId) {
                if (incRevs) {
                    incRevs[revId] = revId;
                }
            };
            updateRespMsgBusy(resp, busyId);
            var resetCheckbox = function () {
                if (add) {
                    $("#addRev" + imgPostfix).show();
                } else {
                    $("#remRev" + imgPostfix).show();
                }
            };
            if (resp.worked) {
                updateRevTicks(resp.removedRevids, true, remRev);
                updateRevTicks(resp.addedRevids, false, addRev);
                if (resp.hasErrors) {
                    $("#error-container").html(resp.errors);
                    resetCheckbox();
                } else {
                    $("#error-container").html("");
                }
            } else {
                resetCheckbox();
            }
            create.setAddRemAll(patchID, incRevs, revs);
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    cruCreate.storeStickyPreference = function (key, value) {
        var params = {
            "key": key,
            "value": value
        };
        var url = CRU.UTIL.jsonUrlBase(permaId) + "/storeStickyPreferenceAjax/";

        FECRU.AJAX.ajaxDo(url, params);
    };

    cruCreate.setSpecificDiffVisible = function (attachMethod) {
        if (attachMethod === 'SPECIFIC_DIFF') {
            $('#specificDiff').show();
        } else {
            $('#specificDiff').hide();
        }
        cruCreate.storeStickyPreference('attachMethod', attachMethod);
    };

    cruCreate.submitDetailsForm = function () {
        var cruReviewUtil = CRU.REVIEW.UTIL;
        cruReviewUtil.postEditDetailsForm(function () {
            cruReviewUtil.reloadReview(true, function () {
                cruReviewUtil.unblockReviewUpdatePolling();
            });

            CRU.FRX.AJAX.unblockFrxLoading();
            CRU.UNSAVED.watchForUnsavedChanges();
        });
    };

    cruCreate.submitDetailsFormAndStart = function (done) {
        //reload the entire page for now - wont have to refresh when we can update via polling
        var approve = function () {
            if (done) {
                done();
            }
            CRU.UTIL.stateTransition('action:approveReview', permaId);
        };
        CRU.REVIEW.UTIL.postEditDetailsForm(approve);
    };

    cruCreate.markChanged = function () {
        CRU.UTIL.editDetailsFormChange = true;
    };

    cruCreate.checkEditForm = function (done) {
        return CRU.UTIL.checkEditForm(done);
    };

    cruCreate.cleanPlaceholders = function ($form) {
        $form.find("input").each(function () {
            var $this = $(this);
            if ($this.isPlaceholded()) {
                $this.val("");
            }
        });
    };

    cruCreate.checkEditAndSubmitThis = function (formElement) {
        var submitter = function () {
            var form = formElement.form || (formElement[0] && formElement[0].form);
            cruCreate.cleanPlaceholders($(form));
            $(form).submit();
        };
        FECRU.UI.swapDatesIfReversed(function (dateString) {
            return dateString.substring(0, dateString.indexOf("T"));
        });
        cruCreate.checkEditForm(submitter);
    };

    cruCreate.command = function (cmd, pid, button) {
        CRU.UTIL.command(cmd, pid, button);
    };

    //This validates the saneness of the team selection removing and disabling the
    //selection of author and moderator as reviewers.
    cruCreate.validateTeamSelection = function () {
        var form = document.editDetailsForm;
        var mod = form.newModerator.value;
        var auth = form.newAuthor.value;
        var reviewers = form.reviewers;
        if (reviewers) {
            for (var i = 0, len = reviewers.length; i < len; i++) {
                var reviewer = reviewers[i];
                if (reviewer.value === mod || reviewer.value === auth) {
                    reviewer.checked = false;
                    reviewer.disabled = true;
                } else {
                    reviewer.disabled = false;
                }
            }
        } else if (reviewers) {
            reviewers.checked = false;
            reviewers.disabled = true;
        }
    };

    cruCreate.addInvitee = function () {
        var $input = $("#inviteeInput");
        var invitee = $input.val();
        if (!invitee) {
            return;
        }
        var $invitees = $("#inviteeSpan");

        var $newInvitee = $("<input name='invitees' type='checkbox' checked='checked' tabindex='8'>")
            .val(invitee);

        var $textSpan = $("<span>" + invitee + "; </span>");

        var $newSpan = $("<span id='inv_" + invitee + "'></span>")
            .append($newInvitee)
            .append($textSpan);

        $invitees.append($newSpan);

        CRU.UTIL.editDetailsFormChange = true;
        $input.val('');
    };

    cruCreate.loadChangesets = function ($container, $activityLoading, $newerActivityBtn, explorer, callback) {
        if (cruCreate.explorer.loading) {
            return false;
        }
        cruCreate.explorer.loading = true;

        $.extend(cruCreate.explorer, explorer);

        function isNavigatePast() {
            return cruCreate.explorer.navigate === "past";
        }

        function isNavigateFuture() {
            return cruCreate.explorer.navigate === "future";
        }

        var url = AJS.contextPath() + "/cru/" + encodeURI(permaId) + "/edit-changelog-ajax";
        if (cruCreate.explorer.wbUrl) {
            url += cruCreate.explorer.wbUrl;
        } else {
            url += cruCreate.explorer.wbSpec + "/" + cruCreate.explorer.fullPath;
        }

        if (isNavigatePast()) {
            if (cruCreate.explorer.nextInPast) {
                url += "?toid=" + encodeURI(cruCreate.explorer.nextInPast) + "&inc=" + encodeURI(cruCreate.explorer.nextInPastIsInc);
            } else {
                delete cruCreate.explorer.navigate;
                cruCreate.explorer.loading = false;
                return false;
            }
        } else if (isNavigateFuture()) {
            if (cruCreate.explorer.nextInFuture) {
                url += "?fromid=" + encodeURI(cruCreate.explorer.nextInFuture) + "&inc=" + encodeURI(cruCreate.explorer.nextInFutureIsInc);
            } else {
                delete cruCreate.explorer.navigate;
                cruCreate.explorer.loading = false;
                return false;
            }
        } else {
            if (cruCreate.explorer.jumptoid) {
                url += "?jumptoid=" + cruCreate.explorer.jumptoid;
            }

            $container.html('');
        }

        $activityLoading.show();
        FECRU.AJAX.ajaxUpdate(url, {}, null, function (response) {
            $activityLoading.hide();
            if (isNavigatePast()) {
                if (response.size) {
                    $container.append(response.payload);
                }
                cruCreate.explorer = $.extend(response.explorer, {
                    nextInFuture: cruCreate.explorer.nextInFuture,
                    nextInFutureIsInc: cruCreate.explorer.nextInFutureIsInc
                })
            } else if (isNavigateFuture()) {
                if (response.size) {
                    $container.prepend(response.payload);
                }

                cruCreate.explorer = $.extend(response.explorer, {
                    nextInPast: cruCreate.explorer.nextInPast,
                    nextInPastIsInc: cruCreate.explorer.nextInPastIsInc
                })
            } else {
                $container.html(response.payload);
                cruCreate.explorer = response.explorer;
            }


            if (cruCreate.explorer.nextInFuture) {
                $newerActivityBtn.show();
            } else {
                $newerActivityBtn.hide();
            }

            cruCreate.explorer.loading = false;
            callback && callback(response);
        });

        return true;
    };
})(AJS.$);
/*[{!create_js_y8w2510!}]*/
