(function ($) {

    $(document).ready(function () {

        var cruCreate = CRU.CREATE;
        var fecruAjax = FECRU.AJAX;
        var cruPatches = CRU.PATCHES;

        $(document).delegate(".changelist-link", "click", function (e) {
            e.preventDefault();
            cruCreate.loadChangesets($('#stream'), $('#activityLoadingTop'), $('.changelist-link-future'), {
                navigate: $(this).data('navigate')
            });
        });

        $(document).delegate("#changesetFilter", "submit", function (e) {
            cruCreate.cleanPlaceholders($(this));
            $('#changelog-warning').html('');
            $('#showid').val('');
            cruCreate.loadChangesets(AJS.$('#stream'), $('#activityLoadingTop'), $('.changelist-link-future'), {
                wbUrl: "/" + cruCreate.explorer.fullPath + "?" + $(this).serialize()
            });
            e.preventDefault();
        });


        $(document).delegate('.removeFrx:not(.disabled)', 'click', function () {
            var $x = $(this);
            var idBits = $x.attr('id').split('-');
            fecruAjax.startSpin($x);
            $x.hide();
            cruCreate.addRevisionFromView('remove', idBits[1], idBits[2], function () {
                fecruAjax.stopSpin($x);
                $x.show();
            });
            return false;
        });

        $(document).delegate('.frxSlider .deleteRev', 'click', function () {
            var $x = $(this);
            var xId = $x.attr('id');
            var idBits = xId.split('-');
            fecruAjax.startSpin($x);
            $x.hide();
            cruCreate.addRevisionFromView('removeRevisions', idBits[1], idBits[2], function () {
                var $x = $('#' + xId);
                fecruAjax.stopSpin($x);
                $x.show();
            });
        });

        $(document).delegate('.addRevision', 'click', function () {
            var $elem = $(this);
            var revId = $elem.attr('id').replace(/^addRev/, '');
            cruCreate.addRevisionToIter(revId);
        });

        $(document).delegate('.removeRevision', 'click', function () {
            var $elem = $(this);
            var revId = $elem.attr('id').replace(/^remRev/, '');
            cruCreate.removeRevisionFromIter(revId);
        });

        $(document).delegate('.addChangeSet', 'click', function () {
            var $elem = $(this);
            var csId = $elem.attr('id').replace(/^(addCs|containsSome)/, '');

            var isPartialMetadataChange = $('#csid-' + csId).data('partialmetadatachange');
            var isMetadataOnlyChange = $('#csid-' + csId).data('metadataonlychange');
            //If the user has added file revisions for the partial or full metadata changeset then
            //the only sensible action is to remove the changeset here
            if (!$elem.hasClass('addAllChangeSet') && (isPartialMetadataChange || isMetadataOnlyChange)) {
                cruCreate.removeChangesetFromIter(csId);
            } else {
                cruCreate.addChangesetToIter(csId);
            }
        });

        $(document).delegate('.removeChangeSet', 'click', function () {
            var $elem = $(this);
            var csId = $elem.attr('id').replace(/^remCs|removeSomeCs/, '');
            cruCreate.removeChangesetFromIter(csId);
        });

        $(document).delegate('.changeDiffAddRevision', 'click', function () {
            var $addButton = $(this);
            if (!$addButton.prop('disabled')) {
                var frxId = $addButton.attr('id').replace(/^changeDiffAddRevision/, '');
                var revId = $('#changeDiffSelect' + frxId).val();
                if (revId) {
                    $addButton.prop('disabled', true);
                    var ajax = fecruAjax;
                    ajax.startSpin($addButton, "edit-revision-spinner");
                    var done = function () {
                        ajax.stopSpin($addButton);
                        // Disabled status of button is handled by addRevisionFromView.
                    };
                    cruCreate.addRevisionFromView('add', frxId, revId, done);
                }
            }
        });

        cruCreate.bindUpdateFrxFromFormToggle = function (selector, frx) {
            var $items = $(selector);
            if ($items.data('updateFrxFromFormToggleBound')) {
                return; // avoid binding more than once
            } else {
                $items.data('updateFrxFromFormToggleBound', true);
            }

            AJS.InlineDialog(
                selector,
                'edit-revisions-inline-dialog-form-' + frx,
                function ($container, editRevisionLink, showPopup) {
                    var $editRevisionLink = $(editRevisionLink);
                    if ($editRevisionLink.is(".toggled-off")) {
                        return;
                    }
                    $editRevisionLink.addClass("toggled-off");

                    var frxId = $editRevisionLink.attr('id').replace('add-revisions-link-', '');
                    var $formSpan = $('#updateFrxFromFormSpan' + frxId);

                    if (!$formSpan.is('.allocated')) {
                        var url = CRU.UTIL.jsonUrlBase(permaId) + "/changeDiffDropdownAjax/";
                        var params = {frxId: frxId};
                        $editRevisionLink.parent().addClass('spinner');

                        fecruAjax.ajaxDo(url, params, function (resp) {
                            $editRevisionLink.parent().removeClass('spinner');
                            if (resp.worked) {
                                $formSpan
                                    .html(resp.msgHtml)
                                    .addClass('allocated');

                                $container.append($formSpan.show());
                                CRU.FRX.AJAX.updateFrxEditRevisionsDropdown(frxId);
                                showPopup();
                            }
                            $editRevisionLink.removeClass("toggled-off");
                        });
                    } else {
                        $container.append($formSpan.show());
                        showPopup();
                        $editRevisionLink.removeClass("toggled-off");
                    }
                },
                {
                    hideDelay: null,
                    width: 520,
                    offsetX: -10,
                    cacheContent: false,
                    initCallback: function () {
                        var inlineDialog = this;
                        $(document).bind('frx-deactive.edit-revisions', function () {
                            inlineDialog.hide();
                        });
                        inlineDialog.popup.find('.close').bind('click.edit-revisions', function () {
                            inlineDialog.hide();
                        });
                    },
                    hideCallback: function () {
                        $(document).unbind('frx-deactive.edit-revisions');
                        var $popup = this.popup;
                        $popup.find('.close').unbind('click.edit-revisions');
                        // Stash the form span away for the next time we need to show it.
                        $('body').append($popup.find('.updateFrxFromFormSpan').hide());
                    }
                }
            );
        };


        /* Patches */
        $(document).delegate('.addAllPatch', 'click', function () {
            var $this = $(this);
            var patchId = $this.data('patchid')
            cruCreate.addAllPatch(patchId);
        });

        $(document).delegate('.removeAllPatch', 'click', function () {
            var $this = $(this);
            var patchId = $this.data('patchid')
            cruCreate.removeAllPatch(patchId);
        });

        $(document).delegate('.remove-patch', 'click', function() {
            var $this = $(this);
            var patchId = $this.data('patch-id');
            var reviewId = $this.data('review-id');
            var $patchControls = AJS.$('#patch-controls-' + patchId);
            $patchControls.hide();
            AJS.$
                .ajax({
                    url: AJS.contextPath() + "/rest-service/reviews-v1/" + reviewId + "/patch/" + patchId,
                    dataType: 'json',
                    type: 'DELETE'
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    $patchControls.show();
                    var msg;
                    try {
                        msg = JSON.parse(jqXHR.responseText).message;
                    } catch (e) {
                        msg = errorThrown;
                    }
                    AJS.messages.error({body: 'Something went wrong removing the patch. ' + msg});
                })
                .done(function(data) {
                    // update labels for the remaining groups
                    _.each(data.patchGroup, function(patchGroup) {
                        var patchId = patchGroup.sourceName.replace('PATCH:', '')
                        $('#patch-group-' + patchId + ' .patch-group-name').text(patchGroup.displayName);
                    });
                    $patchControls.remove();

                    // remove empty groups
                    $('.patch-group').each(function() {
                        if ($(this).find('.patch-controls').length === 0) {
                            $(this).remove();
                        }
                    });

                    // remove the whole 'Existing patches' section if empty
                    var $patchFilesSection = $('.existing-patch-files');
                    if ($patchFilesSection.find('.patch-group').length === 0) {
                        $patchFilesSection.remove();
                    }
                });
        });

        $(document).delegate('.addFileRevision', 'click', function () {
            var $this = $(this);
            var $fileRevision = $this.closest('.fileRevision');
            var sourceName = $fileRevision.attr('id').replace('fileRevision-', '');
            var revId = $this.attr('id').replace('addRev', '');
            cruCreate.addRemoveFileRevision(true, revId, revId, sourceName);
        });

        $(document).delegate('.removeFileRevision', 'click', function () {
            var $this = $(this);
            var $fileRevision = $this.closest('.fileRevision');
            var sourceName = $fileRevision.attr('id').replace('fileRevision-', '');
            var revId = $this.attr('id').replace('remRev', '');
            cruCreate.addRemoveFileRevision(false, revId, revId, sourceName);
        });

        var $anchorRepository = $("#anchor-repository");

        $anchorRepository.delegate('.anchored-path-edit', 'change', function () {
            var $this = $(this);
            if ($this.val() !== '') {
                var $controls = $this.closest('.patch-controls');
                var params = {
                    anchorSource: $controls.find('.anchored-source-value').val(),
                    anchorPath: $this.val(),
                    stripCount: $controls.find('.anchored-stripcount').val()
                };

                cruPatches.anchorPatch($controls, params);
            }
        });

        $anchorRepository.delegate('.anchored-source-edit', 'change', function () {
            var $this = $(this);

            var $controls = $this.closest('.patch-controls');
            if ($this.val() !== '') {
                var params = {
                    anchorSource: $this.val(),
                    search: true
                };

                cruPatches.anchorPatch($controls, params);
            } else {
                cruPatches.anchorPatch($controls, null);
            }
        });

        $anchorRepository.delegate('.edit-anchor, .find-anchor', 'click', function () {
            var $controls = $(this).closest('.patch-controls');
            if ($controls.is('.disabled')) {
                return;
            }

            var currentAnchorSource = $controls.find('.current-anchor > .anchored-source').text();

            $controls.removeClass('viewing');

            if (currentAnchorSource) {
                $controls.addClass('getting-paths');
                cruPatches.getPaths($controls, currentAnchorSource, function () {
                    $controls.removeClass('getting-paths').addClass('editing');
                });
            } else {
                $controls.addClass('editing');
            }
        });

        $anchorRepository.delegate('.cancel-edit', 'click', function () {
            var $controls = $(this).closest('.patch-controls');
            if ($controls.is('.disabled')) {
                return;
            }
            $controls.removeClass('editing').addClass('viewing');
        });

        $anchorRepository.delegate('.cancel-anchor', 'click', function () {
            var $controls = $(this).closest('.patch-controls');
            if ($controls.is('.disabled')) {
                return;
            }
            var cancel = $controls.data('cancel');
            cancel && cancel();
            $controls.removeClass('anchoring getting-paths').addClass('viewing');
        });

        $(document).delegate('.patch-revisions-expand', 'click', function () {
            var $this = $(this);
            var $patchRevisions = $this.parents('.patch-controls').find('.patch-revisions')
            $patchRevisions.slideToggle(200, function () {
                $this.toggleClass('expanded');
            });
        })

    });

})(AJS.$);
/*[{!create_event_js_091a50z!}]*/