// File used in the manage files "browse" panel
if (CRU.CREATE === undefined) {
    CRU.CREATE = {};
}
CRU.CREATE.BROWSE = {};

(function () {
    /**
     * Find a link in the directory tree by its href
     */
    var $findLink = function (href) {
        return AJS.$("#navigation-tree").find("a.pathLink[href='" + href + "']");
    };

    var moveSelectedDirTreeIds = function ($newLink) {
        AJS.$("#selectedDirTreeLink, #selectedDirTreeNode").attr("id", "");
        $newLink.closest("span").attr("id", "selectedDirTreeNode");
        $newLink.attr("id", "selectedDirTreeLink");
    };

    var folderToggled = function ($linkNode) {
        // open the parents
        var $node = $findLink($linkNode.attr("href"));
        $node.parents("ul.closed,span.closed").removeClass("closed").addClass("open");
        moveSelectedDirTreeIds($node);

        AJS.$.ajax({
            type: "GET",
            url: $linkNode.attr("href").replace("edit-browse", "edit-browse-filelist"), // HACK!
            success: function (msg) {
                AJS.$("#fileResults").html(msg);
            }
        });
    };

    var rootSelected = function ($linkNode) {
        // Remove previously selected dirs
        AJS.$("#selectedDirTreeLink, #selectedDirTreeNode").attr("id", "");

        // Make request to root, at '/'
        var rawUrl = $linkNode.attr("href");
        AJS.$.ajax({
            type: "GET",
            url: rawUrl.substring(0, rawUrl.lastIndexOf('/')).replace("edit-browse", "edit-browse-filelist"), // HACK!
            success: function (msg) {
                AJS.$("#fileResults").html(msg);
            }
        });
    };

    CRU.CREATE.BROWSE.browseDirectoryPathLinkFunction = function (event) {
        var $node = AJS.$(event.target);
        var href = $node.attr("href");
        var self = CRU.CREATE.BROWSE.browseDirectoryPathLinkFunction;
        if ($node.hasClass("browse-directory")) {
            // find the node in the tree with the same href as us
            var $selectedLink = $findLink(href);
            FECRU.BROWSE.selectLink($selectedLink, folderToggled, self);
        } else {
            FECRU.BROWSE.selectLink($node, folderToggled, self);
        }
        return false;
    };

    CRU.CREATE.BROWSE.browseFilePathLinkFunction = function (event) {
        event.preventDefault();
        var $node = AJS.$(event.target);
        var $dirParent = $node.parents('ul.tree.open:first');

        // If file has a directory as a parent, select directory, else select root.
        if ($dirParent.length) {
            $node = $dirParent.siblings('span.tree.open').children('.pathLink');
            FECRU.BROWSE.selectLink($node, folderToggled);
        } else {
            rootSelected($node);
        }

        return false;
    };

})();
/*[{!create_browse_js_s51r50y!}]*/