/**
 * @see fecru-analytics-plugin/src/main/resources/whitelist/fecru-core-whitelist.json
 */
(function ($, analytics) {

    /**
     * @returns {string} type of the attach method (like "diff" or "whole file") which is selected in the select box
     */
    var getAttachMethod = function() {
        return $("#attachMethod").val().toLowerCase().replace(/_/g, "-");
    };

    /**
     * @returns {string} type of the repository (like "git") which is selected in the select box
     */
    var getRepositoryType = function() {
        return $('#repository-input').attr('data-repository-type');
    };

    /**
     * @param {string} addContentMethod "method-changelog" / "method-browse" / "method-search"
     * @returns {Object} event's content
     */
    var defineAddContentEvent = function(addContentMethod) {
        return {
            name: function() {
                return 'cru.review.addcontent.' + addContentMethod + '.add.' + getAttachMethod();
            },
            data : {
                repositoryType : getRepositoryType
            }
        };
    };

    /**
     * @param {string} removeContentMethod "method-changelog" / "method-browse" / "method-search"
     * @returns {Object} event's content
     */
    var defineRemoveContentEvent = function(removeContentMethod) {
        return {
            name: 'cru.review.addcontent.' + removeContentMethod + '.remove',
            data : {
                repositoryType : getRepositoryType
            }
        };
    };

    /**
     * @param {string} removeContentMethod "method-changelog" / "method-browse" / "method-search"
     * @returns {Object} event's content
     */
    var defineRemoveAllRevisionsEvent = function(removeContentMethod) {
        return {
            name: 'cru.review.addcontent.' + removeContentMethod + '.remove-all-revisions',
            data : {
                repositoryType : getRepositoryType
            }
        };
    };

    // analytics events related with adding/removing review content via "Browse changesets"
    analytics.sendOn('[data-analytics-event="changelog-add"]', defineAddContentEvent('method-changelog'));
    analytics.sendOn('[data-analytics-event="changelog-remove"]', defineRemoveContentEvent('method-changelog'));
    analytics.sendOn('[data-analytics-event="changelog-remove-all"]', defineRemoveAllRevisionsEvent('method-changelog'));


    // analytics events related with adding/removing review content via "Explore repositories"
    analytics.sendOn('[data-analytics-event="browse-add"]', defineAddContentEvent('method-browse'));
    analytics.sendOn('[data-analytics-event="browse-remove"]', defineRemoveContentEvent('method-browse'));
    analytics.sendOn('[data-analytics-event="browse-remove-all"]', defineRemoveAllRevisionsEvent('method-browse'));

    // analytics events related with adding/removing review content via "Search for files"
    analytics.sendOn('[data-analytics-event="search-add"]', defineAddContentEvent('method-search'));
    analytics.sendOn('[data-analytics-event="search-remove"]', defineRemoveContentEvent('method-search'));
    analytics.sendOn('[data-analytics-event="search-remove-all"]', defineRemoveAllRevisionsEvent('method-search'));

})(AJS.$, FECRU.ANALYTICS);
