require([
    'jquery',
    'global-ns/fecru-xsrf',
    'FECRU/component/trailing-whitespace',
    'FECRU/component/confirmDialog',
    'FECRU/pages/admin/users/filter-group-view'
], function ($, xsrf, trailingWhitespace, confirmDialog, FilterGroupView) {

    var handleUserDeletion = function () {
        $('.users-list--action__delete').on('click', function (e) {
            e.preventDefault();
            var url = this.href;
            confirmDialog(
                'Delete user?',
                'Deleting a user is a permanent action and cannot be undone. Are you sure you wish to delete this user?',
                {
                    onConfirm: function () {
                        xsrf.postUri(url);
                    }
                }
            );
        });
    };

    var handleUsersSelection = function () {
        var $userSelector = $('#userSelector');
        var $selectedUsers = $('input[name="selectedUsers"]');

        $userSelector.on('change', function () {
            $selectedUsers.attr('checked', $(this).is(':checked'));
        });

        $selectedUsers.on('change', function () {
            $userSelector.attr('checked', $selectedUsers.filter(':not(:checked)').length === 0);
        });
    };

    $(function () {
        trailingWhitespace();
        handleUserDeletion();
        handleUsersSelection();
        FilterGroupView.init('.users-list--filter-group');
    });

});