define('FECRU/pages/admin/users/filter-group-view', [
    'jquery',
    'backbone'
],
function ($, Backbone) {

    var URL = AJS.contextPath() + '/rest-service-fecru/admin/groups';
    var PER_PAGE = 25;

    return Backbone.View.extend({
        initialize: function () {
            var toChoice = this.toChoice.bind(this);
            var defaultChoice = this.getDefaultChoice();
            var $el = this.$el;
            var filterString = '';

            $el.auiSelect2({
                ajax: {
                    url: URL,
                    dataType: 'json',
                    data: function (term, page) {
                        filterString = term;
                        return {
                            prefix: term,
                            limit: PER_PAGE,
                            start: (page - 1) * PER_PAGE
                        };
                    },
                    /**
                     * Convert server response into select2 choices.
                     * In case we are on the first page and no query is specified - prepend "Any" option.
                     * @param data {Array<Object>}
                     * @returns {Object}
                     */
                    results: function (data) {
                        var hasMore = !data.lastPage;
                        var isDefaultState = data.start === 0 && !filterString;
                        var availableValues = isDefaultState ? [defaultChoice] : [];
                        return {
                            more: hasMore,
                            results: availableValues.concat(data.values.map(toChoice))
                        };
                    }
                }
            });

            var value = $el.val();
            var data = value ? this.toChoice({name: value}) : defaultChoice;
            $el.select2('data', data);

            return this;
        },

        getDefaultChoice: function () {
            return {id: '', text: 'Any'};
        },

        toChoice: function (group) {
            return {id: group.name, text: group.name };
        }
    },
    {
        init: function (selector) {
            return new this({el: selector});
        }
    });
});