require(['jquery', 'FECRU/component/confirmDialog'], function ($, confirmDialog) {
    var initConfirmDialogForProjectDeletion = function () {
        $(document).on('click', '.projects-list--remove-button', function (e) {
            var confirmURL = $(this).data('href');
            e.preventDefault();
            confirmDialog(
                'Delete project?',
                'Deleting a project is a permanent action and cannot be undone. Are you sure you wish to continue?',
                {
                    onConfirm: function (dialog) {
                        FECRU.XSRF.postUri(confirmURL);
                    }
                }
            );
        });
    };

    $(function () {
        initConfirmDialogForProjectDeletion();
    });
});