require(
    [
        'jquery',
        'FECRU/component/confirmDialog',
        'FECRU/model/PermissionScheme',
        'FECRU/pages/admin/permission_schemes/DialogFormView'
    ],
    function ($, confirmDialog, PermissionScheme, DialogFormView) {
        var TEMPLATES = FECRU.TEMPLATES.pages.admin.permission_schemes.list;

        var initAddNewPermissionSchemeDialog = function () {
            $('[data-ref="add-new-permission-scheme"]').on('click', function () {

                var dialog = confirmDialog(
                    'New permission scheme',
                    TEMPLATES.addNewPermissionSchemeForm({
                        maxLength: +$(this).data('nameMaxLength')
                    }),
                    {
                        confirmButtonLabel: 'Create',
                        isWarning: false,
                        footerContent: confirmDialog.renderButtonWithSpinnerPlaceholder,
                        onConfirm: function (dialog) {
                            formDialogView.submit();
                        }
                    }
                );
                var formDialogView = DialogFormView.create(dialog.$el);
            });
        };
        var initConfirmDialogForPermissionSchemeDeletion = function () {
            $(document).on('click', '.permission-schemes-list--remove-button', function (e) {
                var confirmURL = $(this).data('href');
                e.preventDefault();
                confirmDialog(
                    'Delete permission scheme?',
                    'Deleting a permission scheme is a permanent action and cannot be undone. Are you sure you wish to continue?',
                    {
                        onConfirm: function (dialog) {
                            FECRU.XSRF.postUri(confirmURL);
                        }
                    }
                );
            });
        };

        $(function () {
            initAddNewPermissionSchemeDialog();
            initConfirmDialogForPermissionSchemeDeletion();
        });

    });