define('FECRU/pages/admin/permission_schemes/DialogFormView',
    ['backbone', 'FECRU/model/PermissionScheme'],
    function (Backbone, PermissionScheme) {
        return Backbone.View.extend({
            template: false,
            events: {
                'submit form': 'onSubmit'
            },
            submit: function () {
                this.getForm().submit();
            },
            onSubmit: function (e) {
                e.preventDefault();
                this.getSpinnerPlaceholder().spin();
                this.clearErrors();
                this.validate()
                    .then(function (result) {
                        if (result) {
                            this.$el.off('submit');
                            this.getForm().submit();
                        }
                    }.bind(this))
                    .always(function () {
                        this.getSpinnerPlaceholder().spinStop();
                    }.bind(this));
            },
            clearErrors: function () {
                this.$('.error').remove();
            },
            addError: function (message) {
                Backbone.$(aui.form.fieldError({
                    message: message
                })).insertAfter(this.getNameField());
            },
            validate: function () {
                var deferred = Backbone.$.Deferred();

                var name = this.getNameField().val().trim();

                if (name.length === 0) {
                    this.addError('Permission scheme name cannot be empty');
                    deferred.resolve(false);
                } else {
                    PermissionScheme.exists(name)
                        .then(function (exists) {
                            if (exists) {
                                this.addError(AJS.format('Permission scheme "{0}" already exists', name));
                                deferred.resolve(false);
                                return;
                            }
                            deferred.resolve(true);
                        }.bind(this));
                }
                return deferred.promise();
            },
            getNameField: function () {
                return this.$('input[name="name"]');
            },
            getSpinnerPlaceholder: function () {
                return this.$('[data-ref="spinner"]');
            },
            getForm: function () {
                return this.$('form');
            }
        }, {
            create: function ($dialog) {
                var view = new this({el: $dialog});
                view.render();
                return view;
            }
        });
    });