/**
 * Check if elements have a leading or trailing space and highlight them.
 * Also show an explanatory warning.
 */

define('FECRU/component/trailing-whitespace', ['jquery'], function ($) {
    'use strict';

    return function () {
        var $warning = $('.trailing-whitespace--warning');
        $('[data-check-trailing-whitespace]').each(function () {
            var $el = $(this);
            var text = $el.text();
            if (text !== $.trim(text)) {
                $el.addClass('trailing-whitespace--item');
                $warning.show();
            }
        });
    };

});
