define('FECRU/component/toggleButton', ['jquery'], function ($) {
    'use strict';

    var ACTIVE_CLASS = 'toggle-button__on';
    var UNACTIVE_CLASS = 'toggle-button__off';

    var isActive = function ($element) {
        return $element.hasClass(ACTIVE_CLASS);
    };

    var setActive = function ($element, active) {
        active = !!active;
        $element.trigger('toggle-button:change', active);
        $element.toggleClass(ACTIVE_CLASS, active)
            .toggleClass(UNACTIVE_CLASS, !active);
        $element.find('.toggle-button--off').attr('aria-pressed', !active);
    };

    var toggle = function ($element) {
        setActive($element, !isActive($element));
    };

    /**
     * Toggle button handler
     *
     * Available methods:
     * - no method - initializes toggle button so you can listen on events like
     *               "toggle-button:select-unactive" and "toggle-button:select-active".
     *                   Note that you can change the state of toggle button programatical way only.
     * - "setActive" - accepts second argument which is a target state for toggle button
     * - "isActive"
     * - "toggle"
     */
    $.fn.toggleButton = function (methodName, option) {
        if (methodName === void 0) {
            if (!this.data('has-toggle-button')) {
                this
                    .on('click', '.toggle-button--off', function () {
                        var $button = $(this).closest('.toggle-button');
                        $button.toggleButton('isActive') && $button.trigger('toggle-button:select-unactive');
                    })
                    .on('click', '.toggle-button--on', function () {
                        var $button = $(this).closest('.toggle-button');
                        !$button.toggleButton('isActive') && $button.trigger('toggle-button:select-active');
                    });
                this.data('has-toggle-button', true);
            }
            return this;
        }
        switch (methodName) {
            case 'toggle':
                toggle(this);
                break;
            case 'setActive':
                setActive(this, option);
                break;
            case 'isActive':
                return isActive(this);
            default:
                throw new Error('Unknown method "{0}"', methodName);
        }
        return this;
    };
});